# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['grubhub']

package_data = \
{'': ['*']}

install_requires = \
['bs4>=0.0.1,<0.0.2',
 'python-dateutil>=2.8.1,<3.0.0',
 'pyyaml>=5.3.1,<6.0.0',
 'requests>=2.26.0,<3.0.0',
 'user-agent>=0.1.10,<0.2.0']

setup_kwargs = {
    'name': 'grubhub',
    'version': '0.1.0',
    'description': "A quick wrapper around GrubHub's API, to fetch account and order information.",
    'long_description': '# grubhub\n\nA quick wrapper around GrubHub\'s API, to fetch account and order information.\n\n## Installation\n\nThis library is available on PyPI:\n\n```python\npipenv install grubhub\n```\n\n## Example\n\n```python\nimport grubhub\nghc = grubhub.GrubHubClient()\nghc.login(username="<username>", password="<password>")\norders = ghc.order_history()\n```\n\nand a sample order receipt:\n\n```json\n{\n  "id": "a86651e0-59fa-11ec-81b3-cf196f90eedb",\n  "group_id": "a86651e1-59fa-11ec-81b3-cf196f90eedb",\n  "diner_info": {\n    "id": "91d81980-6bda-11f6-b5e5-7930b4d5f97f",\n    "name": "Jérémie Lumbroso",\n    "email": "<username>",\n    "phone": "<phone>"\n  },\n  "brand": "GRUBHUB",\n  "when_for": "2021-12-10T19:10:24.663Z",\n  "start_time": "2021-12-10T18:54:52.414Z",\n  "time_placed": "2021-12-10T18:55:24.656Z",\n  "currency": "USD",\n  "fulfillment_info": {\n    "type": "PICKUP",\n    "pickup_info": {\n      "name": "Jérémie Lumbroso",\n      "phone": "<phone>",\n      "email": "<username>",\n      "green_indicated": false,\n      "time_zone": {\n        "id": "America/New_York",\n        "name": "Eastern Standard Time",\n        "raw_offset": -18000000\n      },\n      "handoff_options": []\n    }\n  },\n  "charges": {\n    "lines": {\n      "diner_total": 555,\n      "line_items": [\n        {\n          "id": "5413206376",\n          "line_uuid": "qJx9ElnqEeygJwm_AhVS7g",\n          "menu_item_id": "5413206376",\n          "name": "House Brew Tea (Hot)",\n          "price": 0,\n          "quantity": 1,\n          "adjustment_type": "NONE",\n          "tags": [],\n          "diner_total": 555,\n          "options": [\n            {\n              "price": 555,\n              "name": "L",\n              "id": "5412398070",\n              "quantity": 1,\n              "option_tags": [],\n              "child_options": []\n            },\n            {\n              "price": 0,\n              "name": "Oolong",\n              "id": "5263934535",\n              "quantity": 1,\n              "option_tags": [],\n              "child_options": []\n            },\n            {\n              "price": 0,\n              "name": "Extra Strong ",\n              "id": "5413206372",\n              "quantity": 1,\n              "option_tags": [],\n              "child_options": []\n            }\n          ],\n          "special_instructions": "Please add VEGAN oat milk, thank you",\n          "restaurant": {\n            "id": "2421174",\n            "name": "Ficus",\n            "img_url": "https://res.cloudinary.com/grubhub/image/upload/rog5swk6meaw5rpllmkb.png",\n            "media_image": {\n              "base_url": "https://media-cdn.grubhub.com/image/upload/",\n              "public_id": "rog5swk6meaw5rpllmkb",\n              "format": "png",\n              "tag": "logo"\n            },\n            "contact_free_required": false,\n            "managed_delivery": false,\n            "restaurant_tags": ["SUBSCRIPTION_ELIGIBLE_FOR_STANDARD_ORDER"]\n          },\n          "packaging_options": []\n        }\n      ]\n    },\n    "coupons": [],\n    "diner_subtotal": 555,\n    "non_itemized_adjustments": [],\n    "fees": { "total": 0, "delivery": 0, "service": 0, "fee_items": [] },\n    "donations": { "total": 0 },\n    "taxes": { "total": 37, "sales": 37, "delivery": 0 },\n    "tip": { "type": "INCLUDE_IN_BILL", "amount": 0, "tip_adjustments": [] },\n    "diner_grand_total": 592\n  },\n  "payments": {\n    "total": 592,\n    "payments": [\n      {\n        "id": "s0TLyDvtRBqOzUl9xBavyz",\n        "type": "APPLE_PAY",\n        "amount": 592,\n        "payment_uuid": "TlgrcApxNKeDMtjROzU7jQ",\n        "metadata": {\n          "credit_card_type": "Apple Pay - MasterCard",\n          "payment_processor": "braintree",\n          "expiration_date": "10/2024",\n          "cc_last_four": "xxxx"\n        },\n        "amount_events": [\n          {\n            "amount_event_id": "QtrYvEu6P-iaZqvZRVP92A",\n            "amount": 592,\n            "updated_at": "2021-12-10T18:55:24.620Z"\n          }\n        ]\n      }\n    ]\n  },\n  "restaurants": [\n    {\n      "id": "2421174",\n      "name": "Ficus",\n      "img_url": "https://res.cloudinary.com/grubhub/image/upload/rog5swk6meaw5rpllmkb.png",\n      "media_image": {\n        "base_url": "https://media-cdn.grubhub.com/image/upload/",\n        "public_id": "rog5swk6meaw5rpllmkb",\n        "format": "png",\n        "tag": "logo"\n      },\n      "contact_free_required": false,\n      "managed_delivery": false,\n      "restaurant_tags": ["SUBSCRIPTION_ELIGIBLE_FOR_STANDARD_ORDER"]\n    }\n  ],\n  "reviews": [],\n  "state": "COMPLETED",\n  "order_number": "054217315097086",\n  "order_tracking": { "enabled": false },\n  "disallow_reorder": false,\n  "was_preorder": false,\n  "local_when_for": "14:10:24",\n  "system_of_record": "bullrat",\n  "order_status": "CONFIRMED",\n  "expensing_details": {\n    "expensing_allowed": true,\n    "expense_at": "2021-12-11T19:10:24.663Z"\n  },\n  "adjustments": {\n    "history": [\n      {\n        "order_request_uuid": "KGc4uMOvNgmOPQH_3jZtcQ",\n        "ordering": 0,\n        "timestamp": "2021-12-10T18:55:24.656Z",\n        "payments": [{ "key": "TlgrcApxNKeDMtjROwU7jQ", "value": 592 }],\n        "totals": [\n          { "key": "TAXES_TOTAL", "value": 37 },\n          { "key": "DMP_GRUBHUB_MARGIN_TAX_TOTAL", "value": 0 },\n          { "key": "TAXABLE_TOTAL", "value": 555 },\n          { "key": "MERCHANT_GRAND_TOTAL", "value": 592 },\n          { "key": "GRAND_TOTAL", "value": 592 },\n          { "key": "DINER_SUB_TOTAL", "value": 555 },\n          { "key": "FEES_TOTAL", "value": 0 },\n          { "key": "DINER_GRAND_TOTAL", "value": 592 },\n          { "key": "NON_TAXABLE_TOTAL", "value": 0 },\n          { "key": "MERCHANT_SUB_TOTAL", "value": 555 }\n        ]\n      }\n    ]\n  },\n  "editable": false,\n  "catering": false,\n  "group": false,\n  "asap": true,\n  "scheduled": false,\n  "shared_order": false,\n  "shared_order_host": false,\n  "group_admin_cart": false,\n  "expensed": false\n}\n```\n\n## Acknowledgements\n\nPortions of the authentication logic where reverse-engineered by\n[@temminks](https://github.com/temminks)\n[on StackOverflow](https://stackoverflow.com/a/62861527/408734).\n\n## License\n\nThis project is licensed [under the LGPLv3 license](https://www.gnu.org/licenses/lgpl-3.0.en.html),\nwith the understanding that importing a Python modular is similar in spirit to dynamically linking\nagainst it.\n\n- You can use the library/CLI `grubhub` in any project, for any purpose,\n  as long as you provide some acknowledgement to this original project for\n  use of the library (for open source software, just explicitly including\n  `grubhub` in the dependency such as a `pyproject.toml` or `Pipfile`\n  is acknowledgement enough for me!).\n\n- If you make improvements to `grubhub`, you are required to make those\n  changes publicly available.\n',
    'author': 'Jérémie Lumbroso',
    'author_email': 'lumbroso@cs.princeton.edu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jlumbroso/grubhub',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
