% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_line_mapping.R
\name{arxspan.to.ccle}
\alias{arxspan.to.ccle}
\title{Map cell line Broad ID (aka ArxSpan IDs) to the latest CCLE names}
\usage{
arxspan.to.ccle(arxspan.ids, ignore.problems = F, check.unique.mapping = T)
}
\arguments{
\item{arxspan.ids}{A vector of arxspan ids. These are always of the form "ACH-XXXXXX"}

\item{ignore.problems}{if not set to True, any unknown cell lines will result in an error being thrown. If you set to True, then you'll get NA for unknown lines instead.}

\item{check.unique.mapping}{if set, will throw an error if it discovers two different IDs which map to the same CCLE name (which could cause issues downstream)}
}
\description{
Map cell line Broad ID (aka ArxSpan IDs) to the latest CCLE names
}
\examples{
ccle_names <- arxspan.to.ccle(c('ACH-000007', 'ACH-000008'))
}
