"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosCluster = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosClusterProps`
 *
 * @returns the result of the validation.
 */
function RosClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.imageOwnerAlias && (typeof properties.imageOwnerAlias) !== 'object') {
        errors.collect(ros.propertyValidator('imageOwnerAlias', ros.validateAllowedValues)({
            data: properties.imageOwnerAlias,
            allowedValues: ["system", "self", "others", "marketplace"],
        }));
    }
    errors.collect(ros.propertyValidator('imageOwnerAlias', ros.validateString)(properties.imageOwnerAlias));
    if (properties.volumeProtocol && (typeof properties.volumeProtocol) !== 'object') {
        errors.collect(ros.propertyValidator('volumeProtocol', ros.validateAllowedValues)({
            data: properties.volumeProtocol,
            allowedValues: ["nfs"],
        }));
    }
    errors.collect(ros.propertyValidator('volumeProtocol', ros.validateString)(properties.volumeProtocol));
    errors.collect(ros.propertyValidator('ecsOrderComputeCount', ros.requiredValidator)(properties.ecsOrderComputeCount));
    if (properties.ecsOrderComputeCount && (typeof properties.ecsOrderComputeCount) !== 'object') {
        errors.collect(ros.propertyValidator('ecsOrderComputeCount', ros.validateRange)({
            data: properties.ecsOrderComputeCount,
            min: 1,
            max: 99,
        }));
    }
    errors.collect(ros.propertyValidator('ecsOrderComputeCount', ros.validateNumber)(properties.ecsOrderComputeCount));
    if (properties.description && (Array.isArray(properties.description) || (typeof properties.description) === 'string')) {
        errors.collect(ros.propertyValidator('description', ros.validateLength)({
            data: properties.description.length,
            min: 2,
            max: 128,
        }));
    }
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('securityGroupName', ros.validateString)(properties.securityGroupName));
    errors.collect(ros.propertyValidator('autoRenew', ros.validateBoolean)(properties.autoRenew));
    errors.collect(ros.propertyValidator('computeSpotPriceLimit', ros.validateString)(properties.computeSpotPriceLimit));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('volumeId', ros.requiredValidator)(properties.volumeId));
    errors.collect(ros.propertyValidator('volumeId', ros.validateString)(properties.volumeId));
    if (properties.volumeType && (typeof properties.volumeType) !== 'object') {
        errors.collect(ros.propertyValidator('volumeType', ros.validateAllowedValues)({
            data: properties.volumeType,
            allowedValues: ["nas"],
        }));
    }
    errors.collect(ros.propertyValidator('volumeType', ros.validateString)(properties.volumeType));
    if (properties.deployMode && (typeof properties.deployMode) !== 'object') {
        errors.collect(ros.propertyValidator('deployMode', ros.validateAllowedValues)({
            data: properties.deployMode,
            allowedValues: ["Standard", "Advanced", "Simple", "Tiny", "OneBox"],
        }));
    }
    errors.collect(ros.propertyValidator('deployMode', ros.validateString)(properties.deployMode));
    errors.collect(ros.propertyValidator('postInstallScript', ros.listValidator(RosCluster_PostInstallScriptPropertyValidator))(properties.postInstallScript));
    errors.collect(ros.propertyValidator('imageId', ros.validateString)(properties.imageId));
    if (properties.password && (Array.isArray(properties.password) || (typeof properties.password) === 'string')) {
        errors.collect(ros.propertyValidator('password', ros.validateLength)({
            data: properties.password.length,
            min: 8,
            max: 30,
        }));
    }
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('keyPairName', ros.validateString)(properties.keyPairName));
    errors.collect(ros.propertyValidator('remoteDirectory', ros.validateString)(properties.remoteDirectory));
    errors.collect(ros.propertyValidator('sccClusterId', ros.validateString)(properties.sccClusterId));
    errors.collect(ros.propertyValidator('ecsOrderLoginInstanceType', ros.requiredValidator)(properties.ecsOrderLoginInstanceType));
    errors.collect(ros.propertyValidator('ecsOrderLoginInstanceType', ros.validateString)(properties.ecsOrderLoginInstanceType));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('jobQueue', ros.validateString)(properties.jobQueue));
    errors.collect(ros.propertyValidator('ecsOrderLoginCount', ros.requiredValidator)(properties.ecsOrderLoginCount));
    if (properties.ecsOrderLoginCount && (typeof properties.ecsOrderLoginCount) !== 'object') {
        errors.collect(ros.propertyValidator('ecsOrderLoginCount', ros.validateRange)({
            data: properties.ecsOrderLoginCount,
            min: 1,
            max: 1,
        }));
    }
    errors.collect(ros.propertyValidator('ecsOrderLoginCount', ros.validateNumber)(properties.ecsOrderLoginCount));
    errors.collect(ros.propertyValidator('vSwitchId', ros.requiredValidator)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.schedulerType && (typeof properties.schedulerType) !== 'object') {
        errors.collect(ros.propertyValidator('schedulerType', ros.validateAllowedValues)({
            data: properties.schedulerType,
            allowedValues: ["pbs"],
        }));
    }
    errors.collect(ros.propertyValidator('schedulerType', ros.validateString)(properties.schedulerType));
    if (properties.computeSpotStrategy && (typeof properties.computeSpotStrategy) !== 'object') {
        errors.collect(ros.propertyValidator('computeSpotStrategy', ros.validateAllowedValues)({
            data: properties.computeSpotStrategy,
            allowedValues: ["NoSpot", "SpotWithPriceLimit", "SpotAsPriceGo"],
        }));
    }
    errors.collect(ros.propertyValidator('computeSpotStrategy', ros.validateString)(properties.computeSpotStrategy));
    if (properties.accountType && (typeof properties.accountType) !== 'object') {
        errors.collect(ros.propertyValidator('accountType', ros.validateAllowedValues)({
            data: properties.accountType,
            allowedValues: ["nis"],
        }));
    }
    errors.collect(ros.propertyValidator('accountType', ros.validateString)(properties.accountType));
    errors.collect(ros.propertyValidator('ecsOrderManagerInstanceType', ros.requiredValidator)(properties.ecsOrderManagerInstanceType));
    errors.collect(ros.propertyValidator('ecsOrderManagerInstanceType', ros.validateString)(properties.ecsOrderManagerInstanceType));
    errors.collect(ros.propertyValidator('ehpcVersion', ros.requiredValidator)(properties.ehpcVersion));
    if (properties.ehpcVersion && (typeof properties.ehpcVersion) !== 'object') {
        errors.collect(ros.propertyValidator('ehpcVersion', ros.validateAllowedValues)({
            data: properties.ehpcVersion,
            allowedValues: ["1.0.0"],
        }));
    }
    errors.collect(ros.propertyValidator('ehpcVersion', ros.validateString)(properties.ehpcVersion));
    errors.collect(ros.propertyValidator('volumeMountpoint', ros.requiredValidator)(properties.volumeMountpoint));
    errors.collect(ros.propertyValidator('volumeMountpoint', ros.validateString)(properties.volumeMountpoint));
    if (properties.ecsOrderManagerCount && (typeof properties.ecsOrderManagerCount) !== 'object') {
        errors.collect(ros.propertyValidator('ecsOrderManagerCount', ros.validateAllowedValues)({
            data: properties.ecsOrderManagerCount,
            allowedValues: [1, 2, 4],
        }));
    }
    errors.collect(ros.propertyValidator('ecsOrderManagerCount', ros.validateNumber)(properties.ecsOrderManagerCount));
    errors.collect(ros.propertyValidator('ecsOrderComputeInstanceType', ros.requiredValidator)(properties.ecsOrderComputeInstanceType));
    errors.collect(ros.propertyValidator('ecsOrderComputeInstanceType', ros.validateString)(properties.ecsOrderComputeInstanceType));
    errors.collect(ros.propertyValidator('haEnable', ros.validateBoolean)(properties.haEnable));
    errors.collect(ros.propertyValidator('osTag', ros.requiredValidator)(properties.osTag));
    errors.collect(ros.propertyValidator('osTag', ros.validateString)(properties.osTag));
    errors.collect(ros.propertyValidator('ecsChargeType', ros.validateString)(properties.ecsChargeType));
    errors.collect(ros.propertyValidator('application', ros.listValidator(RosCluster_ApplicationPropertyValidator))(properties.application));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Week", "Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster` resource
 *
 * @param properties - the TypeScript properties of a `RosClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster` resource.
 */
// @ts-ignore TS6133
function rosClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosClusterPropsValidator(properties).assertSuccess();
    }
    return {
        EcsOrderComputeCount: ros.numberToRosTemplate(properties.ecsOrderComputeCount),
        EcsOrderComputeInstanceType: ros.stringToRosTemplate(properties.ecsOrderComputeInstanceType),
        EcsOrderLoginCount: ros.numberToRosTemplate(properties.ecsOrderLoginCount),
        EcsOrderLoginInstanceType: ros.stringToRosTemplate(properties.ecsOrderLoginInstanceType),
        EcsOrderManagerInstanceType: ros.stringToRosTemplate(properties.ecsOrderManagerInstanceType),
        EhpcVersion: ros.stringToRosTemplate(properties.ehpcVersion),
        Name: ros.stringToRosTemplate(properties.name),
        OsTag: ros.stringToRosTemplate(properties.osTag),
        VolumeId: ros.stringToRosTemplate(properties.volumeId),
        VolumeMountpoint: ros.stringToRosTemplate(properties.volumeMountpoint),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        AccountType: ros.stringToRosTemplate(properties.accountType),
        Application: ros.listMapper(rosClusterApplicationPropertyToRosTemplate)(properties.application),
        AutoRenew: ros.booleanToRosTemplate(properties.autoRenew),
        AutoRenewPeriod: ros.numberToRosTemplate(properties.autoRenewPeriod),
        ComputeSpotPriceLimit: ros.stringToRosTemplate(properties.computeSpotPriceLimit),
        ComputeSpotStrategy: ros.stringToRosTemplate(properties.computeSpotStrategy),
        DeployMode: ros.stringToRosTemplate(properties.deployMode),
        Description: ros.stringToRosTemplate(properties.description),
        EcsChargeType: ros.stringToRosTemplate(properties.ecsChargeType),
        EcsOrderManagerCount: ros.numberToRosTemplate(properties.ecsOrderManagerCount),
        HaEnable: ros.booleanToRosTemplate(properties.haEnable),
        ImageId: ros.stringToRosTemplate(properties.imageId),
        ImageOwnerAlias: ros.stringToRosTemplate(properties.imageOwnerAlias),
        JobQueue: ros.stringToRosTemplate(properties.jobQueue),
        KeyPairName: ros.stringToRosTemplate(properties.keyPairName),
        Password: ros.stringToRosTemplate(properties.password),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        PostInstallScript: ros.listMapper(rosClusterPostInstallScriptPropertyToRosTemplate)(properties.postInstallScript),
        RemoteDirectory: ros.stringToRosTemplate(properties.remoteDirectory),
        SccClusterId: ros.stringToRosTemplate(properties.sccClusterId),
        SchedulerType: ros.stringToRosTemplate(properties.schedulerType),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        SecurityGroupName: ros.stringToRosTemplate(properties.securityGroupName),
        VolumeProtocol: ros.stringToRosTemplate(properties.volumeProtocol),
        VolumeType: ros.stringToRosTemplate(properties.volumeType),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::EHPC::Cluster`
 */
class RosCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::EHPC::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterId = ros.Token.asString(this.getAtt('ClusterId'));
        this.attrEcsInfo = ros.Token.asString(this.getAtt('EcsInfo'));
        this.attrName = ros.Token.asString(this.getAtt('Name'));
        this.attrSecurityGroupId = ros.Token.asString(this.getAtt('SecurityGroupId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.ecsOrderComputeCount = props.ecsOrderComputeCount;
        this.ecsOrderComputeInstanceType = props.ecsOrderComputeInstanceType;
        this.ecsOrderLoginCount = props.ecsOrderLoginCount;
        this.ecsOrderLoginInstanceType = props.ecsOrderLoginInstanceType;
        this.ecsOrderManagerInstanceType = props.ecsOrderManagerInstanceType;
        this.ehpcVersion = props.ehpcVersion;
        this.name = props.name;
        this.osTag = props.osTag;
        this.volumeId = props.volumeId;
        this.volumeMountpoint = props.volumeMountpoint;
        this.vSwitchId = props.vSwitchId;
        this.accountType = props.accountType;
        this.application = props.application;
        this.autoRenew = props.autoRenew;
        this.autoRenewPeriod = props.autoRenewPeriod;
        this.computeSpotPriceLimit = props.computeSpotPriceLimit;
        this.computeSpotStrategy = props.computeSpotStrategy;
        this.deployMode = props.deployMode;
        this.description = props.description;
        this.ecsChargeType = props.ecsChargeType;
        this.ecsOrderManagerCount = props.ecsOrderManagerCount;
        this.haEnable = props.haEnable;
        this.imageId = props.imageId;
        this.imageOwnerAlias = props.imageOwnerAlias;
        this.jobQueue = props.jobQueue;
        this.keyPairName = props.keyPairName;
        this.password = props.password;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.postInstallScript = props.postInstallScript;
        this.remoteDirectory = props.remoteDirectory;
        this.sccClusterId = props.sccClusterId;
        this.schedulerType = props.schedulerType;
        this.securityGroupId = props.securityGroupId;
        this.securityGroupName = props.securityGroupName;
        this.volumeProtocol = props.volumeProtocol;
        this.volumeType = props.volumeType;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            ecsOrderComputeCount: this.ecsOrderComputeCount,
            ecsOrderComputeInstanceType: this.ecsOrderComputeInstanceType,
            ecsOrderLoginCount: this.ecsOrderLoginCount,
            ecsOrderLoginInstanceType: this.ecsOrderLoginInstanceType,
            ecsOrderManagerInstanceType: this.ecsOrderManagerInstanceType,
            ehpcVersion: this.ehpcVersion,
            name: this.name,
            osTag: this.osTag,
            volumeId: this.volumeId,
            volumeMountpoint: this.volumeMountpoint,
            vSwitchId: this.vSwitchId,
            accountType: this.accountType,
            application: this.application,
            autoRenew: this.autoRenew,
            autoRenewPeriod: this.autoRenewPeriod,
            computeSpotPriceLimit: this.computeSpotPriceLimit,
            computeSpotStrategy: this.computeSpotStrategy,
            deployMode: this.deployMode,
            description: this.description,
            ecsChargeType: this.ecsChargeType,
            ecsOrderManagerCount: this.ecsOrderManagerCount,
            haEnable: this.haEnable,
            imageId: this.imageId,
            imageOwnerAlias: this.imageOwnerAlias,
            jobQueue: this.jobQueue,
            keyPairName: this.keyPairName,
            password: this.password,
            period: this.period,
            periodUnit: this.periodUnit,
            postInstallScript: this.postInstallScript,
            remoteDirectory: this.remoteDirectory,
            sccClusterId: this.sccClusterId,
            schedulerType: this.schedulerType,
            securityGroupId: this.securityGroupId,
            securityGroupName: this.securityGroupName,
            volumeProtocol: this.volumeProtocol,
            volumeType: this.volumeType,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCluster = RosCluster;
/**
 * The resource type name for this resource class.
 */
RosCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::EHPC::Cluster";
/**
 * Determine whether the given properties match those of a `ApplicationProperty`
 *
 * @param properties - the TypeScript properties of a `ApplicationProperty`
 *
 * @returns the result of the validation.
 */
function RosCluster_ApplicationPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tag', ros.requiredValidator)(properties.tag));
    errors.collect(ros.propertyValidator('tag', ros.validateString)(properties.tag));
    return errors.wrap('supplied properties not correct for "ApplicationProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.Application` resource
 *
 * @param properties - the TypeScript properties of a `ApplicationProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.Application` resource.
 */
// @ts-ignore TS6133
function rosClusterApplicationPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCluster_ApplicationPropertyValidator(properties).assertSuccess();
    return {
        Tag: ros.stringToRosTemplate(properties.tag),
    };
}
/**
 * Determine whether the given properties match those of a `PostInstallScriptProperty`
 *
 * @param properties - the TypeScript properties of a `PostInstallScriptProperty`
 *
 * @returns the result of the validation.
 */
function RosCluster_PostInstallScriptPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('args', ros.validateString)(properties.args));
    errors.collect(ros.propertyValidator('url', ros.validateString)(properties.url));
    return errors.wrap('supplied properties not correct for "PostInstallScriptProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.PostInstallScript` resource
 *
 * @param properties - the TypeScript properties of a `PostInstallScriptProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::EHPC::Cluster.PostInstallScript` resource.
 */
// @ts-ignore TS6133
function rosClusterPostInstallScriptPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCluster_PostInstallScriptPropertyValidator(properties).assertSuccess();
    return {
        Args: ros.stringToRosTemplate(properties.args),
        Url: ros.stringToRosTemplate(properties.url),
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWhwYy5nZW5lcmF0ZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlaHBjLmdlbmVyYXRlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEseURBQXlEOzs7QUFFekQsOENBQThDO0FBMk05Qzs7Ozs7O0dBTUc7QUFDSCxTQUFTLHdCQUF3QixDQUFDLFVBQWU7SUFDN0MsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBRyxVQUFVLENBQUMsZUFBZSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsZUFBZSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQy9FLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQ2pGLElBQUksRUFBRSxVQUFVLENBQUMsZUFBZTtZQUNoQyxhQUFhLEVBQUUsQ0FBQyxRQUFRLEVBQUMsTUFBTSxFQUFDLFFBQVEsRUFBQyxhQUFhLENBQUM7U0FDeEQsQ0FBQyxDQUFDLENBQUM7S0FDUDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxJQUFHLFVBQVUsQ0FBQyxjQUFjLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxjQUFjLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDN0UsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLHFCQUFxQixDQUFDLENBQUM7WUFDaEYsSUFBSSxFQUFFLFVBQVUsQ0FBQyxjQUFjO1lBQy9CLGFBQWEsRUFBRSxDQUFDLEtBQUssQ0FBQztTQUN2QixDQUFDLENBQUMsQ0FBQztLQUNQO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDdEgsSUFBRyxVQUFVLENBQUMsb0JBQW9CLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDNUUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxvQkFBb0I7WUFDckMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztJQUNuSCxJQUFHLFVBQVUsQ0FBQyxXQUFXLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLFdBQVcsQ0FBQyxLQUFLLFFBQVEsQ0FBQyxFQUFFO1FBQ2xILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUM7WUFDcEUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxXQUFXLENBQUMsTUFBTTtZQUNuQyxHQUFHLEVBQUUsQ0FBQztZQUNOLEdBQUcsRUFBRSxHQUFHO1NBQ1QsQ0FBQyxDQUFDLENBQUM7S0FDVDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDN0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM5RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQztJQUNySCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixJQUFHLFVBQVUsQ0FBQyxVQUFVLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxVQUFVLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDckUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQzVFLElBQUksRUFBRSxVQUFVLENBQUMsVUFBVTtZQUMzQixhQUFhLEVBQUUsQ0FBQyxLQUFLLENBQUM7U0FDdkIsQ0FBQyxDQUFDLENBQUM7S0FDUDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsSUFBRyxVQUFVLENBQUMsVUFBVSxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsVUFBVSxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ3JFLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUM1RSxJQUFJLEVBQUUsVUFBVSxDQUFDLFVBQVU7WUFDM0IsYUFBYSxFQUFFLENBQUMsVUFBVSxFQUFDLFVBQVUsRUFBQyxRQUFRLEVBQUMsTUFBTSxFQUFDLFFBQVEsQ0FBQztTQUNoRSxDQUFDLENBQUMsQ0FBQztLQUNQO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLDZDQUE2QyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzNKLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsSUFBRyxVQUFVLENBQUMsUUFBUSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxRQUFRLENBQUMsS0FBSyxRQUFRLENBQUMsRUFBRTtRQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1lBQ2pFLElBQUksRUFBRSxVQUFVLENBQUMsUUFBUSxDQUFDLE1BQU07WUFDaEMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDJCQUEyQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUM7SUFDaEksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMkJBQTJCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUM7SUFDN0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUN2RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDbEgsSUFBRyxVQUFVLENBQUMsa0JBQWtCLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUNyRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDMUUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxrQkFBa0I7WUFDbkMsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsQ0FBQztTQUNQLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQztJQUMvRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDaEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUN2RixJQUFHLFVBQVUsQ0FBQyxhQUFhLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxhQUFhLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDM0UsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQy9FLElBQUksRUFBRSxVQUFVLENBQUMsYUFBYTtZQUM5QixhQUFhLEVBQUUsQ0FBQyxLQUFLLENBQUM7U0FDdkIsQ0FBQyxDQUFDLENBQUM7S0FDUDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDckcsSUFBRyxVQUFVLENBQUMsbUJBQW1CLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUN2RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUNyRixJQUFJLEVBQUUsVUFBVSxDQUFDLG1CQUFtQjtZQUNwQyxhQUFhLEVBQUUsQ0FBQyxRQUFRLEVBQUMsb0JBQW9CLEVBQUMsZUFBZSxDQUFDO1NBQy9ELENBQUMsQ0FBQyxDQUFDO0tBQ1A7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNqSCxJQUFHLFVBQVUsQ0FBQyxXQUFXLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxXQUFXLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDdkUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQzdFLElBQUksRUFBRSxVQUFVLENBQUMsV0FBVztZQUM1QixhQUFhLEVBQUUsQ0FBQyxLQUFLLENBQUM7U0FDdkIsQ0FBQyxDQUFDLENBQUM7S0FDUDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQztJQUNwSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw2QkFBNkIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQztJQUNqSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDcEcsSUFBRyxVQUFVLENBQUMsV0FBVyxJQUFJLENBQUMsT0FBTyxVQUFVLENBQUMsV0FBVyxDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ3ZFLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUM3RSxJQUFJLEVBQUUsVUFBVSxDQUFDLFdBQVc7WUFDNUIsYUFBYSxFQUFFLENBQUMsT0FBTyxDQUFDO1NBQ3pCLENBQUMsQ0FBQyxDQUFDO0tBQ1A7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDOUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7SUFDM0csSUFBRyxVQUFVLENBQUMsb0JBQW9CLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUN6RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLENBQUMscUJBQXFCLENBQUMsQ0FBQztZQUN0RixJQUFJLEVBQUUsVUFBVSxDQUFDLG9CQUFvQjtZQUNyQyxhQUFhLEVBQUUsQ0FBQyxDQUFDLEVBQUMsQ0FBQyxFQUFDLENBQUMsQ0FBQztTQUN2QixDQUFDLENBQUMsQ0FBQztLQUNQO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQztJQUNwSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyw2QkFBNkIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQztJQUNqSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzVGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUN4RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDckcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsdUNBQXVDLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3pJLElBQUcsVUFBVSxDQUFDLFVBQVUsSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLFVBQVUsQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUNyRSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLHFCQUFxQixDQUFDLENBQUM7WUFDNUUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxVQUFVO1lBQzNCLGFBQWEsRUFBRSxDQUFDLE1BQU0sRUFBQyxPQUFPLEVBQUMsTUFBTSxDQUFDO1NBQ3ZDLENBQUMsQ0FBQyxDQUFDO0tBQ1A7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx1REFBdUQsQ0FBQyxDQUFDO0FBQ2hGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw0QkFBNEIsQ0FBQyxVQUFlLEVBQUUsZ0NBQXlDO0lBQzVGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxJQUFHLGdDQUFnQyxFQUFFO1FBQ2pDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0tBQ3hEO0lBQ0QsT0FBTztRQUNMLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDOUUsMkJBQTJCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQztRQUM1RixrQkFBa0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDO1FBQzFFLHlCQUF5QixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUM7UUFDeEYsMkJBQTJCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQztRQUM1RixXQUFXLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDNUQsSUFBSSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO1FBQzlDLEtBQUssRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQztRQUNoRCxRQUFRLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDdEQsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN0RSxTQUFTLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDeEQsV0FBVyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzVELFdBQVcsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLDBDQUEwQyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUMvRixTQUFTLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDekQsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3BFLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7UUFDaEYsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQztRQUM1RSxVQUFVLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDMUQsV0FBVyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzVELGFBQWEsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUNoRSxvQkFBb0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQzlFLFFBQVEsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUN2RCxPQUFPLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUM7UUFDcEQsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3BFLFFBQVEsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUN0RCxXQUFXLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDNUQsUUFBUSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3RELE1BQU0sRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztRQUNsRCxVQUFVLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDMUQsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxnREFBZ0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUNqSCxlQUFlLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDcEUsWUFBWSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQzlELGFBQWEsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUNoRSxlQUFlLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUM7UUFDcEUsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUN4RSxjQUFjLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDbEUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzFELE1BQU0sRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztLQUNuRCxDQUFDO0FBQ04sQ0FBQztBQUVEOztHQUVHO0FBQ0gsTUFBYSxVQUFXLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFzTzNDOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBc0IsRUFBRSxnQ0FBeUM7UUFDM0csS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsVUFBVSxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ2pGLElBQUksQ0FBQyxhQUFhLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO1FBQ2xFLElBQUksQ0FBQyxXQUFXLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO1FBQzlELElBQUksQ0FBQyxRQUFRLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO1FBQ3hELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztRQUU5RSxJQUFJLENBQUMsZ0NBQWdDLEdBQUcsZ0NBQWdDLENBQUM7UUFDekUsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQztRQUN2RCxJQUFJLENBQUMsMkJBQTJCLEdBQUcsS0FBSyxDQUFDLDJCQUEyQixDQUFDO1FBQ3JFLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUM7UUFDbkQsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQztRQUNqRSxJQUFJLENBQUMsMkJBQTJCLEdBQUcsS0FBSyxDQUFDLDJCQUEyQixDQUFDO1FBQ3JFLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQy9DLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQztRQUN6RCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1FBQ3JELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7UUFDdkQsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1FBQzNCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO0lBQy9CLENBQUM7SUFHRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILG9CQUFvQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDL0MsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLDJCQUEyQjtZQUM3RCxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzNDLHlCQUF5QixFQUFFLElBQUksQ0FBQyx5QkFBeUI7WUFDekQsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLDJCQUEyQjtZQUM3RCxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2YsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLO1lBQ2pCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixnQkFBZ0IsRUFBRSxJQUFJLENBQUMsZ0JBQWdCO1lBQ3ZDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMscUJBQXFCLEVBQUUsSUFBSSxDQUFDLHFCQUFxQjtZQUNqRCxtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDL0MsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO1lBQ25CLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO1NBQ3RCLENBQUM7SUFDTixDQUFDO0lBQ1MsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyw0QkFBNEIsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDdEYsQ0FBQzs7QUExVUwsZ0NBMlVDO0FBMVVHOztHQUVHO0FBQ29CLGlDQUFzQixHQUFHLHVCQUF1QixDQUFDO0FBb1Y1RTs7Ozs7O0dBTUc7QUFDSCxTQUFTLHVDQUF1QyxDQUFDLFVBQWU7SUFDNUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ3BGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDBDQUEwQyxDQUFDLFVBQWU7SUFDL0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHVDQUF1QyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3BFLE9BQU87UUFDTCxHQUFHLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7S0FDN0MsQ0FBQztBQUNOLENBQUM7QUFpQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyw2Q0FBNkMsQ0FBQyxVQUFlO0lBQ2xFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsaUVBQWlFLENBQUMsQ0FBQztBQUMxRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsZ0RBQWdELENBQUMsVUFBZTtJQUNyRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsNkNBQTZDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDMUUsT0FBTztRQUNMLElBQUksRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUM5QyxHQUFHLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7S0FDN0MsQ0FBQztBQUNOLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cclxuXHJcbmltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcclxuXHJcbi8qKlxyXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkVIUEM6OkNsdXN0ZXJgXHJcbiAqL1xyXG5leHBvcnQgaW50ZXJmYWNlIFJvc0NsdXN0ZXJQcm9wcyB7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZWNzT3JkZXJDb21wdXRlQ291bnQ6IENvbXB1dGluZyBub2RlIG51bWJlciwgd2hpY2ggcmFuZ2VzIGZyb206IDEtOTkuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGVjc09yZGVyQ29tcHV0ZUNvdW50OiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlOiBDbHVzdGVyIGNvbXB1dGluZyBub2RlIGluc3RhbmNlIHNwZWNpZmljYXRpb25zLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBlY3NPcmRlckNvbXB1dGVJbnN0YW5jZVR5cGU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBlY3NPcmRlckxvZ2luQ291bnQ6IExvZ2luIG5vZGUgbnVtYmVyIGNhbiBvbmx5IGJlIDEuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGVjc09yZGVyTG9naW5Db3VudDogbnVtYmVyO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGU6IExvZyBjbHVzdGVyIG5vZGUgaW5zdGFuY2Ugc3BlY2lmaWNhdGlvbnMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGU6IENsdXN0ZXIgY29udHJvbCBub2RlIGluc3RhbmNlIHNwZWNpZmljYXRpb25zLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBlaHBjVmVyc2lvbjogRS1IUEMgcHJvZHVjdCB2ZXJzaW9uIG51bWJlcnMsIGN1cnJlbnRseSBzdXBwb3J0cyAxLjAuMFxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBlaHBjVmVyc2lvbjogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IG5hbWU6IENsdXN0ZXIgbmFtZS4gMi02NCBjaGFyYWN0ZXJzIGluIGxlbmd0aCwgYWxsb3dpbmcgb25seSBpbmNsdWRlIENoaW5lc2UsIGxldHRlcnMsIG51bWJlcnMsIGRhc2hlcyAoLSkgYW5kIHVuZGVyc2NvcmUgKF8pLCBtdXN0IGJlZ2luIHdpdGggYSBsZXR0ZXIgb3IgQ2hpbmVzZS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IG9zVGFnOiBPcGVyYXRpbmcgc3lzdGVtIGltYWdlIHRhZy4gWW91IGNhbiBjYWxsIExpc3RJbWFnZXMgQVBJIHRvIHF1ZXJ5LlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBvc1RhZzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZvbHVtZUlkOiBBbGkgY2xvdWQgTkFTIGluc3RhbmNlIElkLiBDdXJyZW50bHkgaXQgZG9lcyBub3Qgc3VwcG9ydCBhdXRvbWF0aWMgY3JlYXRpb24gQWxpIGNsb3VkIE5BUyBpbnN0YW5jZS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgdm9sdW1lSWQ6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSB2b2x1bWVNb3VudHBvaW50OiBOQVMgdnBjIG1vdW50IHBvaW50LiBDdXJyZW50bHkgaXQgZG9lcyBub3Qgc3VwcG9ydCBhdXRvbWF0aWMgY3JlYXRpb24gQWxpIGNsb3VkIE5BUyBtb3VudCBwb2ludC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgdm9sdW1lTW91bnRwb2ludDogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZTd2l0Y2hJZDogVlBDIGluIHN3aXRjaCBJRC4gUHJvZHVjdHMgY3VycmVudGx5IG9ubHkgc3VwcG9ydHMgVlBDIG5ldHdvcmsuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHZTd2l0Y2hJZDogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGFjY291bnRUeXBlOiBEb21haW4gc2VydmljZSBhY2NvdW50IHR5cGVzLCBjdXJyZW50bHkgc3VwcG9ydHMgbmlzLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBhY2NvdW50VHlwZT86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhcHBsaWNhdGlvbjogQXBwbGljYXRpb24gc29mdHdhcmUgdGFnIChTb2Z0d2FyZVRhZykgbGlzdCwgWW91IGNhbiBjYWxsIExpc3RTb2Z0d2FyZXMgQVBJIHRvIHF1ZXJ5LlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBhcHBsaWNhdGlvbj86IEFycmF5PFJvc0NsdXN0ZXIuQXBwbGljYXRpb25Qcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgYXV0b1JlbmV3OiB0cnVlOiBhdXRvbWF0aWMgcmVuZXdhbHM7IGZhbHNlOiBubyBhdXRvbWF0aWMgcmVuZXdhbHMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGF1dG9SZW5ldz86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgYXV0b1JlbmV3UGVyaW9kOiBEdXJhdGlvbiBvZiBlYWNoIGF1dG9tYXRpYyByZW5ld2FscywgQXV0b1JlbmV3IHRha2UgZWZmZWN0IHdoZW4gQXV0b1JlbmV3IGlzIFRydWUuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGF1dG9SZW5ld1BlcmlvZD86IG51bWJlcjtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBjb21wdXRlU3BvdFByaWNlTGltaXQ6IFNldCBhbiBleGFtcGxlIG9mIHRoZSBoaWdoZXN0IHByaWNlIHBlciBob3VyLCBhcmUgZmxvYXRpbmctcG9pbnQgdmFsdWVzLCBpbiB0aGUgcmFuZ2Ugb2YgdGhlIGN1cnJlbnQgcHJpY2UgcmFuZ2UuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGNvbXB1dGVTcG90UHJpY2VMaW1pdD86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBjb21wdXRlU3BvdFN0cmF0ZWd5OiBDb21wdXRlIG5vZGVzIGJpZGRpbmcgc3RyYXRlZ3ksIHZhbHVlIE5vU3BvdCwgU3BvdFdpdGhQcmljZUxpbWl0IG9yIFNwb3RBc1ByaWNlR29cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgY29tcHV0ZVNwb3RTdHJhdGVneT86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBkZXBsb3lNb2RlOiBEZXBsb3ltZW50IG1vZGU6XHJcbiAgICAgKiBTdGFuZGFyZDogYWNjb3VudCBub2RlICsgc2NoZWR1bGluZyBub2RlICsgbG9naW4gbm9kZSArIGNvbXB1dGluZyBub2RlLlxyXG4gICAgICogQWR2YW5jZWQ6IEhBIG1vZGUuXHJcbiAgICAgKiBTaW1wbGU6IChhY2NvdW50ICsgc2NoZWR1bGUpIG5vZGUgKyBsb2dpbiBub2RlICsgY29tcHV0ZSBub2RlLlxyXG4gICAgICogVGlueTogKGFjY291bnQgKyBzY2hlZHVsaW5nICsgbG9naW4pIG5vZGUgKyBjb21wdXRlIG5vZGUuXHJcbiAgICAgKiBPbmVCb3g6IChhY2NvdW50ICsgc2NoZWR1bGluZyArIGxvZ2luICsgY29tcHV0ZSkgbm9kZSArIG1vcmUgY29tcHV0ZSBub2Rlcy5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgZGVwbG95TW9kZT86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBkZXNjcmlwdGlvbjogQ2x1c3RlciBkZXNjcmlwdGlvbiwgMiB0byAxMjggY2hhcmFjdGVycy5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZWNzQ2hhcmdlVHlwZTogRUNTIGluc3RhbmNlIHBheW1lbnQgdHlwZSwgUG9zdFBhaWQ6IFBheS1Bcy1Zb3UtR28uUHJlUGFpZDogU3Vic2NyaXB0aW9uLklmIHlvdSBjaG9vc2UgUHJlUGFpZCwgYXV0b21hdGljIHJlbmV3YWwgd2lsbCBiZSBlbmFibGVkIGJ5IGRlZmF1bHQsIGFuZCBjbG9zZWQgd2hlbiBub2RlIGlzIHJlbGVhc2VkLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBlY3NDaGFyZ2VUeXBlPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGVjc09yZGVyTWFuYWdlckNvdW50OiBDb250cm9sIG5vZGUgbnVtYmVyIGNhbiBiZSAxLCAyLCA0KEhBKVxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBlY3NPcmRlck1hbmFnZXJDb3VudD86IG51bWJlcjtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBoYUVuYWJsZTogQXZhaWxhYmlsaXR5IGlzIHR1cm5lZCBvbiwgd2hlbiB0dXJuZWQgb24sIHRoZSByb2xlIG9mIGVhY2ggY29udHJvbCBjbHVzdGVyIHdpbGwgdXNlIHR3byBzdGFuZGJ5IGluc3RhbmNlcy5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgaGFFbmFibGU/OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGltYWdlSWQ6IE1pcnJvciBJZCwgaWYgSW1hZ2VUeXBlIGEgc3lzdGVtLCBiYXNlZCBvbiB0aGUgaW1hZ2UgSUQgaXMgZGV0ZXJtaW5lZCBvbmx5IGFjY29yZGluZyBPc1RhZzsgaWYgc2VsZiwgb3RoZXJzLCBvciBtYXJrZXRwbGFjZSwgSW1hZ2VJZCBpcyBtYW5kYXRvcnkuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGltYWdlSWQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaW1hZ2VPd25lckFsaWFzOiBNaXJyb3IgdHlwZTogc3lzdGVtLCBzZWxmLCBvdGhlcnMgb3IgbWFya2V0cGxhY2VcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgaW1hZ2VPd25lckFsaWFzPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGpvYlF1ZXVlOiBDb21wdXRpbmcgbm9kZSBhZGRlZCBxdWV1ZVxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBqb2JRdWV1ZT86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBrZXlQYWlyTmFtZTogS2V5IHBhaXIgbmFtZS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkga2V5UGFpck5hbWU/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcGFzc3dvcmQ6IFJvb3QgcGFzc3dvcmQgb2YganVtcCBzZXJ2ZXIgKGxvZ2luIG5vZGUpLiA4IHRvIDMwIGNoYXJhY3RlcnMsIG11c3QgY29udGFpbiB0aHJlZSAodXBwZXIgYW5kIGxvd2VyIGNhc2UgbGV0dGVycywgbnVtYmVycyBhbmQgc3BlY2lhbCBzeW1ib2xzKS4gISBTdXBwb3J0cyB0aGUgZm9sbG93aW5nIHNwZWNpYWwgY2hhcmFjdGVycyA6KCkgYH4gQCAjICQlIF4gJiAqIC0gKyA9IHwge30gW106OyAnPD4sIC8gQmUgc3VyZSB0byB1c2UgdGhlIEhUVFBTIHByb3RvY29sIEFQSSBjYWxsIHRvIGF2b2lkIHBhc3N3b3JkIGxlYWtzIHRoYXQgbWF5IG9jY3VyLj8uXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHBhc3N3b3JkPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHBlcmlvZDogVGhlIHB1cmNoYXNlIG9mIGxvbmcgcmVzb3VyY2VzLCB1bml0czogd2VlayAvIG1vbnRoIC8geWVhci4gV2hlbiB0aGUgdmFsdWUgb2YgdGhlIHBhcmFtZXRlciBFY3NDaGFyZ2VUeXBlIHdoZW4gUHJlUGFpZCB0YWtlIGVmZmVjdCBhbmQgZm9yIHRoZSBzZWxlY3RlZCB2YWx1ZSB3aWxsIGJlLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBwZXJpb2Q/OiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcGVyaW9kVW5pdDogVGhlIHB1cmNoYXNlIG9mIGxvbmctcmVzb3VyY2VzIHVuaXQuIEFsdGVybmF0aXZlbHkgdmFsdWUgV2VlayAvIE1vbnRoIC8geWVhci5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgcGVyaW9kVW5pdD86IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBwb3N0SW5zdGFsbFNjcmlwdDpcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgcG9zdEluc3RhbGxTY3JpcHQ/OiBBcnJheTxSb3NDbHVzdGVyLlBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHJlbW90ZURpcmVjdG9yeTogTW91bnQgc2hhcmVkIHN0b3JhZ2UgcmVtb3RlIGRpcmVjdG9yeS4gVGhlIGZpbmFsIHBhdGggdG8gdGhlIG1vdW50IHBvaW50IGFuZCBtb3VudCB0aGUgcmVtb3RlIGRpcmVjdG9yeSBjb21wb3NpdGlvbjogTmFzTW91bnRwb2ludDogLyBSZW1vdGVEaXJlY3RvcnlcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgcmVtb3RlRGlyZWN0b3J5Pzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHNjY0NsdXN0ZXJJZDogV2hlbiBTQ0MgbW9kZWxzLCBpZiB5b3UgcGFzcyB0aGlzIGZpZWxkLCB0aGVuIHRoZSBzcGVjaWZpZWQgU2NjQ2x1c3RlciBjcmVhdGUgU2NjIGluc3RhbmNlLCBvdGhlcndpc2UgaXQgd2lsbCBjcmVhdGUgYW4gaW5zdGFuY2UgZm9yIHRoZSB1c2VyLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBzY2NDbHVzdGVySWQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgc2NoZWR1bGVyVHlwZTogVGhlIHNjaGVkdWxlciB0eXBlLCBjdXJyZW50bHkgc3VwcG9ydCBwYnMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHNjaGVkdWxlclR5cGU/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgc2VjdXJpdHlHcm91cElkOiBTZWN1cml0eSBncm91cCBJRC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgc2VjdXJpdHlHcm91cElkPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHNlY3VyaXR5R3JvdXBOYW1lOiBJZiB5b3UgZG8gbm90IHVzZSBhbiBleGlzdGluZyBzZWN1cml0eSBncm91cCAoU2VjdXJpdHlHcm91cElkIGlzIGVtcHR5KSwgdGhlbiB1c2UgdGhpcyBuYW1lIHRvIGNyZWF0ZSBhIG5ldyBzZWN1cml0eSBncm91cCwgdGhlIGRlZmF1bHQgcG9saWN5LiBGb3JtYXQgUmVxdWlyZW1lbnRzIFJlZmVyZW5jZSBFQ1Mgc2VjdXJpdHkgZ3JvdXAgbmFtZS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgc2VjdXJpdHlHcm91cE5hbWU/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgdm9sdW1lUHJvdG9jb2w6IFNoYXJlZCBzdG9yYWdlIG5ldHdvcmsgcHJvdG9jb2xzLCBjdXJyZW50bHkgb25seSBzdXBwb3J0cyBuZnMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHZvbHVtZVByb3RvY29sPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZvbHVtZVR5cGU6IE5ldHdvcmsgc2hhcmVkIHN0b3JhZ2UgdHlwZXMsIGN1cnJlbnRseSBzdXBwb3J0cyBvbmx5IEFsaSBjbG91ZCBOQVMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHZvbHVtZVR5cGU/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgem9uZUlkOiBBdmFpbGFibGUgYXJlYSBJRC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgem9uZUlkPzogc3RyaW5nO1xyXG59XHJcblxyXG4vKipcclxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUm9zQ2x1c3RlclByb3BzYFxyXG4gKlxyXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zQ2x1c3RlclByb3BzYFxyXG4gKlxyXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxyXG4gKi9cclxuZnVuY3Rpb24gUm9zQ2x1c3RlclByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcclxuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHJvcy5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cclxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcclxuICAgIGlmKHByb3BlcnRpZXMuaW1hZ2VPd25lckFsaWFzICYmICh0eXBlb2YgcHJvcGVydGllcy5pbWFnZU93bmVyQWxpYXMpICE9PSAnb2JqZWN0Jykge1xyXG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW1hZ2VPd25lckFsaWFzJywgcm9zLnZhbGlkYXRlQWxsb3dlZFZhbHVlcykoe1xyXG4gICAgICAgICAgZGF0YTogcHJvcGVydGllcy5pbWFnZU93bmVyQWxpYXMsXHJcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbXCJzeXN0ZW1cIixcInNlbGZcIixcIm90aGVyc1wiLFwibWFya2V0cGxhY2VcIl0sXHJcbiAgICAgICAgfSkpO1xyXG4gICAgfVxyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdpbWFnZU93bmVyQWxpYXMnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuaW1hZ2VPd25lckFsaWFzKSk7XHJcbiAgICBpZihwcm9wZXJ0aWVzLnZvbHVtZVByb3RvY29sICYmICh0eXBlb2YgcHJvcGVydGllcy52b2x1bWVQcm90b2NvbCkgIT09ICdvYmplY3QnKSB7XHJcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd2b2x1bWVQcm90b2NvbCcsIHJvcy52YWxpZGF0ZUFsbG93ZWRWYWx1ZXMpKHtcclxuICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMudm9sdW1lUHJvdG9jb2wsXHJcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbXCJuZnNcIl0sXHJcbiAgICAgICAgfSkpO1xyXG4gICAgfVxyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd2b2x1bWVQcm90b2NvbCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52b2x1bWVQcm90b2NvbCkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlckNvbXB1dGVDb3VudCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5lY3NPcmRlckNvbXB1dGVDb3VudCkpO1xyXG4gICAgaWYocHJvcGVydGllcy5lY3NPcmRlckNvbXB1dGVDb3VudCAmJiAodHlwZW9mIHByb3BlcnRpZXMuZWNzT3JkZXJDb21wdXRlQ291bnQpICE9PSAnb2JqZWN0Jykge1xyXG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzT3JkZXJDb21wdXRlQ291bnQnLCByb3MudmFsaWRhdGVSYW5nZSkoe1xyXG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmVjc09yZGVyQ29tcHV0ZUNvdW50LFxyXG4gICAgICAgICAgICBtaW46IDEsXHJcbiAgICAgICAgICAgIG1heDogOTksXHJcbiAgICAgICAgICB9KSk7XHJcbiAgICB9XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Vjc09yZGVyQ29tcHV0ZUNvdW50Jywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmVjc09yZGVyQ29tcHV0ZUNvdW50KSk7XHJcbiAgICBpZihwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uICYmIChBcnJheS5pc0FycmF5KHByb3BlcnRpZXMuZGVzY3JpcHRpb24pIHx8ICh0eXBlb2YgcHJvcGVydGllcy5kZXNjcmlwdGlvbikgPT09ICdzdHJpbmcnKSkge1xyXG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGVzY3JpcHRpb24nLCByb3MudmFsaWRhdGVMZW5ndGgpKHtcclxuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5kZXNjcmlwdGlvbi5sZW5ndGgsXHJcbiAgICAgICAgICAgIG1pbjogMixcclxuICAgICAgICAgICAgbWF4OiAxMjgsXHJcbiAgICAgICAgICB9KSk7XHJcbiAgICB9XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Rlc2NyaXB0aW9uJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3NlY3VyaXR5R3JvdXBOYW1lJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNlY3VyaXR5R3JvdXBOYW1lKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2F1dG9SZW5ldycsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuYXV0b1JlbmV3KSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2NvbXB1dGVTcG90UHJpY2VMaW1pdCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jb21wdXRlU3BvdFByaWNlTGltaXQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5uYW1lKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ25hbWUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubmFtZSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd2b2x1bWVJZCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy52b2x1bWVJZCkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd2b2x1bWVJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy52b2x1bWVJZCkpO1xyXG4gICAgaWYocHJvcGVydGllcy52b2x1bWVUeXBlICYmICh0eXBlb2YgcHJvcGVydGllcy52b2x1bWVUeXBlKSAhPT0gJ29iamVjdCcpIHtcclxuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZvbHVtZVR5cGUnLCByb3MudmFsaWRhdGVBbGxvd2VkVmFsdWVzKSh7XHJcbiAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLnZvbHVtZVR5cGUsXHJcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbXCJuYXNcIl0sXHJcbiAgICAgICAgfSkpO1xyXG4gICAgfVxyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd2b2x1bWVUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZvbHVtZVR5cGUpKTtcclxuICAgIGlmKHByb3BlcnRpZXMuZGVwbG95TW9kZSAmJiAodHlwZW9mIHByb3BlcnRpZXMuZGVwbG95TW9kZSkgIT09ICdvYmplY3QnKSB7XHJcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkZXBsb3lNb2RlJywgcm9zLnZhbGlkYXRlQWxsb3dlZFZhbHVlcykoe1xyXG4gICAgICAgICAgZGF0YTogcHJvcGVydGllcy5kZXBsb3lNb2RlLFxyXG4gICAgICAgICAgYWxsb3dlZFZhbHVlczogW1wiU3RhbmRhcmRcIixcIkFkdmFuY2VkXCIsXCJTaW1wbGVcIixcIlRpbnlcIixcIk9uZUJveFwiXSxcclxuICAgICAgICB9KSk7XHJcbiAgICB9XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2RlcGxveU1vZGUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGVwbG95TW9kZSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdwb3N0SW5zdGFsbFNjcmlwdCcsIHJvcy5saXN0VmFsaWRhdG9yKFJvc0NsdXN0ZXJfUG9zdEluc3RhbGxTY3JpcHRQcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMucG9zdEluc3RhbGxTY3JpcHQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW1hZ2VJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5pbWFnZUlkKSk7XHJcbiAgICBpZihwcm9wZXJ0aWVzLnBhc3N3b3JkICYmIChBcnJheS5pc0FycmF5KHByb3BlcnRpZXMucGFzc3dvcmQpIHx8ICh0eXBlb2YgcHJvcGVydGllcy5wYXNzd29yZCkgPT09ICdzdHJpbmcnKSkge1xyXG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncGFzc3dvcmQnLCByb3MudmFsaWRhdGVMZW5ndGgpKHtcclxuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5wYXNzd29yZC5sZW5ndGgsXHJcbiAgICAgICAgICAgIG1pbjogOCxcclxuICAgICAgICAgICAgbWF4OiAzMCxcclxuICAgICAgICAgIH0pKTtcclxuICAgIH1cclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncGFzc3dvcmQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGFzc3dvcmQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXV0b1JlbmV3UGVyaW9kJywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmF1dG9SZW5ld1BlcmlvZCkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdrZXlQYWlyTmFtZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5rZXlQYWlyTmFtZSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdyZW1vdGVEaXJlY3RvcnknLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucmVtb3RlRGlyZWN0b3J5KSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3NjY0NsdXN0ZXJJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zY2NDbHVzdGVySWQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5lY3NPcmRlckxvZ2luSW5zdGFuY2VUeXBlKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Vjc09yZGVyTG9naW5JbnN0YW5jZVR5cGUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd6b25lSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuem9uZUlkKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2pvYlF1ZXVlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmpvYlF1ZXVlKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Vjc09yZGVyTG9naW5Db3VudCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5lY3NPcmRlckxvZ2luQ291bnQpKTtcclxuICAgIGlmKHByb3BlcnRpZXMuZWNzT3JkZXJMb2dpbkNvdW50ICYmICh0eXBlb2YgcHJvcGVydGllcy5lY3NPcmRlckxvZ2luQ291bnQpICE9PSAnb2JqZWN0Jykge1xyXG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzT3JkZXJMb2dpbkNvdW50Jywgcm9zLnZhbGlkYXRlUmFuZ2UpKHtcclxuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5lY3NPcmRlckxvZ2luQ291bnQsXHJcbiAgICAgICAgICAgIG1pbjogMSxcclxuICAgICAgICAgICAgbWF4OiAxLFxyXG4gICAgICAgICAgfSkpO1xyXG4gICAgfVxyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlckxvZ2luQ291bnQnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZWNzT3JkZXJMb2dpbkNvdW50KSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZTd2l0Y2hJZCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy52U3dpdGNoSWQpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndlN3aXRjaElkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZTd2l0Y2hJZCkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzZWN1cml0eUdyb3VwSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2VjdXJpdHlHcm91cElkKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3BlcmlvZCcsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5wZXJpb2QpKTtcclxuICAgIGlmKHByb3BlcnRpZXMuc2NoZWR1bGVyVHlwZSAmJiAodHlwZW9mIHByb3BlcnRpZXMuc2NoZWR1bGVyVHlwZSkgIT09ICdvYmplY3QnKSB7XHJcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdzY2hlZHVsZXJUeXBlJywgcm9zLnZhbGlkYXRlQWxsb3dlZFZhbHVlcykoe1xyXG4gICAgICAgICAgZGF0YTogcHJvcGVydGllcy5zY2hlZHVsZXJUeXBlLFxyXG4gICAgICAgICAgYWxsb3dlZFZhbHVlczogW1wicGJzXCJdLFxyXG4gICAgICAgIH0pKTtcclxuICAgIH1cclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc2NoZWR1bGVyVHlwZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zY2hlZHVsZXJUeXBlKSk7XHJcbiAgICBpZihwcm9wZXJ0aWVzLmNvbXB1dGVTcG90U3RyYXRlZ3kgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLmNvbXB1dGVTcG90U3RyYXRlZ3kpICE9PSAnb2JqZWN0Jykge1xyXG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY29tcHV0ZVNwb3RTdHJhdGVneScsIHJvcy52YWxpZGF0ZUFsbG93ZWRWYWx1ZXMpKHtcclxuICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMuY29tcHV0ZVNwb3RTdHJhdGVneSxcclxuICAgICAgICAgIGFsbG93ZWRWYWx1ZXM6IFtcIk5vU3BvdFwiLFwiU3BvdFdpdGhQcmljZUxpbWl0XCIsXCJTcG90QXNQcmljZUdvXCJdLFxyXG4gICAgICAgIH0pKTtcclxuICAgIH1cclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY29tcHV0ZVNwb3RTdHJhdGVneScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5jb21wdXRlU3BvdFN0cmF0ZWd5KSk7XHJcbiAgICBpZihwcm9wZXJ0aWVzLmFjY291bnRUeXBlICYmICh0eXBlb2YgcHJvcGVydGllcy5hY2NvdW50VHlwZSkgIT09ICdvYmplY3QnKSB7XHJcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdhY2NvdW50VHlwZScsIHJvcy52YWxpZGF0ZUFsbG93ZWRWYWx1ZXMpKHtcclxuICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMuYWNjb3VudFR5cGUsXHJcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbXCJuaXNcIl0sXHJcbiAgICAgICAgfSkpO1xyXG4gICAgfVxyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdhY2NvdW50VHlwZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hY2NvdW50VHlwZSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGUnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZWNzT3JkZXJNYW5hZ2VySW5zdGFuY2VUeXBlKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Vjc09yZGVyTWFuYWdlckluc3RhbmNlVHlwZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5lY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGUpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWhwY1ZlcnNpb24nLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZWhwY1ZlcnNpb24pKTtcclxuICAgIGlmKHByb3BlcnRpZXMuZWhwY1ZlcnNpb24gJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLmVocGNWZXJzaW9uKSAhPT0gJ29iamVjdCcpIHtcclxuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2VocGNWZXJzaW9uJywgcm9zLnZhbGlkYXRlQWxsb3dlZFZhbHVlcykoe1xyXG4gICAgICAgICAgZGF0YTogcHJvcGVydGllcy5laHBjVmVyc2lvbixcclxuICAgICAgICAgIGFsbG93ZWRWYWx1ZXM6IFtcIjEuMC4wXCJdLFxyXG4gICAgICAgIH0pKTtcclxuICAgIH1cclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWhwY1ZlcnNpb24nLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZWhwY1ZlcnNpb24pKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndm9sdW1lTW91bnRwb2ludCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy52b2x1bWVNb3VudHBvaW50KSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZvbHVtZU1vdW50cG9pbnQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudm9sdW1lTW91bnRwb2ludCkpO1xyXG4gICAgaWYocHJvcGVydGllcy5lY3NPcmRlck1hbmFnZXJDb3VudCAmJiAodHlwZW9mIHByb3BlcnRpZXMuZWNzT3JkZXJNYW5hZ2VyQ291bnQpICE9PSAnb2JqZWN0Jykge1xyXG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzT3JkZXJNYW5hZ2VyQ291bnQnLCByb3MudmFsaWRhdGVBbGxvd2VkVmFsdWVzKSh7XHJcbiAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmVjc09yZGVyTWFuYWdlckNvdW50LFxyXG4gICAgICAgICAgYWxsb3dlZFZhbHVlczogWzEsMiw0XSxcclxuICAgICAgICB9KSk7XHJcbiAgICB9XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Vjc09yZGVyTWFuYWdlckNvdW50Jywgcm9zLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmVjc09yZGVyTWFuYWdlckNvdW50KSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Vjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5lY3NPcmRlckNvbXB1dGVJbnN0YW5jZVR5cGUpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmVjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZSkpO1xyXG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdoYUVuYWJsZScsIHJvcy52YWxpZGF0ZUJvb2xlYW4pKHByb3BlcnRpZXMuaGFFbmFibGUpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignb3NUYWcnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMub3NUYWcpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignb3NUYWcnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMub3NUYWcpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWNzQ2hhcmdlVHlwZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5lY3NDaGFyZ2VUeXBlKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2FwcGxpY2F0aW9uJywgcm9zLmxpc3RWYWxpZGF0b3IoUm9zQ2x1c3Rlcl9BcHBsaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5hcHBsaWNhdGlvbikpO1xyXG4gICAgaWYocHJvcGVydGllcy5wZXJpb2RVbml0ICYmICh0eXBlb2YgcHJvcGVydGllcy5wZXJpb2RVbml0KSAhPT0gJ29iamVjdCcpIHtcclxuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3BlcmlvZFVuaXQnLCByb3MudmFsaWRhdGVBbGxvd2VkVmFsdWVzKSh7XHJcbiAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLnBlcmlvZFVuaXQsXHJcbiAgICAgICAgICBhbGxvd2VkVmFsdWVzOiBbXCJXZWVrXCIsXCJNb250aFwiLFwiWWVhclwiXSxcclxuICAgICAgICB9KSk7XHJcbiAgICB9XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3BlcmlvZFVuaXQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGVyaW9kVW5pdCkpO1xyXG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlJvc0NsdXN0ZXJQcm9wc1wiJyk7XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBSZW5kZXJzIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpFSFBDOjpDbHVzdGVyYCByZXNvdXJjZVxyXG4gKlxyXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zQ2x1c3RlclByb3BzYFxyXG4gKlxyXG4gKiBAcmV0dXJucyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6RUhQQzo6Q2x1c3RlcmAgcmVzb3VyY2UuXHJcbiAqL1xyXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xyXG5mdW5jdGlvbiByb3NDbHVzdGVyUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pOiBhbnkge1xyXG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxyXG4gICAgaWYoZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpIHtcclxuICAgICAgICBSb3NDbHVzdGVyUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xyXG4gICAgfVxyXG4gICAgcmV0dXJuIHtcclxuICAgICAgRWNzT3JkZXJDb21wdXRlQ291bnQ6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZWNzT3JkZXJDb21wdXRlQ291bnQpLFxyXG4gICAgICBFY3NPcmRlckNvbXB1dGVJbnN0YW5jZVR5cGU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlKSxcclxuICAgICAgRWNzT3JkZXJMb2dpbkNvdW50OiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmVjc09yZGVyTG9naW5Db3VudCksXHJcbiAgICAgIEVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZSksXHJcbiAgICAgIEVjc09yZGVyTWFuYWdlckluc3RhbmNlVHlwZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5lY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGUpLFxyXG4gICAgICBFaHBjVmVyc2lvbjogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5laHBjVmVyc2lvbiksXHJcbiAgICAgIE5hbWU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubmFtZSksXHJcbiAgICAgIE9zVGFnOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLm9zVGFnKSxcclxuICAgICAgVm9sdW1lSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudm9sdW1lSWQpLFxyXG4gICAgICBWb2x1bWVNb3VudHBvaW50OiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnZvbHVtZU1vdW50cG9pbnQpLFxyXG4gICAgICBWU3dpdGNoSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudlN3aXRjaElkKSxcclxuICAgICAgQWNjb3VudFR5cGU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuYWNjb3VudFR5cGUpLFxyXG4gICAgICBBcHBsaWNhdGlvbjogcm9zLmxpc3RNYXBwZXIocm9zQ2x1c3RlckFwcGxpY2F0aW9uUHJvcGVydHlUb1Jvc1RlbXBsYXRlKShwcm9wZXJ0aWVzLmFwcGxpY2F0aW9uKSxcclxuICAgICAgQXV0b1JlbmV3OiByb3MuYm9vbGVhblRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5hdXRvUmVuZXcpLFxyXG4gICAgICBBdXRvUmVuZXdQZXJpb2Q6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuYXV0b1JlbmV3UGVyaW9kKSxcclxuICAgICAgQ29tcHV0ZVNwb3RQcmljZUxpbWl0OiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmNvbXB1dGVTcG90UHJpY2VMaW1pdCksXHJcbiAgICAgIENvbXB1dGVTcG90U3RyYXRlZ3k6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuY29tcHV0ZVNwb3RTdHJhdGVneSksXHJcbiAgICAgIERlcGxveU1vZGU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZGVwbG95TW9kZSksXHJcbiAgICAgIERlc2NyaXB0aW9uOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlc2NyaXB0aW9uKSxcclxuICAgICAgRWNzQ2hhcmdlVHlwZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5lY3NDaGFyZ2VUeXBlKSxcclxuICAgICAgRWNzT3JkZXJNYW5hZ2VyQ291bnQ6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZWNzT3JkZXJNYW5hZ2VyQ291bnQpLFxyXG4gICAgICBIYUVuYWJsZTogcm9zLmJvb2xlYW5Ub1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuaGFFbmFibGUpLFxyXG4gICAgICBJbWFnZUlkOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmltYWdlSWQpLFxyXG4gICAgICBJbWFnZU93bmVyQWxpYXM6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuaW1hZ2VPd25lckFsaWFzKSxcclxuICAgICAgSm9iUXVldWU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuam9iUXVldWUpLFxyXG4gICAgICBLZXlQYWlyTmFtZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5rZXlQYWlyTmFtZSksXHJcbiAgICAgIFBhc3N3b3JkOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnBhc3N3b3JkKSxcclxuICAgICAgUGVyaW9kOiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnBlcmlvZCksXHJcbiAgICAgIFBlcmlvZFVuaXQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucGVyaW9kVW5pdCksXHJcbiAgICAgIFBvc3RJbnN0YWxsU2NyaXB0OiByb3MubGlzdE1hcHBlcihyb3NDbHVzdGVyUG9zdEluc3RhbGxTY3JpcHRQcm9wZXJ0eVRvUm9zVGVtcGxhdGUpKHByb3BlcnRpZXMucG9zdEluc3RhbGxTY3JpcHQpLFxyXG4gICAgICBSZW1vdGVEaXJlY3Rvcnk6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucmVtb3RlRGlyZWN0b3J5KSxcclxuICAgICAgU2NjQ2x1c3RlcklkOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnNjY0NsdXN0ZXJJZCksXHJcbiAgICAgIFNjaGVkdWxlclR5cGU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuc2NoZWR1bGVyVHlwZSksXHJcbiAgICAgIFNlY3VyaXR5R3JvdXBJZDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zZWN1cml0eUdyb3VwSWQpLFxyXG4gICAgICBTZWN1cml0eUdyb3VwTmFtZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zZWN1cml0eUdyb3VwTmFtZSksXHJcbiAgICAgIFZvbHVtZVByb3RvY29sOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnZvbHVtZVByb3RvY29sKSxcclxuICAgICAgVm9sdW1lVHlwZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy52b2x1bWVUeXBlKSxcclxuICAgICAgWm9uZUlkOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnpvbmVJZCksXHJcbiAgICB9O1xyXG59XHJcblxyXG4vKipcclxuICogQSBST1MgdGVtcGxhdGUgdHlwZTogIGBBTElZVU46OkVIUEM6OkNsdXN0ZXJgXHJcbiAqL1xyXG5leHBvcnQgY2xhc3MgUm9zQ2x1c3RlciBleHRlbmRzIHJvcy5Sb3NSZXNvdXJjZSB7XHJcbiAgICAvKipcclxuICAgICAqIFRoZSByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUk9TX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQUxJWVVOOjpFSFBDOjpDbHVzdGVyXCI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XHJcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLlxyXG4gICAgICovXHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAQXR0cmlidXRlIENsdXN0ZXJJZDogQ2x1c3RlciBJZC5cclxuICAgICAqL1xyXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJDbHVzdGVySWQ6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgRWNzSW5mbzogQSBkYXRhIHN0cnVjdHVyZSBkZXNjcmliaW5nIHRoZSBudW1iZXIgYW5kIHNwZWNpZmljYXRpb25zIG9mIEVDUyBmb3IgdmFyaW91cyBjb21wb25lbnRzIG9mIHRoZSBjbHVzdGVyLlxyXG5Zb3Ugd2lsbCBnZXQgcmVzdWx0cyBzaW1pbGFyIHRvIHRoZSBmb2xsb3dpbmc6IEVjc0luZm86IHtcIk1hbmFnZXJcIjoge1wiQ291bnRcIjogMiwgXCJJbnN0YW5jZVR5cGVcIjogXCJlY3MubjEubGFyZ2VcIn0sIFwiQ29tcHV0ZVwiOiB7XCJDb3VudFwiOiA4LCBcIkluc3RhbmNlVHlwZVwiOiBcImVjcy5uMS5sYXJnZVwifSwgXCJMb2dpblwiOiB7XCJDb3VudFwiOiAxLCBcIkluc3RhbmNlVHlwZVwiOiBcImVjcy5uMS5sYXJnZVwifX1cclxuICAgICAqL1xyXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJFY3NJbmZvOiBhbnk7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAQXR0cmlidXRlIE5hbWU6IENsdXN0ZXIgbmFtZS5cclxuICAgICAqL1xyXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJOYW1lOiBhbnk7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAQXR0cmlidXRlIFNlY3VyaXR5R3JvdXBJZDogU2VjdXJpdHkgZ3JvdXAgSUQuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZWFkb25seSBhdHRyU2VjdXJpdHlHcm91cElkOiBhbnk7XHJcblxyXG4gICAgcHVibGljIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xyXG5cclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBlY3NPcmRlckNvbXB1dGVDb3VudDogQ29tcHV0aW5nIG5vZGUgbnVtYmVyLCB3aGljaCByYW5nZXMgZnJvbTogMS05OS5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGVjc09yZGVyQ29tcHV0ZUNvdW50OiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlOiBDbHVzdGVyIGNvbXB1dGluZyBub2RlIGluc3RhbmNlIHNwZWNpZmljYXRpb25zLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZWNzT3JkZXJMb2dpbkNvdW50OiBMb2dpbiBub2RlIG51bWJlciBjYW4gb25seSBiZSAxLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgZWNzT3JkZXJMb2dpbkNvdW50OiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZTogTG9nIGNsdXN0ZXIgbm9kZSBpbnN0YW5jZSBzcGVjaWZpY2F0aW9ucy5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGU6IENsdXN0ZXIgY29udHJvbCBub2RlIGluc3RhbmNlIHNwZWNpZmljYXRpb25zLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgZWNzT3JkZXJNYW5hZ2VySW5zdGFuY2VUeXBlOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZWhwY1ZlcnNpb246IEUtSFBDIHByb2R1Y3QgdmVyc2lvbiBudW1iZXJzLCBjdXJyZW50bHkgc3VwcG9ydHMgMS4wLjBcclxuICAgICAqL1xyXG4gICAgcHVibGljIGVocGNWZXJzaW9uOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgbmFtZTogQ2x1c3RlciBuYW1lLiAyLTY0IGNoYXJhY3RlcnMgaW4gbGVuZ3RoLCBhbGxvd2luZyBvbmx5IGluY2x1ZGUgQ2hpbmVzZSwgbGV0dGVycywgbnVtYmVycywgZGFzaGVzICgtKSBhbmQgdW5kZXJzY29yZSAoXyksIG11c3QgYmVnaW4gd2l0aCBhIGxldHRlciBvciBDaGluZXNlLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgbmFtZTogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IG9zVGFnOiBPcGVyYXRpbmcgc3lzdGVtIGltYWdlIHRhZy4gWW91IGNhbiBjYWxsIExpc3RJbWFnZXMgQVBJIHRvIHF1ZXJ5LlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgb3NUYWc6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSB2b2x1bWVJZDogQWxpIGNsb3VkIE5BUyBpbnN0YW5jZSBJZC4gQ3VycmVudGx5IGl0IGRvZXMgbm90IHN1cHBvcnQgYXV0b21hdGljIGNyZWF0aW9uIEFsaSBjbG91ZCBOQVMgaW5zdGFuY2UuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyB2b2x1bWVJZDogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZvbHVtZU1vdW50cG9pbnQ6IE5BUyB2cGMgbW91bnQgcG9pbnQuIEN1cnJlbnRseSBpdCBkb2VzIG5vdCBzdXBwb3J0IGF1dG9tYXRpYyBjcmVhdGlvbiBBbGkgY2xvdWQgTkFTIG1vdW50IHBvaW50LlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgdm9sdW1lTW91bnRwb2ludDogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZTd2l0Y2hJZDogVlBDIGluIHN3aXRjaCBJRC4gUHJvZHVjdHMgY3VycmVudGx5IG9ubHkgc3VwcG9ydHMgVlBDIG5ldHdvcmsuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyB2U3dpdGNoSWQ6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhY2NvdW50VHlwZTogRG9tYWluIHNlcnZpY2UgYWNjb3VudCB0eXBlcywgY3VycmVudGx5IHN1cHBvcnRzIG5pcy5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGFjY291bnRUeXBlOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgYXBwbGljYXRpb246IEFwcGxpY2F0aW9uIHNvZnR3YXJlIHRhZyAoU29mdHdhcmVUYWcpIGxpc3QsIFlvdSBjYW4gY2FsbCBMaXN0U29mdHdhcmVzIEFQSSB0byBxdWVyeS5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGFwcGxpY2F0aW9uOiBBcnJheTxSb3NDbHVzdGVyLkFwcGxpY2F0aW9uUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGF1dG9SZW5ldzogdHJ1ZTogYXV0b21hdGljIHJlbmV3YWxzOyBmYWxzZTogbm8gYXV0b21hdGljIHJlbmV3YWxzLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgYXV0b1JlbmV3OiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGF1dG9SZW5ld1BlcmlvZDogRHVyYXRpb24gb2YgZWFjaCBhdXRvbWF0aWMgcmVuZXdhbHMsIEF1dG9SZW5ldyB0YWtlIGVmZmVjdCB3aGVuIEF1dG9SZW5ldyBpcyBUcnVlLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgYXV0b1JlbmV3UGVyaW9kOiBudW1iZXIgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgY29tcHV0ZVNwb3RQcmljZUxpbWl0OiBTZXQgYW4gZXhhbXBsZSBvZiB0aGUgaGlnaGVzdCBwcmljZSBwZXIgaG91ciwgYXJlIGZsb2F0aW5nLXBvaW50IHZhbHVlcywgaW4gdGhlIHJhbmdlIG9mIHRoZSBjdXJyZW50IHByaWNlIHJhbmdlLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgY29tcHV0ZVNwb3RQcmljZUxpbWl0OiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgY29tcHV0ZVNwb3RTdHJhdGVneTogQ29tcHV0ZSBub2RlcyBiaWRkaW5nIHN0cmF0ZWd5LCB2YWx1ZSBOb1Nwb3QsIFNwb3RXaXRoUHJpY2VMaW1pdCBvciBTcG90QXNQcmljZUdvXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBjb21wdXRlU3BvdFN0cmF0ZWd5OiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZGVwbG95TW9kZTogRGVwbG95bWVudCBtb2RlOlxyXG4gICAgICogU3RhbmRhcmQ6IGFjY291bnQgbm9kZSArIHNjaGVkdWxpbmcgbm9kZSArIGxvZ2luIG5vZGUgKyBjb21wdXRpbmcgbm9kZS5cclxuICAgICAqIEFkdmFuY2VkOiBIQSBtb2RlLlxyXG4gICAgICogU2ltcGxlOiAoYWNjb3VudCArIHNjaGVkdWxlKSBub2RlICsgbG9naW4gbm9kZSArIGNvbXB1dGUgbm9kZS5cclxuICAgICAqIFRpbnk6IChhY2NvdW50ICsgc2NoZWR1bGluZyArIGxvZ2luKSBub2RlICsgY29tcHV0ZSBub2RlLlxyXG4gICAgICogT25lQm94OiAoYWNjb3VudCArIHNjaGVkdWxpbmcgKyBsb2dpbiArIGNvbXB1dGUpIG5vZGUgKyBtb3JlIGNvbXB1dGUgbm9kZXMuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBkZXBsb3lNb2RlOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZGVzY3JpcHRpb246IENsdXN0ZXIgZGVzY3JpcHRpb24sIDIgdG8gMTI4IGNoYXJhY3RlcnMuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBkZXNjcmlwdGlvbjogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGVjc0NoYXJnZVR5cGU6IEVDUyBpbnN0YW5jZSBwYXltZW50IHR5cGUsIFBvc3RQYWlkOiBQYXktQXMtWW91LUdvLlByZVBhaWQ6IFN1YnNjcmlwdGlvbi5JZiB5b3UgY2hvb3NlIFByZVBhaWQsIGF1dG9tYXRpYyByZW5ld2FsIHdpbGwgYmUgZW5hYmxlZCBieSBkZWZhdWx0LCBhbmQgY2xvc2VkIHdoZW4gbm9kZSBpcyByZWxlYXNlZC5cclxuICAgICAqL1xyXG4gICAgcHVibGljIGVjc0NoYXJnZVR5cGU6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBlY3NPcmRlck1hbmFnZXJDb3VudDogQ29udHJvbCBub2RlIG51bWJlciBjYW4gYmUgMSwgMiwgNChIQSlcclxuICAgICAqL1xyXG4gICAgcHVibGljIGVjc09yZGVyTWFuYWdlckNvdW50OiBudW1iZXIgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaGFFbmFibGU6IEF2YWlsYWJpbGl0eSBpcyB0dXJuZWQgb24sIHdoZW4gdHVybmVkIG9uLCB0aGUgcm9sZSBvZiBlYWNoIGNvbnRyb2wgY2x1c3RlciB3aWxsIHVzZSB0d28gc3RhbmRieSBpbnN0YW5jZXMuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBoYUVuYWJsZTogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBpbWFnZUlkOiBNaXJyb3IgSWQsIGlmIEltYWdlVHlwZSBhIHN5c3RlbSwgYmFzZWQgb24gdGhlIGltYWdlIElEIGlzIGRldGVybWluZWQgb25seSBhY2NvcmRpbmcgT3NUYWc7IGlmIHNlbGYsIG90aGVycywgb3IgbWFya2V0cGxhY2UsIEltYWdlSWQgaXMgbWFuZGF0b3J5LlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgaW1hZ2VJZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGltYWdlT3duZXJBbGlhczogTWlycm9yIHR5cGU6IHN5c3RlbSwgc2VsZiwgb3RoZXJzIG9yIG1hcmtldHBsYWNlXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBpbWFnZU93bmVyQWxpYXM6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBqb2JRdWV1ZTogQ29tcHV0aW5nIG5vZGUgYWRkZWQgcXVldWVcclxuICAgICAqL1xyXG4gICAgcHVibGljIGpvYlF1ZXVlOiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkga2V5UGFpck5hbWU6IEtleSBwYWlyIG5hbWUuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBrZXlQYWlyTmFtZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHBhc3N3b3JkOiBSb290IHBhc3N3b3JkIG9mIGp1bXAgc2VydmVyIChsb2dpbiBub2RlKS4gOCB0byAzMCBjaGFyYWN0ZXJzLCBtdXN0IGNvbnRhaW4gdGhyZWUgKHVwcGVyIGFuZCBsb3dlciBjYXNlIGxldHRlcnMsIG51bWJlcnMgYW5kIHNwZWNpYWwgc3ltYm9scykuICEgU3VwcG9ydHMgdGhlIGZvbGxvd2luZyBzcGVjaWFsIGNoYXJhY3RlcnMgOigpIGB+IEAgIyAkJSBeICYgKiAtICsgPSB8IHt9IFtdOjsgJzw+LCAvIEJlIHN1cmUgdG8gdXNlIHRoZSBIVFRQUyBwcm90b2NvbCBBUEkgY2FsbCB0byBhdm9pZCBwYXNzd29yZCBsZWFrcyB0aGF0IG1heSBvY2N1ci4/LlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcGFzc3dvcmQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBwZXJpb2Q6IFRoZSBwdXJjaGFzZSBvZiBsb25nIHJlc291cmNlcywgdW5pdHM6IHdlZWsgLyBtb250aCAvIHllYXIuIFdoZW4gdGhlIHZhbHVlIG9mIHRoZSBwYXJhbWV0ZXIgRWNzQ2hhcmdlVHlwZSB3aGVuIFByZVBhaWQgdGFrZSBlZmZlY3QgYW5kIGZvciB0aGUgc2VsZWN0ZWQgdmFsdWUgd2lsbCBiZS5cclxuICAgICAqL1xyXG4gICAgcHVibGljIHBlcmlvZDogbnVtYmVyIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHBlcmlvZFVuaXQ6IFRoZSBwdXJjaGFzZSBvZiBsb25nLXJlc291cmNlcyB1bml0LiBBbHRlcm5hdGl2ZWx5IHZhbHVlIFdlZWsgLyBNb250aCAvIHllYXIuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBwZXJpb2RVbml0OiBzdHJpbmcgfCB1bmRlZmluZWQ7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgcG9zdEluc3RhbGxTY3JpcHQ6XHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBwb3N0SW5zdGFsbFNjcmlwdDogQXJyYXk8Um9zQ2x1c3Rlci5Qb3N0SW5zdGFsbFNjcmlwdFByb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlPiB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSByZW1vdGVEaXJlY3Rvcnk6IE1vdW50IHNoYXJlZCBzdG9yYWdlIHJlbW90ZSBkaXJlY3RvcnkuIFRoZSBmaW5hbCBwYXRoIHRvIHRoZSBtb3VudCBwb2ludCBhbmQgbW91bnQgdGhlIHJlbW90ZSBkaXJlY3RvcnkgY29tcG9zaXRpb246IE5hc01vdW50cG9pbnQ6IC8gUmVtb3RlRGlyZWN0b3J5XHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZW1vdGVEaXJlY3Rvcnk6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBzY2NDbHVzdGVySWQ6IFdoZW4gU0NDIG1vZGVscywgaWYgeW91IHBhc3MgdGhpcyBmaWVsZCwgdGhlbiB0aGUgc3BlY2lmaWVkIFNjY0NsdXN0ZXIgY3JlYXRlIFNjYyBpbnN0YW5jZSwgb3RoZXJ3aXNlIGl0IHdpbGwgY3JlYXRlIGFuIGluc3RhbmNlIGZvciB0aGUgdXNlci5cclxuICAgICAqL1xyXG4gICAgcHVibGljIHNjY0NsdXN0ZXJJZDogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHNjaGVkdWxlclR5cGU6IFRoZSBzY2hlZHVsZXIgdHlwZSwgY3VycmVudGx5IHN1cHBvcnQgcGJzLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgc2NoZWR1bGVyVHlwZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHNlY3VyaXR5R3JvdXBJZDogU2VjdXJpdHkgZ3JvdXAgSUQuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBzZWN1cml0eUdyb3VwSWQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBzZWN1cml0eUdyb3VwTmFtZTogSWYgeW91IGRvIG5vdCB1c2UgYW4gZXhpc3Rpbmcgc2VjdXJpdHkgZ3JvdXAgKFNlY3VyaXR5R3JvdXBJZCBpcyBlbXB0eSksIHRoZW4gdXNlIHRoaXMgbmFtZSB0byBjcmVhdGUgYSBuZXcgc2VjdXJpdHkgZ3JvdXAsIHRoZSBkZWZhdWx0IHBvbGljeS4gRm9ybWF0IFJlcXVpcmVtZW50cyBSZWZlcmVuY2UgRUNTIHNlY3VyaXR5IGdyb3VwIG5hbWUuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyBzZWN1cml0eUdyb3VwTmFtZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZvbHVtZVByb3RvY29sOiBTaGFyZWQgc3RvcmFnZSBuZXR3b3JrIHByb3RvY29scywgY3VycmVudGx5IG9ubHkgc3VwcG9ydHMgbmZzLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgdm9sdW1lUHJvdG9jb2w6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSB2b2x1bWVUeXBlOiBOZXR3b3JrIHNoYXJlZCBzdG9yYWdlIHR5cGVzLCBjdXJyZW50bHkgc3VwcG9ydHMgb25seSBBbGkgY2xvdWQgTkFTLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgdm9sdW1lVHlwZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHpvbmVJZDogQXZhaWxhYmxlIGFyZWEgSUQuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyB6b25lSWQ6IHN0cmluZyB8IHVuZGVmaW5lZDtcclxuXHJcbiAgICAvKipcclxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpFSFBDOjpDbHVzdGVyYC5cclxuICAgICAqXHJcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcclxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcclxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcclxuICAgICAqL1xyXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSb3NDbHVzdGVyUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuKSB7XHJcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IFJvc0NsdXN0ZXIuUk9TX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XHJcbiAgICAgICAgdGhpcy5hdHRyQ2x1c3RlcklkID0gcm9zLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdDbHVzdGVySWQnKSk7XHJcbiAgICAgICAgdGhpcy5hdHRyRWNzSW5mbyA9IHJvcy5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnRWNzSW5mbycpKTtcclxuICAgICAgICB0aGlzLmF0dHJOYW1lID0gcm9zLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdOYW1lJykpO1xyXG4gICAgICAgIHRoaXMuYXR0clNlY3VyaXR5R3JvdXBJZCA9IHJvcy5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnU2VjdXJpdHlHcm91cElkJykpO1xyXG5cclxuICAgICAgICB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ID0gZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ7XHJcbiAgICAgICAgdGhpcy5lY3NPcmRlckNvbXB1dGVDb3VudCA9IHByb3BzLmVjc09yZGVyQ29tcHV0ZUNvdW50O1xyXG4gICAgICAgIHRoaXMuZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlID0gcHJvcHMuZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlO1xyXG4gICAgICAgIHRoaXMuZWNzT3JkZXJMb2dpbkNvdW50ID0gcHJvcHMuZWNzT3JkZXJMb2dpbkNvdW50O1xyXG4gICAgICAgIHRoaXMuZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZSA9IHByb3BzLmVjc09yZGVyTG9naW5JbnN0YW5jZVR5cGU7XHJcbiAgICAgICAgdGhpcy5lY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGUgPSBwcm9wcy5lY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGU7XHJcbiAgICAgICAgdGhpcy5laHBjVmVyc2lvbiA9IHByb3BzLmVocGNWZXJzaW9uO1xyXG4gICAgICAgIHRoaXMubmFtZSA9IHByb3BzLm5hbWU7XHJcbiAgICAgICAgdGhpcy5vc1RhZyA9IHByb3BzLm9zVGFnO1xyXG4gICAgICAgIHRoaXMudm9sdW1lSWQgPSBwcm9wcy52b2x1bWVJZDtcclxuICAgICAgICB0aGlzLnZvbHVtZU1vdW50cG9pbnQgPSBwcm9wcy52b2x1bWVNb3VudHBvaW50O1xyXG4gICAgICAgIHRoaXMudlN3aXRjaElkID0gcHJvcHMudlN3aXRjaElkO1xyXG4gICAgICAgIHRoaXMuYWNjb3VudFR5cGUgPSBwcm9wcy5hY2NvdW50VHlwZTtcclxuICAgICAgICB0aGlzLmFwcGxpY2F0aW9uID0gcHJvcHMuYXBwbGljYXRpb247XHJcbiAgICAgICAgdGhpcy5hdXRvUmVuZXcgPSBwcm9wcy5hdXRvUmVuZXc7XHJcbiAgICAgICAgdGhpcy5hdXRvUmVuZXdQZXJpb2QgPSBwcm9wcy5hdXRvUmVuZXdQZXJpb2Q7XHJcbiAgICAgICAgdGhpcy5jb21wdXRlU3BvdFByaWNlTGltaXQgPSBwcm9wcy5jb21wdXRlU3BvdFByaWNlTGltaXQ7XHJcbiAgICAgICAgdGhpcy5jb21wdXRlU3BvdFN0cmF0ZWd5ID0gcHJvcHMuY29tcHV0ZVNwb3RTdHJhdGVneTtcclxuICAgICAgICB0aGlzLmRlcGxveU1vZGUgPSBwcm9wcy5kZXBsb3lNb2RlO1xyXG4gICAgICAgIHRoaXMuZGVzY3JpcHRpb24gPSBwcm9wcy5kZXNjcmlwdGlvbjtcclxuICAgICAgICB0aGlzLmVjc0NoYXJnZVR5cGUgPSBwcm9wcy5lY3NDaGFyZ2VUeXBlO1xyXG4gICAgICAgIHRoaXMuZWNzT3JkZXJNYW5hZ2VyQ291bnQgPSBwcm9wcy5lY3NPcmRlck1hbmFnZXJDb3VudDtcclxuICAgICAgICB0aGlzLmhhRW5hYmxlID0gcHJvcHMuaGFFbmFibGU7XHJcbiAgICAgICAgdGhpcy5pbWFnZUlkID0gcHJvcHMuaW1hZ2VJZDtcclxuICAgICAgICB0aGlzLmltYWdlT3duZXJBbGlhcyA9IHByb3BzLmltYWdlT3duZXJBbGlhcztcclxuICAgICAgICB0aGlzLmpvYlF1ZXVlID0gcHJvcHMuam9iUXVldWU7XHJcbiAgICAgICAgdGhpcy5rZXlQYWlyTmFtZSA9IHByb3BzLmtleVBhaXJOYW1lO1xyXG4gICAgICAgIHRoaXMucGFzc3dvcmQgPSBwcm9wcy5wYXNzd29yZDtcclxuICAgICAgICB0aGlzLnBlcmlvZCA9IHByb3BzLnBlcmlvZDtcclxuICAgICAgICB0aGlzLnBlcmlvZFVuaXQgPSBwcm9wcy5wZXJpb2RVbml0O1xyXG4gICAgICAgIHRoaXMucG9zdEluc3RhbGxTY3JpcHQgPSBwcm9wcy5wb3N0SW5zdGFsbFNjcmlwdDtcclxuICAgICAgICB0aGlzLnJlbW90ZURpcmVjdG9yeSA9IHByb3BzLnJlbW90ZURpcmVjdG9yeTtcclxuICAgICAgICB0aGlzLnNjY0NsdXN0ZXJJZCA9IHByb3BzLnNjY0NsdXN0ZXJJZDtcclxuICAgICAgICB0aGlzLnNjaGVkdWxlclR5cGUgPSBwcm9wcy5zY2hlZHVsZXJUeXBlO1xyXG4gICAgICAgIHRoaXMuc2VjdXJpdHlHcm91cElkID0gcHJvcHMuc2VjdXJpdHlHcm91cElkO1xyXG4gICAgICAgIHRoaXMuc2VjdXJpdHlHcm91cE5hbWUgPSBwcm9wcy5zZWN1cml0eUdyb3VwTmFtZTtcclxuICAgICAgICB0aGlzLnZvbHVtZVByb3RvY29sID0gcHJvcHMudm9sdW1lUHJvdG9jb2w7XHJcbiAgICAgICAgdGhpcy52b2x1bWVUeXBlID0gcHJvcHMudm9sdW1lVHlwZTtcclxuICAgICAgICB0aGlzLnpvbmVJZCA9IHByb3BzLnpvbmVJZDtcclxuICAgIH1cclxuXHJcblxyXG4gICAgcHJvdGVjdGVkIGdldCByb3NQcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcclxuICAgICAgICByZXR1cm4ge1xyXG4gICAgICAgICAgICBlY3NPcmRlckNvbXB1dGVDb3VudDogdGhpcy5lY3NPcmRlckNvbXB1dGVDb3VudCxcclxuICAgICAgICAgICAgZWNzT3JkZXJDb21wdXRlSW5zdGFuY2VUeXBlOiB0aGlzLmVjc09yZGVyQ29tcHV0ZUluc3RhbmNlVHlwZSxcclxuICAgICAgICAgICAgZWNzT3JkZXJMb2dpbkNvdW50OiB0aGlzLmVjc09yZGVyTG9naW5Db3VudCxcclxuICAgICAgICAgICAgZWNzT3JkZXJMb2dpbkluc3RhbmNlVHlwZTogdGhpcy5lY3NPcmRlckxvZ2luSW5zdGFuY2VUeXBlLFxyXG4gICAgICAgICAgICBlY3NPcmRlck1hbmFnZXJJbnN0YW5jZVR5cGU6IHRoaXMuZWNzT3JkZXJNYW5hZ2VySW5zdGFuY2VUeXBlLFxyXG4gICAgICAgICAgICBlaHBjVmVyc2lvbjogdGhpcy5laHBjVmVyc2lvbixcclxuICAgICAgICAgICAgbmFtZTogdGhpcy5uYW1lLFxyXG4gICAgICAgICAgICBvc1RhZzogdGhpcy5vc1RhZyxcclxuICAgICAgICAgICAgdm9sdW1lSWQ6IHRoaXMudm9sdW1lSWQsXHJcbiAgICAgICAgICAgIHZvbHVtZU1vdW50cG9pbnQ6IHRoaXMudm9sdW1lTW91bnRwb2ludCxcclxuICAgICAgICAgICAgdlN3aXRjaElkOiB0aGlzLnZTd2l0Y2hJZCxcclxuICAgICAgICAgICAgYWNjb3VudFR5cGU6IHRoaXMuYWNjb3VudFR5cGUsXHJcbiAgICAgICAgICAgIGFwcGxpY2F0aW9uOiB0aGlzLmFwcGxpY2F0aW9uLFxyXG4gICAgICAgICAgICBhdXRvUmVuZXc6IHRoaXMuYXV0b1JlbmV3LFxyXG4gICAgICAgICAgICBhdXRvUmVuZXdQZXJpb2Q6IHRoaXMuYXV0b1JlbmV3UGVyaW9kLFxyXG4gICAgICAgICAgICBjb21wdXRlU3BvdFByaWNlTGltaXQ6IHRoaXMuY29tcHV0ZVNwb3RQcmljZUxpbWl0LFxyXG4gICAgICAgICAgICBjb21wdXRlU3BvdFN0cmF0ZWd5OiB0aGlzLmNvbXB1dGVTcG90U3RyYXRlZ3ksXHJcbiAgICAgICAgICAgIGRlcGxveU1vZGU6IHRoaXMuZGVwbG95TW9kZSxcclxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHRoaXMuZGVzY3JpcHRpb24sXHJcbiAgICAgICAgICAgIGVjc0NoYXJnZVR5cGU6IHRoaXMuZWNzQ2hhcmdlVHlwZSxcclxuICAgICAgICAgICAgZWNzT3JkZXJNYW5hZ2VyQ291bnQ6IHRoaXMuZWNzT3JkZXJNYW5hZ2VyQ291bnQsXHJcbiAgICAgICAgICAgIGhhRW5hYmxlOiB0aGlzLmhhRW5hYmxlLFxyXG4gICAgICAgICAgICBpbWFnZUlkOiB0aGlzLmltYWdlSWQsXHJcbiAgICAgICAgICAgIGltYWdlT3duZXJBbGlhczogdGhpcy5pbWFnZU93bmVyQWxpYXMsXHJcbiAgICAgICAgICAgIGpvYlF1ZXVlOiB0aGlzLmpvYlF1ZXVlLFxyXG4gICAgICAgICAgICBrZXlQYWlyTmFtZTogdGhpcy5rZXlQYWlyTmFtZSxcclxuICAgICAgICAgICAgcGFzc3dvcmQ6IHRoaXMucGFzc3dvcmQsXHJcbiAgICAgICAgICAgIHBlcmlvZDogdGhpcy5wZXJpb2QsXHJcbiAgICAgICAgICAgIHBlcmlvZFVuaXQ6IHRoaXMucGVyaW9kVW5pdCxcclxuICAgICAgICAgICAgcG9zdEluc3RhbGxTY3JpcHQ6IHRoaXMucG9zdEluc3RhbGxTY3JpcHQsXHJcbiAgICAgICAgICAgIHJlbW90ZURpcmVjdG9yeTogdGhpcy5yZW1vdGVEaXJlY3RvcnksXHJcbiAgICAgICAgICAgIHNjY0NsdXN0ZXJJZDogdGhpcy5zY2NDbHVzdGVySWQsXHJcbiAgICAgICAgICAgIHNjaGVkdWxlclR5cGU6IHRoaXMuc2NoZWR1bGVyVHlwZSxcclxuICAgICAgICAgICAgc2VjdXJpdHlHcm91cElkOiB0aGlzLnNlY3VyaXR5R3JvdXBJZCxcclxuICAgICAgICAgICAgc2VjdXJpdHlHcm91cE5hbWU6IHRoaXMuc2VjdXJpdHlHcm91cE5hbWUsXHJcbiAgICAgICAgICAgIHZvbHVtZVByb3RvY29sOiB0aGlzLnZvbHVtZVByb3RvY29sLFxyXG4gICAgICAgICAgICB2b2x1bWVUeXBlOiB0aGlzLnZvbHVtZVR5cGUsXHJcbiAgICAgICAgICAgIHpvbmVJZDogdGhpcy56b25lSWQsXHJcbiAgICAgICAgfTtcclxuICAgIH1cclxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcclxuICAgICAgICByZXR1cm4gcm9zQ2x1c3RlclByb3BzVG9Sb3NUZW1wbGF0ZShwcm9wcywgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XHJcbiAgICB9XHJcbn1cclxuXHJcbmV4cG9ydCBuYW1lc3BhY2UgUm9zQ2x1c3RlciB7XHJcbiAgICAvKipcclxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcclxuICAgICAqL1xyXG4gICAgZXhwb3J0IGludGVyZmFjZSBBcHBsaWNhdGlvblByb3BlcnR5IHtcclxuICAgICAgICAvKipcclxuICAgICAgICAgKiBAUHJvcGVydHkgdGFnOiBBcHBsaWNhdGlvbiBzb2Z0d2FyZSB0YWcgKFNvZnR3YXJlVGFnKSwgZm9yIGV4YW1wbGUgT3Blbk1QSV8xMS4xLlxyXG4gICAgICAgICAqL1xyXG4gICAgICAgIHJlYWRvbmx5IHRhZzogc3RyaW5nO1xyXG4gICAgfVxyXG59XHJcbi8qKlxyXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBBcHBsaWNhdGlvblByb3BlcnR5YFxyXG4gKlxyXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQXBwbGljYXRpb25Qcm9wZXJ0eWBcclxuICpcclxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cclxuICovXHJcbmZ1bmN0aW9uIFJvc0NsdXN0ZXJfQXBwbGljYXRpb25Qcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiByb3MuVmFsaWRhdGlvblJlc3VsdCB7XHJcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XHJcbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgcm9zLlZhbGlkYXRpb25SZXN1bHRzKCk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3RhZycsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy50YWcpKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndGFnJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnRhZykpO1xyXG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIkFwcGxpY2F0aW9uUHJvcGVydHlcIicpO1xyXG59XHJcblxyXG4vKipcclxuICogUmVuZGVycyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6RUhQQzo6Q2x1c3Rlci5BcHBsaWNhdGlvbmAgcmVzb3VyY2VcclxuICpcclxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYEFwcGxpY2F0aW9uUHJvcGVydHlgXHJcbiAqXHJcbiAqIEByZXR1cm5zIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpFSFBDOjpDbHVzdGVyLkFwcGxpY2F0aW9uYCByZXNvdXJjZS5cclxuICovXHJcbi8vIEB0cy1pZ25vcmUgVFM2MTMzXHJcbmZ1bmN0aW9uIHJvc0NsdXN0ZXJBcHBsaWNhdGlvblByb3BlcnR5VG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xyXG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxyXG4gICAgUm9zQ2x1c3Rlcl9BcHBsaWNhdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcclxuICAgIHJldHVybiB7XHJcbiAgICAgIFRhZzogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy50YWcpLFxyXG4gICAgfTtcclxufVxyXG5cclxuZXhwb3J0IG5hbWVzcGFjZSBSb3NDbHVzdGVyIHtcclxuICAgIC8qKlxyXG4gICAgICogQHN0YWJpbGl0eSBleHRlcm5hbFxyXG4gICAgICovXHJcbiAgICBleHBvcnQgaW50ZXJmYWNlIFBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHkge1xyXG4gICAgICAgIC8qKlxyXG4gICAgICAgICAqIEBQcm9wZXJ0eSBhcmdzOiBOLXRoIChuIG51bWJlcmVkIHN0YXJ0aW5nIGZyb20gMSwgeW91IGNhbiBoYXZlIG11bHRpcGxlLCBtYXhpbXVtIDE2KSBleGVjdXRpb24gcGFyYW1ldGVycyBhZnRlciB0aGUgaW5zdGFsbGF0aW9uIHNjcmlwdC5cclxuICAgICAgICAgKi9cclxuICAgICAgICByZWFkb25seSBhcmdzPzogc3RyaW5nO1xyXG4gICAgICAgIC8qKlxyXG4gICAgICAgICAqIEBQcm9wZXJ0eSB1cmw6IE4tdGggKG4gbnVtYmVyZWQgc3RhcnRpbmcgd2l0aCAxLCBjYW4gaGF2ZSBtdWx0aXBsZSwgbWF4aW11bSAxNikgYWZ0ZXIgaW5zdGFsbGF0aW9uIHNjcmlwdCBEb3dubG9hZC5cclxuICAgICAgICAgKi9cclxuICAgICAgICByZWFkb25seSB1cmw/OiBzdHJpbmc7XHJcbiAgICB9XHJcbn1cclxuLyoqXHJcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFBvc3RJbnN0YWxsU2NyaXB0UHJvcGVydHlgXHJcbiAqXHJcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQb3N0SW5zdGFsbFNjcmlwdFByb3BlcnR5YFxyXG4gKlxyXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxyXG4gKi9cclxuZnVuY3Rpb24gUm9zQ2x1c3Rlcl9Qb3N0SW5zdGFsbFNjcmlwdFByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcclxuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHJvcy5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cclxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcclxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXJncycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hcmdzKSk7XHJcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3VybCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy51cmwpKTtcclxuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJQb3N0SW5zdGFsbFNjcmlwdFByb3BlcnR5XCInKTtcclxufVxyXG5cclxuLyoqXHJcbiAqIFJlbmRlcnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OkVIUEM6OkNsdXN0ZXIuUG9zdEluc3RhbGxTY3JpcHRgIHJlc291cmNlXHJcbiAqXHJcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQb3N0SW5zdGFsbFNjcmlwdFByb3BlcnR5YFxyXG4gKlxyXG4gKiBAcmV0dXJucyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6RUhQQzo6Q2x1c3Rlci5Qb3N0SW5zdGFsbFNjcmlwdGAgcmVzb3VyY2UuXHJcbiAqL1xyXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xyXG5mdW5jdGlvbiByb3NDbHVzdGVyUG9zdEluc3RhbGxTY3JpcHRQcm9wZXJ0eVRvUm9zVGVtcGxhdGUocHJvcGVydGllczogYW55KTogYW55IHtcclxuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cclxuICAgIFJvc0NsdXN0ZXJfUG9zdEluc3RhbGxTY3JpcHRQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XHJcbiAgICByZXR1cm4ge1xyXG4gICAgICBBcmdzOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmFyZ3MpLFxyXG4gICAgICBVcmw6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudXJsKSxcclxuICAgIH07XHJcbn1cclxuIl19