"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ehpc_generated_1 = require("./ehpc.generated");
Object.defineProperty(exports, "ClusterProperty", { enumerable: true, get: function () { return ehpc_generated_1.RosCluster; } });
/**
 * A ROS resource type:  `ALIYUN::EHPC::Cluster`
 */
class Cluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::EHPC::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCluster = new ehpc_generated_1.RosCluster(this, id, {
            imageOwnerAlias: props.imageOwnerAlias,
            volumeProtocol: props.volumeProtocol,
            ecsOrderComputeCount: props.ecsOrderComputeCount,
            description: props.description,
            securityGroupName: props.securityGroupName,
            autoRenew: props.autoRenew,
            computeSpotPriceLimit: props.computeSpotPriceLimit,
            name: props.name,
            volumeId: props.volumeId,
            volumeType: props.volumeType,
            deployMode: props.deployMode,
            postInstallScript: props.postInstallScript,
            imageId: props.imageId,
            password: props.password,
            autoRenewPeriod: props.autoRenewPeriod,
            keyPairName: props.keyPairName,
            remoteDirectory: props.remoteDirectory,
            sccClusterId: props.sccClusterId,
            ecsOrderLoginInstanceType: props.ecsOrderLoginInstanceType,
            zoneId: props.zoneId,
            jobQueue: props.jobQueue,
            ecsOrderLoginCount: props.ecsOrderLoginCount,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            period: props.period,
            schedulerType: props.schedulerType,
            computeSpotStrategy: props.computeSpotStrategy,
            accountType: props.accountType,
            ecsOrderManagerInstanceType: props.ecsOrderManagerInstanceType,
            ehpcVersion: props.ehpcVersion,
            volumeMountpoint: props.volumeMountpoint,
            ecsOrderManagerCount: props.ecsOrderManagerCount,
            ecsOrderComputeInstanceType: props.ecsOrderComputeInstanceType,
            haEnable: props.haEnable,
            osTag: props.osTag,
            ecsChargeType: props.ecsChargeType,
            application: props.application,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCluster;
        this.attrClusterId = rosCluster.attrClusterId;
        this.attrEcsInfo = rosCluster.attrEcsInfo;
        this.attrName = rosCluster.attrName;
        this.attrSecurityGroupId = rosCluster.attrSecurityGroupId;
    }
}
exports.Cluster = Cluster;
//# sourceMappingURL=data:application/json;base64,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