# This file is generated by codegen.py. DO NOT EDIT!

from __future__ import annotations

import uuid
from typing import TYPE_CHECKING, Callable, List, Optional

# 14: override Element
from gaphor.core.modeling import Comment, Element
from gaphor.core.modeling.properties import (
    association,
    attribute,
    derived,
    derivedunion,
    enumeration,
    redefine,
    relation_many,
    relation_one,
)


class NamedElement(Element):
    name: attribute[str]
    visibility: enumeration
    clientDependency: relation_many[Dependency]
    supplierDependency: relation_many[Dependency]
    informationFlow: relation_many[InformationFlow]
    qualifiedName: derived[list[str]]
    namespace: relation_one[Namespace]
    memberNamespace: relation_many[Namespace]


class PackageableElement(NamedElement):
    component: relation_one[Component]
    owningPackage: relation_one[Package]


class DeployedArtifact(NamedElement):
    pass


class DeploymentTarget(NamedElement):
    deployment: relation_many[Deployment]


class InstanceSpecification(PackageableElement, DeployedArtifact, DeploymentTarget):
    specification: attribute[str]
    slot: relation_many[Slot]
    classifier: relation_many[Classifier]
    extended: relation_many[Element]


class EnumerationLiteral(InstanceSpecification):
    enumeration: relation_one[Enumeration]


class Relationship(Element):
    relatedElement: relation_many[Element]


class DirectedRelationship(Relationship):
    target: relation_many[Element]
    source: relation_many[Element]


class PackageMerge(DirectedRelationship):
    mergingPackage: relation_one[Package]
    mergedPackage: relation_one[Package]


class RedefinableElement(NamedElement):
    isLeaf: attribute[int]
    visibility: enumeration
    redefinedElement: relation_many[RedefinableElement]
    redefinitionContext: relation_many[Classifier]


class Namespace(NamedElement):
    elementImport: relation_many[ElementImport]
    packageImport: relation_many[PackageImport]
    ownedRule: relation_many[Constraint]
    ownedMember: relation_many[NamedElement]
    member: relation_many[NamedElement]
    importedMember: derivedunion[PackageableElement]


class Type(PackageableElement):
    package: relation_one[Package]


class Classifier(RedefinableElement, Namespace, Type):
    isAbstract: attribute[int]
    specialization: relation_many[Generalization]
    ownedUseCase: relation_many[UseCase]
    generalization: relation_many[Generalization]
    useCase: relation_many[UseCase]
    redefinedClassifier: relation_many[Classifier]
    nestingClass: relation_one[Class]
    attribute: relation_many[Property]
    feature: relation_many[Feature]
    general: derived[Classifier]
    inheritedMember: derivedunion[NamedElement]
    componentRealization: relation_many[ComponentRealization]  # type: ignore[assignment]


class Association(Classifier, Relationship):
    isDerived: attribute[int]
    memberEnd: relation_many[Property]
    ownedEnd: relation_many[Property]
    navigableOwnedEnd: relation_many[Property]
    endType: derived[Type]


class Extension(Association):
    isRequired: attribute[int]
    ownedEnd: relation_one[ExtensionEnd]  # type: ignore[assignment]
    metaclass: property


class BehavioredClassifier(Classifier):
    ownedBehavior: relation_many[Behavior]
    interfaceRealization: relation_many[InterfaceRealization]  # type: ignore[assignment]


class Actor(BehavioredClassifier):
    pass


class ActivityNode(RedefinableElement):
    outgoing: relation_many[ActivityEdge]
    incoming: relation_many[ActivityEdge]
    inGroup: relation_many[ActivityGroup]
    inPartition: relation_many[ActivityPartition]
    activity: relation_one[Activity]
    redefinedElement: relation_many[ActivityNode]  # type: ignore[assignment]


class ControlNode(ActivityNode):
    pass


class MergeNode(ControlNode):
    pass


class Feature(RedefinableElement):
    isStatic: attribute[int]
    featuringClassifier: relation_many[Classifier]


class ActivityEdge(RedefinableElement):
    activity: relation_one[Activity]
    guard: attribute[str]
    source: relation_one[ActivityNode]
    target: relation_one[ActivityNode]
    inGroup: relation_many[ActivityGroup]
    redefinedElement: relation_many[ActivityEdge]  # type: ignore[assignment]


class ObjectFlow(ActivityEdge):
    pass


class FinalNode(ControlNode):
    pass


class ActivityFinalNode(FinalNode):
    pass


class CommunicationPath(Association):
    pass


class Dependency(DirectedRelationship, PackageableElement):
    client: relation_one[NamedElement]
    supplier: relation_one[NamedElement]


class Abstraction(Dependency):
    mapping: attribute[str]


class Realization(Abstraction):
    pass


class TypedElement(NamedElement):
    type: relation_one[Type]
    typeValue: attribute[str]


class ObjectNode(TypedElement, ActivityNode):
    ordering: enumeration
    isControlType: attribute[int]
    upperBound: attribute[str]
    selection: relation_one[Behavior]


class MultiplicityElement(Element):
    isUnique: attribute[int]
    isOrdered: attribute[int]
    upperValue: attribute[str]
    lowerValue: attribute[str]
    lower: attribute[str]
    upper: attribute[str]


class Pin(ObjectNode, MultiplicityElement):
    isControl: attribute[int]


class Generalization(DirectedRelationship):
    isSubstitutable: attribute[int]
    general: relation_one[Classifier]
    specific: relation_one[Classifier]


class StructuredClassifier(Classifier):
    ownedConnector: relation_many[Connector]
    ownedAttribute: relation_many[Property]
    role: relation_many[ConnectableElement]
    part: property


class EncapsulatedClassifer(StructuredClassifier):
    ownedPort: relation_many[Port]


class Class(EncapsulatedClassifer, BehavioredClassifier):
    isActive: attribute[int]
    ownedOperation: relation_many[Operation]
    ownedAttribute: relation_many[Property]
    nestedClassifier: relation_many[Classifier]
    extension: property
    superClass: derived[Classifier]


class Node(Class, DeploymentTarget, DeployedArtifact):
    nestedNode: relation_many[Node]


class Device(Node):
    pass


class StructuralFeature(MultiplicityElement, TypedElement, Feature):
    isReadOnly: attribute[int]
    slot: relation_many[Slot]


class UseCase(BehavioredClassifier):
    subject: relation_many[Classifier]
    extensionPoint: relation_many[ExtensionPoint]
    include: relation_many[Include]
    extend: relation_many[Extend]


class InputPin(Pin):
    pass


class Manifestation(Abstraction):
    artifact: relation_one[Artifact]


class Component(Class):
    isIndirectlyInstantiated: attribute[int]
    packagedElement: relation_many[PackageableElement]
    required: property
    provided: property
    realization: relation_many[ComponentRealization]  # type: ignore[assignment]


class ConnectableElement(TypedElement):
    end: relation_many[ConnectorEnd]


class Interface(Classifier, ConnectableElement):
    ownedAttribute: relation_many[Property]
    redefinedInterface: relation_many[Interface]
    nestedClassifier: relation_many[Classifier]
    ownedOperation: relation_many[Operation]


class Include(DirectedRelationship, NamedElement):
    addition: relation_one[UseCase]
    includingCase: relation_one[UseCase]


class ProfileApplication(DirectedRelationship):
    appliedProfile: relation_one[Profile]


class ExtensionPoint(RedefinableElement):
    useCase: relation_one[UseCase]


class Usage(Dependency):
    pass


class ElementImport(DirectedRelationship):
    visibility: enumeration
    alias: attribute[str]
    importingNamespace: relation_one[Namespace]
    importedElement: relation_one[PackageableElement]


class Property(StructuralFeature, ConnectableElement):
    aggregation: enumeration
    isDerivedUnion: attribute[int]
    isDerived: attribute[int]
    isReadOnly: attribute[int]
    datatype: relation_one[DataType]
    subsettedProperty: relation_many[Property]
    classifier: relation_one[Classifier]
    redefinedProperty: relation_many[Property]
    class_: relation_one[Class]
    defaultValue: attribute[str]
    association: relation_one[Association]
    interface_: relation_one[Interface]
    owningAssociation: relation_one[Association]
    artifact: relation_one[Artifact]
    isComposite: derived[bool]
    navigability: derived[bool | None]
    opposite: relation_one[Property | None]


class ExtensionEnd(Property):
    type: relation_one[Stereotype]  # type: ignore[assignment]


class DataType(Classifier):
    ownedAttribute: relation_many[Property]
    ownedOperation: relation_many[Operation]


class Enumeration(DataType):
    ownedLiteral: relation_many[EnumerationLiteral]


class Slot(Element):
    value: attribute[str]
    owningInstance: relation_one[InstanceSpecification]
    definingFeature: relation_one[StructuralFeature]


class ExecutableNode(ActivityNode):
    pass


class InitialNode(ControlNode):
    pass


class Stereotype(Class):
    icon: relation_many[Image]
    profile: relation_one[Profile]


# 17: override Diagram
from gaphor.core.modeling import Diagram, StyleSheet


class Artifact(Classifier, DeployedArtifact):
    manifestation: relation_many[Manifestation]
    nestedArtifact: relation_many[Artifact]
    artifact: relation_one[Artifact]
    ownedAttribute: relation_many[Property]
    ownedOperation: relation_many[Operation]


class ActivityParameterNode(ObjectNode):
    parameter: relation_one[Parameter]


class PrimitiveType(DataType):
    pass


class DecisionNode(ControlNode):
    decisionInput: relation_one[Behavior]


class Package(Namespace, PackageableElement):
    nestedPackage: relation_many[Package]
    package: relation_one[Package]
    ownedType: relation_many[Type]
    packageMerge: relation_many[PackageMerge]
    appliedProfile: relation_many[ProfileApplication]
    packagedElement: relation_many[PackageableElement]


class Profile(Package):
    metamodelReference: relation_many[PackageImport]
    metaclassReference: relation_many[ElementImport]


class Behavior(Class):
    isReentrant: attribute[int]
    redefinedBehavior: relation_many[Behavior]
    context2: relation_one[BehavioredClassifier]


class Activity(Behavior):
    body: attribute[str]
    language: attribute[str]
    edge: relation_many[ActivityEdge]
    group: relation_many[ActivityGroup]
    node: relation_many[ActivityNode]


class InterfaceRealization(Realization):
    contract: relation_many[Interface]  # type: ignore[assignment]
    implementatingClassifier: relation_one[BehavioredClassifier]  # type: ignore[assignment]


class Parameter(ConnectableElement, MultiplicityElement):
    direction: enumeration
    defaultValue: attribute[str]
    ownerFormalParam: relation_one[BehavioralFeature]
    parameterSet: relation_many[ParameterSet]
    operation: relation_one[Operation]  # type: ignore[assignment]


class BehavioralFeature(Feature, Namespace):
    isAbstract: attribute[int]
    method: relation_many[Behavior]
    ownedParameter: relation_many[Parameter]
    raisedException: relation_many[Type]
    ownedParameterSet: relation_many[ParameterSet]


class Operation(BehavioralFeature):
    isQuery: attribute[int]
    precondition: relation_many[Constraint]
    bodyCondition: relation_one[Constraint]
    redefinedOperation: relation_many[Operation]
    class_: relation_one[Class]
    datatype: relation_one[DataType]
    postcondition: relation_many[Constraint]
    interface_: relation_one[Interface]
    raisedException: relation_many[Type]
    artifact: relation_one[Artifact]
    type: derivedunion[DataType]
    ownedParameter: relation_many[Parameter]  # type: ignore[assignment]


class ControlFlow(ActivityEdge):
    pass


class OutputPin(Pin):
    pass


class ValuePin(InputPin):
    value_: attribute[str]


class Action(ExecutableNode):
    effect: attribute[str]
    interaction: relation_one[Interaction]
    output: relation_many[OutputPin]
    context_: relation_one[Classifier]
    input: relation_many[InputPin]


class ExecutionEnvironment(Node):
    pass


class Extend(DirectedRelationship, NamedElement):
    extendedCase: relation_one[UseCase]
    extensionLocation: relation_many[ExtensionPoint]
    extension: relation_one[UseCase]
    constraint: relation_one[Constraint]


class ActivityGroup(NamedElement):
    activity: relation_one[Activity]
    edgeContents: relation_many[ActivityEdge]
    nodeContents: relation_many[ActivityNode]
    superGroup: relation_one[ActivityGroup]
    subgroup: relation_many[ActivityGroup]


class Constraint(PackageableElement):
    constrainedElement: relation_many[Element]
    specification: attribute[str]
    stateInvariant: relation_one[StateInvariant]
    owningState: relation_one[State]
    transition: relation_one[Transition]
    parameterSet: relation_one[ParameterSet]


class PackageImport(DirectedRelationship):
    visibility: enumeration
    importedPackage: relation_one[Package]
    importingNamespace: relation_one[Namespace]


class InteractionFragment(NamedElement):
    enclosingInteraction: relation_one[Interaction]
    covered: relation_one[Lifeline]
    generalOrdering: relation_many[GeneralOrdering]


class Interaction(Behavior, InteractionFragment):
    fragment: relation_many[InteractionFragment]
    lifeline: relation_many[Lifeline]
    message: relation_many[Message]
    action: relation_many[Action]


class StateInvariant(InteractionFragment):
    invariant: relation_one[Constraint]
    covered: relation_one[Lifeline]  # type: ignore[assignment]


class Lifeline(NamedElement):
    coveredBy: relation_many[InteractionFragment]
    interaction: relation_one[Interaction]
    parse: Callable[[Lifeline, str], None]
    render: Callable[[Lifeline], str]


class Message(NamedElement):
    messageKind: property
    messageSort: enumeration
    argument: attribute[str]
    sendEvent: relation_one[MessageEnd]
    receiveEvent: relation_one[MessageEnd]
    interaction: relation_one[Interaction]
    signature: relation_one[NamedElement]
    messageEnd: relation_many[MessageEnd]


class MessageEnd(NamedElement):
    sendMessage: relation_one[Message]
    receiveMessage: relation_one[Message]
    message: relation_one[Message]


class OccurrenceSpecification(InteractionFragment):
    covered: relation_one[Lifeline]  # type: ignore[assignment]


class GeneralOrdering(NamedElement):
    interactionFragment: relation_one[InteractionFragment]


class Connector(Feature):
    kind: enumeration
    structuredClassifier: relation_one[StructuredClassifier]
    redefinedConnector: relation_many[Connector]
    end: relation_many[ConnectorEnd]
    type: relation_one[Association]
    contract: relation_many[Behavior]
    informationFlow: relation_many[InformationFlow]


class ConnectorEnd(MultiplicityElement):
    partWithPort: relation_one[Property]
    role: relation_one[ConnectableElement]
    definingEnd: relation_one[Property]


class FlowFinalNode(FinalNode):
    pass


class JoinNode(ControlNode):
    isCombineDuplicate: attribute[int]
    joinSpec: attribute[str]


class ForkNode(ControlNode):
    pass


class StateMachine(Behavior):
    region: relation_many[Region]


class Region(Namespace):
    stateMachine: relation_one[StateMachine]
    subvertex: relation_many[Vertex]
    state: relation_one[State]


# 20: override Transition
# Invert order of superclasses to avoid MRO issues
class Transition(RedefinableElement, NamedElement):
    kind: enumeration
    container: relation_one[Region]
    source: relation_one[Vertex]
    target: relation_one[Vertex]
    effect: relation_one[Behavior]
    guard: relation_one[Constraint]
    redefinitionContext: relation_many[Classifier]
    redefinedTransition: relation_many[Transition]


class Vertex(NamedElement):
    container: relation_one[Region]
    outgoing: relation_many[Transition]
    incoming: relation_many[Transition]


class Pseudostate(Vertex):
    kind: enumeration
    stateMachine: relation_one[StateMachine]
    state: relation_one[State]


class ConnectionPointReference(Vertex):
    entry: relation_many[Pseudostate]
    exit: relation_many[Pseudostate]
    state: relation_one[State]


class State(Vertex, Namespace):
    entry: relation_one[Behavior]
    exit: relation_one[Behavior]
    doActivity: relation_one[Behavior]
    statevariant: relation_one[Constraint]
    submachine: relation_one[StateMachine]


class FinalState(State):
    pass


class Port(Property):
    isBehavior: attribute[int]
    isService: attribute[int]
    encapsulatedClassifier: relation_one[EncapsulatedClassifer]


class Deployment(Dependency):
    location: relation_one[DeploymentTarget]
    deployedArtifact: relation_many[DeployedArtifact]


class ActivityPartition(ActivityGroup):
    isDimension: attribute[int]
    isExternal: attribute[int]
    node: relation_many[ActivityNode]
    represents: relation_one[Element]
    subpartition: relation_many[ActivityPartition]


class MessageOccurrenceSpecification(MessageEnd, OccurrenceSpecification):
    pass


class AcceptEventAction(Action):
    isUnmarshall: attribute[int]
    result: relation_many[OutputPin]


class ReplyAction(Action):
    replyValue: relation_one[InputPin]
    returnInformation: relation_one[InputPin]


class UnmarshallAction(Action):
    result: relation_many[OutputPin]
    unmarshallType: relation_one[Classifier]
    object: relation_one[InputPin]


class AcceptCallAction(AcceptEventAction):
    returnInformation: relation_one[OutputPin]


class InvocationAction(Action):
    pass


class SendSignalAction(InvocationAction):
    target: relation_many[InputPin]


class Collaboration(StructuredClassifier, BehavioredClassifier):
    collaborationRole: relation_many[ConnectableElement]


class Trigger(NamedElement):
    event: relation_one[Event]
    port: relation_many[Port]


class Event(PackageableElement):
    pass


class ExecutionSpecification(InteractionFragment):
    executionOccurrenceSpecification: relation_many[ExecutionOccurrenceSpecification]
    start: relation_one[ExecutionOccurrenceSpecification]
    finish: relation_one[ExecutionOccurrenceSpecification]


class ExecutionOccurrenceSpecification(OccurrenceSpecification):
    execution: relation_one[ExecutionSpecification]


class ActionExecutionSpecification(ExecutionSpecification):
    action: relation_one[Action]


class BehaviorExecutionSpecification(ExecutionSpecification):
    behavior: relation_one[Behavior]


class ChangeEvent(Event):
    changeExpression: attribute[str]


class StructuralFeatureAction(Action):
    pass


class WriteStructuralFeatureAction(StructuralFeatureAction):
    pass


class AddStructuralFeatureValueAction(WriteStructuralFeatureAction):
    isReplaceAll: attribute[int]


class ParameterSet(NamedElement):
    parameter: relation_many[Parameter]
    condition: relation_many[Constraint]
    behavioralFeature: relation_one[BehavioralFeature]


class Image(Element):
    content: attribute[str]
    format: attribute[str]


class ComponentRealization(Realization):
    realizingClassifier: relation_one[Classifier]  # type: ignore[assignment]
    abstraction: relation_one[Component]  # type: ignore[assignment]


class InformationItem(Classifier):
    represented: relation_many[Classifier]


class InformationFlow(PackageableElement, DirectedRelationship):
    conveyed: relation_many[Classifier]
    realization: relation_many[Relationship]
    realizingMessage: relation_many[Message]
    realizingActivityEdge: relation_many[ActivityEdge]
    realizingConnector: relation_one[Connector]
    informationTarget: relation_one[NamedElement]
    informationSource: relation_one[NamedElement]


# class 'Expression' has been stereotyped as 'SimpleAttribute'
# class 'OpaqueExpression' has been stereotyped as 'SimpleAttribute'
# class 'ValueSpecification' has been stereotyped as 'SimpleAttribute'
# class 'Expression' has been stereotyped as 'SimpleAttribute' too
# class 'LiteralSpecification' has been stereotyped as 'SimpleAttribute' too
# class 'LiteralUnlimitedNatural' has been stereotyped as 'SimpleAttribute' too
# class 'LiteralBoolean' has been stereotyped as 'SimpleAttribute' too
# class 'LiteralInteger' has been stereotyped as 'SimpleAttribute' too
# class 'LiteralString' has been stereotyped as 'SimpleAttribute' too
# class 'LiteralNull' has been stereotyped as 'SimpleAttribute' too
# class 'OpaqueExpression' has been stereotyped as 'SimpleAttribute' too
Extension.isRequired = attribute("isRequired", int)
Feature.isStatic = attribute("isStatic", int, default=False)
RedefinableElement.isLeaf = attribute("isLeaf", int, default=True)
RedefinableElement.visibility = enumeration(
    "visibility", ("public", "private", "package", "protected"), "public"
)
Pin.isControl = attribute("isControl", int, default=False)
Generalization.isSubstitutable = attribute("isSubstitutable", int)
ObjectNode.ordering = enumeration(
    "ordering", ("unordered", "ordered", "LIFO", "FIFO"), "FIFO"
)
ObjectNode.isControlType = attribute("isControlType", int, default=False)
StructuralFeature.isReadOnly = attribute("isReadOnly", int, default=False)
NamedElement.name = attribute("name", str)
NamedElement.visibility = enumeration(
    "visibility", ("public", "private", "package", "protected"), "public"
)
Component.isIndirectlyInstantiated = attribute(
    "isIndirectlyInstantiated", int, default=True
)
Association.isDerived = attribute("isDerived", int, default=False)
ElementImport.visibility = enumeration(
    "visibility", ("public", "private", "package", "protected"), "public"
)
ElementImport.alias = attribute("alias", str)
MultiplicityElement.isUnique = attribute("isUnique", int, default=True)
MultiplicityElement.isOrdered = attribute("isOrdered", int, default=True)
Activity.body = attribute("body", str)
Activity.language = attribute("language", str)
Classifier.isAbstract = attribute("isAbstract", int, default=False)
Class.isActive = attribute("isActive", int, default=False)
Parameter.direction = enumeration("direction", ("inout", "in", "out", "return"), "in")
Operation.isQuery = attribute("isQuery", int, default=False)
Property.aggregation = enumeration(
    "aggregation", ("none", "shared", "composite"), "none"
)
Property.isDerivedUnion = attribute("isDerivedUnion", int, default=False)
Property.isDerived = attribute("isDerived", int, default=False)
Property.isReadOnly = attribute("isReadOnly", int, default=False)
Behavior.isReentrant = attribute("isReentrant", int)
BehavioralFeature.isAbstract = attribute("isAbstract", int)
Action.effect = attribute("effect", str)
PackageImport.visibility = enumeration(
    "visibility", ("public", "private", "package", "protected"), "public"
)
# 112: override Message.messageKind: property
# defined in umloverrides.py

Message.messageSort = enumeration(
    "messageSort",
    (
        "synchCall",
        "asynchCall",
        "asynchSignal",
        "createMessage",
        "deleteMessage",
        "reply",
    ),
    "synchCall",
)
Connector.kind = enumeration("kind", ("assembly", "delegation"), "assembly")
JoinNode.isCombineDuplicate = attribute("isCombineDuplicate", int, default=True)
Transition.kind = enumeration("kind", ("internal", "local", "external"), "internal")
Pseudostate.kind = enumeration(
    "kind",
    (
        "initial",
        "deepHistory",
        "shallowHistory",
        "join",
        "fork",
        "junction",
        "choice",
        "entryPoint",
        "exitPoint",
        "terminate",
    ),
    "initial",
)
Port.isBehavior = attribute("isBehavior", int)
Port.isService = attribute("isService", int)
ActivityPartition.isDimension = attribute("isDimension", int, default=False)
ActivityPartition.isExternal = attribute("isExternal", int, default=False)
AcceptEventAction.isUnmarshall = attribute("isUnmarshall", int, default=False)
AddStructuralFeatureValueAction.isReplaceAll = attribute(
    "isReplaceAll", int, default=False
)
Image.content = attribute("content", str)
Image.format = attribute("format", str)
Operation.precondition = association("precondition", Constraint, composite=True)
Element.ownedDiagram = association(
    "ownedDiagram", Diagram, composite=True, opposite="element"
)
Diagram.element = association("element", Element, upper=1, opposite="ownedDiagram")
Package.nestedPackage = association(
    "nestedPackage", Package, composite=True, opposite="package"
)
Package.package = association("package", Package, upper=1, opposite="nestedPackage")
NamedElement.clientDependency = association(
    "clientDependency", Dependency, composite=True, opposite="client"
)
Dependency.client = association(
    "client", NamedElement, upper=1, opposite="clientDependency"
)
DecisionNode.decisionInput = association("decisionInput", Behavior, upper=1)
Activity.edge = association("edge", ActivityEdge, composite=True, opposite="activity")
ActivityEdge.activity = association("activity", Activity, upper=1, opposite="edge")
Operation.bodyCondition = association(
    "bodyCondition", Constraint, upper=1, composite=True
)
# 'InstanceSpecification.specification' is a simple attribute
InstanceSpecification.specification = attribute("specification", str)
BehavioralFeature.method = association("method", Behavior)
Property.datatype = association(
    "datatype", DataType, upper=1, opposite="ownedAttribute"
)
DataType.ownedAttribute = association(
    "ownedAttribute", Property, composite=True, opposite="datatype"
)
TypedElement.type = association("type", Type, upper=1)
ActivityParameterNode.parameter = association("parameter", Parameter, lower=1, upper=1)
Dependency.supplier = association(
    "supplier", NamedElement, upper=1, opposite="supplierDependency"
)
NamedElement.supplierDependency = association(
    "supplierDependency", Dependency, opposite="supplier"
)
Operation.redefinedOperation = association("redefinedOperation", Operation)
Activity.group = association(
    "group", ActivityGroup, composite=True, opposite="activity"
)
ActivityGroup.activity = association("activity", Activity, upper=1, opposite="group")
Package.ownedType = association("ownedType", Type, composite=True, opposite="package")
Type.package = association("package", Package, upper=1, opposite="ownedType")
Property.subsettedProperty = association("subsettedProperty", Property)
Property.classifier = association(
    "classifier", Classifier, upper=1, opposite="attribute"
)
Profile.metamodelReference = association(
    "metamodelReference", PackageImport, composite=True
)
# 'ActivityEdge.guard' is a simple attribute
ActivityEdge.guard = attribute("guard", str)
Class.ownedOperation = association(
    "ownedOperation", Operation, composite=True, opposite="class_"
)
Operation.class_ = association("class_", Class, upper=1, opposite="ownedOperation")
Enumeration.ownedLiteral = association(
    "ownedLiteral", EnumerationLiteral, composite=True, opposite="enumeration"
)
EnumerationLiteral.enumeration = association(
    "enumeration", Enumeration, upper=1, opposite="ownedLiteral"
)
ActivityEdge.source = association(
    "source", ActivityNode, lower=1, upper=1, opposite="outgoing"
)
ActivityNode.outgoing = association("outgoing", ActivityEdge, opposite="source")
Property.redefinedProperty = association("redefinedProperty", Property)
DataType.ownedOperation = association(
    "ownedOperation", Operation, composite=True, opposite="datatype"
)
Operation.datatype = association(
    "datatype", DataType, upper=1, opposite="ownedOperation"
)
Generalization.general = association(
    "general", Classifier, lower=1, upper=1, opposite="specialization"
)
Classifier.specialization = association(
    "specialization", Generalization, opposite="general"
)
Classifier.ownedUseCase = association("ownedUseCase", UseCase, composite=True)
# 'MultiplicityElement.upperValue' is a simple attribute
MultiplicityElement.upperValue = attribute("upperValue", str)
PackageMerge.mergingPackage = association(
    "mergingPackage", Package, lower=1, upper=1, opposite="packageMerge"
)
Package.packageMerge = association(
    "packageMerge", PackageMerge, composite=True, opposite="mergingPackage"
)
Package.appliedProfile = association(
    "appliedProfile", ProfileApplication, composite=True
)
# 'Parameter.defaultValue' is a simple attribute
Parameter.defaultValue = attribute("defaultValue", str)
# 'Slot.value' is a simple attribute
Slot.value = attribute("value", str)
Include.addition = association("addition", UseCase, lower=1, upper=1)
# 'TypedElement.typeValue' is a simple attribute
TypedElement.typeValue = attribute("typeValue", str)
Constraint.constrainedElement = association("constrainedElement", Element)
PackageMerge.mergedPackage = association("mergedPackage", Package, lower=1, upper=1)
BehavioralFeature.ownedParameter = association(
    "ownedParameter", Parameter, composite=True, opposite="ownerFormalParam"
)
Parameter.ownerFormalParam = association(
    "ownerFormalParam", BehavioralFeature, upper=1, opposite="ownedParameter"
)
Class.ownedAttribute = association(
    "ownedAttribute", Property, composite=True, opposite="class_"
)
Property.class_ = association("class_", Class, upper=1, opposite="ownedAttribute")
Extend.extendedCase = association("extendedCase", UseCase, lower=1, upper=1)
# 'Property.defaultValue' is a simple attribute
Property.defaultValue = attribute("defaultValue", str)
Property.association = association(
    "association", Association, upper=1, opposite="memberEnd"
)
Association.memberEnd = association(
    "memberEnd", Property, lower=2, composite=True, opposite="association"
)
Classifier.generalization = association(
    "generalization", Generalization, composite=True, opposite="specific"
)
Generalization.specific = association(
    "specific", Classifier, lower=1, upper=1, opposite="generalization"
)
# 'ValuePin.value_' is a simple attribute
ValuePin.value_ = attribute("value_", str)
BehavioralFeature.raisedException = association("raisedException", Type)
# 'Abstraction.mapping' is a simple attribute
Abstraction.mapping = attribute("mapping", str)
ActivityNode.incoming = association("incoming", ActivityEdge, opposite="target")
ActivityEdge.target = association(
    "target", ActivityNode, lower=1, upper=1, opposite="incoming"
)
Extend.extensionLocation = association("extensionLocation", ExtensionPoint, lower=1)
Property.interface_ = association(
    "interface_", Interface, upper=1, opposite="ownedAttribute"
)
Interface.ownedAttribute = association(
    "ownedAttribute", Property, composite=True, opposite="interface_"
)
ActivityGroup.edgeContents = association(
    "edgeContents", ActivityEdge, opposite="inGroup"
)
ActivityEdge.inGroup = association("inGroup", ActivityGroup, opposite="edgeContents")
Slot.owningInstance = association(
    "owningInstance", InstanceSpecification, lower=1, upper=1, opposite="slot"
)
InstanceSpecification.slot = association(
    "slot", Slot, composite=True, opposite="owningInstance"
)
UseCase.subject = association("subject", Classifier, opposite="useCase")
Classifier.useCase = association("useCase", UseCase, opposite="subject")
Property.owningAssociation = association(
    "owningAssociation", Association, upper=1, opposite="ownedEnd"
)
Association.ownedEnd = association(
    "ownedEnd", Property, composite=True, opposite="owningAssociation"
)
Interface.redefinedInterface = association("redefinedInterface", Interface)
Artifact.manifestation = association(
    "manifestation", Manifestation, composite=True, opposite="artifact"
)
Manifestation.artifact = association(
    "artifact", Artifact, lower=1, upper=1, opposite="manifestation"
)
ExtensionPoint.useCase = association(
    "useCase", UseCase, lower=1, upper=1, opposite="extensionPoint"
)
UseCase.extensionPoint = association(
    "extensionPoint", ExtensionPoint, composite=True, opposite="useCase"
)
Operation.postcondition = association("postcondition", Constraint, composite=True)
Extension.ownedEnd = association(
    "ownedEnd", ExtensionEnd, lower=1, upper=1, composite=True
)
# 'Constraint.specification' is a simple attribute
Constraint.specification = attribute("specification", str)
Profile.metaclassReference = association(
    "metaclassReference", ElementImport, composite=True
)
Namespace.elementImport = association(
    "elementImport", ElementImport, composite=True, opposite="importingNamespace"
)
ElementImport.importingNamespace = association(
    "importingNamespace", Namespace, upper=1, opposite="elementImport"
)
# 'MultiplicityElement.lowerValue' is a simple attribute
MultiplicityElement.lowerValue = attribute("lowerValue", str)
Interface.nestedClassifier = association("nestedClassifier", Classifier, composite=True)
InstanceSpecification.classifier = association("classifier", Classifier)
Interface.ownedOperation = association(
    "ownedOperation", Operation, composite=True, opposite="interface_"
)
Operation.interface_ = association(
    "interface_", Interface, upper=1, opposite="ownedOperation"
)
ElementImport.importedElement = association(
    "importedElement", PackageableElement, lower=1, upper=1
)
Classifier.redefinedClassifier = association("redefinedClassifier", Classifier)
Operation.raisedException = association("raisedException", Type)
PackageImport.importedPackage = association(
    "importedPackage", Package, lower=1, upper=1
)
StructuralFeature.slot = association(
    "slot", Slot, composite=True, opposite="definingFeature"
)
Slot.definingFeature = association(
    "definingFeature", StructuralFeature, lower=1, upper=1, opposite="slot"
)
Include.includingCase = association(
    "includingCase", UseCase, lower=1, upper=1, opposite="include"
)
UseCase.include = association(
    "include", Include, composite=True, opposite="includingCase"
)
Extend.extension = association(
    "extension", UseCase, lower=1, upper=1, opposite="extend"
)
UseCase.extend = association("extend", Extend, composite=True, opposite="extension")
Extend.constraint = association("constraint", Constraint, upper=1, composite=True)
ProfileApplication.appliedProfile = association(
    "appliedProfile", Profile, lower=1, upper=1
)
Namespace.packageImport = association(
    "packageImport", PackageImport, composite=True, opposite="importingNamespace"
)
PackageImport.importingNamespace = association(
    "importingNamespace", Namespace, upper=1, opposite="packageImport"
)
Behavior.redefinedBehavior = association("redefinedBehavior", Behavior)
Component.packagedElement = association(
    "packagedElement", PackageableElement, composite=True, opposite="component"
)
PackageableElement.component = association(
    "component", Component, upper=1, opposite="packagedElement"
)
Behavior.context2 = association(
    "context2", BehavioredClassifier, upper=1, opposite="ownedBehavior"
)
BehavioredClassifier.ownedBehavior = association(
    "ownedBehavior", Behavior, composite=True, opposite="context2"
)
ActivityGroup.nodeContents = association(
    "nodeContents", ActivityNode, opposite="inGroup"
)
ActivityNode.inGroup = association("inGroup", ActivityGroup, opposite="nodeContents")
InteractionFragment.enclosingInteraction = association(
    "enclosingInteraction", Interaction, upper=1, opposite="fragment"
)
Interaction.fragment = association(
    "fragment", InteractionFragment, opposite="enclosingInteraction"
)
Constraint.stateInvariant = association(
    "stateInvariant", StateInvariant, upper=1, opposite="invariant"
)
StateInvariant.invariant = association(
    "invariant", Constraint, lower=1, upper=1, composite=True, opposite="stateInvariant"
)
Lifeline.coveredBy = association("coveredBy", InteractionFragment, opposite="covered")
InteractionFragment.covered = association(
    "covered", Lifeline, lower=1, upper=1, opposite="coveredBy"
)
Lifeline.interaction = association(
    "interaction", Interaction, lower=1, upper=1, opposite="lifeline"
)
Interaction.lifeline = association(
    "lifeline", Lifeline, composite=True, opposite="interaction"
)
# 'Message.argument' is a simple attribute
Message.argument = attribute("argument", str)
MessageEnd.sendMessage = association(
    "sendMessage", Message, upper=1, opposite="sendEvent"
)
Message.sendEvent = association(
    "sendEvent", MessageEnd, upper=1, composite=True, opposite="sendMessage"
)
MessageEnd.receiveMessage = association(
    "receiveMessage", Message, upper=1, opposite="receiveEvent"
)
Message.receiveEvent = association(
    "receiveEvent", MessageEnd, upper=1, composite=True, opposite="receiveMessage"
)
Message.interaction = association(
    "interaction", Interaction, lower=1, upper=1, opposite="message"
)
Interaction.message = association(
    "message", Message, composite=True, opposite="interaction"
)
StructuredClassifier.ownedConnector = association(
    "ownedConnector", Connector, composite=True, opposite="structuredClassifier"
)
Connector.structuredClassifier = association(
    "structuredClassifier", StructuredClassifier, upper=1, opposite="ownedConnector"
)
Connector.redefinedConnector = association("redefinedConnector", Connector)
StructuredClassifier.ownedAttribute = association(
    "ownedAttribute", Property, composite=True
)
# 'ObjectNode.upperBound' is a simple attribute
ObjectNode.upperBound = attribute("upperBound", str)
ObjectNode.selection = association("selection", Behavior, upper=1)
# 'JoinNode.joinSpec' is a simple attribute
JoinNode.joinSpec = attribute("joinSpec", str)
StateMachine.region = association(
    "region", Region, lower=1, composite=True, opposite="stateMachine"
)
Region.stateMachine = association(
    "stateMachine", StateMachine, upper=1, opposite="region"
)
Transition.container = association("container", Region, lower=1, upper=1)
Region.subvertex = association(
    "subvertex", Vertex, composite=True, opposite="container"
)
Vertex.container = association("container", Region, upper=1, opposite="subvertex")
Transition.source = association("source", Vertex, lower=1, upper=1, opposite="outgoing")
Vertex.outgoing = association("outgoing", Transition, opposite="source")
Transition.target = association("target", Vertex, lower=1, upper=1, opposite="incoming")
Vertex.incoming = association("incoming", Transition, opposite="target")
ConnectionPointReference.entry = association("entry", Pseudostate)
ConnectionPointReference.exit = association("exit", Pseudostate)
Pseudostate.stateMachine = association("stateMachine", StateMachine, upper=1)
Region.state = association("state", State, upper=1)
Pseudostate.state = association("state", State, upper=1)
ConnectionPointReference.state = association("state", State, upper=1)
State.entry = association("entry", Behavior, upper=1, composite=True)
State.exit = association("exit", Behavior, upper=1, composite=True)
State.doActivity = association("doActivity", Behavior, upper=1, composite=True)
Transition.effect = association("effect", Behavior, upper=1, composite=True)
State.statevariant = association(
    "statevariant", Constraint, upper=1, composite=True, opposite="owningState"
)
Constraint.owningState = association(
    "owningState", State, upper=1, opposite="statevariant"
)
Transition.guard = association(
    "guard", Constraint, upper=1, composite=True, opposite="transition"
)
Constraint.transition = association("transition", Transition, upper=1, opposite="guard")
State.submachine = association("submachine", StateMachine, upper=1)
ConnectorEnd.partWithPort = association("partWithPort", Property, upper=1)
Port.encapsulatedClassifier = association(
    "encapsulatedClassifier", EncapsulatedClassifer, upper=1, opposite="ownedPort"
)
EncapsulatedClassifer.ownedPort = association(
    "ownedPort", Port, composite=True, opposite="encapsulatedClassifier"
)
Element.appliedStereotype = association(
    "appliedStereotype", InstanceSpecification, opposite="extended"
)
InstanceSpecification.extended = association(
    "extended", Element, opposite="appliedStereotype"
)
Node.nestedNode = association("nestedNode", Node, composite=True)
Deployment.location = association(
    "location", DeploymentTarget, lower=1, upper=1, opposite="deployment"
)
DeploymentTarget.deployment = association(
    "deployment", Deployment, composite=True, opposite="location"
)
Deployment.deployedArtifact = association("deployedArtifact", DeployedArtifact)
ActivityNode.inPartition = association(
    "inPartition", ActivityPartition, opposite="node"
)
ActivityPartition.node = association("node", ActivityNode, opposite="inPartition")
ActivityPartition.represents = association("represents", Element, upper=1)
ActivityPartition.subpartition = association("subpartition", ActivityPartition)
Association.navigableOwnedEnd = association("navigableOwnedEnd", Property)
AcceptEventAction.result = association("result", OutputPin, composite=True)
UnmarshallAction.result = association("result", OutputPin, composite=True)
AcceptCallAction.returnInformation = association(
    "returnInformation", OutputPin, lower=1, upper=1, composite=True
)
UnmarshallAction.unmarshallType = association(
    "unmarshallType", Classifier, lower=1, upper=1
)
UnmarshallAction.object = association(
    "object", InputPin, lower=1, upper=1, composite=True
)
ReplyAction.replyValue = association("replyValue", InputPin, upper=1, composite=True)
ReplyAction.returnInformation = association(
    "returnInformation", InputPin, lower=1, upper=1, composite=True
)
SendSignalAction.target = association("target", InputPin, composite=True)
Collaboration.collaborationRole = association("collaborationRole", ConnectableElement)
Trigger.event = association("event", Event, lower=1, upper=1)
Action.interaction = association("interaction", Interaction, upper=1, opposite="action")
Interaction.action = association(
    "action", Action, composite=True, opposite="interaction"
)
Message.signature = association("signature", NamedElement, upper=1)
InteractionFragment.generalOrdering = association(
    "generalOrdering", GeneralOrdering, composite=True, opposite="interactionFragment"
)
GeneralOrdering.interactionFragment = association(
    "interactionFragment", InteractionFragment, upper=1, opposite="generalOrdering"
)
ExecutionSpecification.executionOccurrenceSpecification = association(
    "executionOccurrenceSpecification",
    ExecutionOccurrenceSpecification,
    upper=2,
    composite=True,
    opposite="execution",
)
ExecutionOccurrenceSpecification.execution = association(
    "execution",
    ExecutionSpecification,
    lower=1,
    upper=1,
    opposite="executionOccurrenceSpecification",
)
ActionExecutionSpecification.action = association("action", Action, lower=1, upper=1)
BehaviorExecutionSpecification.behavior = association("behavior", Behavior, upper=1)
# 'ChangeEvent.changeExpression' is a simple attribute
ChangeEvent.changeExpression = attribute("changeExpression", str)
Parameter.parameterSet = association("parameterSet", ParameterSet, opposite="parameter")
ParameterSet.parameter = association(
    "parameter", Parameter, lower=1, opposite="parameterSet"
)
Constraint.parameterSet = association(
    "parameterSet", ParameterSet, upper=1, opposite="condition"
)
ParameterSet.condition = association(
    "condition", Constraint, composite=True, opposite="parameterSet"
)
ParameterSet.behavioralFeature = association(
    "behavioralFeature", BehavioralFeature, upper=1, opposite="ownedParameterSet"
)
BehavioralFeature.ownedParameterSet = association(
    "ownedParameterSet", ParameterSet, composite=True, opposite="behavioralFeature"
)
Connector.end = association("end", ConnectorEnd, lower=2, composite=True)
ConnectorEnd.role = association("role", ConnectableElement, upper=1, opposite="end")
ConnectableElement.end = association("end", ConnectorEnd, opposite="role")
Connector.type = association("type", Association, upper=1)
Connector.contract = association("contract", Behavior)
Classifier.nestingClass = association(
    "nestingClass", Class, upper=1, opposite="nestedClassifier"
)
Class.nestedClassifier = association(
    "nestedClassifier", Classifier, composite=True, opposite="nestingClass"
)
Stereotype.icon = association("icon", Image, composite=True)
Namespace.ownedRule = association("ownedRule", Constraint, composite=True)
Trigger.port = association("port", Port)
ActivityNode.activity = association("activity", Activity, upper=1, opposite="node")
Activity.node = association("node", ActivityNode, composite=True, opposite="activity")
Artifact.nestedArtifact = association(
    "nestedArtifact", Artifact, composite=True, opposite="artifact"
)
Artifact.artifact = association(
    "artifact", Artifact, upper=1, opposite="nestedArtifact"
)
Property.artifact = association(
    "artifact", Artifact, upper=1, opposite="ownedAttribute"
)
Artifact.ownedAttribute = association(
    "ownedAttribute", Property, composite=True, opposite="artifact"
)
Operation.artifact = association(
    "artifact", Artifact, upper=1, opposite="ownedOperation"
)
Artifact.ownedOperation = association(
    "ownedOperation", Operation, composite=True, opposite="artifact"
)
InformationItem.represented = association("represented", Classifier)
InformationFlow.conveyed = association("conveyed", Classifier, lower=1)
InformationFlow.realization = association("realization", Relationship)
InformationFlow.realizingMessage = association("realizingMessage", Message)
InformationFlow.realizingActivityEdge = association(
    "realizingActivityEdge", ActivityEdge
)
Connector.informationFlow = association(
    "informationFlow", InformationFlow, composite=True, opposite="realizingConnector"
)
InformationFlow.realizingConnector = association(
    "realizingConnector", Connector, upper=1, opposite="informationFlow"
)
NamedElement.informationFlow = association(
    "informationFlow", InformationFlow, opposite="informationTarget"
)
InformationFlow.informationTarget = association(
    "informationTarget", NamedElement, lower=1, upper=1, opposite="informationFlow"
)
InformationFlow.informationSource = association(
    "informationSource", NamedElement, lower=1, upper=1
)
# 82: override NamedElement.qualifiedName(NamedElement.namespace): derived[list[str]]

from gaphor.core.modeling.diagram import qualifiedName

NamedElement.qualifiedName = derived(
    "qualifiedName",
    List[str],
    0,
    1,
    lambda obj: [qualifiedName(obj)],
)

# 32: override MultiplicityElement.lower(MultiplicityElement.lowerValue): attribute[str]
MultiplicityElement.lower = MultiplicityElement.lowerValue

# 35: override MultiplicityElement.upper(MultiplicityElement.upperValue): attribute[str]
MultiplicityElement.upper = MultiplicityElement.upperValue

# 76: override Property.isComposite(Property.aggregation): derived[bool]
Property.isComposite = derived(
    "isComposite", bool, 0, 1, lambda obj: [obj.aggregation == "composite"]
)

# 94: override Property.navigability(Property.opposite, Property.association): derived[bool | None]
# defined in umloverrides.py

RedefinableElement.redefinedElement = derivedunion(
    "redefinedElement",
    RedefinableElement,
    0,
    "*",
    Property.redefinedProperty,
    Classifier.redefinedClassifier,
    Operation.redefinedOperation,
    Interface.redefinedInterface,
    Behavior.redefinedBehavior,
    Connector.redefinedConnector,
)
Classifier.attribute = derivedunion(
    "attribute",
    Property,
    0,
    "*",
    Class.ownedAttribute,
    DataType.ownedAttribute,
    Interface.ownedAttribute,
    StructuredClassifier.ownedAttribute,
    Artifact.ownedAttribute,
)
Classifier.feature = derivedunion(
    "feature",
    Feature,
    0,
    "*",
    Interface.ownedOperation,
    DataType.ownedOperation,
    Class.ownedOperation,
    Association.ownedEnd,
    Classifier.attribute,
    StructuredClassifier.ownedConnector,
    Artifact.ownedOperation,
)
Feature.featuringClassifier = derivedunion(
    "featuringClassifier",
    Classifier,
    1,
    "*",
    Property.class_,
    Property.owningAssociation,
    Operation.class_,
    Operation.datatype,
    Operation.interface_,
    Operation.artifact,
)
# 73: override Property.opposite(Property.association, Association.memberEnd): relation_one[Property | None]
# defined in umloverrides.py

Action.output = derivedunion("output", OutputPin, 0, "*")
RedefinableElement.redefinitionContext = derivedunion(
    "redefinitionContext",
    Classifier,
    0,
    "*",
    Operation.class_,
    Property.classifier,
    Operation.datatype,
    Connector.structuredClassifier,
    Port.encapsulatedClassifier,
    Classifier.nestingClass,
    Operation.artifact,
)
PackageableElement.owningPackage = derivedunion(
    "owningPackage", Package, 0, 1, Type.package, Package.package
)
NamedElement.namespace = derivedunion(
    "namespace",
    Namespace,
    0,
    1,
    Extend.extension,
    ExtensionPoint.useCase,
    Property.interface_,
    Include.includingCase,
    Property.class_,
    Property.owningAssociation,
    Operation.class_,
    EnumerationLiteral.enumeration,
    PackageableElement.owningPackage,
    Operation.datatype,
    Property.datatype,
    PackageableElement.component,
    Operation.interface_,
    Parameter.ownerFormalParam,
    InteractionFragment.enclosingInteraction,
    Lifeline.interaction,
    Message.interaction,
    Connector.structuredClassifier,
    Region.stateMachine,
    Transition.container,
    Vertex.container,
    Pseudostate.stateMachine,
    Region.state,
    ConnectionPointReference.state,
    BehavioralFeature.ownedParameterSet,
    Classifier.nestingClass,
    Artifact.artifact,
    Property.artifact,
    Operation.artifact,
)
Package.packagedElement = derivedunion(
    "packagedElement",
    PackageableElement,
    0,
    "*",
    Package.ownedType,
    Package.nestedPackage,
)
Namespace.ownedMember = derivedunion(
    "ownedMember",
    NamedElement,
    0,
    "*",
    Interface.ownedOperation,
    Enumeration.ownedLiteral,
    Interface.nestedClassifier,
    UseCase.extensionPoint,
    Package.packagedElement,
    DataType.ownedOperation,
    Operation.precondition,
    Component.packagedElement,
    Class.ownedAttribute,
    BehavioralFeature.ownedParameter,
    Classifier.ownedUseCase,
    DataType.ownedAttribute,
    Class.ownedOperation,
    Operation.postcondition,
    Association.ownedEnd,
    Interface.ownedAttribute,
    UseCase.include,
    Operation.bodyCondition,
    UseCase.extend,
    Extend.constraint,
    BehavioredClassifier.ownedBehavior,
    Interaction.fragment,
    Interaction.lifeline,
    Interaction.message,
    StructuredClassifier.ownedConnector,
    StructuredClassifier.ownedAttribute,
    StateMachine.region,
    Region.subvertex,
    Node.nestedNode,
    ParameterSet.behavioralFeature,
    Class.nestedClassifier,
    Stereotype.icon,
    Namespace.ownedRule,
    Artifact.nestedArtifact,
    Artifact.ownedAttribute,
    Artifact.ownedOperation,
)
# 64: override Classifier.general(Generalization.general): derived[Classifier]
Classifier.general = derived(
    "general", Classifier, 0, "*", lambda self: [g.general for g in self.generalization]
)

# 38: override Association.endType(Association.memberEnd, Property.type): derived[Type]

# References the classifiers that are used as types of the ends of the
# association.

Association.endType = derived(
    "endType", Type, 0, "*", lambda self: [end.type for end in self.memberEnd if end]
)


# 97: override Operation.type: derivedunion[DataType]
Operation.type = derivedunion("type", DataType, 0, 1)

Stereotype.profile = derivedunion("profile", Profile, 1, 1)
# 58: override Extension.metaclass(Extension.ownedEnd, Association.memberEnd): property
# defined in umloverrides.py

# 46: override Class.extension(Extension.metaclass): property
# See https://www.omg.org/spec/UML/2.5/PDF, section 11.8.3.6, page 219
# It defines `Extension.allInstances()`, which basically means we have to query the element factory.

# TODO: use those as soon as Extension.metaclass can be used.
# Class.extension = derived('extension', Extension, 0, '*', class_extension, Extension.metaclass)

Class.extension = property(
    lambda self: self.model.lselect(
        lambda e: e.isKindOf(Extension) and self is e.metaclass
    ),
    doc="""References the Extensions that specify additional properties of the
metaclass. The property is derived from the extensions whose memberEnds
are typed by the Class.""",
)

DirectedRelationship.target = derivedunion(
    "target",
    Element,
    1,
    "*",
    PackageImport.importedPackage,
    PackageMerge.mergedPackage,
    Generalization.general,
    Include.addition,
    Extend.extendedCase,
    ElementImport.importedElement,
    Dependency.supplier,
    Dependency.client,
    InformationFlow.informationTarget,
)
Element.directedRelationship = derivedunion(
    "directedRelationship",
    DirectedRelationship,
    0,
    "*",
    NamedElement.supplierDependency,
    Classifier.specialization,
    NamedElement.clientDependency,
    UseCase.include,
    Package.packageMerge,
    UseCase.extend,
)
DirectedRelationship.source = derivedunion(
    "source",
    Element,
    1,
    "*",
    Extend.extension,
    Include.includingCase,
    ElementImport.importingNamespace,
    Generalization.specific,
    PackageImport.importingNamespace,
    PackageMerge.mergingPackage,
    InformationFlow.informationSource,
)
Action.context_ = derivedunion("context_", Classifier, 0, 1)
Element.relationship = derivedunion(
    "relationship", Relationship, 0, "*", Element.directedRelationship
)
Relationship.relatedElement = derivedunion(
    "relatedElement",
    Element,
    1,
    "*",
    DirectedRelationship.target,
    DirectedRelationship.source,
)
ActivityGroup.superGroup = derivedunion("superGroup", ActivityGroup, 0, 1)
ActivityGroup.subgroup = derivedunion(
    "subgroup", ActivityGroup, 0, "*", ActivityPartition.subpartition
)
# 61: override Classifier.inheritedMember: derivedunion[NamedElement]
Classifier.inheritedMember = derivedunion("inheritedMember", NamedElement, 0, "*")

StructuredClassifier.role = derivedunion(
    "role",
    ConnectableElement,
    0,
    "*",
    StructuredClassifier.ownedAttribute,
    Collaboration.collaborationRole,
)
Namespace.member = derivedunion(
    "member",
    NamedElement,
    0,
    "*",
    Namespace.ownedMember,
    Association.memberEnd,
    Classifier.inheritedMember,
    StructuredClassifier.role,
)
NamedElement.memberNamespace = derivedunion(
    "memberNamespace", Namespace, 0, "*", Property.association, NamedElement.namespace
)
# 109: override Component.required: property
# defined in umloverrides.py

# 70: override Namespace.importedMember: derivedunion[PackageableElement]
Namespace.importedMember = derivedunion("importedMember", PackageableElement, 0, "*")

Action.input = derivedunion("input", InputPin, 0, "*", SendSignalAction.target)
# 106: override Component.provided: property
# defined in umloverrides.py

Element.owner = derivedunion(
    "owner",
    Element,
    0,
    1,
    Slot.owningInstance,
    ElementImport.importingNamespace,
    Diagram.element,
    Generalization.specific,
    ActivityEdge.activity,
    ActivityGroup.superGroup,
    ActivityGroup.activity,
    PackageImport.importingNamespace,
    PackageMerge.mergingPackage,
    Manifestation.artifact,
    NamedElement.namespace,
    Dependency.client,
    Constraint.stateInvariant,
    Pseudostate.state,
    Constraint.transition,
    Deployment.location,
    Action.interaction,
    GeneralOrdering.interactionFragment,
    Constraint.parameterSet,
    ActivityNode.activity,
    InformationFlow.realizingConnector,
)
Element.ownedElement = derivedunion(
    "ownedElement",
    Element,
    0,
    "*",
    Artifact.manifestation,
    Element.ownedDiagram,
    Action.input,
    InstanceSpecification.slot,
    Classifier.generalization,
    Namespace.ownedMember,
    Namespace.elementImport,
    Activity.group,
    NamedElement.clientDependency,
    Namespace.packageImport,
    Package.packageMerge,
    Package.appliedProfile,
    ActivityGroup.subgroup,
    Activity.edge,
    Action.output,
    StateInvariant.invariant,
    State.entry,
    State.exit,
    State.doActivity,
    Transition.effect,
    State.statevariant,
    Transition.guard,
    DeploymentTarget.deployment,
    Interaction.action,
    InteractionFragment.generalOrdering,
    ParameterSet.condition,
    Connector.end,
    Activity.node,
    Connector.informationFlow,
)
# 115: override StructuredClassifier.part: property
StructuredClassifier.part = property(
    lambda self: tuple(a for a in self.ownedAttribute if a.isComposite),
    doc="""
    Properties owned by a classifier by composition.
""",
)

# 120: override ExecutionSpecification.start(ExecutionSpecification.executionOccurrenceSpecification): relation_one[ExecutionOccurrenceSpecification]
ExecutionSpecification.start = derived(
    "start",
    OccurrenceSpecification,
    0,
    1,
    lambda obj: [
        eos for i, eos in enumerate(obj.executionOccurrenceSpecification) if i == 0
    ],
)

# 124: override ExecutionSpecification.finish(ExecutionSpecification.executionOccurrenceSpecification): relation_one[ExecutionOccurrenceSpecification]
ExecutionSpecification.finish = derived(
    "finish",
    OccurrenceSpecification,
    0,
    1,
    lambda obj: [
        eos for i, eos in enumerate(obj.executionOccurrenceSpecification) if i == 1
    ],
)

ConnectorEnd.definingEnd = derivedunion("definingEnd", Property, 0, 1)
MessageEnd.message = derivedunion(
    "message", Message, 0, 1, MessageEnd.sendMessage, MessageEnd.receiveMessage
)
Message.messageEnd = derivedunion(
    "messageEnd", MessageEnd, 0, 2, Message.sendEvent, Message.receiveEvent
)
# 67: override Class.superClass: derived[Classifier]
Class.superClass = Classifier.general

ExtensionEnd.type = redefine(ExtensionEnd, "type", Stereotype, Property.type)
ActivityNode.redefinedElement = redefine(
    ActivityNode, "redefinedElement", ActivityNode, RedefinableElement.redefinedElement
)
Classifier.componentRealization = redefine(
    Classifier,
    "componentRealization",
    ComponentRealization,
    NamedElement.clientDependency,
)
ComponentRealization.realizingClassifier = redefine(
    ComponentRealization, "realizingClassifier", Classifier, Dependency.client
)
InterfaceRealization.contract = redefine(
    InterfaceRealization, "contract", Interface, Dependency.supplier
)
BehavioredClassifier.interfaceRealization = redefine(
    BehavioredClassifier,
    "interfaceRealization",
    InterfaceRealization,
    NamedElement.clientDependency,
)
InterfaceRealization.implementatingClassifier = redefine(
    InterfaceRealization,
    "implementatingClassifier",
    BehavioredClassifier,
    Dependency.client,
)
ComponentRealization.abstraction = redefine(
    ComponentRealization, "abstraction", Component, Dependency.supplier
)
Component.realization = redefine(
    Component, "realization", ComponentRealization, NamedElement.supplierDependency
)
Parameter.operation = redefine(
    Parameter, "operation", Operation, Parameter.ownerFormalParam
)
Operation.ownedParameter = redefine(
    Operation, "ownedParameter", Parameter, BehavioralFeature.ownedParameter
)
ActivityEdge.redefinedElement = redefine(
    ActivityEdge, "redefinedElement", ActivityEdge, RedefinableElement.redefinedElement
)
StateInvariant.covered = redefine(
    StateInvariant, "covered", Lifeline, InteractionFragment.covered
)
OccurrenceSpecification.covered = redefine(
    OccurrenceSpecification, "covered", Lifeline, InteractionFragment.covered
)
# 100: override Lifeline.parse: Callable[[Lifeline, str], None]
# defined in umloverrides.py

# 103: override Lifeline.render: Callable[[Lifeline], str]
# defined in umloverrides.py
