/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.ql.index.HiveIndex;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.TextMetaDataFormatter;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public final class MetaDataFormatUtils {
    public static final String FIELD_DELIM = "\t";
    public static final String LINE_DELIM = "\n";
    static final int DEFAULT_STRINGBUILDER_SIZE = 2048;
    private static final int ALIGNMENT = 20;

    private MetaDataFormatUtils() {
    }

    private static void formatColumnsHeader(StringBuilder columnInformation, List<ColumnStatisticsObj> colStats) {
        columnInformation.append("# ");
        MetaDataFormatUtils.formatOutput(MetaDataFormatUtils.getColumnsHeader(colStats), columnInformation);
        columnInformation.append(LINE_DELIM);
    }

    public static String getAllColumnsInformation(List<FieldSchema> cols, boolean printHeader, boolean isOutputPadded, List<ColumnStatisticsObj> colStats) {
        StringBuilder columnInformation = new StringBuilder(2048);
        if (printHeader) {
            MetaDataFormatUtils.formatColumnsHeader(columnInformation, colStats);
        }
        MetaDataFormatUtils.formatAllFields(columnInformation, cols, isOutputPadded, colStats);
        return columnInformation.toString();
    }

    public static String getAllColumnsInformation(List<FieldSchema> cols, List<FieldSchema> partCols, boolean printHeader, boolean isOutputPadded, boolean showPartColsSep) {
        StringBuilder columnInformation = new StringBuilder(2048);
        if (printHeader) {
            MetaDataFormatUtils.formatColumnsHeader(columnInformation, null);
        }
        MetaDataFormatUtils.formatAllFields(columnInformation, cols, isOutputPadded, null);
        if (partCols != null && !partCols.isEmpty() && showPartColsSep) {
            columnInformation.append(LINE_DELIM).append("# Partition Information").append(LINE_DELIM);
            MetaDataFormatUtils.formatColumnsHeader(columnInformation, null);
            MetaDataFormatUtils.formatAllFields(columnInformation, partCols, isOutputPadded, null);
        }
        return columnInformation.toString();
    }

    private static void formatAllFields(StringBuilder tableInfo, List<FieldSchema> cols, boolean isOutputPadded, List<ColumnStatisticsObj> colStats) {
        for (FieldSchema col : cols) {
            if (isOutputPadded) {
                MetaDataFormatUtils.formatWithIndentation(col.getName(), col.getType(), MetaDataFormatUtils.getComment(col), tableInfo, colStats);
                continue;
            }
            MetaDataFormatUtils.formatWithoutIndentation(col.getName(), col.getType(), col.getComment(), tableInfo, colStats);
        }
    }

    private static String convertToString(Decimal val) {
        if (val == null) {
            return "";
        }
        return HiveDecimal.create(new BigInteger(val.getUnscaled()), val.getScale()).toString();
    }

    private static String convertToString(Date val) {
        if (val == null) {
            return "";
        }
        DateWritable writableValue = new DateWritable((int)val.getDaysSinceEpoch());
        return writableValue.toString();
    }

    private static ColumnStatisticsObj getColumnStatisticsObject(String colName, String colType, List<ColumnStatisticsObj> colStats) {
        if (colStats != null && !colStats.isEmpty()) {
            for (ColumnStatisticsObj cso : colStats) {
                if (!cso.getColName().equalsIgnoreCase(colName) || !cso.getColType().equalsIgnoreCase(colType)) continue;
                return cso;
            }
        }
        return null;
    }

    private static void formatWithoutIndentation(String name, String type, String comment, StringBuilder colBuffer, List<ColumnStatisticsObj> colStats) {
        colBuffer.append(name);
        colBuffer.append(FIELD_DELIM);
        colBuffer.append(type);
        colBuffer.append(FIELD_DELIM);
        if (colStats != null) {
            ColumnStatisticsObj cso = MetaDataFormatUtils.getColumnStatisticsObject(name, type, colStats);
            if (cso != null) {
                ColumnStatisticsData csd = cso.getStatsData();
                if (csd.isSetBinaryStats()) {
                    BinaryColumnStatsData bcsd = csd.getBinaryStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", bcsd.getNumNulls(), "", bcsd.getAvgColLen(), bcsd.getMaxColLen(), "", "");
                } else if (csd.isSetStringStats()) {
                    StringColumnStatsData scsd = csd.getStringStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", scsd.getNumNulls(), scsd.getNumDVs(), scsd.getAvgColLen(), scsd.getMaxColLen(), "", "");
                } else if (csd.isSetBooleanStats()) {
                    BooleanColumnStatsData bcsd = csd.getBooleanStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", bcsd.getNumNulls(), "", "", "", bcsd.getNumTrues(), bcsd.getNumFalses());
                } else if (csd.isSetDecimalStats()) {
                    DecimalColumnStatsData dcsd = csd.getDecimalStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDoubleStats()) {
                    DoubleColumnStatsData dcsd = csd.getDoubleStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, dcsd.getLowValue(), dcsd.getHighValue(), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetLongStats()) {
                    LongColumnStatsData lcsd = csd.getLongStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, lcsd.getLowValue(), lcsd.getHighValue(), lcsd.getNumNulls(), lcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDateStats()) {
                    DateColumnStatsData dcsd = csd.getDateStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                }
            } else {
                MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", "", "", "", "", "", "");
            }
        }
        colBuffer.append(comment == null ? "" : comment);
        colBuffer.append(LINE_DELIM);
    }

    public static String getAllColumnsInformation(Index index) {
        StringBuilder indexInfo = new StringBuilder(2048);
        ArrayList<String> indexColumns = new ArrayList<String>();
        indexColumns.add(index.getIndexName());
        indexColumns.add(index.getOrigTableName());
        List indexKeys = index.getSd().getCols();
        StringBuilder keyString = new StringBuilder();
        boolean first = true;
        for (FieldSchema key : indexKeys) {
            if (!first) {
                keyString.append(", ");
            }
            keyString.append(key.getName());
            first = false;
        }
        indexColumns.add(keyString.toString());
        indexColumns.add(index.getIndexTableName());
        String indexHandlerClass = index.getIndexHandlerClass();
        HiveIndex.IndexType indexType = HiveIndex.getIndexTypeByClassName(indexHandlerClass);
        indexColumns.add(indexType.getName());
        indexColumns.add((String)index.getParameters().get("comment"));
        MetaDataFormatUtils.formatOutput(indexColumns.toArray(new String[0]), indexInfo);
        return indexInfo.toString();
    }

    public static String getPartitionInformation(Partition part) {
        StringBuilder tableInfo = new StringBuilder(2048);
        tableInfo.append(LINE_DELIM).append("# Detailed Partition Information").append(LINE_DELIM);
        MetaDataFormatUtils.getPartitionMetaDataInformation(tableInfo, part);
        if (part.getTable().getTableType() != TableType.VIRTUAL_VIEW) {
            tableInfo.append(LINE_DELIM).append("# Storage Information").append(LINE_DELIM);
            MetaDataFormatUtils.getStorageDescriptorInfo(tableInfo, part.getTPartition().getSd());
        }
        return tableInfo.toString();
    }

    public static String getTableInformation(Table table) {
        StringBuilder tableInfo = new StringBuilder(2048);
        tableInfo.append(LINE_DELIM).append("# Detailed Table Information").append(LINE_DELIM);
        MetaDataFormatUtils.getTableMetaDataInformation(tableInfo, table);
        tableInfo.append(LINE_DELIM).append("# Storage Information").append(LINE_DELIM);
        MetaDataFormatUtils.getStorageDescriptorInfo(tableInfo, table.getTTable().getSd());
        if (table.isView()) {
            tableInfo.append(LINE_DELIM).append("# View Information").append(LINE_DELIM);
            MetaDataFormatUtils.getViewInfo(tableInfo, table);
        }
        return tableInfo.toString();
    }

    private static void getViewInfo(StringBuilder tableInfo, Table tbl) {
        MetaDataFormatUtils.formatOutput("View Original Text:", tbl.getViewOriginalText(), tableInfo);
        MetaDataFormatUtils.formatOutput("View Expanded Text:", tbl.getViewExpandedText(), tableInfo);
    }

    private static void getStorageDescriptorInfo(StringBuilder tableInfo, StorageDescriptor storageDesc) {
        MetaDataFormatUtils.formatOutput("SerDe Library:", storageDesc.getSerdeInfo().getSerializationLib(), tableInfo);
        MetaDataFormatUtils.formatOutput("InputFormat:", storageDesc.getInputFormat(), tableInfo);
        MetaDataFormatUtils.formatOutput("OutputFormat:", storageDesc.getOutputFormat(), tableInfo);
        MetaDataFormatUtils.formatOutput("Compressed:", storageDesc.isCompressed() ? "Yes" : "No", tableInfo);
        MetaDataFormatUtils.formatOutput("Num Buckets:", String.valueOf(storageDesc.getNumBuckets()), tableInfo);
        MetaDataFormatUtils.formatOutput("Bucket Columns:", storageDesc.getBucketCols().toString(), tableInfo);
        MetaDataFormatUtils.formatOutput("Sort Columns:", storageDesc.getSortCols().toString(), tableInfo);
        if (storageDesc.isStoredAsSubDirectories()) {
            MetaDataFormatUtils.formatOutput("Stored As SubDirectories:", "Yes", tableInfo);
        }
        if (null != storageDesc.getSkewedInfo()) {
            Map skewedColMap;
            List skewedColValues;
            List skewedColNames = storageDesc.getSkewedInfo().getSkewedColNames();
            if (skewedColNames != null && skewedColNames.size() > 0) {
                MetaDataFormatUtils.formatOutput("Skewed Columns:", skewedColNames.toString(), tableInfo);
            }
            if ((skewedColValues = storageDesc.getSkewedInfo().getSkewedColValues()) != null && skewedColValues.size() > 0) {
                MetaDataFormatUtils.formatOutput("Skewed Values:", skewedColValues.toString(), tableInfo);
            }
            if ((skewedColMap = storageDesc.getSkewedInfo().getSkewedColValueLocationMaps()) != null && skewedColMap.size() > 0) {
                MetaDataFormatUtils.formatOutput("Skewed Value to Path:", skewedColMap.toString(), tableInfo);
                HashMap truncatedSkewedColMap = new HashMap();
                Set entries = skewedColMap.entrySet();
                for (Map.Entry entry : entries) {
                    truncatedSkewedColMap.put(entry.getKey(), PlanUtils.removePrefixFromWarehouseConfig((String)entry.getValue()));
                }
                MetaDataFormatUtils.formatOutput("Skewed Value to Truncated Path:", ((Object)truncatedSkewedColMap).toString(), tableInfo);
            }
        }
        if (storageDesc.getSerdeInfo().getParametersSize() > 0) {
            tableInfo.append("Storage Desc Params:").append(LINE_DELIM);
            MetaDataFormatUtils.displayAllParameters(storageDesc.getSerdeInfo().getParameters(), tableInfo);
        }
    }

    private static void getTableMetaDataInformation(StringBuilder tableInfo, Table tbl) {
        MetaDataFormatUtils.formatOutput("Database:", tbl.getDbName(), tableInfo);
        MetaDataFormatUtils.formatOutput("Owner:", tbl.getOwner(), tableInfo);
        MetaDataFormatUtils.formatOutput("CreateTime:", MetaDataFormatUtils.formatDate(tbl.getTTable().getCreateTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("LastAccessTime:", MetaDataFormatUtils.formatDate(tbl.getTTable().getLastAccessTime()), tableInfo);
        String protectMode = tbl.getProtectMode().toString();
        MetaDataFormatUtils.formatOutput("Protect Mode:", protectMode == null ? "None" : protectMode, tableInfo);
        MetaDataFormatUtils.formatOutput("Retention:", Integer.toString(tbl.getRetention()), tableInfo);
        if (!tbl.isView()) {
            MetaDataFormatUtils.formatOutput("Location:", tbl.getDataLocation().toString(), tableInfo);
        }
        MetaDataFormatUtils.formatOutput("Table Type:", tbl.getTableType().name(), tableInfo);
        if (tbl.getParameters().size() > 0) {
            tableInfo.append("Table Parameters:").append(LINE_DELIM);
            MetaDataFormatUtils.displayAllParameters(tbl.getParameters(), tableInfo);
        }
    }

    private static void getPartitionMetaDataInformation(StringBuilder tableInfo, Partition part) {
        MetaDataFormatUtils.formatOutput("Partition Value:", part.getValues().toString(), tableInfo);
        MetaDataFormatUtils.formatOutput("Database:", part.getTPartition().getDbName(), tableInfo);
        MetaDataFormatUtils.formatOutput("Table:", part.getTable().getTableName(), tableInfo);
        MetaDataFormatUtils.formatOutput("CreateTime:", MetaDataFormatUtils.formatDate(part.getTPartition().getCreateTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("LastAccessTime:", MetaDataFormatUtils.formatDate(part.getTPartition().getLastAccessTime()), tableInfo);
        String protectMode = part.getProtectMode().toString();
        MetaDataFormatUtils.formatOutput("Protect Mode:", protectMode == null ? "None" : protectMode, tableInfo);
        MetaDataFormatUtils.formatOutput("Location:", part.getLocation(), tableInfo);
        if (part.getTPartition().getParameters().size() > 0) {
            tableInfo.append("Partition Parameters:").append(LINE_DELIM);
            MetaDataFormatUtils.displayAllParameters(part.getTPartition().getParameters(), tableInfo);
        }
    }

    private static void displayAllParameters(Map<String, String> params, StringBuilder tableInfo) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            tableInfo.append(FIELD_DELIM);
            MetaDataFormatUtils.formatOutput(key, StringEscapeUtils.escapeJava((String)params.get(key)), tableInfo);
        }
    }

    static String getComment(FieldSchema col) {
        return col.getComment() != null ? col.getComment() : "";
    }

    private static String formatDate(long timeInSeconds) {
        if (timeInSeconds != 0L) {
            java.util.Date date = new java.util.Date(timeInSeconds * 1000L);
            return date.toString();
        }
        return "UNKNOWN";
    }

    private static void formatOutput(String[] fields, StringBuilder tableInfo) {
        for (String field : fields) {
            if (field == null) {
                tableInfo.append(FIELD_DELIM);
                continue;
            }
            tableInfo.append(String.format("%-20s", field)).append(FIELD_DELIM);
        }
        tableInfo.append(LINE_DELIM);
    }

    private static void formatOutput(String name, String value, StringBuilder tableInfo) {
        tableInfo.append(String.format("%-20s", name)).append(FIELD_DELIM);
        tableInfo.append(String.format("%-20s", value)).append(LINE_DELIM);
    }

    private static void formatWithIndentation(String colName, String colType, String colComment, StringBuilder tableInfo, List<ColumnStatisticsObj> colStats) {
        tableInfo.append(String.format("%-20s", colName)).append(FIELD_DELIM);
        tableInfo.append(String.format("%-20s", colType)).append(FIELD_DELIM);
        if (colStats != null) {
            ColumnStatisticsObj cso = MetaDataFormatUtils.getColumnStatisticsObject(colName, colType, colStats);
            if (cso != null) {
                DecimalColumnStatsData dcsd;
                BinaryColumnStatsData bcsd;
                ColumnStatisticsData csd = cso.getStatsData();
                if (csd.isSetBinaryStats()) {
                    bcsd = csd.getBinaryStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, "", "", bcsd.getNumNulls(), "", bcsd.getAvgColLen(), bcsd.getMaxColLen(), "", "");
                } else if (csd.isSetStringStats()) {
                    StringColumnStatsData scsd = csd.getStringStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, "", "", scsd.getNumNulls(), scsd.getNumDVs(), scsd.getAvgColLen(), scsd.getMaxColLen(), "", "");
                } else if (csd.isSetBooleanStats()) {
                    bcsd = csd.getBooleanStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, "", "", bcsd.getNumNulls(), "", "", "", bcsd.getNumTrues(), bcsd.getNumFalses());
                } else if (csd.isSetDecimalStats()) {
                    dcsd = csd.getDecimalStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDoubleStats()) {
                    dcsd = csd.getDoubleStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, dcsd.getLowValue(), dcsd.getHighValue(), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetLongStats()) {
                    LongColumnStatsData lcsd = csd.getLongStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, lcsd.getLowValue(), lcsd.getHighValue(), lcsd.getNumNulls(), lcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDateStats()) {
                    dcsd = csd.getDateStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                }
            } else {
                MetaDataFormatUtils.appendColumnStats(tableInfo, "", "", "", "", "", "", "", "");
            }
        }
        String[] commentSegments = colComment.split("\n|\r|\r\n");
        tableInfo.append(String.format("%-20s", commentSegments[0])).append(LINE_DELIM);
        int colNameLength = 20 > colName.length() ? 20 : colName.length();
        int colTypeLength = 20 > colType.length() ? 20 : colType.length();
        for (int i = 1; i < commentSegments.length; ++i) {
            tableInfo.append(String.format("%" + colNameLength + "s" + FIELD_DELIM + "%" + colTypeLength + "s" + FIELD_DELIM + "%s", "", "", commentSegments[i])).append(LINE_DELIM);
        }
    }

    private static void appendColumnStats(StringBuilder sb, Object min, Object max, Object numNulls, Object ndv, Object avgColLen, Object maxColLen, Object numTrues, Object numFalses) {
        sb.append(String.format("%-20s", min)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", max)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", numNulls)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", ndv)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", avgColLen)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", maxColLen)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", numTrues)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", numFalses)).append(FIELD_DELIM);
    }

    private static void appendColumnStatsNoFormatting(StringBuilder sb, Object min, Object max, Object numNulls, Object ndv, Object avgColLen, Object maxColLen, Object numTrues, Object numFalses) {
        sb.append(min).append(FIELD_DELIM);
        sb.append(max).append(FIELD_DELIM);
        sb.append(numNulls).append(FIELD_DELIM);
        sb.append(ndv).append(FIELD_DELIM);
        sb.append(avgColLen).append(FIELD_DELIM);
        sb.append(maxColLen).append(FIELD_DELIM);
        sb.append(numTrues).append(FIELD_DELIM);
        sb.append(numFalses).append(FIELD_DELIM);
    }

    public static String[] getColumnsHeader(List<ColumnStatisticsObj> colStats) {
        boolean showColStats = false;
        if (colStats != null) {
            showColStats = true;
        }
        return DescTableDesc.getSchema(showColStats).split("#")[0].split(",");
    }

    public static String getIndexColumnsHeader() {
        StringBuilder indexCols = new StringBuilder(2048);
        MetaDataFormatUtils.formatOutput(ShowIndexesDesc.getSchema().split("#")[0].split(","), indexCols);
        return indexCols.toString();
    }

    public static MetaDataFormatter getFormatter(HiveConf conf) {
        if ("json".equals(conf.get(HiveConf.ConfVars.HIVE_DDL_OUTPUT_FORMAT.varname, "text"))) {
            return new JsonMetaDataFormatter();
        }
        return new TextMetaDataFormatter(conf.getIntVar(HiveConf.ConfVars.CLIPRETTYOUTPUTNUMCOLS), conf.getBoolVar(HiveConf.ConfVars.HIVE_DISPLAY_PARTITION_COLUMNS_SEPARATELY));
    }
}

