/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.sources.RateStreamMicroBatchInputPartition;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.sources.v2.reader.streaming.Offset;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u0001E\u0011!DU1uKN#(/Z1n\u001b&\u001c'o\u001c\"bi\u000eD'+Z1eKJT!a\u0001\u0003\u0002\u000fM|WO]2fg*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00135\u0011\u0002\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\t1\fgn\u001a\u0006\u0002/\u0005!!.\u0019<b\u0013\tIBC\u0001\u0004PE*,7\r\u001e\t\u00037\tj\u0011\u0001\b\u0006\u0003\u000buQ!AH\u0010\u0002\rI,\u0017\rZ3s\u0015\t\u0001\u0013%\u0001\u0002we)\u00111\u0001C\u0005\u0003Gq\u0011\u0001#T5de>\u0014\u0015\r^2i%\u0016\fG-\u001a:\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dR\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005%2#a\u0002'pO\u001eLgn\u001a\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u00059q\u000e\u001d;j_:\u001c\bCA\u0017/\u001b\u0005y\u0012BA\u0018 \u0005E!\u0015\r^1T_V\u00148-Z(qi&|gn\u001d\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005\u00112\r[3dWB|\u0017N\u001c;M_\u000e\fG/[8o!\t\u0019\u0014H\u0004\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tAT'\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d6\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q\u0019q(\u0011\"\u0011\u0005\u0001\u0003Q\"\u0001\u0002\t\u000b-b\u0004\u0019\u0001\u0017\t\u000bEb\u0004\u0019\u0001\u001a\t\u0011\u0011\u0003!\u0019!C\u0001\u0005\u0015\u000bQa\u00197pG.,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013*\tA!\u001e;jY&\u00111\n\u0013\u0002\u0006\u00072|7m\u001b\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002$\u0002\r\rdwnY6!\u0011\u001dy\u0005A1A\u0005\nA\u000bQB]8xgB+'oU3d_:$W#A)\u0011\u0005Q\u0012\u0016BA*6\u0005\u0011auN\\4\t\rU\u0003\u0001\u0015!\u0003R\u00039\u0011xn^:QKJ\u001cVmY8oI\u0002Bqa\u0016\u0001C\u0002\u0013%\u0001+A\tsC6\u0004X\u000b\u001d+j[\u0016\u001cVmY8oINDa!\u0017\u0001!\u0002\u0013\t\u0016A\u0005:b[B,\u0006\u000fV5nKN+7m\u001c8eg\u0002Bqa\u0017\u0001C\u0002\u0013%\u0001+\u0001\u0006nCb\u001cVmY8oINDa!\u0018\u0001!\u0002\u0013\t\u0016aC7bqN+7m\u001c8eg\u0002B\u0001b\u0018\u0001C\u0002\u0013\u0005!\u0001U\u0001\u000fGJ,\u0017\r^5p]RKW.Z't\u0011\u0019\t\u0007\u0001)A\u0005#\u0006y1M]3bi&|g\u000eV5nK6\u001b\b\u0005C\u0004d\u0001\u0001\u0007I\u0011\u0002)\u0002\u00151\f7\u000f\u001e+j[\u0016l5\u000fC\u0004f\u0001\u0001\u0007I\u0011\u00024\u0002\u001d1\f7\u000f\u001e+j[\u0016l5o\u0018\u0013fcR\u0011qM\u001b\t\u0003i!L!![\u001b\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0012\f\t\u00111\u0001R\u0003\rAH%\r\u0005\u0007[\u0002\u0001\u000b\u0015B)\u0002\u00171\f7\u000f\u001e+j[\u0016l5\u000f\t\u0015\u0003Y>\u0004\"\u0001\u000e9\n\u0005E,$\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013M\u0004\u0001\u0019!a\u0001\n\u0013!\u0018!B:uCJ$X#A;\u0011\u0005Y<X\"\u0001\u0003\n\u0005a$!A\u0003'p]\u001e|eMZ:fi\"I!\u0010\u0001a\u0001\u0002\u0004%Ia_\u0001\ngR\f'\u000f^0%KF$\"a\u001a?\t\u000f-L\u0018\u0011!a\u0001k\"1a\u0010\u0001Q!\nU\faa\u001d;beR\u0004\u0003BCA\u0001\u0001\u0001\u0007\t\u0019!C\u0005i\u0006\u0019QM\u001c3\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013%\u0011qA\u0001\bK:$w\fJ3r)\r9\u0017\u0011\u0002\u0005\tW\u0006\r\u0011\u0011!a\u0001k\"9\u0011Q\u0002\u0001!B\u0013)\u0018\u0001B3oI\u0002Bq!!\u0005\u0001\t\u0003\n\u0019\"\u0001\u0006sK\u0006$7k\u00195f[\u0006$\"!!\u0006\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007\t\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ty\"!\u0007\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002$\u0001!\t%!\n\u0002\u001dM,Go\u00144gg\u0016$(+\u00198hKR)q-a\n\u0002:!91/!\tA\u0002\u0005%\u0002CBA\u0016\u0003_\t\u0019$\u0004\u0002\u0002.)\u0011\u0011JF\u0005\u0005\u0003c\tiC\u0001\u0005PaRLwN\\1m!\rY\u0012QG\u0005\u0004\u0003oa\"AB(gMN,G\u000f\u0003\u0005\u0002\u0002\u0005\u0005\u0002\u0019AA\u0015\u0011\u001d\ti\u0004\u0001C!\u0003\u007f\tabZ3u'R\f'\u000f^(gMN,G\u000f\u0006\u0002\u00024!9\u00111\t\u0001\u0005B\u0005}\u0012\u0001D4fi\u0016sGm\u00144gg\u0016$\bbBA$\u0001\u0011\u0005\u0013\u0011J\u0001\u0012I\u0016\u001cXM]5bY&TXm\u00144gg\u0016$H\u0003BA\u001a\u0003\u0017Bq!!\u0014\u0002F\u0001\u0007!'\u0001\u0003kg>t\u0007bBA)\u0001\u0011\u0005\u00131K\u0001\u0014a2\fg.\u00138qkR\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0003+\u0002b!a\u000b\u0002X\u0005m\u0013\u0002BA-\u0003[\u0011A\u0001T5tiB1\u0011QLA0\u0003Gj\u0011!H\u0005\u0004\u0003Cj\"AD%oaV$\b+\u0019:uSRLwN\u001c\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e\u0005\u0002\u0011\r\fG/\u00197zgRLA!!\u001c\u0002h\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\t\t\b\u0001C!\u0003g\naaY8n[&$HcA4\u0002v!A\u0011\u0011AA8\u0001\u0004\t\u0019\u0004C\u0004\u0002z\u0001!\t%a\u001f\u0002\tM$x\u000e\u001d\u000b\u0002O\"9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003I\u0002")
public class RateStreamMicroBatchReader
implements MicroBatchReader,
Logging {
    private final DataSourceOptions options;
    public final String org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$checkpointLocation;
    private final Clock clock;
    private final long rowsPerSecond;
    private final long rampUpTimeSeconds;
    private final long maxSeconds;
    private final long creationTimeMs;
    private volatile long lastTimeMs;
    private LongOffset start;
    private LongOffset end;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Clock clock() {
        return this.clock;
    }

    private long rowsPerSecond() {
        return this.rowsPerSecond;
    }

    private long rampUpTimeSeconds() {
        return this.rampUpTimeSeconds;
    }

    private long maxSeconds() {
        return this.maxSeconds;
    }

    public long creationTimeMs() {
        return this.creationTimeMs;
    }

    private long lastTimeMs() {
        return this.lastTimeMs;
    }

    private void lastTimeMs_$eq(long x$1) {
        this.lastTimeMs = x$1;
    }

    private LongOffset start() {
        return this.start;
    }

    private void start_$eq(LongOffset x$1) {
        this.start = x$1;
    }

    private LongOffset end() {
        return this.end;
    }

    private void end_$eq(LongOffset x$1) {
        this.end = x$1;
    }

    @Override
    public StructType readSchema() {
        return RateStreamProvider$.MODULE$.SCHEMA();
    }

    @Override
    public void setOffsetRange(Optional<Offset> start2, Optional<Offset> end) {
        this.start_$eq((LongOffset)start2.orElse(new LongOffset(0L)));
        long now = this.clock().getTimeMillis();
        if (this.lastTimeMs() < now) {
            this.lastTimeMs_$eq(now);
        }
        this.end_$eq((LongOffset)end.orElse(new LongOffset(TimeUnit.MILLISECONDS.toSeconds(this.lastTimeMs() - this.creationTimeMs()))));
    }

    @Override
    public Offset getStartOffset() {
        if (this.start() == null) {
            throw new IllegalStateException("start offset not set");
        }
        return this.start();
    }

    @Override
    public Offset getEndOffset() {
        if (this.end() == null) {
            throw new IllegalStateException("end offset not set");
        }
        return this.end();
    }

    @Override
    public Offset deserializeOffset(String json) {
        return new LongOffset(new StringOps(Predef$.MODULE$.augmentString(json)).toLong());
    }

    @Override
    public List<InputPartition<InternalRow>> planInputPartitions() {
        long endSeconds;
        long startSeconds = BoxesRunTime.unboxToLong((Object)LongOffset$.MODULE$.convert(this.start()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LongOffset x$2) {
                return x$2.offset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Predef$.MODULE$.assert(startSeconds <= (endSeconds = BoxesRunTime.unboxToLong((Object)LongOffset$.MODULE$.convert(this.end()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LongOffset x$3) {
                return x$3.offset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }))), (Function0)new Serializable(this, startSeconds, endSeconds){
            public static final long serialVersionUID = 0L;
            private final long startSeconds$1;
            private final long endSeconds$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startSeconds(", ") > endSeconds(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startSeconds$1), BoxesRunTime.boxToLong((long)this.endSeconds$1)}));
            }
            {
                this.startSeconds$1 = startSeconds$1;
                this.endSeconds$1 = endSeconds$1;
            }
        });
        if (endSeconds > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder().append((Object)"Integer overflow. Max offset with ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " rowsPerSecond is ", ", but it's ", " now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rowsPerSecond()), BoxesRunTime.boxToLong((long)this.maxSeconds()), BoxesRunTime.boxToLong((long)endSeconds)}))).toString());
        }
        if (this.lastTimeMs() < TimeUnit.SECONDS.toMillis(endSeconds) + this.creationTimeMs()) {
            this.lastTimeMs_$eq(TimeUnit.SECONDS.toMillis(endSeconds) + this.creationTimeMs());
        }
        long rangeStart = RateStreamProvider$.MODULE$.valueAtSecond(startSeconds, this.rowsPerSecond(), this.rampUpTimeSeconds());
        long rangeEnd = RateStreamProvider$.MODULE$.valueAtSecond(endSeconds, this.rowsPerSecond(), this.rampUpTimeSeconds());
        this.logDebug((Function0<String>)new Serializable(this, startSeconds, endSeconds, rangeStart, rangeEnd){
            public static final long serialVersionUID = 0L;
            private final long startSeconds$1;
            private final long endSeconds$1;
            private final long rangeStart$1;
            private final long rangeEnd$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startSeconds: ", ", endSeconds: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startSeconds$1), BoxesRunTime.boxToLong((long)this.endSeconds$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rangeStart: ", ", rangeEnd: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rangeStart$1), BoxesRunTime.boxToLong((long)this.rangeEnd$1)}))).toString();
            }
            {
                this.startSeconds$1 = startSeconds$1;
                this.endSeconds$1 = endSeconds$1;
                this.rangeStart$1 = rangeStart$1;
                this.rangeEnd$1 = rangeEnd$1;
            }
        });
        if (rangeStart == rangeEnd) {
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava();
        }
        long localStartTimeMs = this.creationTimeMs() + TimeUnit.SECONDS.toMillis(startSeconds);
        double relativeMsPerValue = (double)TimeUnit.SECONDS.toMillis(endSeconds - startSeconds) / (double)(rangeEnd - rangeStart);
        Option<SparkSession> activeSession = SparkSession$.MODULE$.getActiveSession();
        Predef$.MODULE$.require(activeSession.isDefined());
        int numPartitions = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).orElse(null)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this, activeSession){
            public static final long serialVersionUID = 0L;
            private final Option activeSession$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return ((SparkSession)this.activeSession$1.get()).sparkContext().defaultParallelism();
            }
            {
                this.activeSession$1 = activeSession$1;
            }
        }));
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(this, rangeStart, rangeEnd, localStartTimeMs, relativeMsPerValue, numPartitions){
            public static final long serialVersionUID = 0L;
            private final long rangeStart$1;
            private final long rangeEnd$1;
            private final long localStartTimeMs$1;
            private final double relativeMsPerValue$1;
            private final int numPartitions$1;

            public final InputPartition<InternalRow> apply(int p) {
                return new RateStreamMicroBatchInputPartition(p, this.numPartitions$1, this.rangeStart$1, this.rangeEnd$1, this.localStartTimeMs$1, this.relativeMsPerValue$1);
            }
            {
                this.rangeStart$1 = rangeStart$1;
                this.rangeEnd$1 = rangeEnd$1;
                this.localStartTimeMs$1 = localStartTimeMs$1;
                this.relativeMsPerValue$1 = relativeMsPerValue$1;
                this.numPartitions$1 = numPartitions$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public String toString() {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RateStreamV2[rowsPerSecond=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rowsPerSecond())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rampUpTimeSeconds=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rampUpTimeSeconds())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numPartitions=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.options.get(RateStreamProvider$.MODULE$.NUM_PARTITIONS()).orElse("default")}))).toString();
    }

    public RateStreamMicroBatchReader(DataSourceOptions options, String checkpointLocation) {
        this.options = options;
        this.org$apache$spark$sql$execution$streaming$sources$RateStreamMicroBatchReader$$checkpointLocation = checkpointLocation;
        Logging.class.$init$((Logging)this);
        this.clock = options.getBoolean("useManualClock", false) ? new ManualClock() : new SystemClock();
        this.rowsPerSecond = new StringOps(Predef$.MODULE$.augmentString(options.get(RateStreamProvider$.MODULE$.ROWS_PER_SECOND()).orElse("1"))).toLong();
        this.rampUpTimeSeconds = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(options.get(RateStreamProvider$.MODULE$.RAMP_UP_TIME()).orElse(null)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$1) {
                return JavaUtils.timeStringAsSec((String)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.maxSeconds = Long.MAX_VALUE / this.rowsPerSecond();
        if (this.rampUpTimeSeconds() > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Integer overflow. Max offset with ", " rowsPerSecond"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rowsPerSecond())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" is ", ", but 'rampUpTimeSeconds' is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxSeconds()), BoxesRunTime.boxToLong((long)this.rampUpTimeSeconds())}))).toString());
        }
        Option session = SparkSession$.MODULE$.getActiveSession().orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<SparkSession> apply() {
                return SparkSession$.MODULE$.getDefaultSession();
            }
        });
        Predef$.MODULE$.require(session.isDefined());
        HDFSMetadataLog<LongOffset> metadataLog = new HDFSMetadataLog<LongOffset>(this, session){

            public void serialize(LongOffset metadata, OutputStream out) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                writer.write(new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)RateStreamProvider$.MODULE$.VERSION())).append((Object)"\n").toString());
                writer.write(metadata.json());
                writer.flush();
            }

            public LongOffset deserialize(InputStream in) {
                String content = IOUtils.toString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                Predef$.MODULE$.assert(content.length() != 0);
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
                    int indexOfNewLine = content.indexOf("\n");
                    if (indexOfNewLine > 0) {
                        this.parseVersion(content.substring(0, indexOfNewLine), RateStreamProvider$.MODULE$.VERSION());
                        return LongOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to detect the log file version line."})).s((Seq)Nil$.MODULE$));
                }
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to detect the log file version line."})).s((Seq)Nil$.MODULE$));
            }
        };
        this.creationTimeMs = ((LongOffset)metadataLog.get(0L).getOrElse((Function0)new Serializable(this, metadataLog){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RateStreamMicroBatchReader $outer;
            private final HDFSMetadataLog metadataLog$1;

            /*
             * WARNING - void declaration
             */
            public final LongOffset apply() {
                void var1_1;
                LongOffset offset = new LongOffset(this.$outer.clock().getTimeMillis());
                this.metadataLog$1.add(0L, offset);
                this.$outer.logInfo((Function0<String>)new Serializable(this, offset){
                    public static final long serialVersionUID = 0L;
                    private final LongOffset offset$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start time: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offset$1}));
                    }
                    {
                        this.offset$1 = offset$1;
                    }
                });
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metadataLog$1 = metadataLog$1;
            }
        })).offset();
        this.lastTimeMs = this.creationTimeMs();
    }
}

