/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.util.KMeansDataGenerator$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@DeveloperApi
public final class KMeansDataGenerator$ {
    public static final KMeansDataGenerator$ MODULE$;

    static {
        new KMeansDataGenerator$();
    }

    public RDD<double[]> generateKMeansRDD(SparkContext sc, int numPoints, int k, int d, double r, int numPartitions) {
        Random rand2 = new Random(42);
        double[][] centers = (double[][])Array$.MODULE$.fill(k, (Function0)new Serializable(d, r, rand2){
            public static final long serialVersionUID = 0L;
            private final int d$1;
            public final double r$1;
            public final Random rand$1;

            public final double[] apply() {
                return (double[])Array$.MODULE$.fill(this.d$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.rand$1.nextGaussian() * this.$outer.r$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double());
            }
            {
                this.d$1 = d$1;
                this.r$1 = r$1;
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPoints), numPartitions, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(k, d, centers){
            public static final long serialVersionUID = 0L;
            private final int k$1;
            private final int d$1;
            private final double[][] centers$1;

            public final double[] apply(int idx) {
                double[] center = this.centers$1[idx % this.k$1];
                Random rand2 = new Random(42 + idx);
                return (double[])Array$.MODULE$.tabulate(this.d$1, (Function1)new Serializable(this, center, rand2){
                    public static final long serialVersionUID = 0L;
                    private final double[] center$1;
                    private final Random rand2$1;

                    public final double apply(int i) {
                        return this.apply$mcDI$sp(i);
                    }

                    public double apply$mcDI$sp(int i) {
                        return this.center$1[i] + this.rand2$1.nextGaussian();
                    }
                    {
                        this.center$1 = center$1;
                        this.rand2$1 = rand2$1;
                    }
                }, ClassTag$.MODULE$.Double());
            }
            {
                this.k$1 = k$1;
                this.d$1 = d$1;
                this.centers$1 = centers$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public int generateKMeansRDD$default$6() {
        return 2;
    }

    public void main(String[] args) {
        if (args.length < 6) {
            Predef$.MODULE$.println((Object)"Usage: KMeansGenerator <master> <output_dir> <num_points> <k> <d> <r> [<num_partitions>]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int numPoints = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        int k = new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt();
        int d = new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt();
        double r = new StringOps(Predef$.MODULE$.augmentString(args[5])).toDouble();
        int parts = args.length >= 7 ? new StringOps(Predef$.MODULE$.augmentString(args[6])).toInt() : 2;
        SparkContext sc = new SparkContext(sparkMaster, "KMeansDataGenerator");
        RDD<double[]> data = this.generateKMeansRDD(sc, numPoints, k, d, r, parts);
        data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(double[] x$1) {
                return Predef$.MODULE$.doubleArrayOps(x$1).mkString(" ");
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outputPath);
        sc.stop();
        System.exit(0);
    }

    private KMeansDataGenerator$() {
        MODULE$ = this;
    }
}

