import * as iot from '@aws-cdk/aws-iot';
import * as sqs from '@aws-cdk/aws-sqs';
import { CommonActionProps } from './common-action-props';
/**
 * (experimental) Configuration properties of an action for SQS.
 *
 * @experimental
 */
export interface SqsQueueActionProps extends CommonActionProps {
    /**
     * (experimental) Specifies whether to use Base64 encoding.
     *
     * @default false
     * @experimental
     */
    readonly useBase64?: boolean;
}
/**
 * (experimental) The action to write the data from an MQTT message to an Amazon SQS queue.
 *
 * @experimental
 */
export declare class SqsQueueAction implements iot.IAction {
    private readonly role?;
    private readonly queue;
    private readonly useBase64?;
    /**
     * @param queue The Amazon SQS queue to which to write data.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(queue: sqs.IQueue, props?: SqsQueueActionProps);
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
