import * as iot from '@aws-cdk/aws-iot';
import * as kinesis from '@aws-cdk/aws-kinesis';
import { CommonActionProps } from './common-action-props';
/**
 * (experimental) Configuration properties of an action for the Kinesis Data stream.
 *
 * @experimental
 */
export interface KinesisPutRecordActionProps extends CommonActionProps {
    /**
     * (experimental) The partition key used to determine to which shard the data is written.
     *
     * The partition key is usually composed of an expression (for example, ${topic()} or ${timestamp()}).
     *
     * @see https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html#API_PutRecord_RequestParameters
     * @experimental
     */
    readonly partitionKey: string;
}
/**
 * (experimental) The action to put the record from an MQTT message to the Kinesis Data stream.
 *
 * @experimental
 */
export declare class KinesisPutRecordAction implements iot.IAction {
    private readonly stream;
    private readonly partitionKey?;
    private readonly role?;
    /**
     * @param stream The Kinesis Data stream to which to put records.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(stream: kinesis.IStream, props: KinesisPutRecordActionProps);
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
