# Generated by Django 3.0.5 on 2020-04-06 13:02

from django.db import migrations
from image_assets import defaults


# noinspection PyUnusedLocal
def migrate_formats(apps, schema_editor):
    # noinspection PyPep8Naming
    AssetType = apps.get_model('image_assets', 'AssetType')

    for at in AssetType.objects.all():
        flag = getattr(AssetType.formats, at.format)
        at.formats = flag
        at.save()


class Migration(migrations.Migration):
    dependencies = [
        ('image_assets', '0005_assettype_formats'),
    ]

    operations = []

    if defaults.ASSET_TYPE_MODEL == 'image_assets.AssetType':
        operations.extend([
            migrations.RunPython(migrate_formats, migrations.RunPython.noop),
        ])
