# AUTOGENERATED! DO NOT EDIT! File to edit: ../01_card.ipynb.

# %% auto 0
__all__ = ['suits', 'ranks', 'Card']

# %% ../01_card.ipynb 2
from nbdev.showdoc import *
from fastcore.test import *
from fastcore.utils import *

# %% ../01_card.ipynb 3
suits= ["♣", "♦", "♥", "♠"]
ranks = [None, "A"] + [str(x) for x in range(2,11)] + ["J", "Q", "K"]

# %% ../01_card.ipynb 13
class Card:
    '''A playing card, created by passing in `rank` from `ranks` and `suit` from `suits`'''
    def __init__(self, 
                 suit:int, # An index into `suits`
                 rank:int): # An index into `ranks`
        self.suit, self.rank = suit, rank
    def __str__(self): return f"{ranks[self.rank]}{suits[self.suit]}"
    __repr__ = __str__
    def __eq__(self:'Card', a:'Card'): return (self.suit, self.rank)==(a.suit, a.rank)
    def __lt__(self:'Card', a:'Card'): return (self.suit, self.rank)<(a.suit, a.rank)
    def __gt__(self:'Card', a:'Card'): return (self.suit, self.rank)>(a.suit, a.rank)

# %% ../01_card.ipynb 16
# @patch - need "from fastcore.utils import *"
# def __eq__(self:Card, a:Card): return (self.suit, self.rank)==(a.suit, a.rank)
