"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.simulatePattern = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const automation_document_1 = require("../document/automation-document");
const simulation_1 = require("../simulation/simulation");
function simulatePattern(automationComponent, simulationProps, inputs) {
    const stack = new aws_cdk_lib_1.Stack();
    const document = new automation_document_1.AutomationDocument(stack, 'SimulatePatternDoc', {});
    document.addStep(automationComponent);
    return simulation_1.Simulation.ofAutomation(document, simulationProps).simulate(inputs);
}
exports.simulatePattern = simulatePattern;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2ltdWxhdGUtcGF0dGVybi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlscy9zaW11bGF0ZS1wYXR0ZXJuLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZDQUFvQztBQUVwQyx5RUFBcUU7QUFFckUseURBQXVFO0FBRXZFLFNBQWdCLGVBQWUsQ0FBQyxtQkFBeUMsRUFBRSxlQUFnQyxFQUFFLE1BQTJCO0lBRXRJLE1BQU0sS0FBSyxHQUFHLElBQUksbUJBQUssRUFBRSxDQUFDO0lBQzFCLE1BQU0sUUFBUSxHQUFHLElBQUksd0NBQWtCLENBQUMsS0FBSyxFQUFFLG9CQUFvQixFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQ3pFLFFBQVEsQ0FBQyxPQUFPLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxPQUFPLHVCQUFVLENBQUMsWUFBWSxDQUFDLFFBQVEsRUFBRSxlQUFlLENBQUMsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUM7QUFDN0UsQ0FBQztBQU5ELDBDQU1DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBJQXV0b21hdGlvbkNvbXBvbmVudCB9IGZyb20gJy4uL2NvbnN0cnVjdC9kb2N1bWVudC1jb21wb25lbnQnO1xuaW1wb3J0IHsgQXV0b21hdGlvbkRvY3VtZW50IH0gZnJvbSAnLi4vZG9jdW1lbnQvYXV0b21hdGlvbi1kb2N1bWVudCc7XG5pbXBvcnQgeyBEb2N1bWVudFJlc3VsdCB9IGZyb20gJy4uL2RvbWFpbi9kb2N1bWVudC1yZXN1bHQnO1xuaW1wb3J0IHsgU2ltdWxhdGlvbiwgU2ltdWxhdGlvblByb3BzIH0gZnJvbSAnLi4vc2ltdWxhdGlvbi9zaW11bGF0aW9uJztcblxuZXhwb3J0IGZ1bmN0aW9uIHNpbXVsYXRlUGF0dGVybihhdXRvbWF0aW9uQ29tcG9uZW50OiBJQXV0b21hdGlvbkNvbXBvbmVudCwgc2ltdWxhdGlvblByb3BzOiBTaW11bGF0aW9uUHJvcHMsIGlucHV0czogUmVjb3JkPHN0cmluZywgYW55Pik6XG5Eb2N1bWVudFJlc3VsdCB7XG4gIGNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKCk7XG4gIGNvbnN0IGRvY3VtZW50ID0gbmV3IEF1dG9tYXRpb25Eb2N1bWVudChzdGFjaywgJ1NpbXVsYXRlUGF0dGVybkRvYycsIHt9KTtcbiAgZG9jdW1lbnQuYWRkU3RlcChhdXRvbWF0aW9uQ29tcG9uZW50KTtcbiAgcmV0dXJuIFNpbXVsYXRpb24ub2ZBdXRvbWF0aW9uKGRvY3VtZW50LCBzaW11bGF0aW9uUHJvcHMpLnNpbXVsYXRlKGlucHV0cyk7XG59Il19