/**
 * Blocks the main thread to wait for Promise to complete.
 * Granted this is an anti-pattern in TypeScript, but if you dare to block the main thread this will do it.
 * This is usefull in JSII export languages can use this library directly wihtout having to deal with callbacks.
 */
export declare class SynchronousPromise {
    /**
       * You must prepare a file with a class that implements AsyncRunner.
       * AsyncRunner returns a Promise which this class will wait on to complete.
       * Note: The inputs and outputs from this method must be serializable.
       * @param classFile The file which will be "require"ed.
       * @param className The name of the class which implements AsyncRunner.
       * @param funcArgs The args to pass to the AsyncRunner implementation
       * @param timeout The amount of time in seconds after which this function will stop waiting and return.
       * @returns The result of the Promise upon completion.
       */
    wait(classFile: string, className: string, funcArgs: any[], timeout?: number): any;
}
