"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsAsyncInvoker = void 0;
// eslint-disable-next-line @typescript-eslint/no-require-imports
const AWS = require('aws-sdk');
/**
 * Invokes AWS asynchronously.
 * This is used with SynchronousPromise to wait for the AWS call to complete synchronously.
 */
class AwsAsyncInvoker {
    /**
       * Expects a list containing 3 values:
       * 1. AWS Service (such as ec2)
       * 2. AWS API in lowerCamelCase
       * 3. The parameters to send to the specified API.
       */
    runAsync(args) {
        // Reflectively invokes the aws service (args[0]) with the aws api (args[1]) with the aws params (args[2])
        return new Promise(function (resolve, _reject) {
            process.env.AWS_SDK_LOAD_CONFIG = String(true);
            const awsPromise = new AWS[args[0]]()[args[1]](args[2]).promise();
            awsPromise.then(function (data) {
                resolve({ status: 'SUCCESS', Payload: data });
            }).catch(function (err) {
                resolve({ status: 'FAILURE', Payload: err });
            });
        });
    }
}
exports.AwsAsyncInvoker = AwsAsyncInvoker;
//# sourceMappingURL=data:application/json;base64,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