"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutomationSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_step_simulation_1 = require("../automation-step-simulation");
class AutomationSimulation {
    constructor(automationDocument, props) {
        this.automationDocument = automationDocument;
        this.props = props;
    }
    /**
     * Starts the execution of the steps by invoking the first step.
     * The subsequent steps will be invoked by the steps themselves.
     * @param inputs all of the inputs necessary for the document to execute.
     * @returns the outputs specified by all the steps.
     */
    start(inputs) {
        const dateString = new Date().toISOString(); // Example 2021-10-08T08:44:02.106Z
        inputs['global:DATE'] = dateString.split('T')[0];
        inputs['global:DATE_TIME'] = dateString.split('.')[0]
            .replace('T', '_') // Example 2021-10-08_08:44:02
            .replace(/:/g, '.');
        const prefix = Math.floor(Math.random() * 999999).toString().padStart(6, '0');
        inputs['automation:EXECUTION_ID'] = prefix + '-1a2b3c-1a2b3c-1a2b3c1a2b3c1a2b3c';
        return new automation_step_simulation_1.AutomationStepSimulation(this.createChain(this.automationDocument.collectedSteps()), this.props).invoke(inputs);
    }
    /**
     * Chains the steps together in their default orientation (like a linked list).
     * The order of steps can change depending on the properties provided to the steps.
     * @returns the first step of the chain
     */
    createChain(steps) {
        const firstStep = steps[0];
        let previousStep = firstStep;
        steps.slice(1).forEach(s => {
            previousStep.nextStep = s;
            previousStep.allStepsInExecution = steps;
            previousStep = s;
        });
        return firstStep;
    }
}
exports.AutomationSimulation = AutomationSimulation;
_a = JSII_RTTI_SYMBOL_1;
AutomationSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AutomationSimulation", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,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