import { IAwsInvoker } from '../../interface/aws-invoker';
import { ISleepHook } from '../../interface/sleep-hook';
import { WaitForResourceStep } from '../../parent-steps/automation/wait-for-resource-step';
import { AutomationSimulationBase } from './automation-simulation-base';
export interface WaitForResourceSimulationProps {
    /**
     * (Optional) Hook to inject alternate ISleeper (to mock the sleep between failed invocations).
     * @default - really perform sleep using SleeperImpl class.
     */
    readonly sleepHook: ISleepHook;
    /**
     * (Optional) Use this as a hook to inject an alternate IAwsInvoker (for mocking the AWS API call).
     * @default - will perform a real invocation of the JavaScript AWS SDK using ReflectiveAwsInvoker class.
     */
    readonly awsInvoker: IAwsInvoker;
}
/**
 * AutomationStep impl for aws:waitForAwsResourceProperty
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-waitForAwsResourceProperty.html
 */
export declare class WaitForResourceSimulation extends AutomationSimulationBase {
    readonly action: string;
    private waitForResourceStep;
    private props;
    constructor(step: WaitForResourceStep, props: WaitForResourceSimulationProps);
    /**
     * As is the case in an SSM Automation execution, this will continue to sleep/execute until desired value is found.
     * This function will throw if the timeoutSeconds is exceeded and the desired value is still not received from AWS.
     */
    executeStep(inputs: {
        [name: string]: any;
    }): {
        [name: string]: any;
    };
}
