import { IWebhook } from '../../interface/webhook';
import { InvokeWebhookStep } from '../../parent-steps/automation/invoke-webhook-step';
import { AutomationSimulationBase } from './automation-simulation-base';
/**
 * Properties for InvokeWebhookStep
 */
export interface InvokeWebhookSimulationProps {
    /**
     * (Optional) Hook for simulating aws:invokeWebhook
     * @default - Returns 204 with an empty response
     */
    readonly webhook: IWebhook;
}
/**
 * AutomationStep implementation for [aws:invokeWebhook](https://docs.aws.amazon.com/systems-manager/latest/userguide/invoke-webhook.html)
 */
export declare class InvokeWebhookSimulation extends AutomationSimulationBase {
    readonly action = "aws:invokeWebhook";
    private invokeWebhookStep;
    private props;
    constructor(step: InvokeWebhookStep, props: InvokeWebhookSimulationProps);
    executeStep(inputs: Record<string, any>): Record<string, any>;
}
