import { IExecuteAutomationHook } from '..';
import { SimulationResult } from '../domain/simulation-result';
import { IApproveHook } from '../interface/approve-hook';
import { IAwsInvoker } from '../interface/aws-invoker';
import { IObserver } from '../interface/observer';
import { IPauseHook } from '../interface/pause-hook';
import { IRunCommandHook } from '../interface/run-command-hook';
import { ISleepHook } from '../interface/sleep-hook';
import { IWebhook } from '../interface/webhook';
import { AutomationStep } from '../parent-steps/automation-step';
import { IParameterResolver } from '../parent-steps/automation/create-stack-step';
import { AutomationSimulationProps } from './simulation';
/**
 * The same interface as AutomationSimulationProps but all fields are required.
 */
export interface RequiredAutomationSimulationProps {
    readonly sleepHook: ISleepHook;
    readonly awsInvoker: IAwsInvoker;
    readonly pauseHook: IPauseHook;
    readonly inputObserver: IObserver;
    readonly outputObserver: IObserver;
    readonly approveHook: IApproveHook;
    readonly parameterResolver: IParameterResolver;
    readonly webhook: IWebhook;
    readonly runCommandHook: IRunCommandHook;
    readonly executeAutomationHook: IExecuteAutomationHook;
}
export declare class AutomationStepSimulation {
    readonly step: AutomationStep;
    readonly props: RequiredAutomationSimulationProps;
    constructor(step: AutomationStep, props: AutomationSimulationProps);
    /**
     * Invokes the current step on the input and will return a SimulationResult.
     * @param inputs must contain all of the inputs declared by the current step.
     * @returns a SimulationResult with the step outputs in the case of success or stacktrace in the case of failure.
     */
    invoke(inputs: {
        [name: string]: any;
    }): SimulationResult;
    /**
     * If fallback/retries are specified for this step, the retry or skip logic is handled in this function.
     */
    private invokeWithFallback;
    /**
     * This function receives all of the available inputs and returns the subset of inputs that were requested.
     * If any input requested in the current step is not available in the received inputs, this will throw.
     * @param inputs all available inputs for the currently executing step
     * @returns the subset of inputs which are requested by the current step
     */
    private filterInputs;
    /**
     * Adds this step name to the list of executed steps.
     * Since the steps are invoked as a chain, the current step is prepended as invocation stack is popped.
     */
    protected prependSelf(subsequentSteps: string[]): string[];
    private executeWithRetries;
    private tryExecute;
    private mySimulation;
    /**
     * A timeout may be set as a property of a step.
     * This function checks the timeout to ensure that the execution time for the step was not exceeded.
     * The execution will not be killed when timeout is reached.
     * Rather an error will be thrown after the fact if time is exceeded.
     */
    private checkExecutionTime;
    /**
     * Finds each declared step output using the json selector specified.
     * @returns the mapping of output name to the value selected from the step execution response.
     */
    private getSelectedResponse;
}
