"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimedDocument = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const automation_document_1 = require("../../document/automation-document");
class TimedDocument extends automation_document_1.AutomationDocument {
    constructor(stage, id, props) {
        super(stage, id, props);
    }
    collectedSteps() {
        const middleSteps = super.collectedSteps();
        // If this is called a second time during synthesis then the newly created objects are inserted into the tree.
        // So first ensure that these aren't already added
        if (middleSteps.find(s => s.name == 'RecordStartTime')) {
            return middleSteps;
        }
        const recordStartTime = new __1.ExecuteScriptStep(this, 'RecordStartTime', {
            inlineCode: 'from datetime import datetime, timezone\n\n' +
                'def script_handler(params: dict, context):\n' +
                '    return datetime.now(timezone.utc).isoformat()\n\n',
            language: __1.ScriptLanguage.PYTHON,
            outputs: [{ outputType: __1.DataTypeEnum.STRING, name: 'StartTime', selector: '$.Payload' }],
            inputs: [],
        });
        const outputRecoveryTime = new __1.ExecuteScriptStep(this, 'OutputRecoveryTime', {
            inlineCode: 'from datetime import datetime, timezone\n' +
                'from dateutil import parser\n\n' +
                'def script_handler(params: dict, context):\n' +
                '    return (datetime.now(timezone.utc) - parser.parse(params[\'RecordStartTime.StartTime\'])).seconds\n\n',
            language: __1.ScriptLanguage.PYTHON,
            outputs: [{ outputType: __1.DataTypeEnum.INTEGER, name: 'RecoveryTime', selector: '$.Payload' }],
            inputs: ['RecordStartTime.StartTime'],
        });
        this.builder.steps.unshift(recordStartTime);
        this.builder.steps.push(outputRecoveryTime);
        return this.builder.steps;
    }
}
exports.TimedDocument = TimedDocument;
_a = JSII_RTTI_SYMBOL_1;
TimedDocument[_a] = { fqn: "@cdklabs/cdk-ssm-documents.TimedDocument", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,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