"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RebootInstanceAndWait = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_resource_step_1 = require("../../parent-steps/automation/wait-for-resource-step");
const composite_step_1 = require("./composite-step");
class RebootInstanceAndWait extends composite_step_1.CompositeAutomationStep {
    constructor(scope, id, instanceId) {
        super(scope, id);
        this.reboot = new aws_api_step_1.AwsApiStep(this, 'RebootInstances', {
            service: 'ec2',
            pascalCaseApi: 'RebootInstances',
            apiParams: { InstanceIds: [instanceId] },
            outputs: [],
        });
        this.describe = new wait_for_resource_step_1.WaitForResourceStep(this, 'DescribeInstances', {
            service: 'ec2',
            pascalCaseApi: 'DescribeInstances',
            apiParams: { InstanceIds: [instanceId] },
            selector: '$.Reservations[0].Instances[0].State.Name',
            desiredValues: ['running'],
        });
    }
    addToDocument(doc) {
        doc.addStep(this.reboot);
        doc.addStep(this.describe);
    }
}
exports.RebootInstanceAndWait = RebootInstanceAndWait;
_a = JSII_RTTI_SYMBOL_1;
RebootInstanceAndWait[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RebootInstanceAndWait", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,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