import { Construct } from 'constructs';
import { Platform } from '../../domain/platform';
import { IStringListVariable } from '../../interface/variables/string-list-variable';
import { CommandStep, CommandStepProps } from '../command-step';
/**
 * Properties refreshAssociation step
 */
export interface RefreshAssociationStepProps extends CommandStepProps {
    /**
     * List of association IDs. If empty, all associations bound to the specified target are applied.
     */
    readonly associationIds?: IStringListVariable;
}
/**
 * CommandStep implemenation for aws:refreshAssociation
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-refreshassociation
 */
export declare class RefreshAssociationStep extends CommandStep {
    readonly associationIds?: IStringListVariable;
    readonly platforms: Platform[];
    readonly action = "aws:refreshAssociation";
    constructor(scope: Construct, id: string, props: RefreshAssociationStepProps);
    /**
     * Input required for this command is associationIds
     */
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
