"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const string_variable_1 = require("../interface/variables/string-variable");
const step_1 = require("./step");
class CommandStep extends step_1.Step {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.exitOnFailure = props.exitOnFailure ?? false;
        this.exitOnSuccess = props.exitOnSuccess ?? false;
        this.markSuccessAndExitOnFailure = props.markSuccessAndExitOnFailure ?? false;
        this.finallyStep = props.finallyStep ?? false;
        this.precondition = props.precondition;
    }
    addToDocument(doc) {
        doc.addStep(this);
    }
    prepareSsmEntry(inputs) {
        // Maps maintain insertion order
        const ssmDef = new Map();
        if (this.description) {
            ssmDef.set('description', this.description);
        }
        ssmDef.set('name', this.name);
        ssmDef.set('action', this.action);
        if (this.precondition) {
            ssmDef.set('precondition', this.precondition.asSsmEntry());
        }
        ssmDef.set('inputs', inputs);
        if (this.exitOnFailure) {
            ssmDef.set('onFailure', 'exit');
        }
        if (this.markSuccessAndExitOnFailure) {
            ssmDef.set('onFailure', 'successAndExit');
        }
        if (this.exitOnSuccess) {
            ssmDef.set('onSuccess', 'exit');
        }
        if (this.finallyStep) {
            ssmDef.set('finallyStep', this.finallyStep);
        }
        const ssmDict = {};
        ssmDef.forEach((value, key) => {
            ssmDict[key] = value;
        });
        return ssmDict;
    }
    /**
     * RunCommand Steps do not have outputs.
     * @returns []
     */
    listOutputs() {
        return [];
    }
    variables() {
        return Object.assign({}, ...this.listOutputs()
            .map(out => ({ [out.name]: new string_variable_1.StringVariable(`${this.name}.${out.name}`) })));
    }
}
exports.CommandStep = CommandStep;
_a = JSII_RTTI_SYMBOL_1;
CommandStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.CommandStep", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,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