"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SleepStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implemenation for aws:sleep
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-sleep.html
 */
class SleepStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:sleep';
        this.sleepSeconds = props.sleepSeconds;
        if (this.sleepSeconds > 604800) {
            throw new Error('Sleep is greater than maximum of 604800. Seconds specified: ' + this.sleepSeconds);
        }
    }
    /**
       * No outputs emitted from Sleep step
       * @returns []
       */
    listOutputs() {
        return [];
    }
    /**
       * No inputs required for Sleep step
       * @returns []
       */
    listInputs() {
        return [];
    }
    toSsmEntry() {
        return super.prepareSsmEntry({ Duration: `PT${this.sleepSeconds}S` });
    }
}
exports.SleepStep = SleepStep;
_a = JSII_RTTI_SYMBOL_1;
SleepStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.SleepStep", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,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