"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateImageStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implemenation for aws:createImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-create.html
 */
class CreateImageStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:createImage';
        this.instanceId = props.instanceId;
        this.imageName = props.imageName;
        this.imageDescription = props.imageDescription;
        this.noReboot = props.noReboot;
        this.blockDeviceMappings = props.blockDeviceMappings;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ImageId',
                selector: '$.ImageId',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ImageState',
                selector: '$.ImageState',
            }];
    }
    listInputs() {
        const inputs = [
            this.instanceId,
            this.imageName,
            this.imageDescription,
            this.noReboot,
            this.blockDeviceMappings,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const entryMap = {
            InstanceId: this.instanceId,
            ImageName: this.imageName,
            ImageDescription: this.imageDescription,
            NoReboot: this.noReboot,
            BlockDeviceMappings: this.blockDeviceMappings,
        };
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
}
exports.CreateImageStep = CreateImageStep;
_a = JSII_RTTI_SYMBOL_1;
CreateImageStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.CreateImageStep", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,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