"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation of aws:executeAwsApi
 */
class AwsApiStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:executeAwsApi';
        this.service = props.service;
        this.pascalCaseApi = props.pascalCaseApi;
        this.apiParams = new __1.DictFormat(props.apiParams);
        this.outputs = props.outputs;
        this.javaScriptApi = props.javaScriptApi ??
            (this.pascalCaseApi.charAt(0).toLowerCase() + this.pascalCaseApi.slice(1));
    }
    /**
       * @returns Outputs as specified in params
       */
    listOutputs() {
        return this.outputs;
    }
    /**
       * Derives the inputs by parsing the apiParams to find matches for inputs in double circle braces ("{{ INPUT }}").
       * @returns list of required inputs.
       */
    listInputs() {
        return this.apiParams.requiredInputs();
    }
    toSsmEntry() {
        return super.prepareSsmEntry({
            ...{
                Service: this.service,
                Api: this.pascalCaseApi,
            },
            ...this.apiParams.format,
        });
    }
}
exports.AwsApiStep = AwsApiStep;
_a = JSII_RTTI_SYMBOL_1;
AwsApiStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AwsApiStep", version: "0.0.19" };
//# sourceMappingURL=data:application/json;base64,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