# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['jumpscale',
 'jumpscale.clients',
 'jumpscale.clients.docker',
 'jumpscale.clients.gedis',
 'jumpscale.clients.git',
 'jumpscale.clients.redis',
 'jumpscale.clients.sshclient',
 'jumpscale.clients.sshkey',
 'jumpscale.clients.zdb',
 'jumpscale.core.application',
 'jumpscale.core.base',
 'jumpscale.core.base.store',
 'jumpscale.core.config',
 'jumpscale.core.db',
 'jumpscale.core.dirs',
 'jumpscale.core.events',
 'jumpscale.core.exceptions',
 'jumpscale.core.executors',
 'jumpscale.core.logging',
 'jumpscale.data.bcdb',
 'jumpscale.data.bcdb.models',
 'jumpscale.data.cache',
 'jumpscale.data.encryption',
 'jumpscale.data.fake',
 'jumpscale.data.hash',
 'jumpscale.data.idgenerator',
 'jumpscale.data.inifile',
 'jumpscale.data.nacl',
 'jumpscale.data.platform',
 'jumpscale.data.random_names',
 'jumpscale.data.schema',
 'jumpscale.data.serializers',
 'jumpscale.data.tarfile',
 'jumpscale.data.terminaltable',
 'jumpscale.data.text',
 'jumpscale.data.time',
 'jumpscale.data.types',
 'jumpscale.entry_points',
 'jumpscale.sals.fs',
 'jumpscale.sals.hostsfile',
 'jumpscale.sals.nettools',
 'jumpscale.sals.process',
 'jumpscale.sals.testdocs',
 'jumpscale.sals.unix',
 'jumpscale.servers.gedis',
 'jumpscale.servers.gedis_http',
 'jumpscale.servers.openresty',
 'jumpscale.servers.rack',
 'jumpscale.shell',
 'jumpscale.threesdk',
 'jumpscale.tools.alerthandler',
 'jumpscale.tools.codeloader',
 'jumpscale.tools.console',
 'jumpscale.tools.depsresolver',
 'jumpscale.tools.errorhandler',
 'jumpscale.tools.git',
 'jumpscale.tools.highlighter',
 'jumpscale.tools.http',
 'jumpscale.tools.jinja2',
 'jumpscale.tools.keygen',
 'jumpscale.tools.schemac',
 'jumpscale.tools.schemac.plugins',
 'jumpscale.tools.startupcmd',
 'jumpscale.tools.syncer',
 'jumpscale.tools.timer']

package_data = \
{'': ['*'],
 'jumpscale': ['install/*'],
 'jumpscale.servers.openresty': ['templates/*']}

install_requires = \
['GitPython>=3.0,<4.0',
 'PyYAML>=5.1,<6.0',
 'Whoosh>=2.7.4,<3.0.0',
 'arrow>=0.15.7,<0.16.0',
 'better-exceptions>=0.2.2,<0.3.0',
 'bottle>=0.12.18,<0.13.0',
 'click>=7.0,<8.0',
 'colorama>=0.4.1,<0.5.0',
 'dill>=0.3.0,<0.4.0',
 'distro>=1.4,<2.0',
 'docker>=4.2.0,<5.0.0',
 'fabric>=2.4,<3.0',
 'faker>=2.0,<3.0',
 'gevent==1.4.0',
 'greenlet==0.4.16',
 'jinja2>=2.11.1,<3.0.0',
 'libtmux>=0.8.2,<0.9.0',
 'loguru>=0.3.2,<0.4.0',
 'msgpack>=0.6.1,<0.7.0',
 'pdoc3>=0.6.3,<0.7.0',
 'prompt-toolkit<3.0.0',
 'psutil>=5.7.0,<6.0.0',
 'ptpython>=2.0,<3.0',
 'pudb>=2019.1,<2020.0',
 'pycparser>=2.20,<3.0',
 'pylzma>=0.5.0,<0.6.0',
 'pynacl==1.3.0',
 'pytoml>=0.1.21,<0.2.0',
 'redis>=3.3,<4.0',
 'secretconf>=0.1.2,<0.2.0',
 'terminaltables>=3.1,<4.0',
 'watchdog>=0.9.0,<0.10.0',
 'zipp>=3.1.0,<4.0.0']

entry_points = \
{'console_scripts': ['jsctl = jumpscale.entry_points.jsctl:cli',
                     'jsng = jumpscale.entry_points.jsng:run',
                     'jsync = jumpscale.entry_points.jsync:cli',
                     'usershell = jumpscale.entry_points.usershell:run']}

setup_kwargs = {
    'name': 'js-ng',
    'version': '11.0b11',
    'description': 'system automation, configuration management and RPC framework',
    'long_description': None,
    'author': 'xmonader',
    'author_email': 'xmonader@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
