# Impulse Response Files

An impulse response is an acoustic signature used by the process of convolution 
reverb to simulate the acoustic reverberation characteristic of a particular
physical location like a concert chamber, etc...

### The impulse response files included here and their licenses

## Maes Howe

This impulse response adds a sense of space and a touch of realism to the 
output audio stream. It does not produce a lot of echo and is not heavy 
computationally.

**Description by author:** Maes-Howe, Orkney, is one of the finest chambered cairns in Europe, and is dated to 3000BC. Prior work in the acoustics of ancient sites explores how the resonances exhibited therein might have affected regular human ritual and interaction with the space. [Read More](https://www.openair.hosted.york.ac.uk/?page_id=602)

**Author:** Damian T. Murphy, Audiolab, University of York - [www.openairlib.net](https://www.openairlib.net/)

**License:** Attribution 4.0 International (CC BY 4.0)

## St Andrew’s Church

As its name suggests, this impulse response gives the feeling of playing an 
instrument in a big hall with a beautiful moderate echo.

**Description by author:** St Andrew’s Church, built in the 14th Century, has one of the finest examples of in-situ acoustic jars (vases or pots) in the UK. These jars were common to European church construction in the late Middle Ages and are said to be based on the ideas of Roman architect Vitruvius, who discussed the use of resonant jars in the design of amphitheatres to provide clarity of voice presentation. [Read More](https://www.openair.hosted.york.ac.uk/?page_id=683)

**Author:** Damian T. Murphy, Audiolab, University of York - [www.openairlib.net](https://www.openairlib.net/)

**License:** Attribution 4.0 International (CC BY 4.0)

## Inside Piano

A beatutiful echo. This impulse response is computationally heavier than the 
other two. If it makes your computer sweat try running it with a little bit
of extra buffering.

**Description by author:** An impulse response recorded from just outside a Yamaha baby grand piano with the damper pedal down.

**Author:** William Andrew Burnson (2013) - [reverbjs.org](http://reverbjs.org/)

**License:** Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0)