"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabContainerRunner = void 0;
const core_1 = require("@aws-cdk/core");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
class GitlabContainerRunner extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e, _f, _g;
        super(scope, id);
        const vpc = (_a = props.selfvpc) !== null && _a !== void 0 ? _a : new aws_ec2_1.Vpc(this, 'VPC', {
            cidr: '10.0.0.0/16',
            maxAzs: 2,
            subnetConfiguration: [{
                    cidrMask: 26,
                    name: 'RunnerVPC',
                    subnetType: aws_ec2_1.SubnetType.PUBLIC,
                }],
            natGateways: 0,
        });
        const token = props.gitlabtoken;
        const tag1 = (_b = props.tag1) !== null && _b !== void 0 ? _b : 'gitlab';
        const tag2 = (_c = props.tag2) !== null && _c !== void 0 ? _c : 'awscdk';
        const tag3 = (_d = props.tag3) !== null && _d !== void 0 ? _d : 'runner';
        const gitlaburl = (_e = props.gitlaburl) !== null && _e !== void 0 ? _e : 'https://gitlab.com/';
        const ec2type = (_f = props.ec2type) !== null && _f !== void 0 ? _f : 't3.micro';
        const shell = aws_ec2_1.UserData.forLinux();
        shell.addCommands('yum update -y');
        shell.addCommands('yum install docker -y');
        shell.addCommands('service docker start');
        shell.addCommands('usermod -aG docker ec2-user');
        shell.addCommands('chmod +x /var/run/docker.sock');
        shell.addCommands('service docker restart &&  chkconfig docker on');
        shell.addCommands('docker run -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner-register gitlab/gitlab-runner:alpine register --non-interactive --url ' + gitlaburl + ' --registration-token ' + token + ' --docker-pull-policy if-not-present --docker-volumes \"/var/run/docker.sock:/var/run/docker.sock\" --executor docker --docker-image \"alpine:latest\" --description \"Docker Runner\" --tag-list \"' + tag1 + ',' + tag2 + ',' + tag3 + '\" --docker-privileged');
        shell.addCommands('sleep 2 && docker run --restart always -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner gitlab/gitlab-runner:alpine');
        shell.addCommands('usermod -aG docker ssm-user');
        this.runnerRole = (_g = props.ec2iamrole) !== null && _g !== void 0 ? _g : new aws_iam_1.Role(this, 'runner-role', {
            assumedBy: new aws_iam_1.ServicePrincipal('ec2.amazonaws.com'),
            description: 'For Gitlab EC2 Runner Role',
        });
        this.runnerEc2 = new aws_ec2_1.Instance(this, 'GitlabRunner', {
            instanceType: new aws_ec2_1.InstanceType(ec2type),
            instanceName: 'Gitlab-Runner',
            vpc,
            machineImage: aws_ec2_1.MachineImage.latestAmazonLinux({ generation: aws_ec2_1.AmazonLinuxGeneration.AMAZON_LINUX_2 }),
            role: this.runnerRole,
            userData: shell,
            blockDevices: [({ deviceName: '/dev/xvda', volume: aws_ec2_1.BlockDeviceVolume.ebs(60) })],
        });
        this.runnerRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new core_1.CfnOutput(this, 'Runner-Instance-ID', { value: this.runnerEc2.instanceId });
        new core_1.CfnOutput(this, 'Runner-Role-Arn', { value: this.runnerRole.roleArn });
    }
}
exports.GitlabContainerRunner = GitlabContainerRunner;
//# sourceMappingURL=data:application/json;base64,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