import cProfile

import pytest

from tests.performance.models import (
    PerformanceSecondInnerDataTest,
    PerformanceInnerDataTest,
    PerformanceDataTest,
)
from trafalgar_log.core.logger import Logger

lorem_ipsum = {
    "a": "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam. Id aliquet lectus proin nibh. Nulla facilisi etiam dignissim diam quis enim lobortis. Praesent tristique magna sit amet purus. At augue eget arcu dictum varius. Eu consequat ac felis donec et odio pellentesque diam volutpat. At tellus at urna condimentum mattis pellentesque id nibh. Laoreet non curabitur gravida arcu ac. Sem et tortor consequat id porta nibh venenatis cras.",
    "b": "Ac felis donec et odio. Tincidunt tortor aliquam nulla facilisi cras fermentum odio eu feugiat. Non tellus orci ac auctor augue mauris. Odio morbi quis commodo odio aenean sed adipiscing. Ante in nibh mauris cursus mattis molestie a. Duis convallis convallis tellus id. Quam pellentesque nec nam aliquam sem et tortor consequat. Velit aliquet sagittis id consectetur purus ut faucibus. Faucibus a pellentesque sit amet porttitor. Velit ut tortor pretium viverra. Lorem dolor sed viverra ipsum nunc. Eu ultrices vitae auctor eu augue. Quisque id diam vel quam elementum pulvinar etiam. Tortor id aliquet lectus proin nibh nisl condimentum. Vel turpis nunc eget lorem dolor sed viverra. Vestibulum rhoncus est pellentesque elit ullamcorper dignissim cras tincidunt. Etiam dignissim diam quis enim. Egestas tellus rutrum tellus pellentesque eu tincidunt. Quisque sagittis purus sit amet volutpat consequat mauris.",
    "c": "A cras semper auctor neque vitae tempus quam pellentesque nec. Aliquam purus sit amet luctus venenatis lectus. Elit sed vulputate mi sit amet. Nunc consequat interdum varius sit amet mattis. Dolor morbi non arcu risus quis. Donec enim diam vulputate ut pharetra sit amet aliquam. Sed tempus urna et pharetra pharetra massa. Malesuada pellentesque elit eget gravida cum sociis. Mi eget mauris pharetra et ultrices. Augue ut lectus arcu bibendum at varius vel. Id interdum velit laoreet id donec ultrices tincidunt. Suspendisse interdum consectetur libero id faucibus. Neque convallis a cras semper auctor neque vitae tempus quam. Enim facilisis gravida neque convallis a cras semper. Et netus et malesuada fames ac turpis egestas.",
    "d": "Tempus quam pellentesque nec nam aliquam sem et tortor consequat. Rutrum tellus pellentesque eu tincidunt tortor. Posuere morbi leo urna molestie at elementum eu facilisis sed. A diam sollicitudin tempor id eu nisl. Nec sagittis aliquam malesuada bibendum arcu vitae. Turpis in eu mi bibendum neque egestas congue. Lacus vestibulum sed arcu non odio euismod lacinia. Elementum nisi quis eleifend quam adipiscing vitae proin sagittis nisl. Ultrices neque ornare aenean euismod. Orci eu lobortis elementum nibh tellus molestie nunc non blandit. Feugiat nisl pretium fusce id. Gravida dictum fusce ut placerat orci. Consectetur adipiscing elit pellentesque habitant morbi tristique senectus et. Aenean euismod elementum nisi quis eleifend quam adipiscing vitae. Commodo nulla facilisi nullam vehicula ipsum a arcu cursus. Aliquet nibh praesent tristique magna sit amet purus. Porta lorem mollis aliquam ut. Non quam lacus suspendisse faucibus interdum. Varius sit amet mattis vulputate enim.",
    "e": "Vitae congue eu consequat ac felis donec. Et ligula ullamcorper malesuada proin libero nunc consequat. Eu volutpat odio facilisis mauris sit amet massa vitae. Adipiscing at in tellus integer feugiat scelerisque varius. Eget sit amet tellus cras. In arcu cursus euismod quis. Fermentum posuere urna nec tincidunt. Sit amet justo donec enim. Elit sed vulputate mi sit amet mauris commodo quis. Leo a diam sollicitudin tempor id. Aliquam ultrices sagittis orci a scelerisque purus. Nisl rhoncus mattis rhoncus urna. Id porta nibh venenatis cras sed felis eget. Egestas egestas fringilla phasellus faucibus scelerisque.",
    "f": "Ut tortor pretium viverra suspendisse potenti nullam ac. Amet nulla facilisi morbi tempus iaculis urna id volutpat. Adipiscing tristique risus nec feugiat in fermentum posuere. Viverra nam libero justo laoreet sit. Mi sit amet mauris commodo quis imperdiet massa. Laoreet sit amet cursus sit amet dictum sit. A arcu cursus vitae congue. Facilisis magna etiam tempor orci eu. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper. Feugiat nisl pretium fusce id velit.",
    "g": "Euismod elementum nisi quis eleifend quam adipiscing vitae proin. Pharetra magna ac placerat vestibulum lectus mauris. Non enim praesent elementum facilisis. Sagittis eu volutpat odio facilisis. In pellentesque massa placerat duis ultricies lacus. Enim nunc faucibus a pellentesque sit amet porttitor eget. Adipiscing elit pellentesque habitant morbi tristique senectus et netus. Habitasse platea dictumst quisque sagittis purus sit. Nisi lacus sed viverra tellus in hac habitasse platea dictumst. Amet est placerat in egestas erat imperdiet sed euismod nisi. Nec dui nunc mattis enim ut. Congue eu consequat ac felis. Tempor id eu nisl nunc mi ipsum faucibus. Nisl nunc mi ipsum faucibus vitae. Nunc lobortis mattis aliquam faucibus purus in massa. Egestas purus viverra accumsan in nisl nisi scelerisque eu. In hac habitasse platea dictumst vestibulum. Nullam eget felis eget nunc. Nec ullamcorper sit amet risus nullam eget felis eget.",
    "h": "Porta nibh venenatis cras sed felis eget velit aliquet. Auctor neque vitae tempus quam pellentesque nec. Malesuada fames ac turpis egestas. Non curabitur gravida arcu ac tortor dignissim convallis aenean et. Lectus proin nibh nisl condimentum id venenatis a. Urna nunc id cursus metus aliquam eleifend mi. Viverra adipiscing at in tellus integer feugiat scelerisque varius. Gravida cum sociis natoque penatibus et magnis dis parturient. Purus semper eget duis at tellus at urna condimentum mattis. Nam at lectus urna duis convallis convallis tellus. Massa placerat duis ultricies lacus sed turpis tincidunt id. Morbi quis commodo odio aenean sed adipiscing.",
    "i": "Ullamcorper velit sed ullamcorper morbi tincidunt ornare. Etiam dignissim diam quis enim lobortis scelerisque fermentum. Bibendum est ultricies integer quis. Pretium fusce id velit ut tortor. Enim diam vulputate ut pharetra. Diam in arcu cursus euismod. Vitae sapien pellentesque habitant morbi. Lacus vestibulum sed arcu non odio. Ipsum suspendisse ultrices gravida dictum fusce. Libero id faucibus nisl tincidunt eget. Urna id volutpat lacus laoreet non. In dictum non consectetur a erat nam at lectus. Varius morbi enim nunc faucibus a pellentesque sit amet porttitor. Augue ut lectus arcu bibendum at varius vel pharetra.",
    "j": "Amet nisl suscipit adipiscing bibendum est ultricies. Tincidunt augue interdum velit euismod in pellentesque massa. Nec ullamcorper sit amet risus nullam eget felis. Orci dapibus ultrices in iaculis nunc sed augue. Consectetur adipiscing elit ut aliquam purus. Erat velit scelerisque in dictum non consectetur a erat nam. Purus non enim praesent elementum facilisis leo. Neque convallis a cras semper auctor neque. Elit scelerisque mauris pellentesque pulvinar. Tempus urna et pharetra pharetra. A diam maecenas sed enim ut sem viverra aliquet eget. In nulla posuere sollicitudin aliquam ultrices sagittis orci a scelerisque. Turpis in eu mi bibendum. Aliquet nec ullamcorper sit amet. Scelerisque fermentum dui faucibus in. Facilisi nullam vehicula ipsum a arcu. Integer feugiat scelerisque varius morbi enim nunc faucibus. Vulputate dignissim suspendisse in est ante in nibh mauris cursus. Lacinia at quis risus sed vulputate odio ut enim. Eros in cursus turpis massa tincidunt dui.",
    "k": "In cursus turpis massa tincidunt. In nisl nisi scelerisque eu. Tortor dignissim convallis aenean et tortor. Dui accumsan sit amet nulla. Sapien faucibus et molestie ac feugiat sed lectus. Condimentum lacinia quis vel eros donec ac. Cursus metus aliquam eleifend mi in nulla. Lacus sed viverra tellus in hac habitasse. Pulvinar sapien et ligula ullamcorper. Ante metus dictum at tempor commodo ullamcorper a lacus vestibulum. Commodo odio aenean sed adipiscing diam. Quam vulputate dignissim suspendisse in est. Urna porttitor rhoncus dolor purus non. Felis bibendum ut tristique et egestas. Vestibulum mattis ullamcorper velit sed ullamcorper morbi. Sed enim ut sem viverra aliquet.",
    "l": "In nisl nisi scelerisque eu ultrices. Felis eget velit aliquet sagittis id consectetur purus ut faucibus. Justo eget magna fermentum iaculis eu non diam phasellus. Consequat ac felis donec et odio pellentesque. Mus mauris vitae ultricies leo integer. Sit amet tellus cras adipiscing enim eu turpis. Amet nisl suscipit adipiscing bibendum. Velit aliquet sagittis id consectetur purus ut faucibus pulvinar. Mauris in aliquam sem fringilla ut morbi. Quam vulputate dignissim suspendisse in. Urna duis convallis convallis tellus id. Accumsan in nisl nisi scelerisque. Posuere lorem ipsum dolor sit amet. Congue eu consequat ac felis donec. Tristique senectus et netus et malesuada. Tellus mauris a diam maecenas sed enim ut sem viverra. Imperdiet dui accumsan sit amet nulla facilisi morbi tempus. Risus quis varius quam quisque id diam vel.",
    "m": "Imperdiet sed euismod nisi porta lorem mollis aliquam ut porttitor. Viverra tellus in hac habitasse platea dictumst vestibulum. Turpis cursus in hac habitasse platea dictumst quisque. Risus in hendrerit gravida rutrum quisque non tellus. Dictumst vestibulum rhoncus est pellentesque elit. Pretium nibh ipsum consequat nisl vel. Gravida dictum fusce ut placerat orci nulla. Sagittis orci a scelerisque purus semper eget. Nunc mi ipsum faucibus vitae aliquet nec ullamcorper sit amet. Nec dui nunc mattis enim. Id venenatis a condimentum vitae sapien pellentesque habitant morbi tristique. Placerat in egestas erat imperdiet sed euismod. Ultrices tincidunt arcu non sodales neque sodales ut. Magna fermentum iaculis eu non diam phasellus vestibulum lorem. Vulputate ut pharetra sit amet aliquam id diam maecenas ultricies. Ornare quam viverra orci sagittis eu. Curabitur gravida arcu ac tortor dignissim convallis aenean et tortor. Aenean euismod elementum nisi quis eleifend. Ultricies mi eget mauris pharetra et ultrices neque ornare aenean. Phasellus faucibus scelerisque eleifend donec pretium vulputate sapien nec sagittis.",
    "n": "Leo vel orci porta non pulvinar neque laoreet suspendisse interdum. Risus sed vulputate odio ut enim blandit volutpat. Lacinia at quis risus sed vulputate odio. Amet tellus cras adipiscing enim eu turpis egestas. Vulputate mi sit amet mauris commodo quis imperdiet. Est pellentesque elit ullamcorper dignissim cras tincidunt lobortis feugiat. Nunc vel risus commodo viverra maecenas. Est ultricies integer quis auctor elit. Lacus viverra vitae congue eu consequat ac felis donec. Quisque non tellus orci ac auctor. Proin fermentum leo vel orci porta non pulvinar neque laoreet.",
    "o": "Ultricies integer quis auctor elit sed vulputate. Vitae sapien pellentesque habitant morbi tristique. Porttitor leo a diam sollicitudin. Eget mi proin sed libero enim sed faucibus turpis. Malesuada nunc vel risus commodo. Adipiscing commodo elit at imperdiet dui. Sapien faucibus et molestie ac feugiat sed lectus. Interdum velit laoreet id donec ultrices tincidunt arcu. Consectetur adipiscing elit ut aliquam purus sit amet. Id nibh tortor id aliquet. Faucibus purus in massa tempor. Nunc eget lorem dolor sed viverra ipsum nunc aliquet. Felis bibendum ut tristique et egestas. Tincidunt arcu non sodales neque sodales ut etiam sit. Quis vel eros donec ac. At quis risus sed vulputate odio ut. Auctor augue mauris augue neque gravida in fermentum. Varius sit amet mattis vulputate enim nulla aliquet porttitor lacus. At varius vel pharetra vel turpis nunc eget lorem.",
    "p": "Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Hendrerit gravida rutrum quisque non tellus orci. Orci phasellus egestas tellus rutrum tellus pellentesque eu. Quis ipsum suspendisse ultrices gravida dictum fusce. Magna etiam tempor orci eu. Ut faucibus pulvinar elementum integer enim neque. Velit aliquet sagittis id consectetur purus ut faucibus pulvinar. Aliquet nibh praesent tristique magna sit. Mi sit amet mauris commodo quis imperdiet massa. Quam quisque id diam vel quam elementum. Sed felis eget velit aliquet sagittis.",
    "q": "Tellus elementum sagittis vitae et leo duis. Et malesuada fames ac turpis egestas. Lorem donec massa sapien faucibus. Donec massa sapien faucibus et molestie ac feugiat sed. Nam aliquam sem et tortor consequat id. Enim neque volutpat ac tincidunt vitae semper quis lectus nulla. A diam sollicitudin tempor id eu nisl nunc mi. Tortor condimentum lacinia quis vel eros donec. Elementum tempus egestas sed sed risus. Pellentesque dignissim enim sit amet venenatis. Elit scelerisque mauris pellentesque pulvinar pellentesque habitant morbi tristique senectus. Viverra maecenas accumsan lacus vel facilisis volutpat. Etiam tempor orci eu lobortis.",
    "r": "Interdum varius sit amet mattis vulputate. Ac odio tempor orci dapibus ultrices in. Diam donec adipiscing tristique risus nec feugiat in fermentum. Imperdiet nulla malesuada pellentesque elit eget gravida. Et malesuada fames ac turpis egestas integer eget. Egestas egestas fringilla phasellus faucibus scelerisque eleifend donec pretium vulputate. Amet volutpat consequat mauris nunc congue. Suspendisse sed nisi lacus sed viverra tellus. At tempor commodo ullamcorper a. Quam viverra orci sagittis eu volutpat odio facilisis mauris sit. In est ante in nibh mauris cursus mattis molestie a. Risus quis varius quam quisque. Lacus sed viverra tellus in hac habitasse platea dictumst. Luctus accumsan tortor posuere ac ut consequat semper viverra nam. Ut placerat orci nulla pellentesque dignissim enim sit amet. Arcu odio ut sem nulla pharetra diam sit.",
    "s": "Mi tempus imperdiet nulla malesuada pellentesque. Non pulvinar neque laoreet suspendisse interdum consectetur libero id faucibus. Fermentum odio eu feugiat pretium nibh. Est ante in nibh mauris cursus mattis. Lorem mollis aliquam ut porttitor leo a diam. Purus ut faucibus pulvinar elementum. Mauris nunc congue nisi vitae suscipit tellus mauris a diam. Massa eget egestas purus viverra. Enim eu turpis egestas pretium aenean pharetra. Facilisis sed odio morbi quis commodo odio. Sed augue lacus viverra vitae congue eu consequat ac. Neque egestas congue quisque egestas. Enim nulla aliquet porttitor lacus luctus accumsan tortor posuere. Turpis massa sed elementum tempus. Vulputate ut pharetra sit amet aliquam id. Velit scelerisque in dictum non consectetur a erat nam at.",
    "t": "Dictum sit amet justo donec enim diam vulputate ut pharetra. Lacus sed viverra tellus in hac habitasse platea. Duis ultricies lacus sed turpis tincidunt id aliquet. Integer quis auctor elit sed vulputate mi sit. Id ornare arcu odio ut sem nulla. Est lorem ipsum dolor sit amet consectetur adipiscing elit pellentesque. Fermentum dui faucibus in ornare quam viverra orci sagittis. Curabitur gravida arcu ac tortor dignissim convallis aenean. Sollicitudin tempor id eu nisl nunc mi ipsum faucibus vitae. Nibh venenatis cras sed felis eget. Non pulvinar neque laoreet suspendisse interdum.",
    "u": "Urna neque viverra justo nec ultrices dui sapien eget. Vel quam elementum pulvinar etiam non quam lacus suspendisse faucibus. Semper feugiat nibh sed pulvinar proin gravida. Pellentesque sit amet porttitor eget dolor morbi non arcu. Viverra adipiscing at in tellus integer feugiat scelerisque varius morbi. Sed euismod nisi porta lorem mollis aliquam ut porttitor. Non pulvinar neque laoreet suspendisse interdum. Leo duis ut diam quam nulla porttitor massa id. Ultrices neque ornare aenean euismod elementum nisi quis eleifend quam. Volutpat maecenas volutpat blandit aliquam etiam erat velit scelerisque in. Etiam erat velit scelerisque in dictum non consectetur. Duis ultricies lacus sed turpis tincidunt. Risus ultricies tristique nulla aliquet enim tortor. Eget magna fermentum iaculis eu non diam phasellus vestibulum lorem. Sed faucibus turpis in eu. Platea dictumst vestibulum rhoncus est pellentesque elit. Et tortor at risus viverra adipiscing at in.",
    "v": "Dui ut ornare lectus sit amet est placerat in egestas. Massa id neque aliquam vestibulum morbi blandit cursus. Et netus et malesuada fames ac turpis egestas. Nunc pulvinar sapien et ligula. Pharetra sit amet aliquam id diam. Risus nullam eget felis eget nunc lobortis mattis. Vestibulum mattis ullamcorper velit sed ullamcorper morbi tincidunt. Habitasse platea dictumst vestibulum rhoncus. Platea dictumst quisque sagittis purus sit. Congue eu consequat ac felis. Habitant morbi tristique senectus et netus et malesuada. Nisl pretium fusce id velit ut tortor pretium viverra suspendisse. Urna id volutpat lacus laoreet non. Nunc sed augue lacus viverra vitae congue eu consequat. Netus et malesuada fames ac turpis egestas maecenas pharetra convallis.",
    "w": "Massa id neque aliquam vestibulum morbi blandit cursus risus at. Sed tempus urna et pharetra pharetra. Fermentum odio eu feugiat pretium. Lectus mauris ultrices eros in cursus turpis massa tincidunt. Ultrices eros in cursus turpis. Sapien eget mi proin sed libero enim sed. Vulputate mi sit amet mauris commodo quis imperdiet massa. Condimentum id venenatis a condimentum vitae sapien pellentesque. Quis lectus nulla at volutpat diam. Morbi tincidunt ornare massa eget egestas purus viverra. Pellentesque nec nam aliquam sem. Nunc sed velit dignissim sodales ut eu. Ultricies leo integer malesuada nunc vel risus commodo viverra. Non enim praesent elementum facilisis leo. Nisl tincidunt eget nullam non nisi est sit. Mattis pellentesque id nibh tortor id aliquet lectus proin.",
    "x": "Viverra nibh cras pulvinar mattis nunc sed blandit. Semper quis lectus nulla at. Risus commodo viverra maecenas accumsan lacus. Nam at lectus urna duis convallis convallis tellus. Viverra nibh cras pulvinar mattis nunc. Quis varius quam quisque id diam vel. Neque convallis a cras semper. Sagittis purus sit amet volutpat consequat. Urna id volutpat lacus laoreet non. Euismod in pellentesque massa placerat duis ultricies. Enim nec dui nunc mattis enim ut. Mi sit amet mauris commodo quis. Sed nisi lacus sed viverra tellus in hac habitasse platea. Egestas quis ipsum suspendisse ultrices gravida dictum fusce. Pellentesque habitant morbi tristique senectus et netus et. Donec massa sapien faucibus et molestie. Pretium vulputate sapien nec sagittis aliquam malesuada bibendum. Pulvinar sapien et ligula ullamcorper.",
    "y": "Dignissim suspendisse in est ante in nibh mauris. Nisl tincidunt eget nullam non nisi est sit amet facilisis. Augue lacus viverra vitae congue eu consequat ac felis donec. Et malesuada fames ac turpis. Neque volutpat ac tincidunt vitae. Sociis natoque penatibus et magnis. Nunc vel risus commodo viverra maecenas. Egestas diam in arcu cursus euismod quis viverra nibh cras. Tellus pellentesque eu tincidunt tortor aliquam nulla facilisi cras. Sem integer vitae justo eget. Malesuada bibendum arcu vitae elementum curabitur vitae nunc.",
    "z": None,
}

z = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Tristique sollicitudin nibh sit amet commodo nulla facilisi. Ligula ullamcorper malesuada proin libero nunc consequat interdum. Purus faucibus ornare suspendisse sed nisi lacus sed. Ut consequat semper viverra nam libero justo laoreet sit. Risus sed vulputate odio ut enim blandit volutpat maecenas volutpat. Dignissim suspendisse in est ante. Gravida neque convallis a cras semper auctor neque vitae. Amet consectetur adipiscing elit duis tristique sollicitudin nibh sit. Integer quis auctor elit sed vulputate mi. Massa sapien faucibus et molestie ac feugiat. Orci a scelerisque purus semper. Amet purus gravida quis blandit turpis cursus in hac. Ullamcorper sit amet risus nullam eget. Ornare quam viverra orci sagittis eu. Rhoncus est pellentesque elit ullamcorper. Luctus accumsan tortor posuere ac ut consequat semper."
LOG_CODE: str = "Testing performance"
TIMEOUT: int = 16
NUMBER_OF_ITERATIONS = 1000


def _build_performance_second_inner_data_test() -> PerformanceSecondInnerDataTest:
    data = PerformanceSecondInnerDataTest(**lorem_ipsum)
    data.z = z
    return data


def _build_performance_inner_data_test() -> PerformanceInnerDataTest:
    data = PerformanceInnerDataTest(**lorem_ipsum)
    data.z = _build_performance_second_inner_data_test()
    return data


def _build_performance_data_test() -> PerformanceDataTest:
    data = PerformanceDataTest(**lorem_ipsum)
    data.z = _build_performance_inner_data_test()
    return data


@pytest.mark.timeout(TIMEOUT)
def test_performance():
    i: int = 0

    a: PerformanceDataTest = _build_performance_data_test()

    while i < NUMBER_OF_ITERATIONS:
        Logger.info(LOG_CODE, f"Testing performance {i}", a)
        i += 1


@pytest.mark.timeout(TIMEOUT)
def test_performance_exception():
    i: int = 0

    a: PerformanceDataTest = _build_performance_data_test()
    b: dict = {}

    while i < NUMBER_OF_ITERATIONS:
        Logger.info(LOG_CODE, f"Testing performance {i}", a)

        try:
            b["a"]
        except KeyError as e:
            Logger.error(LOG_CODE, f"Testing performance {i}", str(e))
        i += 1


if __name__ == "__main__":
    cProfile.run("test_performance()")
    cProfile.run("test_performance_exception()")
