### Contributing

Contributions from the community are welcome, and I would be pleased to have them. Please follow this guide for contributing to PyShiftAE.

#### Reporting Issues

- Please make sure to check for existing issues before creating a new one. Your issue might have already been reported and possibly even fixed in the `main` branch.
- When creating an issue, please provide a clear and descriptive title, and explain the problem in detail. Include any relevant code snippets or error messages.

#### Submitting Pull Requests

- Fork the repository and create a new branch for your feature or bug fix.
- There's no strict coding style guideline at the moment, but please keep your code clean and well-commented. Following the general structure and commenting style of the existing code would be appreciated. To further this, detailed comments help both myself, and others learn and collaborate better.
- Submit your pull request against the `main` branch. If there is a `develop` branch or other relevant branches in the future, please redirect your pull request accordingly.

#### Code Guidelines

- Your code should be well-commented with docstrings for classes and methods.
- Please try to keep your code as clean and straightforward as possible.
- It would be beneficial to follow common Python conventions and keep a consistent coding style. (On the API exposure side)
- The Core logic files `Core.h`, `Core.cpp`, `PyCore.h`, `PyCore.cpp`, as well as `Task_Utils.h` provide a large comment block detailing usage guidelines.

#### Testing

- At the moment, there is not a specific testing framework in place. However, I would appreciate if you could provide simple tests or usage examples to demonstrate the functionality of your contribution. Eg: scripts used, video demonstrations, etc;

#### Docs

- You can follow the existing documentation as a format guide.
- When adding new features, it would be great to include relevant documentation updates alongside your code contributions.

#### Community Interaction

- Discussion around the project will primarily occur here on GitHub. Feel free to ask questions or discuss anything related to the project in the issue tracker.
- You can get in touch with me directly via the contact information provided on GitHub.

#### Legal

- By contributing, you agree that your contributions will be licensed under the same license as the project (AGPL 3.0).
- Ensure that you have the right to submit your contribution and that your code does not infringe any other person's or entity's rights.

#### Environment Setup

- The project is currently set up for Microsoft x64, using pybind11 x64 static, linked to Python 3.11 (debug and release). Follow the instructions provided in the [WIKI](https://github.com/Trentonom0r3/PyShiftAE/wiki/Building-from-source) for setting up your development environment.

#### Review Process

- Contributions will be reviewed by the community and maintainers. Constructive feedback will be provided, and once your contribution is accepted, it will be merged into the `main` branch.
- Given the experimental nature of the project, contributors who provide robust, well-thought-out and well-tested contributions might find themselves reviewing other contributions as well.

#### Acknowledgements

- All contributors will be acknowledged in the project repository. Your contributions, no matter how small, are valuable to us and the community.