import datetime
from typing import Any, Dict, List, Type, TypeVar, Union

import attr
from dateutil.parser import isoparse

from ..models.exploits_api_v1_report_pending_retrieve_response_200_pending_actions_item import (
    ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem,
)
from ..types import UNSET, OSIDBModel, Unset

T = TypeVar("T", bound="ExploitsApiV1ReportPendingRetrieveResponse200")


@attr.s(auto_attribs=True)
class ExploitsApiV1ReportPendingRetrieveResponse200(OSIDBModel):
    """ """

    dt: Union[Unset, datetime.datetime] = UNSET
    env: Union[Unset, str] = UNSET
    pending_actions: Union[
        Unset, List[ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem]
    ] = UNSET
    pending_actions_count: Union[Unset, int] = UNSET
    revision: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        dt: Union[Unset, str] = UNSET
        if not isinstance(self.dt, Unset):
            dt = self.dt.isoformat()

        env = self.env
        pending_actions: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.pending_actions, Unset):
            pending_actions = []
            for pending_actions_item_data in self.pending_actions:
                pending_actions_item: Dict[str, Any] = UNSET
                if not isinstance(pending_actions_item_data, Unset):
                    pending_actions_item = pending_actions_item_data.to_dict()

                pending_actions.append(pending_actions_item)

        pending_actions_count = self.pending_actions_count
        revision = self.revision
        version = self.version

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if dt is not UNSET:
            field_dict["dt"] = dt
        if env is not UNSET:
            field_dict["env"] = env
        if pending_actions is not UNSET:
            field_dict["pending_actions"] = pending_actions
        if pending_actions_count is not UNSET:
            field_dict["pending_actions_count"] = pending_actions_count
        if revision is not UNSET:
            field_dict["revision"] = revision
        if version is not UNSET:
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        _dt = d.pop("dt", UNSET)
        dt: Union[Unset, datetime.datetime]
        if isinstance(_dt, Unset):
            dt = UNSET
        else:
            dt = isoparse(_dt)

        env = d.pop("env", UNSET)

        pending_actions = []
        _pending_actions = d.pop("pending_actions", UNSET)
        if _pending_actions is UNSET:
            pending_actions = UNSET
        else:
            for pending_actions_item_data in _pending_actions or []:
                _pending_actions_item = pending_actions_item_data
                pending_actions_item: ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem
                if isinstance(_pending_actions_item, Unset):
                    pending_actions_item = UNSET
                else:
                    pending_actions_item = ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem.from_dict(
                        _pending_actions_item
                    )

                pending_actions.append(pending_actions_item)

        pending_actions_count = d.pop("pending_actions_count", UNSET)

        revision = d.pop("revision", UNSET)

        version = d.pop("version", UNSET)

        exploits_api_v1_report_pending_retrieve_response_200 = cls(
            dt=dt,
            env=env,
            pending_actions=pending_actions,
            pending_actions_count=pending_actions_count,
            revision=revision,
            version=version,
        )

        exploits_api_v1_report_pending_retrieve_response_200.additional_properties = d
        return exploits_api_v1_report_pending_retrieve_response_200

    @staticmethod
    def get_fields():
        return {
            "dt": datetime.datetime,
            "env": str,
            "pending_actions": List[
                ExploitsApiV1ReportPendingRetrieveResponse200PendingActionsItem
            ],
            "pending_actions_count": int,
            "revision": str,
            "version": str,
        }

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
