from typing import Any, Dict, Optional, Union

import requests

from ...client import AuthenticatedClient
from ...models.exploits_api_v1_flaw_data_list_response_200 import (
    ExploitsApiV1FlawDataListResponse200,
)
from ...types import UNSET, Response, Unset

QUERY_PARAMS = {
    "limit": int,
    "offset": int,
}


def _get_kwargs(
    *,
    client: AuthenticatedClient,
    limit: Union[Unset, None, int] = UNSET,
    offset: Union[Unset, None, int] = UNSET,
) -> Dict[str, Any]:
    url = "{}/exploits/api/v1/flaw_data".format(
        client.base_url,
    )

    headers: Dict[str, Any] = client.get_headers()

    params: Dict[str, Any] = {
        "limit": limit,
        "offset": offset,
    }
    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    return {
        "url": url,
        "headers": headers,
        "params": params,
    }


def _parse_response(
    *, response: requests.Response
) -> Optional[ExploitsApiV1FlawDataListResponse200]:
    if response.status_code == 200:
        _response_200 = response.json()
        response_200: ExploitsApiV1FlawDataListResponse200
        if isinstance(_response_200, Unset):
            response_200 = UNSET
        else:
            response_200 = ExploitsApiV1FlawDataListResponse200.from_dict(_response_200)

        return response_200
    return None


def _build_response(
    *, response: requests.Response
) -> Response[ExploitsApiV1FlawDataListResponse200]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
    limit: Union[Unset, None, int] = UNSET,
    offset: Union[Unset, None, int] = UNSET,
) -> Response[ExploitsApiV1FlawDataListResponse200]:
    kwargs = _get_kwargs(
        client=client,
        limit=limit,
        offset=offset,
    )

    response = requests.get(
        verify=client.verify_ssl,
        auth=client.auth,
        timeout=client.timeout,
        **kwargs,
    )
    response.raise_for_status()

    return _build_response(response=response)


def sync(
    *,
    client: AuthenticatedClient,
    limit: Union[Unset, None, int] = UNSET,
    offset: Union[Unset, None, int] = UNSET,
) -> Optional[ExploitsApiV1FlawDataListResponse200]:
    """Flaw, affect, and tracker data for Exploits"""

    return sync_detailed(
        client=client,
        limit=limit,
        offset=offset,
    ).parsed
