# -*- coding: utf-8 -*-

import unittest
import base64
import zlib
from unittest.mock import *
from libgenapi.libgenapi import Libgenapi


class LibgenApiTest(unittest.TestCase):
    @patch("libgenapi.libgenapi.grab.Grab.go")
    def test_libgenapi_search_method_returns_correct_result(self, mock_go):
        lg = Libgenapi(["http://mirror.com"])
        # f=open('testwebsearchresult.html','r')
        # HTML=f.read().encode("utf-8")
        HTML = zlib.decompress(base64.b64decode(html))
        # f.close()
        lg.g.setup_document(HTML)
        result = lg.search("python", 1)
        expectedResult = [
            {
                "author": "Dat Guy",
                "series": "Library of New Guy Studies volume 420",
                "title": "Dat perfect 5/7 Title !",
                "isbn": "123456",
                "publisher": "WHo knows? Me no!",
                "year": "420",
                "pages": "420",
                "language": "chan",
                "size": "420 kb",
                "extension": "vap",
                "mirrors": [
                    "http://IDontWantADMCA.takedown/view.php?id=1337HAYKER",
                    "http://IDontWantADMCA.takedown/ads.php?md5=MD5HERE",
                    "http://IDontWantADMCA.takedown/md5/MD5HERE",
                    "http://IDontWantADMCA.takedown/md5/MD5HERE",
                ],
            }
        ]
        self.maxDiff = None
        self.assertEqual(result, expectedResult)


if __name__ == "__main__":
    unittest.main()

# html source code example to test against, compressed so it takes less space
html = b"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"
