# examples/Features_Customization/fig_annotation_example.py

import paperplot as pp
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

print(f"--- Running Example: {__file__} ---")

try:
    # 1. Create a Plotter instance with a 2x2 layout
    plotter = pp.Plotter(layout=(2, 2), figsize=(12, 10), style='publication')

    # 2. Add some plots to the subplots
    df = pd.DataFrame({
        'x': np.linspace(0, 10, 50),
        'y1': np.sin(np.linspace(0, 10, 50)),
        'y2': np.cos(np.linspace(0, 10, 50)),
        'y3': np.random.rand(50) * 5
    })

    plotter.add_line(data=df, x='x', y='y1', tag='ax00', label='Sine'
    ).set_title('Top-Left Plot'
    ).set_legend()

    plotter.add_scatter(data=df, x='x', y='y2', tag='ax01', label='Cosine', marker='o'
    ).set_title('Top-Right Plot'
    ).set_legend()

    plotter.add_hist(data=df, x='y3', tag='ax10', bins=10, color='skyblue'
    ).set_title('Bottom-Left Plot')

    plotter.add_bar(data=pd.DataFrame({'cat': ['A', 'B', 'C'], 'val': [1, 3, 2]}), x='cat', y='val', tag='ax11'
    ).set_title('Bottom-Right Plot')

    # Apply cleanup for shared axes
    plotter.cleanup(auto_share=True)

    # 3. Use the new global figure-level annotation APIs

    # fig_add_text
    plotter.fig_add_text(0.5, 0.96, 'Comprehensive Figure Analysis', ha='center', va='top', fontsize=16, weight='bold', color='darkblue')
    plotter.fig_add_text(0.02, 0.02, 'Generated by PaperPlot', ha='left', va='bottom', fontsize=8, style='italic')

    # fig_add_line - draw a line across the figure
    plotter.fig_add_line([0.1, 0.9], [0.5, 0.5], color='red', linestyle=':', linewidth=2)
    plotter.fig_add_text(0.5, 0.51, 'Mid-Figure Separator', ha='center', va='bottom', color='red', fontsize=10)

    # fig_add_box - box around top row plots
    plotter.fig_add_box(tags=['ax00', 'ax01'], padding=0.01, edgecolor='green', linewidth=2, linestyle='-')
    plotter.fig_add_label(tags=['ax00', 'ax01'], text='Top Row Insights', position='top_center', padding=0.02, fontsize=12, color='green')

    # fig_add_box - box around bottom-left plot
    plotter.fig_add_box(tags='ax10', padding=0.005, edgecolor='purple', linewidth=1, linestyle='-.')
    plotter.fig_add_label(tags='ax10', text='Distribution', position='bottom_right', padding=0.01, fontsize=10, color='purple')

    # fig_add_label - label for the entire figure (relative to all axes)
    plotter.fig_add_label(tags=['ax00', 'ax01', 'ax10', 'ax11'], text='Overall Study Results', position='right_center', padding=0.05, rotation=-90, fontsize=14, color='gray')


    # 4. Save the figure
    plotter.save("fig_annotation_example.png")

except pp.PaperPlotError as e:
    print(f"\nA PaperPlot error occurred:\n{e}")
except Exception as e:
    print(f"An unexpected error occurred: {e}")
finally:
    plt.close('all')

print(f"--- Finished Example: {__file__} ---")
print("A new file 'fig_annotation_example.png' was generated.")
