csr_constants = {
    'fast_a_iir_c_shift': 23,
    'fast_a_iir_c_width': 25,
    'fast_a_iir_c_interval': 1,
    'fast_a_iir_c_latency': 2,
    'fast_a_iir_c_order': 1,
    'fast_a_iir_c_iterative': 0,
    'fast_a_iir_d_shift': 23,
    'fast_a_iir_d_width': 25,
    'fast_a_iir_d_interval': 1,
    'fast_a_iir_d_latency': 3,
    'fast_a_iir_d_order': 2,
    'fast_a_iir_d_iterative': 0,
    'fast_b_iir_c_shift': 23,
    'fast_b_iir_c_width': 25,
    'fast_b_iir_c_interval': 1,
    'fast_b_iir_c_latency': 2,
    'fast_b_iir_c_order': 1,
    'fast_b_iir_c_iterative': 0,
    'fast_b_iir_d_shift': 23,
    'fast_b_iir_d_width': 25,
    'fast_b_iir_d_interval': 1,
    'fast_b_iir_d_latency': 3,
    'fast_b_iir_d_order': 2,
    'fast_b_iir_d_iterative': 0,
    'root_sweep_shift': 24,
}

csr = {
    'dna_dna': (28, 0x000, 64, False),
    'fast_a_y_tap': (0, 0x000, 2, True),
    'fast_a_demod_delay': (0, 0x001, 32, True),
    'fast_a_demod_multiplier': (0, 0x005, 4, True),
    'fast_a_x_limit_min': (0, 0x006, 25, True),
    'fast_a_x_limit_max': (0, 0x00a, 25, True),
    'fast_a_iir_c_z0': (0, 0x00e, 27, True),
    'fast_a_iir_c_a1': (0, 0x012, 25, True),
    'fast_a_iir_c_b0': (0, 0x016, 25, True),
    'fast_a_iir_c_b1': (0, 0x01a, 25, True),
    'fast_a_iir_d_z0': (0, 0x01e, 27, True),
    'fast_a_iir_d_a1': (0, 0x022, 25, True),
    'fast_a_iir_d_a2': (0, 0x026, 25, True),
    'fast_a_iir_d_b0': (0, 0x02a, 25, True),
    'fast_a_iir_d_b1': (0, 0x02e, 25, True),
    'fast_a_iir_d_b2': (0, 0x032, 25, True),
    'fast_a_y_limit_min': (0, 0x036, 25, True),
    'fast_a_y_limit_max': (0, 0x03a, 25, True),
    'fast_a_x_clr': (0, 0x03e, 1, True),
    'fast_a_x_max': (0, 0x03f, 25, False),
    'fast_a_x_min': (0, 0x043, 25, False),
    'fast_a_y_clr': (0, 0x047, 1, True),
    'fast_a_y_max': (0, 0x048, 25, False),
    'fast_a_y_min': (0, 0x04c, 25, False),
    'fast_a_x_hold_en': (0, 0x050, 15, True),
    'fast_a_x_clear_en': (0, 0x052, 15, True),
    'fast_a_y_hold_en': (0, 0x054, 15, True),
    'fast_a_y_clear_en': (0, 0x056, 15, True),
    'fast_a_dx_sel': (0, 0x058, 4, True),
    'fast_a_dy_sel': (0, 0x059, 4, True),
    'fast_a_rx_sel': (0, 0x05a, 4, True),
    'fast_b_y_tap': (1, 0x000, 2, True),
    'fast_b_demod_delay': (1, 0x001, 32, True),
    'fast_b_demod_multiplier': (1, 0x005, 4, True),
    'fast_b_x_limit_min': (1, 0x006, 25, True),
    'fast_b_x_limit_max': (1, 0x00a, 25, True),
    'fast_b_iir_c_z0': (1, 0x00e, 27, True),
    'fast_b_iir_c_a1': (1, 0x012, 25, True),
    'fast_b_iir_c_b0': (1, 0x016, 25, True),
    'fast_b_iir_c_b1': (1, 0x01a, 25, True),
    'fast_b_iir_d_z0': (1, 0x01e, 27, True),
    'fast_b_iir_d_a1': (1, 0x022, 25, True),
    'fast_b_iir_d_a2': (1, 0x026, 25, True),
    'fast_b_iir_d_b0': (1, 0x02a, 25, True),
    'fast_b_iir_d_b1': (1, 0x02e, 25, True),
    'fast_b_iir_d_b2': (1, 0x032, 25, True),
    'fast_b_y_limit_min': (1, 0x036, 25, True),
    'fast_b_y_limit_max': (1, 0x03a, 25, True),
    'fast_b_x_clr': (1, 0x03e, 1, True),
    'fast_b_x_max': (1, 0x03f, 25, False),
    'fast_b_x_min': (1, 0x043, 25, False),
    'fast_b_y_clr': (1, 0x047, 1, True),
    'fast_b_y_max': (1, 0x048, 25, False),
    'fast_b_y_min': (1, 0x04c, 25, False),
    'fast_b_x_hold_en': (1, 0x050, 15, True),
    'fast_b_x_clear_en': (1, 0x052, 15, True),
    'fast_b_y_hold_en': (1, 0x054, 15, True),
    'fast_b_y_clear_en': (1, 0x056, 15, True),
    'fast_b_dx_sel': (1, 0x058, 4, True),
    'fast_b_dy_sel': (1, 0x059, 4, True),
    'fast_b_rx_sel': (1, 0x05a, 4, True),
    'gpio_n_ins': (30, 0x000, 8, False),
    'gpio_n_outs': (30, 0x001, 8, True),
    'gpio_n_oes': (30, 0x002, 8, True),
    'gpio_n_state': (30, 0x003, 15, False),
    'gpio_n_state_clr': (30, 0x005, 1, True),
    'gpio_n_do0_en': (30, 0x006, 15, True),
    'gpio_n_do1_en': (30, 0x008, 15, True),
    'gpio_n_do2_en': (30, 0x00a, 15, True),
    'gpio_n_do3_en': (30, 0x00c, 15, True),
    'gpio_n_do4_en': (30, 0x00e, 15, True),
    'gpio_n_do5_en': (30, 0x010, 15, True),
    'gpio_n_do6_en': (30, 0x012, 15, True),
    'gpio_n_do7_en': (30, 0x014, 15, True),
    'gpio_p_ins': (31, 0x000, 8, False),
    'gpio_p_outs': (31, 0x001, 8, True),
    'gpio_p_oes': (31, 0x002, 8, True),
    'root_dual_channel': (8, 0x000, 1, True),
    'root_chain_a_factor': (8, 0x001, 9, True),
    'root_chain_b_factor': (8, 0x003, 9, True),
    'root_chain_a_offset': (8, 0x005, 14, True),
    'root_chain_b_offset': (8, 0x007, 14, True),
    'root_combined_offset': (8, 0x009, 14, True),
    'root_out_offset': (8, 0x00b, 14, True),
    'root_mod_channel': (8, 0x00d, 1, True),
    'root_control_channel': (8, 0x00e, 1, True),
    'root_sweep_channel': (8, 0x00f, 2, True),
    'root_slow_value': (8, 0x010, 14, False),
    'root_mod_amp': (8, 0x012, 14, True),
    'root_mod_freq': (8, 0x014, 32, True),
    'root_sweep_step': (8, 0x018, 30, True),
    'root_sweep_min': (8, 0x01c, 14, True),
    'root_sweep_max': (8, 0x01e, 14, True),
    'root_sweep_run': (8, 0x020, 1, True),
    'root_limit_error_signal_min': (8, 0x021, 25, True),
    'root_limit_error_signal_max': (8, 0x025, 25, True),
    'root_limit_fast1_min': (8, 0x029, 14, True),
    'root_limit_fast1_max': (8, 0x02b, 14, True),
    'root_limit_fast2_min': (8, 0x02d, 14, True),
    'root_limit_fast2_max': (8, 0x02f, 14, True),
    'root_pid_setpoint': (8, 0x031, 25, True),
    'root_pid_kp': (8, 0x035, 14, True),
    'root_pid_ki': (8, 0x037, 14, True),
    'root_pid_reset': (8, 0x039, 1, True),
    'root_pid_kd': (8, 0x03a, 14, True),
    'root_slow_decimation': (8, 0x03c, 5, True),
    'root_control_signal_clr': (8, 0x03d, 1, True),
    'root_control_signal_max': (8, 0x03e, 25, False),
    'root_control_signal_min': (8, 0x042, 25, False),
    'root_combined_error_signal_clr': (8, 0x046, 1, True),
    'root_combined_error_signal_max': (8, 0x047, 25, False),
    'root_combined_error_signal_min': (8, 0x04b, 25, False),
    'scopegen_external_trigger': (6, 0x000, 1, True),
    'scopegen_dac_a_clr': (6, 0x001, 1, True),
    'scopegen_dac_a_max': (6, 0x002, 25, False),
    'scopegen_dac_a_min': (6, 0x006, 25, False),
    'scopegen_dac_b_clr': (6, 0x00a, 1, True),
    'scopegen_dac_b_max': (6, 0x00b, 25, False),
    'scopegen_dac_b_min': (6, 0x00f, 25, False),
    'scopegen_adc_a_sel': (6, 0x013, 4, True),
    'scopegen_adc_b_sel': (6, 0x014, 4, True),
    'slow_pid_setpoint': (2, 0x000, 14, True),
    'slow_pid_kp': (2, 0x002, 14, True),
    'slow_pid_ki': (2, 0x004, 14, True),
    'slow_pid_reset': (2, 0x006, 1, True),
    'slow_pid_kd': (2, 0x007, 14, True),
    'slow_limit_min': (2, 0x009, 14, True),
    'slow_limit_max': (2, 0x00b, 14, True),
    'slow_out_clr': (2, 0x00d, 1, True),
    'slow_out_max': (2, 0x00e, 25, False),
    'slow_out_min': (2, 0x012, 25, False),
    'xadc_temp': (29, 0x000, 12, False),
    'xadc_v': (29, 0x002, 12, False),
    'xadc_a': (29, 0x004, 12, False),
    'xadc_b': (29, 0x006, 12, False),
    'xadc_c': (29, 0x008, 12, False),
    'xadc_d': (29, 0x00a, 12, False),
}
states = ['force', 'di0', 'di1', 'di2', 'di3', 'di4', 'di5', 'di6', 'di7', 'fast_a_x_railed', 'fast_a_y_sat', 'fast_a_y_railed', 'fast_b_x_railed', 'fast_b_y_sat', 'fast_b_y_railed']
signals = ['zero', 'fast_a_x', 'fast_a_y', 'fast_b_x', 'fast_b_y', 'slow_out', 'scopegen_dac_a', 'scopegen_dac_b', 'root_control_signal', 'root_combined_error_signal']
