# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: coinomiwallet.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List

import betterproto


class KeyType(betterproto.Enum):
    ORIGINAL = 1
    ENCRYPTED_SCRYPT_AES = 2
    DETERMINISTIC_MNEMONIC = 3
    DETERMINISTIC_KEY = 4


class TransactionConfidenceType(betterproto.Enum):
    UNKNOWN = 0
    BUILDING = 1
    PENDING = 2
    DEAD = 3


class TransactionConfidenceSource(betterproto.Enum):
    SOURCE_UNKNOWN = 0
    SOURCE_NETWORK = 1
    SOURCE_SELF = 2
    SOURCE_TRUSTED = 3


class TransactionPool(betterproto.Enum):
    UNSPENT = 4
    SPENT = 5
    DEAD = 10
    PENDING = 16


class WalletEncryptionType(betterproto.Enum):
    UNENCRYPTED = 1
    ENCRYPTED_SCRYPT_AES = 2
    ENCRYPTED_AES = 3


@dataclass
class PeerAddress(betterproto.Message):
    ip_address: bytes = betterproto.bytes_field(1)
    port: int = betterproto.uint32_field(2)
    services: int = betterproto.uint64_field(3)


@dataclass
class EncryptedData(betterproto.Message):
    initialisation_vector: bytes = betterproto.bytes_field(1)
    encrypted_private_key: bytes = betterproto.bytes_field(2)


@dataclass
class DeterministicKey(betterproto.Message):
    """
    * Data attached to a Key message that defines the data needed by the BIP32
    deterministic key hierarchy algorithm.
    """

    # Random data that allows us to extend a key. Without this, we can't figure
    # out the next key in the chain and should just treat it as a regular
    # ORIGINAL type key.
    chain_code: bytes = betterproto.bytes_field(1)
    # The path through the key tree. Each number is encoded in the standard form:
    # high bit set for private derivation and high bit unset for public
    # derivation.
    path: List[int] = betterproto.uint32_field(2)
    # How many children of this key have been issued, that is, given to the user
    # when they requested a fresh key? For the parents of keys being handed out,
    # this is always less than the true number of children: the difference is
    # called the lookahead zone. These keys are put into Bloom filters so we can
    # spot transactions made by clones of this wallet - for instance when
    # restoring from backup or if the seed was shared between devices. If this
    # field is missing it means we're not issuing subkeys of this key to users.
    issued_subkeys: int = betterproto.uint32_field(3)
    lookahead_size: int = betterproto.uint32_field(4)
    # * Flag indicating that this key is a root of a following chain. This chain
    # is following the next non-following chain. Following/followed chains
    # concept is used for married keychains, where the set of keys combined
    # together to produce a single P2SH multisignature address
    is_following: bool = betterproto.bool_field(5)


@dataclass
class Key(betterproto.Message):
    """
    * A key used to control Bitcoin spending. Either the private key, the
    public key or both may be present.  It is recommended that if the private
    key is provided that the public key is provided too because deriving it is
    slow. If only the public key is provided, the key can only be used to watch
    the blockchain and verify transactions, and not for spending.
    """

    type: "KeyType" = betterproto.enum_field(1)
    # Either the private EC key bytes (without any ASN.1 wrapping), or the
    # deterministic root seed. If the secret is encrypted, or this is a "watching
    # entry" then this is missing.
    secret_bytes: bytes = betterproto.bytes_field(2)
    # If the secret data is encrypted, then secret_bytes is missing and this
    # field is set.
    encrypted_data: "EncryptedData" = betterproto.message_field(3)
    # The public EC key derived from the private key. We allow both to be stored
    # to avoid mobile clients having to do lots of slow EC math on startup. For
    # DETERMINISTIC_MNEMONIC entries this is missing.
    public_key: bytes = betterproto.bytes_field(4)
    # User-provided label associated with the key.
    label: str = betterproto.string_field(5)
    deterministic_key: "DeterministicKey" = betterproto.message_field(6)


@dataclass
class TransactionInput(betterproto.Message):
    # Hash of the transaction this input is using.
    transaction_out_point_hash: bytes = betterproto.bytes_field(1)
    # Index of transaction output used by this input.
    transaction_out_point_index: int = betterproto.uint32_field(2)
    # Script that contains the signatures/pubkeys.
    script_bytes: bytes = betterproto.bytes_field(3)
    # Sequence number. Currently unused, but intended for contracts in future.
    sequence: int = betterproto.uint32_field(4)
    # Value of connected output, if known
    value: int = betterproto.int64_field(5)


@dataclass
class TransactionOutput(betterproto.Message):
    value: int = betterproto.int64_field(1)
    script_bytes: bytes = betterproto.bytes_field(2)
    # If spent, the hash of the transaction doing the spend.
    spent_by_transaction_hash: bytes = betterproto.bytes_field(3)
    # If spent, the index of the transaction input of the transaction doing the
    # spend.
    spent_by_transaction_index: int = betterproto.int32_field(4)


@dataclass
class TransactionConfidence(betterproto.Message):
    """
    * A description of the confidence we have that a transaction cannot be
    reversed in the future. Parsing should be lenient, since this could change
    for different applications yet we should maintain backward compatibility.
    """

    # This is optional in case we add confidence types to prevent parse errors -
    # backwards compatible.
    type: "TransactionConfidenceType" = betterproto.enum_field(1)
    # If type == BUILDING then this is the chain height at which the transaction
    # was included.
    appeared_at_height: int = betterproto.int32_field(2)
    # If set, hash of the transaction that double spent this one into oblivion. A
    # transaction can be double spent by multiple transactions in the case of
    # several inputs being re-spent by several transactions but we don't bother
    # to track them all, just the first. This only makes sense if type = DEAD.
    overriding_transaction: bytes = betterproto.bytes_field(3)
    # If type == BUILDING then this is the depth of the transaction in the
    # blockchain. Zero confirmations: depth = 0, one confirmation: depth = 1
    # etc.
    depth: int = betterproto.int32_field(4)
    broadcast_by: List["PeerAddress"] = betterproto.message_field(5)
    source: "TransactionConfidenceSource" = betterproto.enum_field(6)


@dataclass
class Transaction(betterproto.Message):
    # See Wallet.java for detailed description of pool semantics
    version: int = betterproto.int32_field(1)
    time: int = betterproto.int32_field(11)
    hash: bytes = betterproto.bytes_field(2)
    # If pool is not present, that means either:  - This Transaction is either
    # not in a wallet at all (the proto is re-used elsewhere)  - Or it is stored
    # but for other purposes, for example, because it is the overriding
    # transaction of a double spend.  - Or the Pool enum got a new value which
    # your software is too old to parse.
    pool: "TransactionPool" = betterproto.enum_field(3)
    lock_time: int = betterproto.uint32_field(4)
    updated_at: int = betterproto.int64_field(5)
    transaction_input: List["TransactionInput"] = betterproto.message_field(6)
    transaction_output: List["TransactionOutput"] = betterproto.message_field(
        7)
    # A list of blocks in which the transaction has been observed (on any chain).
    # Also, a number used to disambiguate ordering within a block.
    block_hash: List[bytes] = betterproto.bytes_field(8)
    block_relativity_offsets: List[int] = betterproto.int32_field(9)
    # Data describing where the transaction is in the chain.
    confidence: "TransactionConfidence" = betterproto.message_field(10)
    token_id: int = betterproto.int32_field(12)


@dataclass
class AddressStatus(betterproto.Message):
    address: str = betterproto.string_field(1)
    status: str = betterproto.string_field(2)


@dataclass
class WalletPocket(betterproto.Message):
    """* A wallet pocket"""

    network_identifier: str = betterproto.string_field(1)
    # A UTF8 encoded text description of the wallet that is intended for end user
    # provided text.
    description: str = betterproto.string_field(2)
    key: List["Key"] = betterproto.message_field(3)
    # The SHA256 hash of the head of the best chain seen by this wallet.
    last_seen_block_hash: bytes = betterproto.bytes_field(4)
    # The height in the chain of the last seen block.
    last_seen_block_height: int = betterproto.uint32_field(5)
    last_seen_block_time_secs: int = betterproto.int64_field(6)
    transaction: List["Transaction"] = betterproto.message_field(7)
    address_status: List["AddressStatus"] = betterproto.message_field(8)


@dataclass
class ScryptParameters(betterproto.Message):
    """
    * The parameters used in the scrypt key derivation function.  The default
    values are taken from http://www.tarsnap.com/scrypt/scrypt-slides.pdf.
    They can be increased - n is the number of iterations performed and  r and
    p can be used to tweak the algorithm - see:
    http://stackoverflow.com/questions/11126315/what-are-optimal-scrypt-work-
    factors
    """

    salt: bytes = betterproto.bytes_field(1)
    n: int = betterproto.int64_field(2)
    r: int = betterproto.int32_field(3)
    p: int = betterproto.int32_field(4)


@dataclass
class Wallet(betterproto.Message):
    """* A bitcoin wallet"""

    # The version number of the wallet - used to detect wallets that were
    # produced in the future (i.e the wallet may contain some future format this
    # protobuf/ code does not know about)
    version: int = betterproto.int32_field(1)
    seed: "Key" = betterproto.message_field(2)
    master_key: "Key" = betterproto.message_field(3)
    encryption_type: "WalletEncryptionType" = betterproto.enum_field(4)
    encryption_parameters: "ScryptParameters" = betterproto.message_field(5)
    pockets: List["WalletPocket"] = betterproto.message_field(6)
