#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# Author: will.shi@tman.ltd


from datetime import datetime


class AppLogger(object):

    @staticmethod
    def exit():
        exit(1)

    @staticmethod
    def launch(log_content):
        """
        🏁
        :param log_content:
        :return:
        """
        print("\n\U0001F3C1 {}".format(log_content))
        return True

    @staticmethod
    def tab_launch(log_content):
        """
        ➤
        :param log_content:
        :return:
        """
        print("    \u27A4 {}".format(log_content))
        return True

    @staticmethod
    def failure(log_content):
        """
        ✘
        :param log_content:
        :return:
        """
        print("\n\u2718 {}".format(log_content))
        return False

    @staticmethod
    def tab_failure(log_content, tab_string="    "):
        """
        ✘
        :param log_content:
        :param tab_string:
        :return:
        """
        print("{}\u2718 {}".format(tab_string, log_content))
        return False

    @staticmethod
    def warning(log_content):
        """
        ❕
        :param log_content:
        :return:
        """
        print("\n\u2755 {}".format(log_content))
        return True

    @staticmethod
    def tab_warning(log_content, tab_string="    "):
        """
        ❕
        :param log_content:
        :param tab_string:
        :return:
        """
        print("{}\u2755 {}".format(tab_string, log_content))
        return True

    @staticmethod
    def success(log_content):
        """
        ✔
        :param log_content:
        :return:
        """
        print("\n\u2714 {}".format(log_content))
        return True

    @staticmethod
    def tab_success(log_content, tab_string="    "):
        """
        ✔
        :param log_content:
        :param tab_string:
        :return:
        """
        print("{}\u2714 {}".format(tab_string, log_content))
        return True

    @staticmethod
    def logo():
        """
        Generated by https://textkool.com/en/ascii-art-generator
        Font: Small Slant
        :return:
        """
        # exec_time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        """
        """
        print("\n".join([
            "   ___ ________   ___   ____  ___ ___________  __  ___                           ",
            "  / _ /_  __/ /  / _ | / __/ / _ /_  __/ ___/ /  |/  /__ ____  ___ ____ ____ ____",
            " / __ |/ / / /__/ __ |_\ \  / __ |/ / / /__  / /|_/ / _ `/ _ \/ _ `/ _ `/ -_) __/",
            "/_/ |_/_/ /____/_/ |_/___/ /_/ |_/_/  \___/ /_/  /_/\_,_/_//_/\_,_/\_, /\__/_/   ",
            "                                                                  /___/          ",
            "                                                 Powered by TMAN                 ",
            ""
        ]))
        return True

    @staticmethod
    def print_relative_time(time_string):
        time_object = datetime.strptime(str(time_string).split(".")[0], '%Y-%m-%dT%H:%M:%S')
        time_delta = datetime.utcnow() - time_object
        if time_delta.days > 0:
            time_unit = int(time_delta.days / 365)
            if time_unit > 0:
                return "{} years ago".format(time_unit)
            time_unit = int(time_delta.days / 30)
            if time_unit > 0:
                return "{} months ago".format(time_unit)
            return "{} days ago".format(time_delta.days)
        else:
            time_unit = int(time_delta.seconds / 3600)
            if time_unit > 0:
                return "{} hours ago".format(time_unit)
            time_unit = int(time_delta.seconds / 60)
            if time_unit > 0:
                return "{} minutes ago".format(time_unit)
            return "{} seconds ago".format(time_delta.seconds)


if __name__ == "__main__":
    print("🚀 This is a logger package")
