import { aws_eks } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { KongDataPlane } from '../../../KongDataPlane';
import { DnsProps } from '../../interfaces/dns-props';
export interface KongDPProps {
    readonly cluster: aws_eks.Cluster;
    readonly namespace: string;
    readonly endpoints: DnsProps;
    readonly license_secret_name: string;
    readonly cacertname: String;
    readonly clusterIssuerName: String;
}
export declare class KongEksDataPlane extends KongDataPlane {
    constructor(scope: Construct, id: string, props: KongDPProps);
}
