"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const kong_core = require("kong-core");
const index_1 = require("./resources/eks/helm-charts/kong/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    //   public readonly rdsCluster: rds.DatabaseInstance;
    //   public readonly eksCluster: eks.Cluster;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        //TODO : Modularize this further
        // const kong_namespace = 'kong-dp';
        const data_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'DPSecretsKey', {
            enableKeyRotation: true,
        });
        // const data_plane_secretskey = new kms.Key(this, 'DataPlaneSecretsKey');
        // const artifactoryBucket = new s3.Bucket(this, 'ArtifactoryBucket');
        const data_plane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'DP', {
            ...props.dataPlaneClusterProps,
            secretsEncryptionKey: data_plane_secretskey,
            defaultCapacity: 0,
            albController: {
                version: aws_cdk_lib_1.aws_eks.AlbControllerVersion.V2_4_1,
            },
        });
        const dp_nodegroup = data_plane.addNodegroupCapacity('DpASG', props.dataPlaneNodeProps);
        dp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: data_plane,
        //   nodegroup: dp_nodegroup,
        // });
        // TODO : Make a new construct class for all helm charts
        // new ElastiCacheStack(this, 'KongCache', {
        //   numberofnodegroups: 3,
        //   vpc: data_plane.vpc,
        // });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'AwsCertManager', {
            cluster: data_plane,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            privateCaArn: props.privateCaArn,
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: data_plane,
        });
        //TODO : Error: kong-dp/KongEksDp/KongPreReqsStack/AutoScalar/KarpenterNodeRole should be defined in the scope of the kong-dp stack to prevent circular dependencies
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: data_plane,
            nodegroup: dp_nodegroup,
        });
        new kong_core.MetricsServer(kong_pre_requisites_nested_stack, 'MetricsServer', {
            cluster: data_plane,
        });
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryStack');
        new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.kongTelemetryOptions.createPrometheusWorkspace,
            prometheusEndpoint: props.kongTelemetryOptions.prometheusEndpoint,
            cluster: data_plane,
            namespace: kong_core.Namespace.TELEMETRY,
        });
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
        const kong_data_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongDpStack');
        new index_1.KongEksDataPlane(kong_data_plane_nested_stack, 'KongDPHelmInstall', {
            cluster: data_plane,
            namespace: kong_core.Namespace.KONG_DATA_PLANE,
            // nodegroup: dp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_DP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            endpoints: props.dnsProps,
        });
        kong_data_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-data-plane.KongEks", version: "3.0.0-dev.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia29uZy1la3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMva29uZy1la3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBcUU7QUFDckUsMkNBQXVDO0FBQ3ZDLHVDQUF1QztBQUN2QyxrRUFBMEU7QUFpQzFFOztHQUVHO0FBQ0gsTUFBYSxPQUFRLFNBQVEsc0JBQVM7SUFDcEMsc0RBQXNEO0lBQ3RELDZDQUE2QztJQUU3Qzs7Ozs7OztTQU9LO0lBQ0wsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLGdDQUFnQztRQUVoQyxvQ0FBb0M7UUFFcEMsTUFBTSxxQkFBcUIsR0FBRyxJQUFJLHFCQUFPLENBQUMsR0FBRyxDQUFDLElBQUksRUFBRSxjQUFjLEVBQUU7WUFDbEUsaUJBQWlCLEVBQUUsSUFBSTtTQUN4QixDQUFDLENBQUM7UUFDSCwwRUFBMEU7UUFDMUUsc0VBQXNFO1FBRXRFLE1BQU0sVUFBVSxHQUFHLElBQUkscUJBQU8sQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRTtZQUNqRCxHQUFHLEtBQUssQ0FBQyxxQkFBcUI7WUFDOUIsb0JBQW9CLEVBQUUscUJBQXFCO1lBQzNDLGVBQWUsRUFBRSxDQUFDO1lBQ2xCLGFBQWEsRUFBRTtnQkFDYixPQUFPLEVBQUUscUJBQU8sQ0FBQyxvQkFBb0IsQ0FBQyxNQUFNO2FBQzdDO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsTUFBTSxZQUFZLEdBQUcsVUFBVSxDQUFDLG9CQUFvQixDQUFDLE9BQU8sRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUN4RixZQUFZLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHFCQUFPLENBQUMsYUFBYSxDQUFDLHdCQUF3QixDQUFDLDhCQUE4QixDQUFDLENBQUMsQ0FBQztRQUduSCw0Q0FBNEM7UUFDNUMseUJBQXlCO1FBQ3pCLDZCQUE2QjtRQUM3QixNQUFNO1FBRU4sd0RBQXdEO1FBRXhELDRDQUE0QztRQUM1QywyQkFBMkI7UUFDM0IseUJBQXlCO1FBQ3pCLE1BQU07UUFFTixNQUFNLGdDQUFnQyxHQUFHLElBQUkseUJBQVcsQ0FBQyxJQUFJLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUNuRixJQUFJLFNBQVMsQ0FBQyxjQUFjLENBQUMsZ0NBQWdDLEVBQUUsZ0JBQWdCLEVBQUU7WUFDL0UsT0FBTyxFQUFFLFVBQVU7WUFDbkIsaUJBQWlCLEVBQUUsU0FBUyxDQUFDLEdBQUcsQ0FBQywyQkFBMkI7WUFDNUQsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1NBQ2pDLENBQUMsQ0FBQztRQUdILElBQUksU0FBUyxDQUFDLGNBQWMsQ0FBQyxnQ0FBZ0MsRUFBRSxZQUFZLEVBQUU7WUFDM0UsT0FBTyxFQUFFLFVBQVU7U0FDcEIsQ0FBQyxDQUFDO1FBR0gsb0tBQW9LO1FBQ3BLLElBQUksU0FBUyxDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFO1lBQzNDLE9BQU8sRUFBRSxVQUFVO1lBQ25CLFNBQVMsRUFBRSxZQUFZO1NBQ3hCLENBQUMsQ0FBQztRQUVILElBQUksU0FBUyxDQUFDLGFBQWEsQ0FBQyxnQ0FBZ0MsRUFBRSxlQUFlLEVBQUU7WUFDN0UsT0FBTyxFQUFFLFVBQVU7U0FDcEIsQ0FBQyxDQUFDO1FBRUgsTUFBTSxzQkFBc0IsR0FBRyxJQUFJLHlCQUFXLENBQUMsSUFBSSxFQUFFLG9CQUFvQixDQUFDLENBQUM7UUFFM0UsSUFBSSxTQUFTLENBQUMsU0FBUyxDQUFDLHNCQUFzQixFQUFFLGFBQWEsRUFBRTtZQUM3RCx5QkFBeUIsRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMseUJBQXlCO1lBQy9FLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxrQkFBa0I7WUFDakUsT0FBTyxFQUFFLFVBQVU7WUFDbkIsU0FBUyxFQUFFLFNBQVMsQ0FBQyxTQUFTLENBQUMsU0FBUztTQUN6QyxDQUFDLENBQUM7UUFFSCxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFFNUUsTUFBTSw0QkFBNEIsR0FBRyxJQUFJLHlCQUFXLENBQUMsSUFBSSxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQzFFLElBQUksd0JBQWdCLENBQUMsNEJBQTRCLEVBQUUsbUJBQW1CLEVBQUU7WUFDdEUsT0FBTyxFQUFFLFVBQVU7WUFDbkIsU0FBUyxFQUFFLFNBQVMsQ0FBQyxTQUFTLENBQUMsZUFBZTtZQUM5QywyQkFBMkI7WUFDM0IsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM3QyxVQUFVLEVBQUUsU0FBUyxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0I7WUFDMUMsaUJBQWlCLEVBQUUsU0FBUyxDQUFDLEdBQUcsQ0FBQywyQkFBMkI7WUFDNUQsU0FBUyxFQUFFLEtBQUssQ0FBQyxRQUFRO1NBQzFCLENBQ0EsQ0FBQztRQUVGLDRCQUE0QixDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUVwRixDQUFDOztBQWxHSCwwQkFtR0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBhd3NfZWtzLCBhd3Nfa21zLCBhd3NfaWFtLCBOZXN0ZWRTdGFjayB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMga29uZ19jb3JlIGZyb20gJ2tvbmctY29yZSc7XG5pbXBvcnQgeyBLb25nRWtzRGF0YVBsYW5lIH0gZnJvbSAnLi9yZXNvdXJjZXMvZWtzL2hlbG0tY2hhcnRzL2tvbmcvaW5kZXgnO1xuaW1wb3J0IHsgRG5zUHJvcHMgfSBmcm9tICcuL3Jlc291cmNlcy9la3MvaW50ZXJmYWNlcy9kbnMtcHJvcHMnO1xuLy8gaW1wb3J0ICogYXMga29uZ19jb3JlIGZyb20gJy4uLy4uL2tvbmctY29yZS8nO1xuXG5leHBvcnQgaW50ZXJmYWNlIEtvbmdFa3NEYXRhUGxhbmVQcm9wcyB7XG4gIC8qKlxuICAgICAqIEBzdW1tYXJ5IENvbnRyb2wgUGxhbmUgRUtTIENsdXN0ZXIgcHJvcGVydGllc1xuICAgICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nkay9hcGkvbGF0ZXN0L2RvY3MvQGF3cy1jZGtfYXdzLWVrcy5DbHVzdGVyUHJvcHMuaHRtbFxuICAgICAqL1xuICByZWFkb25seSBkYXRhUGxhbmVDbHVzdGVyUHJvcHM6IGF3c19la3MuQ2x1c3RlclByb3BzO1xuICAvKipcbiAgICAgKiBAc3VtbWFyeSBEYXRhIFBsYW5lIEVLUyBDbHVzdGVyIHByb3BlcnRpZXNcbiAgICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jZGsvYXBpL2xhdGVzdC9kb2NzL0Bhd3MtY2RrX2F3cy1la3MuQ2x1c3RlclByb3BzLmh0bWxcbiAgICAgKi9cbiAgLyoqXG4gICAgICogQHN1bW1hcnkgS29uZyBEYXRhIFBsYW5lIEVLUyBOb2RlcyBwcm9wZXJ0aWVzXG4gICAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2RrL2FwaS9sYXRlc3QvZG9jcy9AYXdzLWNka19hd3MtZWtzLkF1dG9TY2FsaW5nR3JvdXBDYXBhY2l0eU9wdGlvbnMuaHRtbFxuICAgICAqL1xuXG4gIC8qKlxuICAgICogQHN1bW1hcnkgTmFtZSBvZiB0aGUgU2VjcmV0IGluIEFXUyBTZWNyZXRzIE1hbmFnZXJcbiAgICAqL1xuICByZWFkb25seSBsaWNlbnNlU2VjcmV0c05hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgZGF0YVBsYW5lTm9kZVByb3BzOiBhd3NfZWtzLk5vZGVncm91cE9wdGlvbnM7XG4gIHJlYWRvbmx5IGRuc1Byb3BzOiBEbnNQcm9wcztcbiAgcmVhZG9ubHkgcHJpdmF0ZUNhQXJuIDogc3RyaW5nO1xuICByZWFkb25seSBrb25nVGVsZW1ldHJ5T3B0aW9uczogRGF0YVBsYW5lVGVsZW1ldHJ5UHJvcHM7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGF0YVBsYW5lVGVsZW1ldHJ5UHJvcHMge1xuICByZWFkb25seSBjcmVhdGVQcm9tZXRoZXVzV29ya3NwYWNlOiBCb29sZWFuO1xuICByZWFkb25seSBwcm9tZXRoZXVzRW5kcG9pbnQ/OiBzdHJpbmc7XG59XG4vKipcbiAqIEBzdW1tYXJ5IFRoZSBLb25nRWtzIGNsYXNzLlxuICovXG5leHBvcnQgY2xhc3MgS29uZ0VrcyBleHRlbmRzIENvbnN0cnVjdCB7XG4gIC8vICAgcHVibGljIHJlYWRvbmx5IHJkc0NsdXN0ZXI6IHJkcy5EYXRhYmFzZUluc3RhbmNlO1xuICAvLyAgIHB1YmxpYyByZWFkb25seSBla3NDbHVzdGVyOiBla3MuQ2x1c3RlcjtcblxuICAvKipcbiAgICAgKiBAc3VtbWFyeSBDb25zdHJ1Y3RzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBLb25nRWtzIGNsYXNzLlxuICAgICAqIEBwYXJhbSB7Y2RrLkFwcH0gc2NvcGUgLSByZXByZXNlbnRzIHRoZSBzY29wZSBmb3IgYWxsIHRoZSByZXNvdXJjZXMuXG4gICAgICogQHBhcmFtIHtzdHJpbmd9IGlkIC0gdGhpcyBpcyBhIGEgc2NvcGUtdW5pcXVlIGlkLlxuICAgICAqIEBwYXJhbSB7Q2xvdWRGcm9udFRvQXBpR2F0ZXdheVRvTGFtYmRhUHJvcHN9IHByb3BzIC0gdXNlciBwcm92aWRlZCBwcm9wcyBmb3IgdGhlIGNvbnN0cnVjdC5cbiAgICAgKiBAc2luY2UgMC4xLjBcbiAgICAgKiBAYWNjZXNzIHB1YmxpY1xuICAgICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogS29uZ0Vrc0RhdGFQbGFuZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIC8vVE9ETyA6IE1vZHVsYXJpemUgdGhpcyBmdXJ0aGVyXG5cbiAgICAvLyBjb25zdCBrb25nX25hbWVzcGFjZSA9ICdrb25nLWRwJztcblxuICAgIGNvbnN0IGRhdGFfcGxhbmVfc2VjcmV0c2tleSA9IG5ldyBhd3Nfa21zLktleSh0aGlzLCAnRFBTZWNyZXRzS2V5Jywge1xuICAgICAgZW5hYmxlS2V5Um90YXRpb246IHRydWUsXG4gICAgfSk7XG4gICAgLy8gY29uc3QgZGF0YV9wbGFuZV9zZWNyZXRza2V5ID0gbmV3IGttcy5LZXkodGhpcywgJ0RhdGFQbGFuZVNlY3JldHNLZXknKTtcbiAgICAvLyBjb25zdCBhcnRpZmFjdG9yeUJ1Y2tldCA9IG5ldyBzMy5CdWNrZXQodGhpcywgJ0FydGlmYWN0b3J5QnVja2V0Jyk7XG5cbiAgICBjb25zdCBkYXRhX3BsYW5lID0gbmV3IGF3c19la3MuQ2x1c3Rlcih0aGlzLCAnRFAnLCB7XG4gICAgICAuLi5wcm9wcy5kYXRhUGxhbmVDbHVzdGVyUHJvcHMsXG4gICAgICBzZWNyZXRzRW5jcnlwdGlvbktleTogZGF0YV9wbGFuZV9zZWNyZXRza2V5LFxuICAgICAgZGVmYXVsdENhcGFjaXR5OiAwLFxuICAgICAgYWxiQ29udHJvbGxlcjoge1xuICAgICAgICB2ZXJzaW9uOiBhd3NfZWtzLkFsYkNvbnRyb2xsZXJWZXJzaW9uLlYyXzRfMSxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBjb25zdCBkcF9ub2RlZ3JvdXAgPSBkYXRhX3BsYW5lLmFkZE5vZGVncm91cENhcGFjaXR5KCdEcEFTRycsIHByb3BzLmRhdGFQbGFuZU5vZGVQcm9wcyk7XG4gICAgZHBfbm9kZWdyb3VwLnJvbGUuYWRkTWFuYWdlZFBvbGljeShhd3NfaWFtLk1hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKCdBbWF6b25TU01NYW5hZ2VkSW5zdGFuY2VDb3JlJykpO1xuXG5cbiAgICAvLyBuZXcgRWtzTm9kZUhhbmRsZXIodGhpcywgJ05vZGVIYW5kbGVyJywge1xuICAgIC8vICAgY2x1c3RlcjogZGF0YV9wbGFuZSxcbiAgICAvLyAgIG5vZGVncm91cDogZHBfbm9kZWdyb3VwLFxuICAgIC8vIH0pO1xuXG4gICAgLy8gVE9ETyA6IE1ha2UgYSBuZXcgY29uc3RydWN0IGNsYXNzIGZvciBhbGwgaGVsbSBjaGFydHNcblxuICAgIC8vIG5ldyBFbGFzdGlDYWNoZVN0YWNrKHRoaXMsICdLb25nQ2FjaGUnLCB7XG4gICAgLy8gICBudW1iZXJvZm5vZGVncm91cHM6IDMsXG4gICAgLy8gICB2cGM6IGRhdGFfcGxhbmUudnBjLFxuICAgIC8vIH0pO1xuXG4gICAgY29uc3Qga29uZ19wcmVfcmVxdWlzaXRlc19uZXN0ZWRfc3RhY2sgPSBuZXcgTmVzdGVkU3RhY2sodGhpcywgJ0tvbmdQcmVSZXFzU3RhY2snKTtcbiAgICBuZXcga29uZ19jb3JlLkF3c0NlcnRNYW5hZ2VyKGtvbmdfcHJlX3JlcXVpc2l0ZXNfbmVzdGVkX3N0YWNrLCAnQXdzQ2VydE1hbmFnZXInLCB7XG4gICAgICBjbHVzdGVyOiBkYXRhX3BsYW5lLFxuICAgICAgY2x1c3Rlcklzc3Vlck5hbWU6IGtvbmdfY29yZS5UbHMuS09OR19EUF9DTFVTVEVSX0lTU1VFUl9OQU1FLFxuICAgICAgcHJpdmF0ZUNhQXJuOiBwcm9wcy5wcml2YXRlQ2FBcm4sXG4gICAgfSk7XG5cblxuICAgIG5ldyBrb25nX2NvcmUuU2VjcmV0c01hbmFnZXIoa29uZ19wcmVfcmVxdWlzaXRlc19uZXN0ZWRfc3RhY2ssICdTZWNyZXRzQ3NpJywge1xuICAgICAgY2x1c3RlcjogZGF0YV9wbGFuZSxcbiAgICB9KTtcblxuXG4gICAgLy9UT0RPIDogRXJyb3I6IGtvbmctZHAvS29uZ0Vrc0RwL0tvbmdQcmVSZXFzU3RhY2svQXV0b1NjYWxhci9LYXJwZW50ZXJOb2RlUm9sZSBzaG91bGQgYmUgZGVmaW5lZCBpbiB0aGUgc2NvcGUgb2YgdGhlIGtvbmctZHAgc3RhY2sgdG8gcHJldmVudCBjaXJjdWxhciBkZXBlbmRlbmNpZXNcbiAgICBuZXcga29uZ19jb3JlLkF1dG9TY2FsYXIodGhpcywgJ0F1dG9TY2FsYXInLCB7XG4gICAgICBjbHVzdGVyOiBkYXRhX3BsYW5lLFxuICAgICAgbm9kZWdyb3VwOiBkcF9ub2RlZ3JvdXAsXG4gICAgfSk7XG5cbiAgICBuZXcga29uZ19jb3JlLk1ldHJpY3NTZXJ2ZXIoa29uZ19wcmVfcmVxdWlzaXRlc19uZXN0ZWRfc3RhY2ssICdNZXRyaWNzU2VydmVyJywge1xuICAgICAgY2x1c3RlcjogZGF0YV9wbGFuZSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHRlbGVtZXRyeV9uZXN0ZWRfc3RhY2sgPSBuZXcgTmVzdGVkU3RhY2sodGhpcywgJ0tvbmdUZWxlbWV0cnlTdGFjaycpO1xuXG4gICAgbmV3IGtvbmdfY29yZS5UZWxlbWV0cnkodGVsZW1ldHJ5X25lc3RlZF9zdGFjaywgJ0tvbmdMb2dnaW5nJywge1xuICAgICAgY3JlYXRlUHJvbWV0aGV1c1dvcmtzcGFjZTogcHJvcHMua29uZ1RlbGVtZXRyeU9wdGlvbnMuY3JlYXRlUHJvbWV0aGV1c1dvcmtzcGFjZSxcbiAgICAgIHByb21ldGhldXNFbmRwb2ludDogcHJvcHMua29uZ1RlbGVtZXRyeU9wdGlvbnMucHJvbWV0aGV1c0VuZHBvaW50LFxuICAgICAgY2x1c3RlcjogZGF0YV9wbGFuZSxcbiAgICAgIG5hbWVzcGFjZToga29uZ19jb3JlLk5hbWVzcGFjZS5URUxFTUVUUlksXG4gICAgfSk7XG5cbiAgICB0ZWxlbWV0cnlfbmVzdGVkX3N0YWNrLm5vZGUuYWRkRGVwZW5kZW5jeShrb25nX3ByZV9yZXF1aXNpdGVzX25lc3RlZF9zdGFjayk7XG5cbiAgICBjb25zdCBrb25nX2RhdGFfcGxhbmVfbmVzdGVkX3N0YWNrID0gbmV3IE5lc3RlZFN0YWNrKHRoaXMsICdLb25nRHBTdGFjaycpO1xuICAgIG5ldyBLb25nRWtzRGF0YVBsYW5lKGtvbmdfZGF0YV9wbGFuZV9uZXN0ZWRfc3RhY2ssICdLb25nRFBIZWxtSW5zdGFsbCcsIHtcbiAgICAgIGNsdXN0ZXI6IGRhdGFfcGxhbmUsXG4gICAgICBuYW1lc3BhY2U6IGtvbmdfY29yZS5OYW1lc3BhY2UuS09OR19EQVRBX1BMQU5FLFxuICAgICAgLy8gbm9kZWdyb3VwOiBkcF9ub2RlZ3JvdXAsXG4gICAgICBsaWNlbnNlX3NlY3JldF9uYW1lOiBwcm9wcy5saWNlbnNlU2VjcmV0c05hbWUsXG4gICAgICBjYWNlcnRuYW1lOiBrb25nX2NvcmUuVGxzLktPTkdfRFBfQ0VSVE5BTUUsXG4gICAgICBjbHVzdGVySXNzdWVyTmFtZToga29uZ19jb3JlLlRscy5LT05HX0RQX0NMVVNURVJfSVNTVUVSX05BTUUsXG4gICAgICBlbmRwb2ludHM6IHByb3BzLmRuc1Byb3BzLFxuICAgIH0sXG4gICAgKTtcblxuICAgIGtvbmdfZGF0YV9wbGFuZV9uZXN0ZWRfc3RhY2subm9kZS5hZGREZXBlbmRlbmN5KGtvbmdfcHJlX3JlcXVpc2l0ZXNfbmVzdGVkX3N0YWNrKTtcblxuICB9XG59Il19