"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEcs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core/");
const index_1 = require("./resources/ecs/index");
class KongEcs extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const cluster = new aws_ecs_1.Cluster(this, 'KongDPCluster', props.clusterProps);
        const nlb = new kong_core.NlbStack(this, 'KongDPAlb', {
            vpc: cluster.vpc,
            name: props.clusterProps.clusterName + kong_core.Nlb.KONG_DP_LB_SUFFIX,
            internetFacing: props.internetFacing ?? false,
        });
        const tld = props.clusterProps.clusterName + '-dp.internal';
        const kongDPCertificates = new kong_core.Certificates(this, 'KongDPCertificate', {
            topLevelDomain: tld,
            privateCaArn: props.privateCaArn,
            dnsNames: [
                tld,
            ],
        });
        new index_1.KongEcsDataPlane(this, 'KongDP', {
            cluster: cluster,
            nlb: nlb.kongNlb,
            image: props.image ?? 'docker.io/kong/kong-gateway:2.8.1.0-alpine',
            certificates: kongDPCertificates,
            kongTaskProps: props.kongTaskProps,
            clusterDns: props.clusterDns,
            telemeteryDns: props.telemetryDns,
            licenseSecret: props.licenseSecret ?? undefined,
            desiredCount: props.desiredCount ?? 1,
        });
    }
}
exports.KongEcs = KongEcs;
_a = JSII_RTTI_SYMBOL_1;
KongEcs[_a] = { fqn: "kong-data-plane.KongEcs", version: "3.0.0-dev.4" };
//# sourceMappingURL=data:application/json;base64,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