# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['frontegg',
 'frontegg.baseConfig',
 'frontegg.fastapi',
 'frontegg.fastapi.secure_access',
 'frontegg.flask',
 'frontegg.flask.secure_access',
 'frontegg.helpers',
 'frontegg.sanic',
 'frontegg.sanic.secure_access']

package_data = \
{'': ['*']}

install_requires = \
['arrow>=0.15.5,<0.16.0',
 'cryptography>=3.1,<4.0',
 'pyjwt>=1.7.1,<2.0.0',
 'requests>=2.22.0,<3.0.0']

extras_require = \
{u'fastapi': ['fastapi'], u'flask': ['flask>=1.0,<2.0']}

setup_kwargs = {
    'name': 'frontegg',
    'version': '1.0.9',
    'description': 'Frontegg is a web platform where SaaS companies can set up their fully managed, scalable and brand aware - SaaS features and integrate them into their SaaS portals in up to 5 lines of code.',
    'long_description': '.. image:: https://fronteggstuff.blob.core.windows.net/frongegg-logos/logo-transparent.png\n   :alt: Frontegg\n\nFrontegg is a web platform where SaaS companies can set up their fully managed, scalable and brand aware - SaaS features and integrate them into their SaaS portals in up to 5 lines of code.\n\nFor more information and usage you can visit the `github repo <https://github.com/frontegg/python-sdk>`_.',
    'author': 'Frontegg LTD',
    'author_email': 'hello@frontegg.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://frontegg.com/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
