/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.algos.glm.GlmMojoModelBase;
import hex.genmodel.utils.ArrayUtils;
import java.util.Arrays;

public class GlmOrdinalMojoModel
extends GlmMojoModelBase {
    private int P;
    private int noff;
    private int lastClass;
    private int[] icptIndices;

    GlmOrdinalMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        this.P = this._beta.length / this._nclasses;
        this.lastClass = this._nclasses - 1;
        this.icptIndices = new int[this.lastClass];
        for (int c2 = 0; c2 < this.lastClass; ++c2) {
            this.icptIndices[c2] = this.P - 1 + c2 * this.P;
        }
        if (this.P * this._nclasses != this._beta.length) {
            throw new IllegalStateException("Incorrect coding of Beta.");
        }
        this.noff = this._catOffsets[this._cats];
    }

    @Override
    public final double[] score0(double[] data, double offset, double[] preds) {
        if (this._meanImputation) {
            super.imputeMissingWithMeans(data);
        }
        return this.glmScore0(data, offset, preds);
    }

    double[] glmScore0(double[] data, double offset, double[] preds) {
        Arrays.fill(preds, 0.0);
        preds[0] = this.lastClass;
        for (int c2 = 0; c2 < this.lastClass; ++c2) {
            int i2;
            if (this._cats > 0) {
                int ival;
                if (!this._useAllFactorLevels) {
                    for (i2 = 0; i2 < this._catOffsets.length - 1; ++i2) {
                        if (data[i2] == 0.0) continue;
                        ival = (int)data[i2] - 1;
                        if ((double)ival != data[i2] - 1.0) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((ival += this._catOffsets[i2]) >= this._catOffsets[i2 + 1]) continue;
                        int n2 = c2 + 1;
                        preds[n2] = preds[n2] + this._beta[ival + c2 * this.P];
                    }
                } else {
                    for (i2 = 0; i2 < this._catOffsets.length - 1; ++i2) {
                        ival = (int)data[i2];
                        if ((double)ival != data[i2]) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((ival += this._catOffsets[i2]) >= this._catOffsets[i2 + 1]) continue;
                        int n3 = c2 + 1;
                        preds[n3] = preds[n3] + this._beta[ival + c2 * this.P];
                    }
                }
            }
            for (i2 = 0; i2 < this._nums; ++i2) {
                int n4 = c2 + 1;
                preds[n4] = preds[n4] + this._beta[i2 + this.noff + c2 * this.P] * data[i2 + this._cats];
            }
            int n5 = c2 + 1;
            preds[n5] = preds[n5] + this._beta[this.icptIndices[c2]];
        }
        double previousCDF = 0.0;
        for (int cInd = 0; cInd < this.lastClass; ++cInd) {
            double eta = preds[cInd + 1] + offset;
            double currCDF = 1.0 / (1.0 + Math.exp(-eta));
            preds[cInd + 1] = currCDF - previousCDF;
            previousCDF = currCDF;
        }
        preds[this._nclasses] = 1.0 - previousCDF;
        preds[0] = 0.0;
        preds[0] = ArrayUtils.maxIndex(preds) - 1;
        return preds;
    }
}

