/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.FieldSet;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class SmallSortedMap<K extends Comparable<K>, V>
extends AbstractMap<K, V> {
    private final int maxArraySize;
    private List<Entry> entryList;
    private Map<K, V> overflowEntries;
    private boolean isImmutable;
    private volatile EntrySet lazyEntrySet;

    static <FieldDescriptorType extends FieldSet.FieldDescriptorLite<FieldDescriptorType>> SmallSortedMap<FieldDescriptorType, Object> newFieldMap(int arraySize) {
        return new SmallSortedMap<FieldDescriptorType, Object>(arraySize){

            @Override
            public final void makeImmutable() {
                if (!this.isImmutable()) {
                    List list;
                    for (int i2 = 0; i2 < this.getNumArrayEntries(); ++i2) {
                        Map.Entry entry = this.getArrayEntryAt(i2);
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        list = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(list));
                    }
                    for (Map.Entry entry : this.getOverflowEntries()) {
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        list = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(list));
                    }
                }
                super.makeImmutable();
            }
        };
    }

    static <K extends Comparable<K>, V> SmallSortedMap<K, V> newInstanceForTest(int arraySize) {
        return new SmallSortedMap<K, V>(arraySize);
    }

    private SmallSortedMap(int arraySize) {
        this.maxArraySize = arraySize;
        this.entryList = Collections.emptyList();
        this.overflowEntries = Collections.emptyMap();
    }

    public void makeImmutable() {
        if (!this.isImmutable) {
            this.overflowEntries = this.overflowEntries.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.overflowEntries);
            this.isImmutable = true;
        }
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public int getNumArrayEntries() {
        return this.entryList.size();
    }

    public Map.Entry<K, V> getArrayEntryAt(int index) {
        return this.entryList.get(index);
    }

    public int getNumOverflowEntries() {
        return this.overflowEntries.size();
    }

    public Iterable<Map.Entry<K, V>> getOverflowEntries() {
        if (this.overflowEntries.isEmpty()) {
            return EmptySet.iterable();
        }
        return this.overflowEntries.entrySet();
    }

    @Override
    public int size() {
        return this.entryList.size() + this.overflowEntries.size();
    }

    @Override
    public boolean containsKey(Object o2) {
        Comparable comparable = (Comparable)o2;
        return this.binarySearchInArray(comparable) >= 0 || this.overflowEntries.containsKey(comparable);
    }

    @Override
    public V get(Object o2) {
        Comparable comparable = (Comparable)o2;
        int n2 = this.binarySearchInArray(comparable);
        if (n2 >= 0) {
            return this.entryList.get(n2).getValue();
        }
        return this.overflowEntries.get(comparable);
    }

    @Override
    public V put(K key, V value) {
        this.checkMutable();
        int n2 = this.binarySearchInArray(key);
        if (n2 >= 0) {
            return this.entryList.get(n2).setValue(value);
        }
        this.ensureEntryArrayMutable();
        int n3 = -(n2 + 1);
        if (n3 >= this.maxArraySize) {
            return this.getOverflowEntriesMutable().put(key, value);
        }
        if (this.entryList.size() == this.maxArraySize) {
            Entry entry = this.entryList.remove(this.maxArraySize - 1);
            this.getOverflowEntriesMutable().put(entry.getKey(), entry.getValue());
        }
        this.entryList.add(n3, new Entry(this, key, value));
        return null;
    }

    @Override
    public void clear() {
        this.checkMutable();
        if (!this.entryList.isEmpty()) {
            this.entryList.clear();
        }
        if (!this.overflowEntries.isEmpty()) {
            this.overflowEntries.clear();
        }
    }

    @Override
    public V remove(Object o2) {
        this.checkMutable();
        Comparable comparable = (Comparable)o2;
        int n2 = this.binarySearchInArray(comparable);
        if (n2 >= 0) {
            return this.removeArrayEntryAt(n2);
        }
        if (this.overflowEntries.isEmpty()) {
            return null;
        }
        return this.overflowEntries.remove(comparable);
    }

    private V removeArrayEntryAt(int index) {
        this.checkMutable();
        Object v2 = this.entryList.remove(index).getValue();
        if (!this.overflowEntries.isEmpty()) {
            Iterator<Map.Entry<K, V>> iterator = this.getOverflowEntriesMutable().entrySet().iterator();
            this.entryList.add(new Entry(this, iterator.next()));
            iterator.remove();
        }
        return v2;
    }

    private int binarySearchInArray(K key) {
        int n2;
        int n3 = 0;
        int n4 = this.entryList.size() - 1;
        if (n4 >= 0) {
            n2 = key.compareTo((Object)this.entryList.get(n4).getKey());
            if (n2 > 0) {
                return -(n4 + 2);
            }
            if (n2 == 0) {
                return n4;
            }
        }
        while (n3 <= n4) {
            n2 = (n3 + n4) / 2;
            int n5 = key.compareTo((Object)this.entryList.get(n2).getKey());
            if (n5 < 0) {
                n4 = n2 - 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n2 + 1;
                continue;
            }
            return n2;
        }
        return -(n3 + 1);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.lazyEntrySet == null) {
            this.lazyEntrySet = new EntrySet();
        }
        return this.lazyEntrySet;
    }

    private void checkMutable() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException();
        }
    }

    private SortedMap<K, V> getOverflowEntriesMutable() {
        this.checkMutable();
        if (this.overflowEntries.isEmpty() && !(this.overflowEntries instanceof TreeMap)) {
            this.overflowEntries = new TreeMap();
        }
        return (SortedMap)this.overflowEntries;
    }

    private void ensureEntryArrayMutable() {
        this.checkMutable();
        if (this.entryList.isEmpty() && !(this.entryList instanceof ArrayList)) {
            this.entryList = new ArrayList<Entry>(this.maxArraySize);
        }
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof SmallSortedMap)) {
            return super.equals(o2);
        }
        SmallSortedMap smallSortedMap = (SmallSortedMap)o2;
        int n2 = this.size();
        if (n2 != smallSortedMap.size()) {
            return false;
        }
        int n3 = this.getNumArrayEntries();
        if (n3 != smallSortedMap.getNumArrayEntries()) {
            return this.entrySet().equals(smallSortedMap.entrySet());
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.getArrayEntryAt(i2).equals(smallSortedMap.getArrayEntryAt(i2))) continue;
            return false;
        }
        if (n3 != n2) {
            return this.overflowEntries.equals(smallSortedMap.overflowEntries);
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.getNumArrayEntries();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += this.entryList.get(i2).hashCode();
        }
        if (this.getNumOverflowEntries() > 0) {
            n2 += this.overflowEntries.hashCode();
        }
        return n2;
    }

    private static class EmptySet {
        private static final Iterator<Object> ITERATOR = new Iterator<Object>(){

            @Override
            public final boolean hasNext() {
                return false;
            }

            @Override
            public final Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
        private static final Iterable<Object> ITERABLE = new Iterable<Object>(){

            @Override
            public final Iterator<Object> iterator() {
                return ITERATOR;
            }
        };

        private EmptySet() {
        }

        static <T> Iterable<T> iterable() {
            return ITERABLE;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int pos = -1;
        private boolean nextCalledBeforeRemove;
        private Iterator<Map.Entry<K, V>> lazyOverflowIterator;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < SmallSortedMap.this.entryList.size() || !SmallSortedMap.this.overflowEntries.isEmpty() && this.getOverflowIterator().hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.nextCalledBeforeRemove = true;
            if (++this.pos < SmallSortedMap.this.entryList.size()) {
                return (Map.Entry)SmallSortedMap.this.entryList.get(this.pos);
            }
            return this.getOverflowIterator().next();
        }

        @Override
        public void remove() {
            if (!this.nextCalledBeforeRemove) {
                throw new IllegalStateException("remove() was called before next()");
            }
            this.nextCalledBeforeRemove = false;
            SmallSortedMap.this.checkMutable();
            if (this.pos < SmallSortedMap.this.entryList.size()) {
                SmallSortedMap.this.removeArrayEntryAt(this.pos--);
                return;
            }
            this.getOverflowIterator().remove();
        }

        private Iterator<Map.Entry<K, V>> getOverflowIterator() {
            if (this.lazyOverflowIterator == null) {
                this.lazyOverflowIterator = SmallSortedMap.this.overflowEntries.entrySet().iterator();
            }
            return this.lazyOverflowIterator;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SmallSortedMap.this.size();
        }

        @Override
        public boolean contains(Object o2) {
            Object v2;
            Map.Entry entry = (Map.Entry)o2;
            Object v3 = SmallSortedMap.this.get(entry.getKey());
            return v3 == (v2 = entry.getValue()) || v3 != null && v3.equals(v2);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            if (!this.contains(entry)) {
                SmallSortedMap.this.put((Comparable)entry.getKey(), entry.getValue());
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object o2) {
            Map.Entry entry = (Map.Entry)o2;
            if (this.contains(entry)) {
                SmallSortedMap.this.remove(entry.getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SmallSortedMap.this.clear();
        }
    }

    private static class Entry
    implements Comparable<Entry>,
    Map.Entry<K, V> {
        private final K key;
        private V value;
        final /* synthetic */ SmallSortedMap this$0;

        Entry(SmallSortedMap smallSortedMap, Map.Entry<K, V> copy) {
            this(smallSortedMap, (Comparable)copy.getKey(), copy.getValue());
        }

        Entry(K key, V value) {
            this.this$0 = var1_1;
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Entry other) {
            return this.getKey().compareTo(other.getKey());
        }

        @Override
        public V setValue(V newValue) {
            this.this$0.checkMutable();
            Object v2 = this.value;
            this.value = newValue;
            return v2;
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o2;
            Entry entry2 = this;
            if (entry2.equals(entry2.key, entry.getKey())) {
                Entry entry3 = this;
                if (entry3.equals(entry3.value, entry.getValue())) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }
    }
}

