# generated by datamodel-codegen:
#   filename:  schema.json

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import AnyUrl, BaseModel, EmailStr, Extra, Field
from typing_extensions import Literal


class AuthorizedActorsOnly(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[bool] = Field(None, alias="from")


class AuthorizedActorNames(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[List[str]] = Field(None, alias="from")


class RequiredStatusChecks(AuthorizedActorNames):
    pass


class Changes(BaseModel):
    class Config:
        extra = Extra.forbid

    authorized_actors_only: Optional[AuthorizedActorsOnly] = None
    authorized_actor_names: Optional[AuthorizedActorNames] = None
    required_status_checks: Optional[RequiredStatusChecks] = None


class Conclusion(Enum):
    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    timed_out = "timed_out"
    action_required = "action_required"
    stale = "stale"
    skipped = "skipped"
    NoneType_None = None


class Output(BaseModel):
    class Config:
        extra = Extra.forbid

    title: Optional[Optional[str]] = None
    summary: Optional[Optional[str]] = None
    text: Optional[Optional[str]] = None
    annotations_count: Optional[int] = None
    annotations_url: Optional[AnyUrl] = None


class Status(str, Enum):
    in_progress = "in_progress"
    completed = "completed"
    queued = "queued"


class Conclusion1(Enum):
    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    timed_out = "timed_out"
    action_required = "action_required"
    stale = "stale"
    NoneType_None = None


class RequestedAction(BaseModel):
    class Config:
        extra = Extra.forbid

    identifier: Optional[str] = Field(
        None,
        description="The integrator reference of the action requested by the user.",
    )


class Status1(str, Enum):
    queued = "queued"
    in_progress = "in_progress"
    completed = "completed"
    waiting = "waiting"


class Output1(Output):
    pass


class Status2(str, Enum):
    queued = "queued"
    in_progress = "in_progress"
    completed = "completed"


class RequestedAction1(RequestedAction):
    pass


class Output2(Output):
    pass


class RequestedAction2(RequestedAction):
    pass


class Output3(Output):
    pass


class Conclusion7(str, Enum):
    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    timed_out = "timed_out"
    action_required = "action_required"
    stale = "stale"


class RequestedAction3(RequestedAction):
    pass


class Status5(Enum):
    requested = "requested"
    in_progress = "in_progress"
    completed = "completed"
    queued = "queued"
    NoneType_None = None


class State(str, Enum):
    open = "open"
    dismissed = "dismissed"
    fixed = "fixed"


class DismissedReason(Enum):
    false_positive = "false positive"
    won_t_fix = "won't fix"
    used_in_tests = "used in tests"
    NoneType_None = None


class Severity(Enum):
    none = "none"
    note = "note"
    warning = "warning"
    error = "error"
    NoneType_None = None


class Rule(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[str] = Field(
        None, description="A unique identifier for the rule used to detect the alert."
    )
    severity: Optional[Severity] = Field(None, description="The severity of the alert.")
    description: Optional[str] = Field(
        None, description="A short description of the rule used to detect the alert."
    )


class Tool(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(
        None,
        description="The name of the tool used to generate the code scanning analysis alert.",
    )
    version: Optional[Optional[str]] = Field(
        None, description="The version of the tool used to detect the alert."
    )


class Rule1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[str] = Field(
        None, description="A unique identifier for the rule used to detect the alert."
    )
    severity: Optional[Severity] = Field(None, description="The severity of the alert.")
    description: Optional[str] = Field(
        None, description="A short description of the rule used to detect the alert."
    )
    name: Optional[str] = None
    full_description: Optional[str] = None
    tags: Optional[Any] = None
    help: Optional[Any] = None


class Tool1(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(
        None,
        description="The name of the tool used to generate the code scanning analysis alert.",
    )
    version: Optional[Optional[str]] = Field(
        None, description="The version of the tool used to detect the alert."
    )
    guid: Optional[Optional[str]] = None


class State1(str, Enum):
    open = "open"
    dismissed = "dismissed"


class Rule2(Rule1):
    pass


class Tool2(Tool1):
    pass


class Rule3(Rule1):
    pass


class Tool3(Tool1):
    pass


class Rule4(Rule1):
    pass


class Tool4(Tool1):
    pass


class Rule5(Rule):
    pass


class Tool5(Tool):
    pass


class RefType(str, Enum):
    tag = "tag"
    branch = "branch"


class Key(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    key: Optional[str] = None
    url: Optional[AnyUrl] = None
    title: Optional[str] = None
    verified: Optional[bool] = None
    created_at: Optional[str] = None
    read_only: Optional[bool] = None


class Key1(Key):
    pass


class CheckRun4(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="The id of the check.")
    name: Optional[str] = Field(None, description="The name of the check run.")
    node_id: Optional[str] = None
    head_sha: Optional[str] = Field(
        None, description="The SHA of the commit that is being checked."
    )
    external_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    details_url: Optional[AnyUrl] = None
    status: Optional[Status1] = Field(
        None,
        description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`.",
    )
    conclusion: Optional[Conclusion] = Field(
        None,
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
    )
    started_at: Optional[datetime] = None
    completed_at: Optional[Optional[str]] = None


class Category(BaseModel):
    is_answerable: Optional[Literal[True]] = None


class From(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    repository_id: Optional[int] = None
    emoji: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[str] = None
    slug: Optional[str] = None
    is_answerable: Optional[bool] = None


class Category1(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[From] = Field(None, alias="from")


class Changes1(BaseModel):
    class Config:
        extra = Extra.forbid

    category: Optional[Category1] = None


class State4(str, Enum):
    open = "open"
    converting = "converting"


class Title(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(None, alias="from")


class Body(Title):
    pass


class Changes2(BaseModel):
    class Config:
        extra = Extra.forbid

    title: Optional[Title] = None
    body: Optional[Body] = None


class Category2(Category):
    pass


class Body1(Title):
    pass


class Changes4(BaseModel):
    class Config:
        extra = Extra.forbid

    body: Optional[Body1] = None


class Action(str, Enum):
    created = "created"
    edited = "edited"


class Page(BaseModel):
    class Config:
        extra = Extra.forbid

    page_name: Optional[str] = Field(None, description="The name of the page.")
    title: Optional[str] = Field(None, description="The current page title.")
    summary: Optional[Any] = None
    action: Optional[Action] = Field(
        None,
        description="The action that was performed on the page. Can be `created` or `edited`.",
    )
    sha: Optional[str] = Field(None, description="The latest commit SHA of the page.")
    html_url: Optional[AnyUrl] = Field(
        None, description="Points to the HTML wiki page."
    )


class Repository1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="Unique identifier of the repository")
    node_id: Optional[str] = None
    name: Optional[str] = Field(None, description="The name of the repository.")
    full_name: Optional[str] = None
    private: Optional[bool] = Field(
        None, description="Whether the repository is private or public."
    )


class Repository2(Repository1):
    pass


class Repository3(Repository1):
    pass


class Repository4(Repository1):
    pass


class Repository5(Repository1):
    pass


class RepositorySelection(str, Enum):
    all = "all"
    selected = "selected"


class RepositoriesAddedItem(Repository1):
    pass


class RepositoriesRemovedItem(Repository1):
    pass


class RepositoriesAddedItem1(Repository1):
    pass


class RepositoriesRemovedItem1(Repository1):
    pass


class State5(str, Enum):
    open = "open"
    closed = "closed"


class Body2(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None, alias="from", description="The previous version of the body."
    )


class Changes5(BaseModel):
    class Config:
        extra = Extra.forbid

    body: Optional[Body2] = None


class Body3(Body2):
    pass


class Title1(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None, alias="from", description="The previous version of the title."
    )


class Changes6(BaseModel):
    class Config:
        extra = Extra.forbid

    body: Optional[Body3] = None
    title: Optional[Title1] = None


class ActiveLockReason(Enum):
    resolved = "resolved"
    off_topic = "off-topic"
    too_heated = "too heated"
    spam = "spam"
    NoneType_None = None


class Color(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The previous version of the color if the action was `edited`.",
    )


class Name(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The previous version of the name if the action was `edited`.",
    )


class Description(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The previous version of the description if the action was `edited`.",
    )


class Changes9(BaseModel):
    class Config:
        extra = Extra.forbid

    color: Optional[Color] = None
    name: Optional[Name] = None
    description: Optional[Description] = None


class Sender(BaseModel):
    class Config:
        extra = Extra.forbid

    login: Optional[str] = None
    id: Optional[int] = None
    avatar_url: Optional[AnyUrl] = None
    gravatar_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    followers_url: Optional[AnyUrl] = None
    following_url: Optional[str] = None
    gists_url: Optional[str] = None
    starred_url: Optional[str] = None
    subscriptions_url: Optional[AnyUrl] = None
    organizations_url: Optional[AnyUrl] = None
    repos_url: Optional[AnyUrl] = None
    events_url: Optional[str] = None
    received_events_url: Optional[AnyUrl] = None
    type: Optional[str] = None
    site_admin: Optional[bool] = None
    email: Optional[str] = None


class Sender1(Sender):
    pass


class Sender2(Sender):
    pass


class Sender3(Sender):
    pass


class Sender4(Sender):
    pass


class To(str, Enum):
    write = "write"
    admin = "admin"


class Permission(BaseModel):
    class Config:
        extra = Extra.forbid

    to: Optional[To] = None


class Changes10(BaseModel):
    class Config:
        extra = Extra.forbid

    permission: Optional[Permission] = None


class OldPermission(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The previous permissions of the collaborator if the action was edited.",
    )


class Changes11(BaseModel):
    class Config:
        extra = Extra.forbid

    old_permission: Optional[OldPermission] = None


class Scope(str, Enum):
    team = "team"
    organization = "organization"


class TeamItem(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    name: Optional[str] = None
    deleted: Optional[bool] = None


class ContentType(str, Enum):
    json = "json"
    form = "form"


class Config(BaseModel):
    class Config:
        extra = Extra.forbid

    content_type: Optional[ContentType] = None
    insecure_ssl: Optional[str] = None
    url: Optional[AnyUrl] = None
    secret: Optional[str] = None


class Description1(Description):
    pass


class DueOn(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The previous version of the due date if the action was `edited`.",
    )


class Title2(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The previous version of the title if the action was `edited`.",
    )


class Changes12(BaseModel):
    class Config:
        extra = Extra.forbid

    description: Optional[Description1] = None
    due_on: Optional[DueOn] = None
    title: Optional[Title2] = None


class PackageFile(BaseModel):
    class Config:
        extra = Extra.forbid

    download_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    name: Optional[str] = None
    sha256: Optional[str] = None
    sha1: Optional[str] = None
    md5: Optional[str] = None
    content_type: Optional[str] = None
    state: Optional[str] = None
    size: Optional[int] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None


class Registry(BaseModel):
    class Config:
        extra = Extra.forbid

    about_url: Optional[AnyUrl] = None
    name: Optional[str] = None
    type: Optional[str] = None
    url: Optional[AnyUrl] = None
    vendor: Optional[str] = None


class PackageFile1(PackageFile):
    pass


class Registry1(Registry):
    pass


class Error(BaseModel):
    class Config:
        extra = Extra.forbid

    message: Optional[Optional[str]] = None


class Config1(BaseModel):
    class Config:
        extra = Extra.forbid

    content_type: Optional[ContentType] = None
    secret: Optional[str] = None
    url: Optional[AnyUrl] = None
    insecure_ssl: Optional[str] = None


class LastResponse(BaseModel):
    class Config:
        extra = Extra.forbid

    code: Optional[Any] = None
    status: Optional[str] = None
    message: Optional[Any] = None


class Name1(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The changes to the project if the action was `edited`.",
    )


class Body4(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The previous version of the body if the action was `edited`.",
    )


class Changes13(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[Name1] = None
    body: Optional[Body4] = None


class Note(Title):
    pass


class Changes14(BaseModel):
    class Config:
        extra = Extra.forbid

    note: Optional[Note] = None


class Note1(Title):
    pass


class Changes15(BaseModel):
    class Config:
        extra = Extra.forbid

    note: Optional[Note1] = None


class ColumnId(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[int] = Field(None, alias="from")


class Changes16(BaseModel):
    class Config:
        extra = Extra.forbid

    column_id: Optional[ColumnId] = None


class Name2(Title):
    pass


class Changes17(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[Name2] = None


class ArchivedAt(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[Any] = Field(None, alias="from")
    to: Optional[datetime] = None


class Changes18(BaseModel):
    class Config:
        extra = Extra.forbid

    archived_at: Optional[ArchivedAt] = None


class ContentType2(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[Literal["DraftIssue"]] = Field(None, alias="from")
    to: Optional[Literal["Issue"]] = None


class Changes19(BaseModel):
    class Config:
        extra = Extra.forbid

    content_type: Optional[ContentType2] = None


class FieldType(str, Enum):
    single_select = "single_select"
    date = "date"
    number = "number"
    text = "text"
    iteration = "iteration"


class FieldValue(BaseModel):
    class Config:
        extra = Extra.forbid

    field_type: Optional[FieldType] = None
    field_node_id: Optional[str] = None


class Changes20(BaseModel):
    class Config:
        extra = Extra.forbid

    field_value: Optional[FieldValue] = None


class PreviousProjectsV2ItemNodeId(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(None, alias="from")
    to: Optional[Optional[str]] = None


class Changes21(BaseModel):
    class Config:
        extra = Extra.forbid

    previous_projects_v2_item_node_id: Optional[PreviousProjectsV2ItemNodeId] = None


class ArchivedAt1(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[datetime] = Field(None, alias="from")
    to: Optional[Any] = None


class Changes22(BaseModel):
    class Config:
        extra = Extra.forbid

    archived_at: Optional[ArchivedAt1] = None


class Body5(Body4):
    pass


class Title3(Title2):
    pass


class Ref(Title):
    pass


class Sha(Title):
    pass


class Base(BaseModel):
    class Config:
        extra = Extra.forbid

    ref: Optional[Ref] = None
    sha: Optional[Sha] = None


class Changes23(BaseModel):
    class Config:
        extra = Extra.forbid

    body: Optional[Body5] = None
    title: Optional[Title3] = None
    base: Optional[Base] = None


class Body6(Body4):
    pass


class Changes24(BaseModel):
    class Config:
        extra = Extra.forbid

    body: Optional[Body6] = None


class Body7(Body2):
    pass


class Changes25(BaseModel):
    class Config:
        extra = Extra.forbid

    body: Optional[Body7] = None


class Body8(Body4):
    pass


class Name3(Name):
    pass


class Changes26(BaseModel):
    class Config:
        extra = Extra.forbid

    body: Optional[Body8] = None
    name: Optional[Name3] = None


class Description2(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[Optional[str]] = Field(None, alias="from")


class DefaultBranch(Title):
    pass


class Homepage(Description2):
    pass


class Changes27(BaseModel):
    class Config:
        extra = Extra.forbid

    description: Optional[Description2] = None
    default_branch: Optional[DefaultBranch] = None
    homepage: Optional[Homepage] = None


class Name4(Title):
    pass


class Repository10(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[Name4] = None


class Changes28(BaseModel):
    class Config:
        extra = Extra.forbid

    repository: Optional[Repository10] = None


class Status9(str, Enum):
    success = "success"
    cancelled = "cancelled"
    failure = "failure"


class Alert10(BaseModel):
    class Config:
        extra = Extra.forbid

    number: Optional[int] = None
    secret_type: Optional[str] = None
    resolution: Optional[Any] = None
    resolved_by: Optional[Any] = None
    resolved_at: Optional[Any] = None


class Alert11(Alert10):
    pass


class Resolution(str, Enum):
    false_positive = "false_positive"
    wontfix = "wontfix"
    revoked = "revoked"
    used_in_tests = "used_in_tests"


class Cvss(BaseModel):
    class Config:
        extra = Extra.forbid

    vector_string: Optional[Optional[str]] = None
    score: Optional[float] = None


class Cwe(BaseModel):
    class Config:
        extra = Extra.forbid

    cwe_id: Optional[str] = None
    name: Optional[str] = None


class Identifier(BaseModel):
    class Config:
        extra = Extra.forbid

    value: Optional[str] = None
    type: Optional[str] = None


class Reference(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None


class Package2(BaseModel):
    class Config:
        extra = Extra.forbid

    ecosystem: Optional[str] = None
    name: Optional[str] = None


class FirstPatchedVersion(BaseModel):
    class Config:
        extra = Extra.forbid

    identifier: Optional[str] = None


class Vulnerability(BaseModel):
    class Config:
        extra = Extra.forbid

    package: Optional[Package2] = None
    severity: Optional[str] = None
    vulnerable_version_range: Optional[str] = None
    first_patched_version: Optional[FirstPatchedVersion] = None


class SecurityAdvisory(BaseModel):
    class Config:
        extra = Extra.forbid

    cvss: Optional[Cvss] = None
    cwes: Optional[List[Cwe]] = None
    ghsa_id: Optional[str] = None
    summary: Optional[str] = None
    description: Optional[str] = None
    severity: Optional[str] = None
    identifiers: Optional[List[Identifier]] = None
    references: Optional[List[Reference]] = None
    published_at: Optional[str] = None
    updated_at: Optional[str] = None
    withdrawn_at: Optional[Optional[str]] = None
    vulnerabilities: Optional[List[Vulnerability]] = None


class SecurityAdvisoryPerformed(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["performed"]] = None
    security_advisory: Optional[SecurityAdvisory] = Field(
        None,
        description="The details of the security advisory, including summary, description, and severity.",
    )


class Cvss1(Cvss):
    pass


class Cwe1(Cwe):
    pass


class Identifier1(Identifier):
    pass


class Reference1(Reference):
    pass


class Package3(Package2):
    pass


class FirstPatchedVersion1(FirstPatchedVersion):
    pass


class Vulnerability1(BaseModel):
    class Config:
        extra = Extra.forbid

    package: Optional[Package3] = None
    severity: Optional[str] = None
    vulnerable_version_range: Optional[str] = None
    first_patched_version: Optional[FirstPatchedVersion1] = None


class SecurityAdvisory1(BaseModel):
    class Config:
        extra = Extra.forbid

    cvss: Optional[Cvss1] = None
    cwes: Optional[List[Cwe1]] = None
    ghsa_id: Optional[str] = None
    summary: Optional[str] = None
    description: Optional[str] = None
    severity: Optional[str] = None
    identifiers: Optional[List[Identifier1]] = None
    references: Optional[List[Reference1]] = None
    published_at: Optional[str] = None
    updated_at: Optional[str] = None
    withdrawn_at: Optional[Optional[str]] = None
    vulnerabilities: Optional[List[Vulnerability1]] = None


class SecurityAdvisoryPublished(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["published"]] = None
    security_advisory: Optional[SecurityAdvisory1] = Field(
        None,
        description="The details of the security advisory, including summary, description, and severity.",
    )


class Cvss2(Cvss):
    pass


class Cwe2(Cwe):
    pass


class Identifier2(Identifier):
    pass


class Reference2(Reference):
    pass


class Package4(Package2):
    pass


class FirstPatchedVersion2(FirstPatchedVersion):
    pass


class Vulnerability2(BaseModel):
    class Config:
        extra = Extra.forbid

    package: Optional[Package4] = None
    severity: Optional[str] = None
    vulnerable_version_range: Optional[str] = None
    first_patched_version: Optional[FirstPatchedVersion2] = None


class SecurityAdvisory2(BaseModel):
    class Config:
        extra = Extra.forbid

    cvss: Optional[Cvss2] = None
    cwes: Optional[List[Cwe2]] = None
    ghsa_id: Optional[str] = None
    summary: Optional[str] = None
    description: Optional[str] = None
    severity: Optional[str] = None
    identifiers: Optional[List[Identifier2]] = None
    references: Optional[List[Reference2]] = None
    published_at: Optional[str] = None
    updated_at: Optional[str] = None
    withdrawn_at: Optional[Optional[str]] = None
    vulnerabilities: Optional[List[Vulnerability2]] = None


class SecurityAdvisoryUpdated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["updated"]] = None
    security_advisory: Optional[SecurityAdvisory2] = Field(
        None,
        description="The details of the security advisory, including summary, description, and severity.",
    )


class Cvss3(Cvss):
    pass


class Cwe3(Cwe):
    pass


class Identifier3(Identifier):
    pass


class Reference3(Reference):
    pass


class Package5(Package2):
    pass


class FirstPatchedVersion3(FirstPatchedVersion):
    pass


class Vulnerability3(BaseModel):
    class Config:
        extra = Extra.forbid

    package: Optional[Package5] = None
    severity: Optional[str] = None
    vulnerable_version_range: Optional[str] = None
    first_patched_version: Optional[FirstPatchedVersion3] = None


class SecurityAdvisory3(BaseModel):
    class Config:
        extra = Extra.forbid

    cvss: Optional[Cvss3] = None
    cwes: Optional[List[Cwe3]] = None
    ghsa_id: Optional[str] = None
    summary: Optional[str] = None
    description: Optional[str] = None
    severity: Optional[str] = None
    identifiers: Optional[List[Identifier3]] = None
    references: Optional[List[Reference3]] = None
    published_at: Optional[str] = None
    updated_at: Optional[str] = None
    withdrawn_at: Optional[str] = None
    vulnerabilities: Optional[List[Vulnerability3]] = None


class SecurityAdvisoryWithdrawn(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["withdrawn"]] = None
    security_advisory: Optional[SecurityAdvisory3] = Field(
        None,
        description="The details of the security advisory, including summary, description, and severity.",
    )


class SecurityAdvisoryEvent(BaseModel):
    __root__: Optional[
        Union[
            SecurityAdvisoryPerformed,
            SecurityAdvisoryPublished,
            SecurityAdvisoryUpdated,
            SecurityAdvisoryWithdrawn,
        ]
    ] = None


class PrivacyLevel(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The `edited` event types include the details about the change when someone edits a sponsorship to change the privacy.",
    )


class Changes30(BaseModel):
    class Config:
        extra = Extra.forbid

    privacy_level: Optional[PrivacyLevel] = None


class State11(str, Enum):
    pending = "pending"
    success = "success"
    failure = "failure"
    error = "error"


class Tree(BaseModel):
    class Config:
        extra = Extra.forbid

    sha: Optional[str] = None
    url: Optional[AnyUrl] = None


class Reason(str, Enum):
    expired_key = "expired_key"
    not_signing_key = "not_signing_key"
    gpgverify_error = "gpgverify_error"
    gpgverify_unavailable = "gpgverify_unavailable"
    unsigned = "unsigned"
    unknown_signature_type = "unknown_signature_type"
    no_user = "no_user"
    unverified_email = "unverified_email"
    bad_email = "bad_email"
    unknown_key = "unknown_key"
    malformed_signature = "malformed_signature"
    invalid = "invalid"
    valid = "valid"


class Verification(BaseModel):
    class Config:
        extra = Extra.forbid

    verified: Optional[bool] = None
    reason: Optional[Reason] = None
    signature: Optional[Optional[str]] = None
    payload: Optional[Optional[str]] = None


class Parent(BaseModel):
    class Config:
        extra = Extra.forbid

    sha: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None


class Commit3(Tree):
    pass


class Branch(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = None
    commit: Optional[Commit3] = None
    protected: Optional[bool] = None


class Description3(Description):
    pass


class Name5(Name):
    pass


class Privacy(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[str] = Field(
        None,
        alias="from",
        description="The previous version of the team's privacy if the action was `edited`.",
    )


class From2(BaseModel):
    class Config:
        extra = Extra.forbid

    admin: Optional[bool] = Field(
        None,
        description="The previous version of the team member's `admin` permission on a repository, if the action was `edited`.",
    )
    pull: Optional[bool] = Field(
        None,
        description="The previous version of the team member's `pull` permission on a repository, if the action was `edited`.",
    )
    push: Optional[bool] = Field(
        None,
        description="The previous version of the team member's `push` permission on a repository, if the action was `edited`.",
    )


class Permissions(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[From2] = Field(None, alias="from")


class Repository12(BaseModel):
    class Config:
        extra = Extra.forbid

    permissions: Optional[Permissions] = None


class Changes33(BaseModel):
    class Config:
        extra = Extra.forbid

    description: Optional[Description3] = None
    name: Optional[Name5] = None
    privacy: Optional[Privacy] = None
    repository: Optional[Repository12] = None


class Conclusion12(str, Enum):
    success = "success"
    failure = "failure"


class Conclusion13(str, Enum):
    success = "success"
    failure = "failure"
    neutral = "neutral"
    cancelled = "cancelled"
    timed_out = "timed_out"
    action_required = "action_required"
    stale = "stale"
    skipped = "skipped"


class Message(BaseModel):
    class Config:
        extra = Extra.forbid

    text: Optional[str] = None


class Location(BaseModel):
    class Config:
        extra = Extra.forbid

    path: Optional[str] = None
    start_line: Optional[int] = None
    end_line: Optional[int] = None
    start_column: Optional[int] = None
    end_column: Optional[int] = None


class AlertInstance(BaseModel):
    class Config:
        extra = Extra.forbid

    ref: Optional[str] = Field(
        None,
        description="The full Git reference, formatted as `refs/heads/<branch name>`.",
    )
    analysis_key: Optional[str] = Field(
        None,
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
    )
    environment: Optional[str] = Field(
        None,
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
    )
    state: Optional[State] = Field(None, description="State of a code scanning alert.")
    commit_sha: Optional[str] = None
    message: Optional[Message] = None
    location: Optional[Location] = None
    classifications: Optional[List[str]] = None


class Actions(str, Enum):
    read = "read"
    write = "write"


class Permissions1(BaseModel):
    class Config:
        extra = Extra.forbid

    actions: Optional[Actions] = None
    administration: Optional[Actions] = None
    checks: Optional[Actions] = None
    content_references: Optional[Actions] = None
    contents: Optional[Actions] = None
    deployments: Optional[Actions] = None
    discussions: Optional[Actions] = None
    emails: Optional[Actions] = None
    environments: Optional[Actions] = None
    issues: Optional[Actions] = None
    keys: Optional[Actions] = None
    members: Optional[Actions] = None
    metadata: Optional[Actions] = None
    organization_administration: Optional[Actions] = None
    organization_hooks: Optional[Actions] = None
    organization_packages: Optional[Actions] = None
    organization_plan: Optional[Actions] = None
    organization_projects: Optional[Actions] = None
    organization_secrets: Optional[Actions] = None
    organization_self_hosted_runners: Optional[Actions] = None
    organization_user_blocking: Optional[Actions] = None
    packages: Optional[Actions] = None
    pages: Optional[Actions] = None
    pull_requests: Optional[Actions] = None
    repository_hooks: Optional[Actions] = None
    repository_projects: Optional[Actions] = None
    secret_scanning_alerts: Optional[Actions] = None
    secrets: Optional[Actions] = None
    security_events: Optional[Actions] = None
    security_scanning_alert: Optional[Actions] = None
    single_file: Optional[Actions] = None
    statuses: Optional[Actions] = None
    team_discussions: Optional[Actions] = None
    vulnerability_alerts: Optional[Actions] = None
    workflows: Optional[Actions] = None


class Event(str, Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_run = "workflow_run"


class AuthorAssociation(str, Enum):
    COLLABORATOR = "COLLABORATOR"
    CONTRIBUTOR = "CONTRIBUTOR"
    FIRST_TIMER = "FIRST_TIMER"
    FIRST_TIME_CONTRIBUTOR = "FIRST_TIME_CONTRIBUTOR"
    MANNEQUIN = "MANNEQUIN"
    MEMBER = "MEMBER"
    NONE = "NONE"
    OWNER = "OWNER"


class MergeMethod(str, Enum):
    merge = "merge"
    squash = "squash"
    rebase = "rebase"


class PullRequestReviewsEnforcementLevel(str, Enum):
    off = "off"
    non_admins = "non_admins"
    everyone = "everyone"


class BranchProtectionRule(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    repository_id: Optional[int] = None
    name: Optional[str] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    pull_request_reviews_enforcement_level: Optional[
        PullRequestReviewsEnforcementLevel
    ] = None
    required_approving_review_count: Optional[int] = None
    dismiss_stale_reviews_on_push: Optional[bool] = None
    require_code_owner_review: Optional[bool] = None
    authorized_dismissal_actors_only: Optional[bool] = None
    ignore_approvals_from_contributors: Optional[bool] = None
    required_status_checks: Optional[List[str]] = None
    required_status_checks_enforcement_level: Optional[
        PullRequestReviewsEnforcementLevel
    ] = None
    strict_required_status_checks_policy: Optional[bool] = None
    signature_requirement_enforcement_level: Optional[
        PullRequestReviewsEnforcementLevel
    ] = None
    linear_history_requirement_enforcement_level: Optional[
        PullRequestReviewsEnforcementLevel
    ] = None
    admin_enforced: Optional[bool] = None
    allow_force_pushes_enforcement_level: Optional[
        PullRequestReviewsEnforcementLevel
    ] = None
    allow_deletions_enforcement_level: Optional[
        PullRequestReviewsEnforcementLevel
    ] = None
    merge_queue_enforcement_level: Optional[PullRequestReviewsEnforcementLevel] = None
    required_deployments_enforcement_level: Optional[
        PullRequestReviewsEnforcementLevel
    ] = None
    required_conversation_resolution_level: Optional[
        PullRequestReviewsEnforcementLevel
    ] = None
    authorized_actors_only: Optional[bool] = None
    authorized_actor_names: Optional[List[str]] = None


class CheckRunDeployment(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    task: Optional[str] = None
    original_environment: Optional[str] = None
    environment: Optional[str] = None
    description: Optional[Optional[str]] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    statuses_url: Optional[AnyUrl] = None
    repository_url: Optional[AnyUrl] = None


class Committer(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(None, description="The git author's name.")
    email: Optional[Optional[EmailStr]] = Field(
        None, description="The git author's email address."
    )
    date: Optional[datetime] = None
    username: Optional[str] = None


class Status10(str, Enum):
    requested = "requested"
    in_progress = "in_progress"
    completed = "completed"
    queued = "queued"


class Category3(From):
    pass


class State13(str, Enum):
    open = "open"
    locked = "locked"
    converting = "converting"


class GithubOrg(BaseModel):
    class Config:
        extra = Extra.forbid

    login: Optional[str] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    name: Optional[str] = None
    email: Optional[Any] = None
    avatar_url: Optional[AnyUrl] = None
    gravatar_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    followers_url: Optional[AnyUrl] = None
    following_url: Optional[str] = None
    gists_url: Optional[str] = None
    starred_url: Optional[str] = None
    subscriptions_url: Optional[AnyUrl] = None
    organizations_url: Optional[AnyUrl] = None
    repos_url: Optional[AnyUrl] = None
    events_url: Optional[str] = None
    received_events_url: Optional[AnyUrl] = None
    type: Optional[str] = None
    site_admin: Optional[bool] = None


class InstallationLite(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="The ID of the installation.")
    node_id: Optional[str] = None


class TargetType(str, Enum):
    User = "User"
    Organization = "Organization"


class Permissions2(BaseModel):
    class Config:
        extra = Extra.forbid

    actions: Optional[Actions] = None
    administration: Optional[Actions] = None
    checks: Optional[Actions] = None
    content_references: Optional[Actions] = None
    contents: Optional[Actions] = None
    deployments: Optional[Actions] = None
    discussions: Optional[Actions] = None
    emails: Optional[Actions] = None
    environments: Optional[Actions] = None
    issues: Optional[Actions] = None
    members: Optional[Actions] = None
    metadata: Optional[Actions] = None
    organization_administration: Optional[Actions] = None
    organization_events: Optional[Actions] = None
    organization_hooks: Optional[Actions] = None
    organization_packages: Optional[Actions] = None
    organization_plan: Optional[Actions] = None
    organization_projects: Optional[Actions] = None
    organization_secrets: Optional[Actions] = None
    organization_self_hosted_runners: Optional[Actions] = None
    organization_user_blocking: Optional[Actions] = None
    packages: Optional[Actions] = None
    pages: Optional[Actions] = None
    pull_requests: Optional[Actions] = None
    repository_hooks: Optional[Actions] = None
    repository_projects: Optional[Actions] = None
    secret_scanning_alerts: Optional[Actions] = None
    secrets: Optional[Actions] = None
    security_events: Optional[Actions] = None
    security_scanning_alert: Optional[Actions] = None
    single_file: Optional[Actions] = None
    statuses: Optional[Actions] = None
    team_discussions: Optional[Actions] = None
    vulnerability_alerts: Optional[Actions] = None
    workflows: Optional[Actions] = None


class Event1(str, Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    content_reference = "content_reference"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_review = "deployment_review"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    merge_queue_entry = "merge_queue_entry"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    pull_request_review_thread = "pull_request_review_thread"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_dispatch = "repository_dispatch"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_dispatch = "workflow_dispatch"
    workflow_job = "workflow_job"
    workflow_run = "workflow_run"


class PullRequest9(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    diff_url: Optional[AnyUrl] = None
    patch_url: Optional[AnyUrl] = None
    merged_at: Optional[Optional[str]] = None


class Label(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    node_id: Optional[str] = None
    url: Optional[AnyUrl] = Field(None, description="URL for the label")
    name: Optional[str] = Field(None, description="The name of the label.")
    description: Optional[Optional[str]] = None
    color: Optional[str] = Field(
        None,
        description="6-character hex code, without the leading #, identifying the color",
    )
    default: Optional[bool] = None


class License(BaseModel):
    class Config:
        extra = Extra.forbid

    key: Optional[str] = None
    name: Optional[str] = None
    spdx_id: Optional[str] = None
    url: Optional[Optional[str]] = None
    node_id: Optional[str] = None


class Link(BaseModel):
    class Config:
        extra = Extra.forbid

    href: Optional[str] = None


class Account(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[str] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    login: Optional[str] = None
    organization_billing_email: Optional[str] = None


class Plan(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    name: Optional[str] = None
    description: Optional[str] = None
    monthly_price_in_cents: Optional[int] = None
    yearly_price_in_cents: Optional[int] = None
    price_model: Optional[str] = None
    has_free_trial: Optional[bool] = None
    unit_name: Optional[Optional[str]] = None
    bullets: Optional[List[str]] = None


class MarketplacePurchase(BaseModel):
    class Config:
        extra = Extra.forbid

    account: Optional[Account] = None
    billing_cycle: Optional[str] = None
    unit_count: Optional[int] = None
    on_free_trial: Optional[bool] = None
    free_trial_ends_on: Optional[Any] = None
    next_billing_date: Optional[str] = None
    plan: Optional[Plan] = None


class Organization(BaseModel):
    class Config:
        extra = Extra.forbid

    login: Optional[str] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    repos_url: Optional[AnyUrl] = None
    events_url: Optional[AnyUrl] = None
    hooks_url: Optional[AnyUrl] = None
    issues_url: Optional[AnyUrl] = None
    members_url: Optional[str] = None
    public_members_url: Optional[str] = None
    avatar_url: Optional[AnyUrl] = None
    description: Optional[Optional[str]] = None


class ProjectColumn(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    project_url: Optional[AnyUrl] = None
    cards_url: Optional[AnyUrl] = None
    id: Optional[int] = Field(
        None, description="The unique identifier of the project column"
    )
    node_id: Optional[str] = None
    name: Optional[str] = Field(None, description="Name of the project column")
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None


class ContentType3(str, Enum):
    DraftIssue = "DraftIssue"
    Issue = "Issue"
    PullRequest = "PullRequest"


class Links6(BaseModel):
    class Config:
        extra = Extra.forbid

    self: Optional[Link] = None
    html: Optional[Link] = None
    pull_request: Optional[Link] = None


class StartSide(Enum):
    LEFT = "LEFT"
    RIGHT = "RIGHT"
    NoneType_None = None


class Side(str, Enum):
    LEFT = "LEFT"
    RIGHT = "RIGHT"


class Links7(BaseModel):
    class Config:
        extra = Extra.forbid

    self: Optional[Link] = None
    html: Optional[Link] = None
    issue: Optional[Link] = None
    comments: Optional[Link] = None
    review_comments: Optional[Link] = None
    review_comment: Optional[Link] = None
    commits: Optional[Link] = None
    statuses: Optional[Link] = None


class Reactions(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    total_count: Optional[int] = None
    plus1: Optional[int] = Field(None, alias="+1")
    minus1: Optional[int] = Field(None, alias="-1")
    laugh: Optional[int] = None
    hooray: Optional[int] = None
    confused: Optional[int] = None
    heart: Optional[int] = None
    rocket: Optional[int] = None
    eyes: Optional[int] = None


class RepoRef(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    url: Optional[AnyUrl] = None
    name: Optional[str] = None


class Visibility(str, Enum):
    public = "public"
    private = "private"
    internal = "internal"


class Permissions3(BaseModel):
    class Config:
        extra = Extra.forbid

    pull: Optional[bool] = None
    push: Optional[bool] = None
    admin: Optional[bool] = None
    maintain: Optional[bool] = None
    triage: Optional[bool] = None


class Links8(Links7):
    pass


class SponsorshipTier(BaseModel):
    class Config:
        extra = Extra.forbid

    node_id: Optional[str] = None
    created_at: Optional[str] = None
    description: Optional[str] = None
    monthly_price_in_cents: Optional[int] = None
    monthly_price_in_dollars: Optional[int] = None
    name: Optional[str] = None
    is_one_time: Optional[bool] = None
    is_custom_ammount: Optional[bool] = None


class Privacy1(str, Enum):
    open = "open"
    closed = "closed"
    secret = "secret"


class Parent1(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(None, description="Name of the team")
    id: Optional[int] = Field(None, description="Unique identifier of the team")
    node_id: Optional[str] = None
    slug: Optional[str] = None
    description: Optional[Optional[str]] = Field(
        None, description="Description of the team"
    )
    privacy: Optional[Privacy1] = None
    url: Optional[AnyUrl] = Field(None, description="URL for the team")
    html_url: Optional[AnyUrl] = None
    members_url: Optional[str] = None
    repositories_url: Optional[AnyUrl] = None
    permission: Optional[str] = Field(
        None, description="Permission that the team will have for its repositories"
    )


class Team(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(None, description="Name of the team")
    id: Optional[int] = Field(None, description="Unique identifier of the team")
    node_id: Optional[str] = None
    slug: Optional[str] = None
    description: Optional[Optional[str]] = Field(
        None, description="Description of the team"
    )
    privacy: Optional[Privacy1] = None
    url: Optional[AnyUrl] = Field(None, description="URL for the team")
    html_url: Optional[AnyUrl] = None
    members_url: Optional[str] = None
    repositories_url: Optional[AnyUrl] = None
    permission: Optional[str] = Field(
        None, description="Permission that the team will have for its repositories"
    )
    parent: Optional[Parent1] = None


class Type(str, Enum):
    Bot = "Bot"
    User = "User"
    Organization = "Organization"


class User(BaseModel):
    class Config:
        extra = Extra.forbid

    login: Optional[str] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    name: Optional[str] = None
    email: Optional[Optional[str]] = None
    avatar_url: Optional[AnyUrl] = None
    gravatar_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    followers_url: Optional[AnyUrl] = None
    following_url: Optional[str] = None
    gists_url: Optional[str] = None
    starred_url: Optional[str] = None
    subscriptions_url: Optional[AnyUrl] = None
    organizations_url: Optional[AnyUrl] = None
    repos_url: Optional[AnyUrl] = None
    events_url: Optional[str] = None
    received_events_url: Optional[AnyUrl] = None
    type: Optional[Type] = None
    site_admin: Optional[bool] = None


class WebhookEvent(str, Enum):
    branch_protection_rule = "branch_protection_rule"
    check_run = "check_run"
    check_suite = "check_suite"
    code_scanning_alert = "code_scanning_alert"
    commit_comment = "commit_comment"
    create = "create"
    delete = "delete"
    deployment = "deployment"
    deployment_status = "deployment_status"
    deploy_key = "deploy_key"
    discussion = "discussion"
    discussion_comment = "discussion_comment"
    fork = "fork"
    gollum = "gollum"
    issues = "issues"
    issue_comment = "issue_comment"
    label = "label"
    member = "member"
    membership = "membership"
    meta = "meta"
    milestone = "milestone"
    organization = "organization"
    org_block = "org_block"
    package = "package"
    page_build = "page_build"
    project = "project"
    project_card = "project_card"
    project_column = "project_column"
    public = "public"
    pull_request = "pull_request"
    pull_request_review = "pull_request_review"
    pull_request_review_comment = "pull_request_review_comment"
    pull_request_review_thread = "pull_request_review_thread"
    push = "push"
    registry_package = "registry_package"
    release = "release"
    repository = "repository"
    repository_import = "repository_import"
    repository_vulnerability_alert = "repository_vulnerability_alert"
    secret_scanning_alert = "secret_scanning_alert"
    star = "star"
    status = "status"
    team = "team"
    team_add = "team_add"
    watch = "watch"
    workflow_job = "workflow_job"
    workflow_run = "workflow_run"


class WebhookEvents(BaseModel):
    __root__: Optional[Union[List[WebhookEvent], List[str]]] = Field(
        None, title="Webhook Events"
    )


class Conclusion15(Enum):
    success = "success"
    failure = "failure"
    NoneType_None = None


class Head6(BaseModel):
    class Config:
        extra = Extra.forbid

    ref: Optional[str] = None
    sha: Optional[str] = None
    repo: Optional[RepoRef] = None


class Base7(Head6):
    pass


class PullRequest10(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[float] = None
    number: Optional[float] = None
    head: Optional[Head6] = None
    base: Optional[Base7] = None


class Status12(str, Enum):
    requested = "requested"
    in_progress = "in_progress"
    completed = "completed"
    queued = "queued"
    waiting = "waiting"


class Conclusion17(str, Enum):
    failure = "failure"
    skipped = "skipped"
    success = "success"


class WorkflowStepCompleted(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = None
    status: Optional[Literal["completed"]] = None
    conclusion: Optional[Conclusion17] = None
    number: Optional[int] = None
    started_at: Optional[str] = None
    completed_at: Optional[str] = None


class WorkflowStepInProgress(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = None
    status: Optional[Literal["in_progress"]] = None
    conclusion: Optional[Any] = None
    number: Optional[int] = None
    started_at: Optional[str] = None
    completed_at: Optional[Any] = None


class WorkflowStep(BaseModel):
    __root__: Optional[Union[WorkflowStepInProgress, WorkflowStepCompleted]] = Field(
        None, title="Workflow Step"
    )


class Workflow(BaseModel):
    class Config:
        extra = Extra.forbid

    badge_url: Optional[AnyUrl] = None
    created_at: Optional[datetime] = None
    html_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    name: Optional[str] = None
    node_id: Optional[str] = None
    path: Optional[str] = None
    state: Optional[str] = None
    updated_at: Optional[datetime] = None
    url: Optional[AnyUrl] = None


class Alert(BaseModel):
    class Config:
        extra = Extra.forbid

    number: Optional[int] = Field(None, description="The code scanning alert number.")
    created_at: Optional[datetime] = Field(
        None,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
    )
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = Field(
        None, description="The GitHub URL of the alert resource."
    )
    instances: Optional[List[AlertInstance]] = None
    most_recent_instance: Optional[AlertInstance] = None
    state: Optional[State] = Field(None, description="State of a code scanning alert.")
    dismissed_by: Optional[Optional[User]] = None
    dismissed_at: Optional[Optional[str]] = Field(
        None,
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    dismissed_reason: Optional[DismissedReason] = Field(
        None,
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
    )
    rule: Optional[Rule] = None
    tool: Optional[Tool] = None


class Instance(AlertInstance):
    state: Optional[Literal["dismissed"]] = None


class Alert1(BaseModel):
    class Config:
        extra = Extra.forbid

    number: Optional[int] = Field(None, description="The code scanning alert number.")
    created_at: Optional[datetime] = Field(
        None,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
    )
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = Field(
        None, description="The GitHub URL of the alert resource."
    )
    instances: Optional[List[Instance]] = None
    most_recent_instance: Optional[AlertInstance] = None
    state: Optional[Literal["dismissed"]] = Field(
        None, description="State of a code scanning alert."
    )
    dismissed_by: Optional[User] = None
    dismissed_at: Optional[datetime] = Field(
        None,
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    dismissed_reason: Optional[DismissedReason] = Field(
        None,
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
    )
    rule: Optional[Rule1] = None
    tool: Optional[Tool1] = None


class Instance1(AlertInstance):
    state: Optional[State1] = None


class Alert2(BaseModel):
    class Config:
        extra = Extra.forbid

    number: Optional[int] = Field(None, description="The code scanning alert number.")
    created_at: Optional[datetime] = Field(
        None,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
    )
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = Field(
        None, description="The GitHub URL of the alert resource."
    )
    instances: Optional[List[Instance1]] = None
    most_recent_instance: Optional[AlertInstance] = None
    state: Optional[State1] = Field(None, description="State of a code scanning alert.")
    dismissed_by: Optional[Any] = None
    dismissed_at: Optional[Any] = Field(
        None,
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    dismissed_reason: Optional[Any] = Field(
        None,
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
    )
    rule: Optional[Rule2] = None
    tool: Optional[Tool2] = None


class Instance2(AlertInstance):
    state: Optional[Literal["fixed"]] = None


class Alert3(BaseModel):
    class Config:
        extra = Extra.forbid

    number: Optional[int] = Field(None, description="The code scanning alert number.")
    created_at: Optional[datetime] = Field(
        None,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
    )
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = Field(
        None, description="The GitHub URL of the alert resource."
    )
    instances: Optional[List[Instance2]] = None
    state: Optional[Literal["fixed"]] = Field(
        None, description="State of a code scanning alert."
    )
    dismissed_by: Optional[Optional[User]] = None
    dismissed_at: Optional[Optional[str]] = Field(
        None,
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    dismissed_reason: Optional[DismissedReason] = Field(
        None,
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
    )
    rule: Optional[Rule3] = None
    tool: Optional[Tool3] = None
    most_recent_instance: Optional[AlertInstance] = None
    instances_url: Optional[AnyUrl] = None


class Instance3(AlertInstance):
    state: Optional[Literal["open"]] = None


class Alert4(BaseModel):
    class Config:
        extra = Extra.forbid

    number: Optional[int] = Field(None, description="The code scanning alert number.")
    created_at: Optional[datetime] = Field(
        None,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
    )
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = Field(
        None, description="The GitHub URL of the alert resource."
    )
    instances: Optional[List[Instance3]] = None
    most_recent_instance: Optional[AlertInstance] = None
    state: Optional[State] = Field(None, description="State of a code scanning alert.")
    dismissed_by: Optional[Any] = None
    dismissed_at: Optional[Any] = Field(
        None,
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    dismissed_reason: Optional[Any] = Field(
        None,
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
    )
    rule: Optional[Rule4] = None
    tool: Optional[Tool4] = None


class Instance4(Instance3):
    pass


class Alert5(BaseModel):
    class Config:
        extra = Extra.forbid

    number: Optional[int] = Field(None, description="The code scanning alert number.")
    created_at: Optional[datetime] = Field(
        None,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
    )
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = Field(
        None, description="The GitHub URL of the alert resource."
    )
    instances: Optional[List[Instance4]] = None
    most_recent_instance: Optional[AlertInstance] = None
    state: Optional[Literal["open"]] = Field(
        None, description="State of a code scanning alert."
    )
    dismissed_by: Optional[Any] = None
    dismissed_at: Optional[Any] = Field(
        None,
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    dismissed_reason: Optional[Any] = Field(
        None,
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
    )
    rule: Optional[Rule5] = None
    tool: Optional[Tool5] = None


class Comment(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    id: Optional[int] = Field(None, description="The ID of the commit comment.")
    node_id: Optional[str] = Field(
        None, description="The node ID of the commit comment."
    )
    user: Optional[User] = None
    position: Optional[Optional[int]] = Field(
        None, description="The line index in the diff to which the comment applies."
    )
    line: Optional[Optional[int]] = Field(
        None,
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
    )
    path: Optional[Optional[str]] = Field(
        None, description="The relative path of the file to which the comment applies."
    )
    commit_id: Optional[str] = Field(
        None, description="The SHA of the commit to which the comment applies."
    )
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    author_association: Optional[AuthorAssociation] = None
    body: Optional[str] = Field(None, description="The text of the comment.")


class Answer(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    node_id: Optional[str] = None
    html_url: Optional[str] = None
    parent_id: Optional[Any] = None
    child_comment_count: Optional[int] = None
    repository_url: Optional[str] = None
    discussion_id: Optional[int] = None
    author_association: Optional[AuthorAssociation] = None
    user: Optional[User] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    body: Optional[str] = None


class OldAnswer(Answer):
    pass


class Comment1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    node_id: Optional[str] = None
    html_url: Optional[str] = None
    parent_id: Optional[Optional[int]] = None
    child_comment_count: Optional[int] = None
    repository_url: Optional[str] = None
    discussion_id: Optional[int] = None
    author_association: Optional[AuthorAssociation] = None
    user: Optional[User] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    body: Optional[str] = None
    reactions: Optional[Reactions] = None


class Comment2(Comment1):
    pass


class Comment3(Comment1):
    pass


class GithubAppAuthorizationRevoked(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["revoked"]] = None
    sender: Optional[User] = None


class GithubAppAuthorizationEvent(BaseModel):
    __root__: Optional[GithubAppAuthorizationRevoked] = None


class MarketplacePurchaseModel(MarketplacePurchase):
    class Config:
        extra = Extra.forbid

    next_billing_date: Optional[str] = None


class MarketplacePurchaseCancelled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["cancelled"]] = None
    effective_date: Optional[str] = None
    sender: Optional[Sender] = None
    marketplace_purchase: Optional[MarketplacePurchaseModel] = None
    previous_marketplace_purchase: Optional[MarketplacePurchase] = None


class MarketplacePurchase1(MarketplacePurchase):
    next_billing_date: Optional[str] = None


class MarketplacePurchaseChanged(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["changed"]] = None
    effective_date: Optional[str] = None
    sender: Optional[Sender1] = None
    marketplace_purchase: Optional[MarketplacePurchase1] = None
    previous_marketplace_purchase: Optional[MarketplacePurchase] = None


class MarketplacePurchase2(MarketplacePurchase1):
    pass


class MarketplacePurchasePendingChange(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["pending_change"]] = None
    effective_date: Optional[str] = None
    sender: Optional[Sender2] = None
    marketplace_purchase: Optional[MarketplacePurchase2] = None
    previous_marketplace_purchase: Optional[MarketplacePurchase] = None


class MarketplacePurchase3(MarketplacePurchase1):
    pass


class MarketplacePurchasePendingChangeCancelled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["pending_change_cancelled"]] = None
    effective_date: Optional[str] = None
    sender: Optional[Sender3] = None
    marketplace_purchase: Optional[MarketplacePurchase3] = None
    previous_marketplace_purchase: Optional[MarketplacePurchase] = None


class MarketplacePurchase4(MarketplacePurchase1):
    pass


class MarketplacePurchasePurchased(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["purchased"]] = None
    effective_date: Optional[str] = None
    sender: Optional[Sender4] = None
    marketplace_purchase: Optional[MarketplacePurchase4] = None
    previous_marketplace_purchase: Optional[MarketplacePurchase] = None


class MarketplacePurchaseEvent(BaseModel):
    __root__: Optional[
        Union[
            MarketplacePurchaseCancelled,
            MarketplacePurchaseChanged,
            MarketplacePurchasePendingChange,
            MarketplacePurchasePendingChangeCancelled,
            MarketplacePurchasePurchased,
        ]
    ] = None


class MembershipAdded(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["added"]] = None
    scope: Optional[Literal["team"]] = Field(
        None, description="The scope of the membership. Currently, can only be `team`."
    )
    member: Optional[User] = Field(
        None,
        description="The [user](https://docs.github.com/en/rest/reference/users) that was added or removed.",
    )
    sender: Optional[User] = None
    team: Optional[Team] = Field(
        None,
        description="The [team](https://docs.github.com/en/rest/reference/teams) for the membership.",
    )
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class MembershipRemoved(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["removed"]] = None
    scope: Optional[Scope] = Field(
        None, description="The scope of the membership. Currently, can only be `team`."
    )
    member: Optional[User] = Field(
        None,
        description="The [user](https://docs.github.com/en/rest/reference/users) that was added or removed.",
    )
    sender: Optional[User] = None
    team: Optional[Union[Team, TeamItem]] = Field(
        None,
        description="The [team](https://docs.github.com/en/rest/reference/teams) for the membership.",
    )
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class MembershipEvent(BaseModel):
    __root__: Optional[Union[MembershipAdded, MembershipRemoved]] = None


class Hook(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[str] = None
    id: Optional[int] = None
    name: Optional[str] = None
    active: Optional[bool] = None
    events: Optional[WebhookEvents] = None
    config: Optional[Config] = None
    updated_at: Optional[str] = None
    created_at: Optional[str] = None


class OrgBlockBlocked(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["blocked"]] = None
    blocked_user: Optional[User] = Field(
        None, description="Information about the user that was blocked or unblocked."
    )
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class OrgBlockUnblocked(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unblocked"]] = None
    blocked_user: Optional[User] = Field(
        None, description="Information about the user that was blocked or unblocked."
    )
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class OrgBlockEvent(BaseModel):
    __root__: Optional[Union[OrgBlockBlocked, OrgBlockUnblocked]] = None


class Invitation(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[float] = None
    node_id: Optional[str] = None
    login: Optional[str] = None
    email: Optional[Optional[str]] = None
    role: Optional[str] = None
    created_at: Optional[datetime] = None
    failed_at: Optional[Optional[datetime]] = None
    failed_reason: Optional[Optional[str]] = None
    inviter: Optional[User] = None
    team_count: Optional[float] = None
    invitation_teams_url: Optional[AnyUrl] = None


class OrganizationMemberInvited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["member_invited"]] = None
    invitation: Optional[Invitation] = Field(
        None,
        description="The invitation for the user or email if the action is `member_invited`.",
    )
    user: Optional[User] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Release(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    tag_name: Optional[str] = None
    target_commitish: Optional[str] = None
    name: Optional[str] = None
    draft: Optional[bool] = None
    author: Optional[User] = None
    prerelease: Optional[bool] = None
    created_at: Optional[str] = None
    published_at: Optional[str] = None


class PackageVersion(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    version: Optional[str] = None
    summary: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    body: Optional[str] = None
    body_html: Optional[str] = None
    release: Optional[Release] = None
    manifest: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    tag_name: Optional[str] = None
    target_commitish: Optional[str] = None
    target_oid: Optional[str] = None
    draft: Optional[bool] = None
    prerelease: Optional[bool] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    metadata: Optional[List] = None
    docker_metadata: Optional[List] = None
    package_files: Optional[List[PackageFile]] = None
    author: Optional[User] = None
    source_url: Optional[str] = None
    installation_command: Optional[str] = None


class Package(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    description: Optional[Optional[str]] = None
    ecosystem: Optional[str] = None
    package_type: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    owner: Optional[User] = None
    package_version: Optional[PackageVersion] = None
    registry: Optional[Registry] = None


class Release1(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    tag_name: Optional[str] = None
    target_commitish: Optional[str] = None
    name: Optional[str] = None
    draft: Optional[bool] = None
    author: Optional[User] = None
    prerelease: Optional[bool] = None
    created_at: Optional[str] = None
    published_at: Optional[str] = None


class PackageVersion1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    version: Optional[str] = None
    summary: Optional[str] = None
    name: Optional[str] = None
    description: Optional[str] = None
    body: Optional[str] = None
    body_html: Optional[str] = None
    release: Optional[Release1] = None
    manifest: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    tag_name: Optional[str] = None
    target_commitish: Optional[str] = None
    target_oid: Optional[str] = None
    draft: Optional[bool] = None
    prerelease: Optional[bool] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    metadata: Optional[List] = None
    docker_metadata: Optional[List] = None
    package_files: Optional[List[PackageFile1]] = None
    author: Optional[User] = None
    source_url: Optional[AnyUrl] = None
    installation_command: Optional[str] = None


class Package1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    name: Optional[str] = None
    namespace: Optional[str] = None
    description: Optional[Optional[str]] = None
    ecosystem: Optional[str] = None
    package_type: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    owner: Optional[User] = None
    package_version: Optional[PackageVersion1] = None
    registry: Optional[Registry1] = None


class Build(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    status: Optional[str] = None
    error: Optional[Error] = None
    pusher: Optional[User] = None
    commit: Optional[str] = None
    duration: Optional[int] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None


class Hook1(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[str] = None
    id: Optional[int] = None
    name: Optional[str] = None
    active: Optional[bool] = None
    app_id: Optional[int] = Field(
        None,
        description="When you register a new GitHub App, GitHub sends a ping event to the **webhook URL** you specified during registration. The event contains the `app_id`, which is required for [authenticating](https://docs.github.com/en/apps/building-integrations/setting-up-and-registering-github-apps/about-authentication-options-for-github-apps) an app.",
    )
    events: Optional[WebhookEvents] = None
    config: Optional[Config1] = None
    updated_at: Optional[str] = None
    created_at: Optional[str] = None
    url: Optional[AnyUrl] = None
    test_url: Optional[AnyUrl] = None
    ping_url: Optional[AnyUrl] = None
    deliveries_url: Optional[AnyUrl] = None
    last_response: Optional[LastResponse] = None


class Links(BaseModel):
    class Config:
        extra = Extra.forbid

    html: Optional[Link] = None
    pull_request: Optional[Link] = None


class Review(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="Unique identifier of the review")
    node_id: Optional[str] = None
    user: Optional[User] = None
    body: Optional[Optional[str]] = Field(None, description="The text of the review.")
    commit_id: Optional[str] = Field(None, description="A commit SHA for the review.")
    submitted_at: Optional[datetime] = None
    state: Optional[Literal["dismissed"]] = None
    html_url: Optional[AnyUrl] = None
    pull_request_url: Optional[AnyUrl] = None
    author_association: Optional[AuthorAssociation] = None
    links: Optional[Links] = Field(None, alias="_links")


class Links1(Links):
    pass


class Review1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="Unique identifier of the review")
    node_id: Optional[str] = None
    user: Optional[User] = None
    body: Optional[Optional[str]] = Field(None, description="The text of the review.")
    commit_id: Optional[str] = Field(None, description="A commit SHA for the review.")
    submitted_at: Optional[datetime] = None
    state: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    pull_request_url: Optional[AnyUrl] = None
    author_association: Optional[AuthorAssociation] = None
    links: Optional[Links1] = Field(None, alias="_links")


class Links2(Links):
    pass


class Review2(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="Unique identifier of the review")
    node_id: Optional[str] = None
    user: Optional[User] = None
    body: Optional[Optional[str]] = Field(None, description="The text of the review.")
    commit_id: Optional[str] = Field(None, description="A commit SHA for the review.")
    submitted_at: Optional[datetime] = None
    state: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    pull_request_url: Optional[AnyUrl] = None
    author_association: Optional[AuthorAssociation] = None
    links: Optional[Links2] = Field(None, alias="_links")


class Links3(Links7):
    pass


class Links4(Links7):
    pass


class Links5(Links7):
    pass


class From1(BaseModel):
    class Config:
        extra = Extra.forbid

    user: Optional[User] = None


class Owner(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[From1] = Field(None, alias="from")


class Changes29(BaseModel):
    class Config:
        extra = Extra.forbid

    owner: Optional[Owner] = None


class Alert12(BaseModel):
    class Config:
        extra = Extra.forbid

    number: Optional[int] = None
    secret_type: Optional[str] = None
    resolution: Optional[Resolution] = None
    resolved_by: Optional[User] = None
    resolved_at: Optional[str] = None


class Sponsorship(BaseModel):
    class Config:
        extra = Extra.forbid

    node_id: Optional[str] = None
    created_at: Optional[str] = None
    sponsorable: Optional[User] = None
    sponsor: Optional[User] = None
    privacy_level: Optional[str] = None
    tier: Optional[SponsorshipTier] = None


class SponsorshipCancelled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["cancelled"]] = None
    sponsorship: Optional[Sponsorship] = None
    sender: Optional[User] = None


class Sponsorship1(Sponsorship):
    pass


class SponsorshipCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    sponsorship: Optional[Sponsorship1] = None
    sender: Optional[User] = None


class Sponsorship2(Sponsorship):
    pass


class SponsorshipEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    sponsorship: Optional[Sponsorship2] = None
    changes: Optional[Changes30] = None
    sender: Optional[User] = None


class Sponsorship3(Sponsorship):
    pass


class SponsorshipPendingCancellation(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["pending_cancellation"]] = None
    sponsorship: Optional[Sponsorship3] = None
    effective_date: Optional[str] = Field(
        None,
        description="The `pending_cancellation` and `pending_tier_change` event types will include the date the cancellation or tier change will take effect.",
    )
    sender: Optional[User] = None


class Sponsorship4(Sponsorship):
    pass


class Tier(BaseModel):
    class Config:
        extra = Extra.forbid

    from_: Optional[SponsorshipTier] = Field(None, alias="from")


class Changes31(BaseModel):
    class Config:
        extra = Extra.forbid

    tier: Optional[Tier] = None


class SponsorshipPendingTierChange(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["pending_tier_change"]] = None
    sponsorship: Optional[Sponsorship4] = None
    effective_date: Optional[str] = Field(
        None,
        description="The `pending_cancellation` and `pending_tier_change` event types will include the date the cancellation or tier change will take effect.",
    )
    changes: Optional[Changes31] = None
    sender: Optional[User] = None


class Sponsorship5(Sponsorship):
    pass


class Tier1(Tier):
    pass


class Changes32(BaseModel):
    class Config:
        extra = Extra.forbid

    tier: Optional[Tier1] = None


class SponsorshipTierChanged(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["tier_changed"]] = None
    sponsorship: Optional[Sponsorship5] = None
    changes: Optional[Changes32] = None
    sender: Optional[User] = None


class SponsorshipEvent(BaseModel):
    __root__: Optional[
        Union[
            SponsorshipCancelled,
            SponsorshipCreated,
            SponsorshipEdited,
            SponsorshipPendingCancellation,
            SponsorshipPendingTierChange,
            SponsorshipTierChanged,
        ]
    ] = None


class Author(Committer):
    date: Optional[str] = None


class Committer1(Author):
    pass


class Commit2(BaseModel):
    class Config:
        extra = Extra.forbid

    author: Optional[Author] = None
    committer: Optional[Committer1] = None
    message: Optional[str] = None
    tree: Optional[Tree] = None
    url: Optional[AnyUrl] = None
    comment_count: Optional[int] = None
    verification: Optional[Verification] = None


class Commit1(BaseModel):
    class Config:
        extra = Extra.forbid

    sha: Optional[str] = None
    node_id: Optional[str] = None
    commit: Optional[Commit2] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    comments_url: Optional[AnyUrl] = None
    author: Optional[Optional[User]] = None
    committer: Optional[Optional[User]] = None
    parents: Optional[List[Parent]] = None


class WorkflowJob2(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    run_id: Optional[float] = None
    run_url: Optional[AnyUrl] = None
    run_attempt: Optional[int] = None
    head_sha: Optional[str] = None
    node_id: Optional[str] = None
    name: Optional[str] = None
    check_run_url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    url: Optional[AnyUrl] = None
    status: Optional[Literal["queued"]] = None
    steps: Optional[List[WorkflowStep]] = None
    conclusion: Optional[Any] = None
    labels: Optional[List[str]] = None
    runner_id: Optional[Optional[int]] = None
    runner_name: Optional[Optional[str]] = None
    runner_group_id: Optional[Optional[int]] = None
    runner_group_name: Optional[Optional[str]] = None
    started_at: Optional[datetime] = None
    completed_at: Optional[Any] = None


class App(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="Unique identifier of the GitHub app")
    slug: Optional[str] = Field(None, description="The slug name of the GitHub app")
    node_id: Optional[str] = None
    owner: Optional[User] = None
    name: Optional[str] = Field(None, description="The name of the GitHub app")
    description: Optional[Optional[str]] = None
    external_url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    permissions: Optional[Permissions1] = Field(
        None, description="The set of permissions for the GitHub app"
    )
    events: Optional[List[Event]] = Field(
        None, description="The list of events for the GitHub app"
    )


class AutoMerge(BaseModel):
    class Config:
        extra = Extra.forbid

    enabled_by: Optional[User] = None
    merge_method: Optional[MergeMethod] = Field(
        None, description="The merge method to use."
    )
    commit_title: Optional[str] = Field(
        None, description="Title for the merge commit message."
    )
    commit_message: Optional[str] = Field(
        None, description="Commit message for the merge commit."
    )


class Head3(Head6):
    pass


class Base4(Head6):
    pass


class CheckRunPullRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[int] = None
    number: Optional[int] = None
    head: Optional[Head3] = None
    base: Optional[Base4] = None


class CommitSimple(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[str] = None
    tree_id: Optional[str] = None
    message: Optional[str] = None
    timestamp: Optional[str] = None
    author: Optional[Committer] = None
    committer: Optional[Committer] = None


class Commit(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[str] = None
    tree_id: Optional[str] = None
    distinct: Optional[bool] = Field(
        None,
        description="Whether this commit is distinct from any that have been pushed before.",
    )
    message: Optional[str] = Field(None, description="The commit message.")
    timestamp: Optional[datetime] = Field(
        None, description="The ISO 8601 timestamp of the commit."
    )
    url: Optional[AnyUrl] = Field(
        None, description="URL that points to the commit API resource."
    )
    author: Optional[Committer] = None
    committer: Optional[Committer] = None
    added: Optional[List[str]] = Field(
        None, description="An array of files added in the commit."
    )
    modified: Optional[List[str]] = Field(
        None, description="An array of files modified by the commit."
    )
    removed: Optional[List[str]] = Field(
        None, description="An array of files removed in the commit."
    )


class DeploymentWorkflowRun(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    name: Optional[str] = None
    node_id: Optional[str] = None
    head_branch: Optional[str] = None
    head_sha: Optional[str] = None
    run_number: Optional[int] = None
    event: Optional[str] = None
    status: Optional[Status10] = None
    conclusion: Optional[Conclusion1] = None
    workflow_id: Optional[int] = None
    check_suite_id: Optional[int] = None
    check_suite_node_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    actor: Optional[User] = None
    triggering_actor: Optional[User] = None
    run_attempt: Optional[int] = None
    run_started_at: Optional[datetime] = None


class Deployment(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    sha: Optional[str] = None
    ref: Optional[str] = None
    task: Optional[str] = None
    payload: Optional[Dict[str, Any]] = None
    original_environment: Optional[str] = None
    environment: Optional[str] = None
    transient_environment: Optional[bool] = None
    production_environment: Optional[bool] = None
    description: Optional[Optional[str]] = None
    creator: Optional[User] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    statuses_url: Optional[AnyUrl] = None
    repository_url: Optional[AnyUrl] = None
    performed_via_github_app: Optional[Optional[App]] = None


class Discussion(BaseModel):
    class Config:
        extra = Extra.forbid

    repository_url: Optional[str] = None
    category: Optional[Category3] = None
    answer_html_url: Optional[Optional[str]] = None
    answer_chosen_at: Optional[Optional[str]] = None
    answer_chosen_by: Optional[Optional[User]] = None
    html_url: Optional[str] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    number: Optional[int] = None
    title: Optional[str] = None
    user: Optional[User] = None
    state: Optional[State13] = None
    locked: Optional[bool] = None
    comments: Optional[int] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    author_association: Optional[AuthorAssociation] = None
    active_lock_reason: Optional[Optional[str]] = None
    body: Optional[str] = None
    reactions: Optional[Reactions] = None


class Installation(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="The ID of the installation.")
    account: Optional[User] = None
    repository_selection: Optional[RepositorySelection] = Field(
        None,
        description="Describe whether all repositories have been selected or there's a selection involved",
    )
    access_tokens_url: Optional[AnyUrl] = None
    repositories_url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    app_id: Optional[int] = None
    app_slug: Optional[str] = None
    target_id: Optional[int] = Field(
        None,
        description="The ID of the user or organization this token is being scoped to.",
    )
    target_type: Optional[TargetType] = None
    permissions: Optional[Permissions2] = None
    events: Optional[List[Event1]] = None
    created_at: Optional[Union[datetime, int]] = None
    updated_at: Optional[Union[datetime, int]] = None
    single_file_name: Optional[Optional[str]] = None
    has_multiple_single_files: Optional[bool] = None
    single_file_paths: Optional[List[str]] = None
    suspended_by: Optional[Optional[User]] = None
    suspended_at: Optional[Optional[str]] = None


class IssueComment(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = Field(None, description="URL for the issue comment")
    html_url: Optional[AnyUrl] = None
    issue_url: Optional[AnyUrl] = None
    id: Optional[int] = Field(
        None, description="Unique identifier of the issue comment"
    )
    node_id: Optional[str] = None
    user: Optional[User] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    author_association: Optional[AuthorAssociation] = None
    body: Optional[str] = Field(None, description="Contents of the issue comment")
    reactions: Optional[Reactions] = None
    performed_via_github_app: Optional[Optional[App]] = None


class Membership(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    state: Optional[str] = None
    role: Optional[str] = None
    organization_url: Optional[AnyUrl] = None
    user: Optional[User] = None


class Milestone(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    labels_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    number: Optional[int] = Field(None, description="The number of the milestone.")
    title: Optional[str] = Field(None, description="The title of the milestone.")
    description: Optional[Optional[str]] = None
    creator: Optional[User] = None
    open_issues: Optional[int] = None
    closed_issues: Optional[int] = None
    state: Optional[State5] = Field(None, description="The state of the milestone.")
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    due_on: Optional[Optional[str]] = None
    closed_at: Optional[Optional[str]] = None


class ProjectCard(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    project_url: Optional[AnyUrl] = None
    column_url: Optional[AnyUrl] = None
    column_id: Optional[int] = None
    id: Optional[int] = Field(None, description="The project card's ID")
    node_id: Optional[str] = None
    note: Optional[Optional[str]] = None
    archived: Optional[bool] = Field(
        None, description="Whether or not the card is archived"
    )
    creator: Optional[User] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    content_url: Optional[AnyUrl] = None
    after_id: Optional[Optional[str]] = None


class Project(BaseModel):
    class Config:
        extra = Extra.forbid

    owner_url: Optional[AnyUrl] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    columns_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    name: Optional[str] = Field(None, description="Name of the project")
    body: Optional[Optional[str]] = Field(None, description="Body of the project")
    number: Optional[int] = None
    state: Optional[State5] = Field(
        None, description="State of the project; either 'open' or 'closed'"
    )
    creator: Optional[User] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None


class ProjectsV2Item(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[float] = None
    node_id: Optional[str] = None
    project_node_id: Optional[str] = None
    content_node_id: Optional[str] = None
    content_type: Optional[ContentType3] = None
    creator: Optional[User] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    archived_at: Optional[Optional[str]] = None


class PullRequestReviewComment(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = Field(
        None, description="URL for the pull request review comment"
    )
    pull_request_review_id: Optional[int] = Field(
        None,
        description="The ID of the pull request review to which the comment belongs.",
    )
    id: Optional[int] = Field(
        None, description="The ID of the pull request review comment."
    )
    node_id: Optional[str] = Field(
        None, description="The node ID of the pull request review comment."
    )
    diff_hunk: Optional[str] = Field(
        None, description="The diff of the line that the comment refers to."
    )
    path: Optional[str] = Field(
        None, description="The relative path of the file to which the comment applies."
    )
    position: Optional[Optional[int]] = Field(
        None, description="The line index in the diff to which the comment applies."
    )
    original_position: Optional[int] = Field(
        None,
        description="The index of the original line in the diff to which the comment applies.",
    )
    commit_id: Optional[str] = Field(
        None, description="The SHA of the commit to which the comment applies."
    )
    original_commit_id: Optional[str] = Field(
        None, description="The SHA of the original commit to which the comment applies."
    )
    user: Optional[User] = None
    body: Optional[str] = Field(None, description="The text of the comment.")
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    html_url: Optional[AnyUrl] = Field(
        None, description="HTML URL for the pull request review comment."
    )
    pull_request_url: Optional[AnyUrl] = Field(
        None, description="URL for the pull request that the review comment belongs to."
    )
    author_association: Optional[AuthorAssociation] = None
    links: Optional[Links6] = Field(None, alias="_links")
    reactions: Optional[Reactions] = None
    start_line: Optional[Optional[int]] = Field(
        None, description="The first line of the range for a multi-line comment."
    )
    original_start_line: Optional[Optional[int]] = Field(
        None, description="The first line of the range for a multi-line comment."
    )
    start_side: Optional[StartSide] = Field(
        "RIGHT",
        description="The side of the first line of the range for a multi-line comment.",
    )
    line: Optional[Optional[int]] = Field(
        None,
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
    )
    original_line: Optional[int] = Field(
        None,
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
    )
    side: Optional[Side] = Field(
        None,
        description="The side of the first line of the range for a multi-line comment.",
    )
    in_reply_to_id: Optional[int] = Field(
        None, description="The comment ID to reply to."
    )


class ReleaseAsset(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    browser_download_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    name: Optional[str] = Field(None, description="The file name of the asset.")
    label: Optional[Optional[str]] = None
    state: Optional[Literal["uploaded"]] = Field(
        None, description="State of the release asset."
    )
    content_type: Optional[str] = None
    size: Optional[int] = None
    download_count: Optional[int] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    uploader: Optional[User] = None


class ReleaseModel(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    assets_url: Optional[AnyUrl] = None
    upload_url: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    tag_name: Optional[str] = Field(None, description="The name of the tag.")
    target_commitish: Optional[str] = Field(
        None,
        description="Specifies the commitish value that determines where the Git tag is created from.",
    )
    name: Optional[str] = None
    draft: Optional[bool] = Field(
        None, description="Wether the release is a draft or published"
    )
    author: Optional[User] = None
    prerelease: Optional[bool] = Field(
        None,
        description="Whether the release is identified as a prerelease or a full release.",
    )
    created_at: Optional[Optional[str]] = None
    published_at: Optional[Optional[str]] = None
    assets: Optional[List[ReleaseAsset]] = None
    tarball_url: Optional[Optional[str]] = None
    zipball_url: Optional[Optional[str]] = None
    body: Optional[str] = None
    reactions: Optional[Reactions] = None
    discussion_url: Optional[AnyUrl] = None


class RepositoryLite(BaseModel):
    class Config:
        extra = Extra.forbid

    archive_url: Optional[str] = None
    assignees_url: Optional[str] = None
    blobs_url: Optional[str] = None
    branches_url: Optional[str] = None
    collaborators_url: Optional[str] = None
    comments_url: Optional[str] = None
    commits_url: Optional[str] = None
    compare_url: Optional[str] = None
    contents_url: Optional[str] = None
    contributors_url: Optional[AnyUrl] = None
    deployments_url: Optional[AnyUrl] = None
    description: Optional[Optional[str]] = None
    downloads_url: Optional[AnyUrl] = None
    events_url: Optional[AnyUrl] = None
    fork: Optional[bool] = None
    forks_url: Optional[AnyUrl] = None
    full_name: Optional[str] = None
    git_commits_url: Optional[str] = None
    git_refs_url: Optional[str] = None
    git_tags_url: Optional[str] = None
    hooks_url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    id: Optional[int] = Field(None, description="Unique identifier of the repository")
    issue_comment_url: Optional[str] = None
    issue_events_url: Optional[str] = None
    issues_url: Optional[str] = None
    keys_url: Optional[str] = None
    labels_url: Optional[str] = None
    languages_url: Optional[AnyUrl] = None
    merges_url: Optional[AnyUrl] = None
    milestones_url: Optional[str] = None
    name: Optional[str] = Field(None, description="The name of the repository.")
    node_id: Optional[str] = None
    notifications_url: Optional[str] = None
    owner: Optional[User] = None
    private: Optional[bool] = Field(
        None, description="Whether the repository is private or public."
    )
    pulls_url: Optional[str] = None
    releases_url: Optional[str] = None
    stargazers_url: Optional[AnyUrl] = None
    statuses_url: Optional[str] = None
    subscribers_url: Optional[AnyUrl] = None
    subscription_url: Optional[AnyUrl] = None
    tags_url: Optional[AnyUrl] = None
    teams_url: Optional[AnyUrl] = None
    trees_url: Optional[str] = None
    url: Optional[AnyUrl] = None


class RepositoryVulnerabilityAlertAlert(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    number: Optional[int] = None
    node_id: Optional[str] = None
    state: Optional[State] = None
    affected_range: Optional[str] = None
    affected_package_name: Optional[str] = None
    dismisser: Optional[User] = None
    dismiss_reason: Optional[str] = None
    dismissed_at: Optional[str] = None
    severity: Optional[str] = None
    ghsa_id: Optional[str] = None
    external_reference: Optional[AnyUrl] = None
    external_identifier: Optional[str] = None
    fixed_in: Optional[str] = None
    fixed_at: Optional[datetime] = None
    fix_reason: Optional[str] = None
    created_at: Optional[str] = None


class Repository(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="Unique identifier of the repository")
    node_id: Optional[str] = None
    name: Optional[str] = Field(None, description="The name of the repository.")
    full_name: Optional[str] = None
    private: Optional[bool] = Field(
        None, description="Whether the repository is private or public."
    )
    owner: Optional[User] = None
    html_url: Optional[AnyUrl] = None
    description: Optional[Optional[str]] = None
    fork: Optional[bool] = None
    url: Optional[AnyUrl] = None
    forks_url: Optional[AnyUrl] = None
    keys_url: Optional[str] = None
    collaborators_url: Optional[str] = None
    teams_url: Optional[AnyUrl] = None
    hooks_url: Optional[AnyUrl] = None
    issue_events_url: Optional[str] = None
    events_url: Optional[AnyUrl] = None
    assignees_url: Optional[str] = None
    branches_url: Optional[str] = None
    tags_url: Optional[AnyUrl] = None
    blobs_url: Optional[str] = None
    git_tags_url: Optional[str] = None
    git_refs_url: Optional[str] = None
    trees_url: Optional[str] = None
    statuses_url: Optional[str] = None
    languages_url: Optional[AnyUrl] = None
    stargazers_url: Optional[AnyUrl] = None
    contributors_url: Optional[AnyUrl] = None
    subscribers_url: Optional[AnyUrl] = None
    subscription_url: Optional[AnyUrl] = None
    commits_url: Optional[str] = None
    git_commits_url: Optional[str] = None
    comments_url: Optional[str] = None
    issue_comment_url: Optional[str] = None
    contents_url: Optional[str] = None
    compare_url: Optional[str] = None
    merges_url: Optional[AnyUrl] = None
    archive_url: Optional[str] = None
    downloads_url: Optional[AnyUrl] = None
    issues_url: Optional[str] = None
    pulls_url: Optional[str] = None
    milestones_url: Optional[str] = None
    notifications_url: Optional[str] = None
    labels_url: Optional[str] = None
    releases_url: Optional[str] = None
    deployments_url: Optional[AnyUrl] = None
    created_at: Optional[Union[int, datetime]] = None
    updated_at: Optional[datetime] = None
    pushed_at: Optional[Optional[Union[int, datetime]]] = None
    git_url: Optional[AnyUrl] = None
    ssh_url: Optional[str] = None
    clone_url: Optional[AnyUrl] = None
    svn_url: Optional[AnyUrl] = None
    homepage: Optional[Optional[str]] = None
    size: Optional[int] = None
    stargazers_count: Optional[int] = None
    watchers_count: Optional[int] = None
    language: Optional[Optional[str]] = None
    has_issues: Optional[bool] = Field(True, description="Whether issues are enabled.")
    has_projects: Optional[bool] = Field(
        True, description="Whether projects are enabled."
    )
    has_downloads: Optional[bool] = Field(
        True, description="Whether downloads are enabled."
    )
    has_wiki: Optional[bool] = Field(True, description="Whether the wiki is enabled.")
    has_pages: Optional[bool] = None
    forks_count: Optional[int] = None
    mirror_url: Optional[Optional[str]] = None
    archived: Optional[bool] = Field(
        False, description="Whether the repository is archived."
    )
    disabled: Optional[bool] = Field(
        None, description="Returns whether or not this repository is disabled."
    )
    open_issues_count: Optional[int] = None
    license: Optional[Optional[License]] = None
    forks: Optional[int] = None
    open_issues: Optional[int] = None
    watchers: Optional[int] = None
    stargazers: Optional[int] = None
    default_branch: Optional[str] = Field(
        None, description="The default branch of the repository."
    )
    allow_squash_merge: Optional[bool] = Field(
        True, description="Whether to allow squash merges for pull requests."
    )
    allow_merge_commit: Optional[bool] = Field(
        True, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Optional[bool] = Field(
        True, description="Whether to allow rebase merges for pull requests."
    )
    allow_auto_merge: Optional[bool] = Field(
        False, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Optional[bool] = Field(
        None, description="Whether to allow private forks"
    )
    allow_update_branch: Optional[bool] = None
    is_template: Optional[bool] = None
    topics: Optional[List[str]] = None
    visibility: Optional[Visibility] = None
    delete_branch_on_merge: Optional[bool] = Field(
        False,
        description="Whether to delete head branches when pull requests are merged",
    )
    master_branch: Optional[str] = None
    permissions: Optional[Permissions3] = None
    public: Optional[bool] = None
    organization: Optional[str] = None


class Head5(BaseModel):
    class Config:
        extra = Extra.forbid

    label: Optional[str] = None
    ref: Optional[str] = None
    sha: Optional[str] = None
    user: Optional[User] = None
    repo: Optional[Repository] = None


class Base6(Head5):
    pass


class SimplePullRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    diff_url: Optional[AnyUrl] = None
    patch_url: Optional[AnyUrl] = None
    issue_url: Optional[AnyUrl] = None
    number: Optional[int] = None
    state: Optional[State5] = None
    locked: Optional[bool] = None
    title: Optional[str] = None
    user: Optional[User] = None
    body: Optional[str] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    closed_at: Optional[Optional[str]] = None
    merged_at: Optional[Optional[str]] = None
    merge_commit_sha: Optional[Optional[str]] = None
    assignee: Optional[Optional[User]] = None
    assignees: Optional[List[User]] = None
    requested_reviewers: Optional[List[Union[User, Team]]] = None
    requested_teams: Optional[List[Team]] = None
    labels: Optional[List[Label]] = None
    milestone: Optional[Optional[Milestone]] = None
    draft: Optional[bool] = None
    commits_url: Optional[AnyUrl] = None
    review_comments_url: Optional[AnyUrl] = None
    review_comment_url: Optional[str] = None
    comments_url: Optional[AnyUrl] = None
    statuses_url: Optional[AnyUrl] = None
    head: Optional[Head5] = None
    base: Optional[Base6] = None
    links: Optional[Links8] = Field(None, alias="_links")
    author_association: Optional[AuthorAssociation] = None
    auto_merge: Optional[Optional[AutoMerge]] = None
    active_lock_reason: Optional[ActiveLockReason] = None


class WorkflowJob(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    run_id: Optional[float] = None
    run_attempt: Optional[int] = None
    run_url: Optional[AnyUrl] = None
    head_sha: Optional[str] = None
    node_id: Optional[str] = None
    name: Optional[str] = None
    check_run_url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    url: Optional[AnyUrl] = None
    status: Optional[Status2] = Field(
        None,
        description="The current status of the job. Can be `queued`, `in_progress`, or `completed`.",
    )
    steps: Optional[List[WorkflowStep]] = Field(None, min_items=1)
    conclusion: Optional[Conclusion15] = None
    labels: Optional[List[str]] = Field(
        None,
        description='Custom labels for the job. Specified by the [`"runs-on"` attribute](https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#jobsjob_idruns-on) in the workflow YAML.',
    )
    runner_id: Optional[Optional[int]] = Field(
        None,
        description="The ID of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
    )
    runner_name: Optional[Optional[str]] = Field(
        None,
        description="The name of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
    )
    runner_group_id: Optional[Optional[int]] = Field(
        None,
        description="The ID of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
    )
    runner_group_name: Optional[Optional[str]] = Field(
        None,
        description="The name of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
    )
    started_at: Optional[str] = None
    completed_at: Optional[Optional[str]] = None


class WorkflowRun(BaseModel):
    class Config:
        extra = Extra.forbid

    artifacts_url: Optional[AnyUrl] = None
    cancel_url: Optional[AnyUrl] = None
    check_suite_url: Optional[AnyUrl] = None
    check_suite_id: Optional[int] = None
    check_suite_node_id: Optional[str] = None
    conclusion: Optional[Conclusion] = None
    created_at: Optional[datetime] = None
    event: Optional[str] = None
    head_branch: Optional[str] = None
    head_commit: Optional[CommitSimple] = None
    head_repository: Optional[RepositoryLite] = None
    head_sha: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    jobs_url: Optional[AnyUrl] = None
    logs_url: Optional[AnyUrl] = None
    node_id: Optional[str] = None
    name: Optional[str] = None
    pull_requests: Optional[List[PullRequest10]] = None
    repository: Optional[RepositoryLite] = None
    rerun_url: Optional[AnyUrl] = None
    run_number: Optional[int] = None
    status: Optional[Status12] = None
    updated_at: Optional[datetime] = None
    url: Optional[AnyUrl] = None
    workflow_id: Optional[int] = None
    workflow_url: Optional[AnyUrl] = None
    run_attempt: Optional[int] = None
    run_started_at: Optional[datetime] = None
    previous_attempt_url: Optional[Optional[AnyUrl]] = None
    actor: Optional[User] = None
    triggering_actor: Optional[User] = None


class BranchProtectionRuleCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    rule: Optional[BranchProtectionRule] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class BranchProtectionRuleDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    rule: Optional[BranchProtectionRule] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class BranchProtectionRuleEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    rule: Optional[BranchProtectionRule] = None
    changes: Optional[Changes] = Field(
        None, description="If the action was `edited`, the changes to the rule."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class BranchProtectionRuleEvent(BaseModel):
    __root__: Optional[
        Union[
            BranchProtectionRuleCreated,
            BranchProtectionRuleDeleted,
            BranchProtectionRuleEdited,
        ]
    ] = None


class CheckSuite(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(
        None, description="The id of the check suite that this check run is part of."
    )
    node_id: Optional[str] = None
    head_branch: Optional[Optional[str]] = None
    head_sha: Optional[str] = Field(
        None, description="The SHA of the head commit that is being checked."
    )
    status: Optional[Status] = None
    conclusion: Optional[Conclusion1] = None
    url: Optional[AnyUrl] = None
    before: Optional[Optional[str]] = None
    after: Optional[Optional[str]] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = Field(
        None,
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.  \n  \n**Note:**\n\n*   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.\n*   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
    )
    deployment: Optional[CheckRunDeployment] = None
    app: Optional[App] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None


class CheckRun(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="The id of the check.")
    node_id: Optional[str] = None
    head_sha: Optional[str] = Field(
        None, description="The SHA of the commit that is being checked."
    )
    external_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    details_url: Optional[AnyUrl] = None
    status: Optional[Literal["completed"]] = Field(
        None,
        description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`.",
    )
    conclusion: Optional[Conclusion] = Field(
        None,
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
    )
    started_at: Optional[str] = Field(
        None,
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    completed_at: Optional[str] = Field(
        None,
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    output: Optional[Output] = None
    name: Optional[str] = Field(None, description="The name of the check run.")
    check_suite: Optional[CheckSuite] = None
    app: Optional[App] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = None
    deployment: Optional[CheckRunDeployment] = None


class CheckRunCompleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["completed"]] = None
    check_run: Optional[CheckRun] = Field(
        None,
        description="The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).",
    )
    requested_action: Optional[RequestedAction] = Field(
        None, description="The action requested by the user."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CheckSuite1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(
        None, description="The id of the check suite that this check run is part of."
    )
    node_id: Optional[str] = None
    head_branch: Optional[Optional[str]] = None
    head_sha: Optional[str] = Field(
        None, description="The SHA of the head commit that is being checked."
    )
    status: Optional[Status2] = None
    conclusion: Optional[Conclusion1] = None
    url: Optional[AnyUrl] = None
    before: Optional[Optional[str]] = None
    after: Optional[Optional[str]] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = Field(
        None,
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.  \n  \n**Note:**\n\n*   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.\n*   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
    )
    deployment: Optional[CheckRunDeployment] = None
    app: Optional[App] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None


class CheckRun1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="The id of the check.")
    node_id: Optional[str] = None
    head_sha: Optional[str] = Field(
        None, description="The SHA of the commit that is being checked."
    )
    external_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    details_url: Optional[AnyUrl] = None
    status: Optional[Status1] = Field(
        None,
        description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`.",
    )
    conclusion: Optional[Conclusion] = Field(
        None,
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
    )
    started_at: Optional[str] = Field(
        None,
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    completed_at: Optional[Optional[str]] = Field(
        None,
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    output: Optional[Output1] = None
    name: Optional[str] = Field(None, description="The name of the check run.")
    check_suite: Optional[CheckSuite1] = None
    app: Optional[App] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = None
    deployment: Optional[CheckRunDeployment] = None


class CheckRunCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    check_run: Optional[CheckRun1] = Field(
        None,
        description="The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).",
    )
    requested_action: Optional[RequestedAction1] = Field(
        None, description="The action requested by the user."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CheckSuite2(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(
        None, description="The id of the check suite that this check run is part of."
    )
    node_id: Optional[str] = None
    head_branch: Optional[Optional[str]] = None
    head_sha: Optional[str] = Field(
        None, description="The SHA of the head commit that is being checked."
    )
    status: Optional[Status1] = None
    conclusion: Optional[Conclusion1] = None
    url: Optional[AnyUrl] = None
    before: Optional[Optional[str]] = None
    after: Optional[Optional[str]] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = Field(
        None,
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.  \n  \n**Note:**\n\n*   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.\n*   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
    )
    deployment: Optional[CheckRunDeployment] = None
    app: Optional[App] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None


class CheckRun2(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="The id of the check.")
    node_id: Optional[str] = None
    head_sha: Optional[str] = Field(
        None, description="The SHA of the commit that is being checked."
    )
    external_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    details_url: Optional[AnyUrl] = None
    status: Optional[Status2] = Field(
        None,
        description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`.",
    )
    conclusion: Optional[Conclusion] = Field(
        None,
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
    )
    started_at: Optional[str] = Field(
        None,
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    completed_at: Optional[Optional[str]] = Field(
        None,
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    output: Optional[Output2] = None
    name: Optional[str] = Field(None, description="The name of the check run.")
    check_suite: Optional[CheckSuite2] = None
    app: Optional[App] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = None
    deployment: Optional[CheckRunDeployment] = None


class CheckRunRequestedAction(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["requested_action"]] = None
    check_run: Optional[CheckRun2] = Field(
        None,
        description="The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).",
    )
    requested_action: Optional[RequestedAction2] = Field(
        None, description="The action requested by the user."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CheckSuite3(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(
        None, description="The id of the check suite that this check run is part of."
    )
    node_id: Optional[str] = None
    head_branch: Optional[Optional[str]] = None
    head_sha: Optional[str] = Field(
        None, description="The SHA of the head commit that is being checked."
    )
    status: Optional[Literal["completed"]] = None
    conclusion: Optional[Conclusion7] = None
    url: Optional[AnyUrl] = None
    before: Optional[Optional[str]] = None
    after: Optional[Optional[str]] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = Field(
        None,
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.  \n  \n**Note:**\n\n*   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.\n*   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
    )
    deployment: Optional[CheckRunDeployment] = None
    app: Optional[App] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None


class CheckRun3(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="The id of the check.")
    node_id: Optional[str] = None
    head_sha: Optional[str] = Field(
        None, description="The SHA of the commit that is being checked."
    )
    external_id: Optional[str] = None
    url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    details_url: Optional[AnyUrl] = None
    status: Optional[Literal["completed"]] = Field(
        None, description="The phase of the lifecycle that the check is currently in."
    )
    conclusion: Optional[Conclusion] = Field(
        None,
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.",
    )
    started_at: Optional[str] = Field(
        None,
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    completed_at: Optional[str] = Field(
        None,
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    output: Optional[Output3] = None
    name: Optional[str] = Field(None, description="The name of the check.")
    check_suite: Optional[CheckSuite3] = None
    app: Optional[App] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = None
    deployment: Optional[CheckRunDeployment] = None


class CheckRunRerequested(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["rerequested"]] = None
    check_run: Optional[CheckRun3] = Field(
        None,
        description="The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).",
    )
    requested_action: Optional[RequestedAction3] = Field(
        None, description="The action requested by the user."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CheckRunEvent(BaseModel):
    __root__: Optional[
        Union[
            CheckRunCompleted,
            CheckRunCreated,
            CheckRunRequestedAction,
            CheckRunRerequested,
        ]
    ] = None


class CheckSuite4(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    node_id: Optional[str] = None
    head_branch: Optional[Optional[str]] = Field(
        None, description="The head branch name the changes are on."
    )
    head_sha: Optional[str] = Field(
        None, description="The SHA of the head commit that is being checked."
    )
    status: Optional[Status5] = Field(
        None,
        description="The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.",
    )
    conclusion: Optional[Conclusion1] = Field(
        None,
        description="The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.",
    )
    url: Optional[AnyUrl] = Field(
        None, description="URL that points to the check suite API resource."
    )
    before: Optional[Optional[str]] = None
    after: Optional[Optional[str]] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = Field(
        None,
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
    )
    app: Optional[App] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    runs_rerequestable: Optional[bool] = None
    rerequestable: Optional[bool] = None
    latest_check_runs_count: Optional[int] = None
    check_runs_url: Optional[AnyUrl] = None
    head_commit: Optional[CommitSimple] = None


class CheckSuiteCompleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["completed"]] = None
    check_suite: Optional[CheckSuite4] = Field(
        None,
        description="The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CheckSuite5(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    node_id: Optional[str] = None
    head_branch: Optional[Optional[str]] = Field(
        None, description="The head branch name the changes are on."
    )
    head_sha: Optional[str] = Field(
        None, description="The SHA of the head commit that is being checked."
    )
    status: Optional[Status5] = Field(
        None,
        description="The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.",
    )
    conclusion: Optional[Conclusion1] = Field(
        None,
        description="The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
    )
    url: Optional[AnyUrl] = Field(
        None, description="URL that points to the check suite API resource."
    )
    before: Optional[Optional[str]] = None
    after: Optional[Optional[str]] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = Field(
        None,
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
    )
    app: Optional[App] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    runs_rerequestable: Optional[bool] = None
    rerequestable: Optional[bool] = None
    latest_check_runs_count: Optional[int] = None
    check_runs_url: Optional[AnyUrl] = None
    head_commit: Optional[CommitSimple] = None


class CheckSuiteRequested(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["requested"]] = None
    check_suite: Optional[CheckSuite5] = Field(
        None,
        description="The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CheckSuite6(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    node_id: Optional[str] = None
    head_branch: Optional[Optional[str]] = Field(
        None, description="The head branch name the changes are on."
    )
    head_sha: Optional[str] = Field(
        None, description="The SHA of the head commit that is being checked."
    )
    status: Optional[Status5] = Field(
        None,
        description="The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.",
    )
    conclusion: Optional[Conclusion1] = Field(
        None,
        description="The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
    )
    url: Optional[AnyUrl] = Field(
        None, description="URL that points to the check suite API resource."
    )
    before: Optional[Optional[str]] = None
    after: Optional[Optional[str]] = None
    pull_requests: Optional[List[CheckRunPullRequest]] = Field(
        None,
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
    )
    app: Optional[App] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    latest_check_runs_count: Optional[int] = None
    check_runs_url: Optional[AnyUrl] = None
    head_commit: Optional[CommitSimple] = None


class CheckSuiteRerequested(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["rerequested"]] = None
    check_suite: Optional[CheckSuite6] = Field(
        None,
        description="The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CheckSuiteEvent(BaseModel):
    __root__: Optional[
        Union[CheckSuiteCompleted, CheckSuiteRequested, CheckSuiteRerequested]
    ] = None


class CodeScanningAlertAppearedInBranch(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["appeared_in_branch"]] = None
    alert: Optional[Alert] = Field(
        None, description="The code scanning alert involved in the event."
    )
    ref: Optional[str] = Field(
        None,
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    commit_oid: Optional[str] = Field(
        None,
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    repository: Optional[Repository] = None
    sender: Optional[GithubOrg] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CodeScanningAlertClosedByUser(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["closed_by_user"]] = None
    alert: Optional[Alert1] = Field(
        None, description="The code scanning alert involved in the event."
    )
    ref: Optional[str] = Field(
        None,
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    commit_oid: Optional[str] = Field(
        None,
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CodeScanningAlertCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    alert: Optional[Alert2] = Field(
        None, description="The code scanning alert involved in the event."
    )
    ref: Optional[str] = Field(
        None,
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    commit_oid: Optional[str] = Field(
        None,
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    repository: Optional[Repository] = None
    sender: Optional[GithubOrg] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CodeScanningAlertFixed(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["fixed"]] = None
    alert: Optional[Alert3] = Field(
        None, description="The code scanning alert involved in the event."
    )
    ref: Optional[str] = Field(
        None,
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    commit_oid: Optional[str] = Field(
        None,
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    repository: Optional[Repository] = None
    sender: Optional[GithubOrg] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CodeScanningAlertReopened(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["reopened"]] = None
    alert: Optional[Alert4] = Field(
        None, description="The code scanning alert involved in the event."
    )
    ref: Optional[str] = Field(
        None,
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    commit_oid: Optional[str] = Field(
        None,
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    repository: Optional[Repository] = None
    sender: Optional[GithubOrg] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CodeScanningAlertReopenedByUser(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["reopened_by_user"]] = None
    alert: Optional[Alert5] = Field(
        None, description="The code scanning alert involved in the event."
    )
    ref: Optional[str] = Field(
        None,
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    commit_oid: Optional[str] = Field(
        None,
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CodeScanningAlertEvent(BaseModel):
    __root__: Optional[
        Union[
            CodeScanningAlertAppearedInBranch,
            CodeScanningAlertClosedByUser,
            CodeScanningAlertCreated,
            CodeScanningAlertFixed,
            CodeScanningAlertReopened,
            CodeScanningAlertReopenedByUser,
        ]
    ] = None


class CommitCommentCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = Field(
        None, description="The action performed. Can be `created`."
    )
    comment: Optional[Comment] = Field(
        None,
        description="The [commit comment](https://docs.github.com/en/rest/reference/repos#get-a-commit-comment) resource.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class CommitCommentEvent(BaseModel):
    __root__: Optional[CommitCommentCreated] = None


class CreateEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    ref: Optional[str] = Field(
        None,
        description="The [`git ref`](https://docs.github.com/en/rest/reference/git#get-a-reference) resource.",
    )
    ref_type: Optional[RefType] = Field(
        None,
        description="The type of Git ref object created in the repository. Can be either `branch` or `tag`.",
    )
    master_branch: Optional[str] = Field(
        None,
        description="The name of the repository's default branch (usually `main`).",
    )
    description: Optional[Optional[str]] = Field(
        None, description="The repository's current description."
    )
    pusher_type: Optional[str] = Field(
        None,
        description="The pusher type for the event. Can be either `user` or a deploy key.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DeleteEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    ref: Optional[str] = Field(
        None,
        description="The [`git ref`](https://docs.github.com/en/rest/reference/git#get-a-reference) resource.",
    )
    ref_type: Optional[RefType] = Field(
        None,
        description="The type of Git ref object deleted in the repository. Can be either `branch` or `tag`.",
    )
    pusher_type: Optional[str] = Field(
        None,
        description="The pusher type for the event. Can be either `user` or a deploy key.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DeployKeyCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    key: Optional[Key] = Field(
        None,
        description="The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-deploy-key) resource.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DeployKeyDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    key: Optional[Key1] = Field(
        None,
        description="The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-deploy-key) resource.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DeployKeyEvent(BaseModel):
    __root__: Optional[Union[DeployKeyCreated, DeployKeyDeleted]] = None


class DeploymentCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    deployment: Optional[Deployment] = None
    workflow: Optional[Optional[Workflow]] = None
    workflow_run: Optional[Optional[DeploymentWorkflowRun]] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DeploymentEvent(BaseModel):
    __root__: Optional[DeploymentCreated] = None


class DeploymentStatus(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    state: Optional[str] = Field(
        None,
        description="The new state. Can be `pending`, `success`, `failure`, or `error`.",
    )
    creator: Optional[User] = None
    description: Optional[str] = Field(
        None, description="The optional human-readable description added to the status."
    )
    environment: Optional[str] = None
    environment_url: Optional[Union[AnyUrl, Literal[""]]] = None
    log_url: Optional[AnyUrl] = None
    target_url: Optional[str] = Field(
        None, description="The optional link added to the status."
    )
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    deployment_url: Optional[AnyUrl] = None
    repository_url: Optional[AnyUrl] = None
    performed_via_github_app: Optional[Optional[App]] = None


class DeploymentStatusCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    deployment_status: Optional[DeploymentStatus] = Field(
        None,
        description="The [deployment status](https://docs.github.com/en/rest/reference/deployments#list-deployment-statuses).",
    )
    deployment: Optional[Deployment] = None
    check_run: Optional[CheckRun4] = None
    workflow_run: Optional[DeploymentWorkflowRun] = None
    workflow: Optional[Workflow] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DeploymentStatusEvent(BaseModel):
    __root__: Optional[DeploymentStatusCreated] = None


class DiscussionModel(Discussion):
    class Config:
        extra = Extra.forbid

    category: Optional[Category] = None
    answer_html_url: Optional[AnyUrl] = None
    answer_chosen_at: Optional[datetime] = None
    answer_chosen_by: Optional[User] = None


class DiscussionAnswered(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["answered"]] = None
    discussion: Optional[DiscussionModel] = None
    answer: Optional[Answer] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionCategoryChanged(BaseModel):
    class Config:
        extra = Extra.forbid

    changes: Optional[Changes1] = None
    action: Optional[Literal["category_changed"]] = None
    discussion: Optional[Discussion] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Discussion1(Discussion):
    state: Optional[State4] = None
    locked: Optional[Literal[False]] = None
    answer_html_url: Optional[Any] = None
    answer_chosen_at: Optional[Any] = None
    answer_chosen_by: Optional[Any] = None


class DiscussionCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    discussion: Optional[Discussion1] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    discussion: Optional[Discussion] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    changes: Optional[Changes2] = None
    action: Optional[Literal["edited"]] = None
    discussion: Optional[Discussion] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionLabeled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["labeled"]] = None
    discussion: Optional[Discussion] = None
    label: Optional[Label] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Discussion2(Discussion):
    state: Optional[Literal["locked"]] = None
    locked: Optional[Literal[True]] = None


class DiscussionLocked(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["locked"]] = None
    discussion: Optional[Discussion2] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionPinned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["pinned"]] = None
    discussion: Optional[Discussion] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Changes3(BaseModel):
    class Config:
        extra = Extra.forbid

    new_discussion: Optional[Discussion] = None
    new_repository: Optional[Repository] = None


class DiscussionTransferred(BaseModel):
    class Config:
        extra = Extra.forbid

    changes: Optional[Changes3] = None
    action: Optional[Literal["transferred"]] = None
    discussion: Optional[Discussion] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Discussion3(Discussion):
    category: Optional[Category2] = None
    answer_html_url: Optional[Any] = None
    answer_chosen_at: Optional[Any] = None
    answer_chosen_by: Optional[Any] = None


class DiscussionUnanswered(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unanswered"]] = None
    discussion: Optional[Discussion3] = None
    old_answer: Optional[OldAnswer] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionUnlabeled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unlabeled"]] = None
    discussion: Optional[Discussion] = None
    label: Optional[Label] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Discussion4(Discussion):
    state: Optional[Literal["open"]] = None
    locked: Optional[Literal[False]] = None


class DiscussionUnlocked(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unlocked"]] = None
    discussion: Optional[Discussion4] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionUnpinned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unpinned"]] = None
    discussion: Optional[Discussion] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionEvent(BaseModel):
    __root__: Optional[
        Union[
            DiscussionAnswered,
            DiscussionCategoryChanged,
            DiscussionCreated,
            DiscussionDeleted,
            DiscussionEdited,
            DiscussionLabeled,
            DiscussionLocked,
            DiscussionPinned,
            DiscussionTransferred,
            DiscussionUnanswered,
            DiscussionUnlabeled,
            DiscussionUnlocked,
            DiscussionUnpinned,
        ]
    ] = None


class DiscussionCommentCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    comment: Optional[Comment1] = None
    discussion: Optional[Discussion] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionCommentDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    comment: Optional[Comment2] = None
    discussion: Optional[Discussion] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionCommentEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    changes: Optional[Changes4] = None
    action: Optional[Literal["edited"]] = None
    comment: Optional[Comment3] = None
    discussion: Optional[Discussion] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class DiscussionCommentEvent(BaseModel):
    __root__: Optional[
        Union[
            DiscussionCommentCreated, DiscussionCommentDeleted, DiscussionCommentEdited
        ]
    ] = None


class Forkee(Repository):
    fork: Optional[Literal[True]] = None


class ForkEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    forkee: Optional[Forkee] = Field(
        None,
        description="The created [`repository`](https://docs.github.com/en/rest/reference/repos#get-a-repository) resource.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class GollumEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    pages: Optional[List[Page]] = Field(
        None, description="The pages that were updated."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class InstallationCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    installation: Optional[Installation] = None
    repositories: Optional[List[Repository1]] = Field(
        None,
        description="An array of repository objects that the installation can access.",
    )
    requester: Optional[User] = None
    sender: Optional[User] = None


class InstallationDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    installation: Optional[Installation] = None
    repositories: Optional[List[Repository2]] = Field(
        None,
        description="An array of repository objects that the installation can access.",
    )
    requester: Optional[Any] = None
    sender: Optional[User] = None


class InstallationNewPermissionsAccepted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["new_permissions_accepted"]] = None
    installation: Optional[Installation] = None
    repositories: Optional[List[Repository3]] = Field(
        None,
        description="An array of repository objects that the installation can access.",
    )
    requester: Optional[Any] = None
    sender: Optional[User] = None


class Installation1(Installation):
    suspended_by: Optional[User] = None
    suspended_at: Optional[datetime] = None


class InstallationSuspend(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["suspend"]] = None
    installation: Optional[Installation1] = None
    repositories: Optional[List[Repository4]] = Field(
        None,
        description="An array of repository objects that the installation can access.",
    )
    requester: Optional[Any] = None
    sender: Optional[User] = None


class Installation2(Installation):
    suspended_by: Optional[Any] = None
    suspended_at: Optional[Any] = None


class InstallationUnsuspend(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unsuspend"]] = None
    installation: Optional[Installation2] = None
    repositories: Optional[List[Repository5]] = Field(
        None,
        description="An array of repository objects that the installation can access.",
    )
    requester: Optional[Any] = None
    sender: Optional[User] = None


class InstallationEvent(BaseModel):
    __root__: Optional[
        Union[
            InstallationCreated,
            InstallationDeleted,
            InstallationNewPermissionsAccepted,
            InstallationSuspend,
            InstallationUnsuspend,
        ]
    ] = None


class InstallationRepositoriesAdded(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["added"]] = None
    installation: Optional[Installation] = None
    repository_selection: Optional[RepositorySelection] = Field(
        None,
        description="Describe whether all repositories have been selected or there's a selection involved",
    )
    repositories_added: Optional[List[RepositoriesAddedItem]] = Field(
        None,
        description="An array of repository objects, which were added to the installation.",
    )
    repositories_removed: Optional[List[RepositoriesRemovedItem]] = Field(
        None,
        description="An array of repository objects, which were removed from the installation.",
        max_items=0,
    )
    requester: Optional[Optional[User]] = None
    sender: Optional[User] = None


class InstallationRepositoriesRemoved(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["removed"]] = None
    installation: Optional[Installation] = None
    repository_selection: Optional[RepositorySelection] = Field(
        None,
        description="Describe whether all repositories have been selected or there's a selection involved",
    )
    repositories_added: Optional[List[RepositoriesAddedItem1]] = Field(
        None,
        description="An array of repository objects, which were added to the installation.",
        max_items=0,
    )
    repositories_removed: Optional[List[RepositoriesRemovedItem1]] = Field(
        None,
        description="An array of repository objects, which were removed from the installation.",
    )
    requester: Optional[Optional[User]] = None
    sender: Optional[User] = None


class InstallationRepositoriesEvent(BaseModel):
    __root__: Optional[
        Union[InstallationRepositoriesAdded, InstallationRepositoriesRemoved]
    ] = None


class LabelCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    label: Optional[Label] = Field(None, description="The label that was added.")
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class LabelDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    label: Optional[Label] = Field(None, description="The label that was removed.")
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class LabelEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    label: Optional[Label] = Field(None, description="The label that was edited.")
    changes: Optional[Changes9] = Field(
        None, description="The changes to the label if the action was `edited`."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class LabelEvent(BaseModel):
    __root__: Optional[Union[LabelCreated, LabelDeleted, LabelEdited]] = None


class MemberAdded(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["added"]] = None
    changes: Optional[Changes10] = None
    member: Optional[User] = Field(None, description="The user that was added.")
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    sender: Optional[User] = None


class MemberEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    member: Optional[User] = Field(
        None, description="The user who's permissions are changed."
    )
    changes: Optional[Changes11] = Field(
        None, description="The changes to the collaborator permissions"
    )
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    sender: Optional[User] = None


class MemberRemoved(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["removed"]] = None
    member: Optional[User] = Field(None, description="The user that was removed.")
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    sender: Optional[User] = None


class MemberEvent(BaseModel):
    __root__: Optional[Union[MemberAdded, MemberEdited, MemberRemoved]] = None


class MetaDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    hook_id: Optional[int] = Field(None, description="The id of the modified webhook.")
    hook: Optional[Hook] = Field(
        None,
        description="The modified webhook. This will contain different keys based on the type of webhook it is: repository, organization, business, app, or GitHub Marketplace.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None


class MetaEvent(BaseModel):
    __root__: Optional[MetaDeleted] = None


class Milestone1(Milestone):
    state: Optional[Literal["closed"]] = None
    closed_at: Optional[str] = None


class MilestoneClosed(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["closed"]] = None
    milestone: Optional[Milestone1] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Milestone2(Milestone):
    state: Optional[Literal["open"]] = None
    closed_at: Optional[Any] = None


class MilestoneCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    milestone: Optional[Milestone2] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class MilestoneDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    milestone: Optional[Milestone] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class MilestoneEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes12] = Field(
        None, description="The changes to the milestone if the action was `edited`."
    )
    milestone: Optional[Milestone] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Milestone3(Milestone2):
    pass


class MilestoneOpened(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["opened"]] = None
    milestone: Optional[Milestone3] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class MilestoneEvent(BaseModel):
    __root__: Optional[
        Union[
            MilestoneClosed,
            MilestoneCreated,
            MilestoneDeleted,
            MilestoneEdited,
            MilestoneOpened,
        ]
    ] = None


class OrganizationDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    membership: Optional[Membership] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class OrganizationMemberAdded(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["member_added"]] = None
    membership: Optional[Membership] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class OrganizationMemberRemoved(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["member_removed"]] = None
    membership: Optional[Membership] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class OrganizationRenamed(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["renamed"]] = None
    membership: Optional[Membership] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class OrganizationEvent(BaseModel):
    __root__: Optional[
        Union[
            OrganizationDeleted,
            OrganizationMemberAdded,
            OrganizationMemberInvited,
            OrganizationMemberRemoved,
            OrganizationRenamed,
        ]
    ] = None


class PackagePublished(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["published"]] = None
    package: Optional[Package] = Field(
        None, description="Information about the package."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None


class PackageUpdated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["updated"]] = None
    package: Optional[Package1] = Field(
        None, description="Information about the package."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None


class PackageEvent(BaseModel):
    __root__: Optional[Union[PackagePublished, PackageUpdated]] = None


class PageBuildEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = None
    build: Optional[Build] = Field(
        None,
        description="The [List GitHub Pages builds](https://docs.github.com/en/rest/reference/repos#list-github-pages-builds) itself.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class PingEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    zen: Optional[str] = None
    hook_id: Optional[int] = Field(
        None, description="The ID of the webhook that triggered the ping."
    )
    hook: Optional[Hook1] = Field(
        None,
        description="The [webhook configuration](https://docs.github.com/en/rest/reference/repos#get-a-repository-webhook).",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None


class ProjectClosed(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["closed"]] = None
    project: Optional[Project] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ProjectCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    project: Optional[Project] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ProjectDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    project: Optional[Project] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ProjectEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes13] = Field(
        None, description="The changes to the project if the action was `edited`."
    )
    project: Optional[Project] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ProjectReopened(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["reopened"]] = None
    project: Optional[Project] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ProjectEvent(BaseModel):
    __root__: Optional[
        Union[
            ProjectClosed,
            ProjectCreated,
            ProjectDeleted,
            ProjectEdited,
            ProjectReopened,
        ]
    ] = None


class ProjectCardConverted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["converted"]] = None
    changes: Optional[Changes14] = None
    project_card: Optional[ProjectCard] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectCardCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    project_card: Optional[ProjectCard] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectCardDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    project_card: Optional[ProjectCard] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectCardEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes15] = None
    project_card: Optional[ProjectCard] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectCard1(ProjectCard):
    after_id: Optional[Optional[float]] = None


class ProjectCardMoved(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["moved"]] = None
    changes: Optional[Changes16] = None
    project_card: Optional[ProjectCard1] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectCardEvent(BaseModel):
    __root__: Optional[
        Union[
            ProjectCardConverted,
            ProjectCardCreated,
            ProjectCardDeleted,
            ProjectCardEdited,
            ProjectCardMoved,
        ]
    ] = None


class ProjectColumnCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    project_column: Optional[ProjectColumn] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ProjectColumnDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    project_column: Optional[ProjectColumn] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ProjectColumnEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes17] = None
    project_column: Optional[ProjectColumn] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ProjectColumnMoved(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["moved"]] = None
    project_column: Optional[ProjectColumn] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ProjectColumnEvent(BaseModel):
    __root__: Optional[
        Union[
            ProjectColumnCreated,
            ProjectColumnDeleted,
            ProjectColumnEdited,
            ProjectColumnMoved,
        ]
    ] = None


class ProjectsV2ItemModel(ProjectsV2Item):
    class Config:
        extra = Extra.forbid

    archived_at: Optional[datetime] = None


class ProjectsV2ItemArchived(BaseModel):
    class Config:
        extra = Extra.forbid

    changes: Optional[Changes18] = None
    action: Optional[Literal["archived"]] = None
    projects_v2_item: Optional[ProjectsV2ItemModel] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectsV2Item1(ProjectsV2Item):
    content_type: Optional[Literal["Issue"]] = None


class ProjectsV2ItemConverted(BaseModel):
    class Config:
        extra = Extra.forbid

    changes: Optional[Changes19] = None
    action: Optional[Literal["converted"]] = None
    projects_v2_item: Optional[ProjectsV2Item1] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectsV2Item2(ProjectsV2Item):
    archived_at: Optional[Any] = None


class ProjectsV2ItemCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    projects_v2_item: Optional[ProjectsV2Item2] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectsV2ItemDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    projects_v2_item: Optional[ProjectsV2Item] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectsV2ItemEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    changes: Optional[Changes20] = None
    action: Optional[Literal["edited"]] = None
    projects_v2_item: Optional[ProjectsV2Item] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectsV2ItemReordered(BaseModel):
    class Config:
        extra = Extra.forbid

    changes: Optional[Changes21] = None
    action: Optional[Literal["reordered"]] = None
    projects_v2_item: Optional[ProjectsV2Item] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectsV2Item3(ProjectsV2Item2):
    pass


class ProjectsV2ItemRestored(BaseModel):
    class Config:
        extra = Extra.forbid

    changes: Optional[Changes22] = None
    action: Optional[Literal["restored"]] = None
    projects_v2_item: Optional[ProjectsV2Item3] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class ProjectsV2ItemEvent(BaseModel):
    __root__: Optional[
        Union[
            ProjectsV2ItemArchived,
            ProjectsV2ItemConverted,
            ProjectsV2ItemCreated,
            ProjectsV2ItemDeleted,
            ProjectsV2ItemEdited,
            ProjectsV2ItemReordered,
            ProjectsV2ItemRestored,
        ]
    ] = None


class Repository6(Repository):
    private: Optional[Literal[False]] = None


class PublicEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    repository: Optional[Repository6] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class PullRequestReviewDismissed(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["dismissed"]] = None
    review: Optional[Review] = Field(None, description="The review that was affected.")
    pull_request: Optional[SimplePullRequest] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes24] = None
    review: Optional[Review1] = Field(None, description="The review that was affected.")
    pull_request: Optional[SimplePullRequest] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewSubmitted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["submitted"]] = None
    review: Optional[Review2] = Field(None, description="The review that was affected.")
    pull_request: Optional[SimplePullRequest] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewEvent(BaseModel):
    __root__: Optional[
        Union[
            PullRequestReviewDismissed,
            PullRequestReviewEdited,
            PullRequestReviewSubmitted,
        ]
    ] = None


class Head(Head5):
    pass


class Base1(Head5):
    pass


class PullRequest6(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    diff_url: Optional[AnyUrl] = None
    patch_url: Optional[AnyUrl] = None
    issue_url: Optional[AnyUrl] = None
    number: Optional[int] = None
    state: Optional[State5] = None
    locked: Optional[bool] = None
    title: Optional[str] = None
    user: Optional[User] = None
    body: Optional[str] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    closed_at: Optional[Optional[str]] = None
    merged_at: Optional[Optional[str]] = None
    merge_commit_sha: Optional[Optional[str]] = None
    assignee: Optional[Optional[User]] = None
    assignees: Optional[List[User]] = None
    requested_reviewers: Optional[List[Union[User, Team]]] = None
    requested_teams: Optional[List[Team]] = None
    labels: Optional[List[Label]] = None
    milestone: Optional[Optional[Milestone]] = None
    draft: Optional[bool] = None
    commits_url: Optional[AnyUrl] = None
    review_comments_url: Optional[AnyUrl] = None
    review_comment_url: Optional[str] = None
    comments_url: Optional[AnyUrl] = None
    statuses_url: Optional[AnyUrl] = None
    head: Optional[Head] = None
    base: Optional[Base1] = None
    links: Optional[Links3] = Field(None, alias="_links")
    auto_merge: Optional[Optional[AutoMerge]] = None
    author_association: Optional[AuthorAssociation] = None
    active_lock_reason: Optional[ActiveLockReason] = None


class PullRequestReviewCommentCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    comment: Optional[PullRequestReviewComment] = None
    pull_request: Optional[PullRequest6] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class Head1(Head5):
    pass


class Base2(Head5):
    pass


class PullRequest7(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    diff_url: Optional[AnyUrl] = None
    patch_url: Optional[AnyUrl] = None
    issue_url: Optional[AnyUrl] = None
    number: Optional[int] = None
    state: Optional[State5] = None
    locked: Optional[bool] = None
    title: Optional[str] = None
    user: Optional[User] = None
    body: Optional[str] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    closed_at: Optional[Optional[str]] = None
    merged_at: Optional[Optional[str]] = None
    merge_commit_sha: Optional[Optional[str]] = None
    assignee: Optional[Optional[User]] = None
    assignees: Optional[List[User]] = None
    requested_reviewers: Optional[List[Union[User, Team]]] = None
    requested_teams: Optional[List[Team]] = None
    labels: Optional[List[Label]] = None
    milestone: Optional[Optional[Milestone]] = None
    draft: Optional[bool] = None
    commits_url: Optional[AnyUrl] = None
    review_comments_url: Optional[AnyUrl] = None
    review_comment_url: Optional[str] = None
    comments_url: Optional[AnyUrl] = None
    statuses_url: Optional[AnyUrl] = None
    head: Optional[Head1] = None
    base: Optional[Base2] = None
    links: Optional[Links4] = Field(None, alias="_links")
    auto_merge: Optional[Optional[AutoMerge]] = None
    author_association: Optional[AuthorAssociation] = None
    active_lock_reason: Optional[ActiveLockReason] = None


class PullRequestReviewCommentDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    comment: Optional[PullRequestReviewComment] = None
    pull_request: Optional[PullRequest7] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class Head2(Head5):
    pass


class Base3(Head5):
    pass


class PullRequest8(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    diff_url: Optional[AnyUrl] = None
    patch_url: Optional[AnyUrl] = None
    issue_url: Optional[AnyUrl] = None
    number: Optional[int] = None
    state: Optional[State5] = None
    locked: Optional[bool] = None
    title: Optional[str] = None
    user: Optional[User] = None
    body: Optional[str] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    closed_at: Optional[Optional[str]] = None
    merged_at: Optional[Optional[str]] = None
    merge_commit_sha: Optional[Optional[str]] = None
    assignee: Optional[Optional[User]] = None
    assignees: Optional[List[User]] = None
    requested_reviewers: Optional[List[Union[User, Team]]] = None
    requested_teams: Optional[List[Team]] = None
    labels: Optional[List[Label]] = None
    milestone: Optional[Optional[Milestone]] = None
    draft: Optional[bool] = None
    commits_url: Optional[AnyUrl] = None
    review_comments_url: Optional[AnyUrl] = None
    review_comment_url: Optional[str] = None
    comments_url: Optional[AnyUrl] = None
    statuses_url: Optional[AnyUrl] = None
    head: Optional[Head2] = None
    base: Optional[Base3] = None
    links: Optional[Links5] = Field(None, alias="_links")
    auto_merge: Optional[Optional[AutoMerge]] = None
    author_association: Optional[AuthorAssociation] = None
    active_lock_reason: Optional[ActiveLockReason] = None


class PullRequestReviewCommentEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes25] = Field(
        None, description="The changes to the comment."
    )
    comment: Optional[PullRequestReviewComment] = None
    pull_request: Optional[PullRequest8] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewCommentEvent(BaseModel):
    __root__: Optional[
        Union[
            PullRequestReviewCommentCreated,
            PullRequestReviewCommentDeleted,
            PullRequestReviewCommentEdited,
        ]
    ] = None


class Thread(BaseModel):
    class Config:
        extra = Extra.forbid

    node_id: Optional[str] = None
    comments: Optional[List[PullRequestReviewComment]] = None


class PullRequestReviewThreadResolved(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["resolved"]] = None
    thread: Optional[Thread] = None
    pull_request: Optional[SimplePullRequest] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class Thread1(Thread):
    pass


class PullRequestReviewThreadUnresolved(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unresolved"]] = None
    thread: Optional[Thread1] = None
    pull_request: Optional[SimplePullRequest] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewThreadEvent(BaseModel):
    __root__: Optional[
        Union[PullRequestReviewThreadResolved, PullRequestReviewThreadUnresolved]
    ] = None


class PushEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    ref: Optional[str] = Field(
        None,
        description="The full git ref that was pushed. Example: `refs/heads/main` or `refs/tags/v3.14.1`.",
    )
    before: Optional[str] = Field(
        None, description="The SHA of the most recent commit on `ref` before the push."
    )
    after: Optional[str] = Field(
        None, description="The SHA of the most recent commit on `ref` after the push."
    )
    created: Optional[bool] = Field(
        None, description="Whether this push created the `ref`."
    )
    deleted: Optional[bool] = Field(
        None, description="Whether this push deleted the `ref`."
    )
    forced: Optional[bool] = Field(
        None, description="Whether this push was a force push of the `ref`."
    )
    base_ref: Optional[Optional[str]] = None
    compare: Optional[str] = Field(
        None,
        description="URL that shows the changes in this `ref` update, from the `before` commit to the `after` commit. For a newly created `ref` that is directly based on the default branch, this is the comparison between the head of the default branch and the `after` commit. Otherwise, this shows all commits until the `after` commit.",
    )
    commits: Optional[List[Commit]] = Field(
        None,
        description="An array of commit objects describing the pushed commits. (Pushed commits are all commits that are included in the `compare` between the `before` commit and the `after` commit.) The array includes a maximum of 20 commits. If necessary, you can use the [Commits API](https://docs.github.com/en/rest/reference/repos#commits) to fetch additional commits. This limit is applied to timeline events only and isn't applied to webhook deliveries.",
    )
    head_commit: Optional[Optional[Commit]] = Field(
        None,
        description="For pushes where `after` is or points to a commit object, an expanded representation of that commit. For pushes where `after` refers to an annotated tag object, an expanded representation of the commit pointed to by the annotated tag.",
    )
    repository: Optional[Repository] = None
    pusher: Optional[Committer] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ReleaseCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    release: Optional[ReleaseModel] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ReleaseDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    release: Optional[ReleaseModel] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ReleaseEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes26] = None
    release: Optional[ReleaseModel] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Release2(ReleaseModel):
    prerelease: Optional[Literal[True]] = Field(
        None,
        description="Whether the release is identified as a prerelease or a full release.",
    )


class ReleasePrereleased(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["prereleased"]] = None
    release: Optional[Release2] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Release3(ReleaseModel):
    published_at: Optional[datetime] = None


class ReleasePublished(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["published"]] = None
    release: Optional[Release3] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ReleaseReleased(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["released"]] = None
    release: Optional[ReleaseModel] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Release4(ReleaseModel):
    published_at: Optional[Any] = None


class ReleaseUnpublished(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unpublished"]] = None
    release: Optional[Release4] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class ReleaseEvent(BaseModel):
    __root__: Optional[
        Union[
            ReleaseCreated,
            ReleaseDeleted,
            ReleaseEdited,
            ReleasePrereleased,
            ReleasePublished,
            ReleaseReleased,
            ReleaseUnpublished,
        ]
    ] = None


class Repository7(Repository):
    archived: Optional[Literal[True]] = Field(
        False, description="Whether the repository is archived."
    )


class RepositoryArchived(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["archived"]] = None
    repository: Optional[Repository7] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class RepositoryCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class RepositoryDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class RepositoryEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes27] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Repository8(Repository):
    private: Optional[Literal[True]] = Field(
        None, description="Whether the repository is private or public."
    )


class RepositoryPrivatized(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["privatized"]] = None
    repository: Optional[Repository8] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Repository9(Repository):
    private: Optional[Literal[False]] = Field(
        None, description="Whether the repository is private or public."
    )


class RepositoryPublicized(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["publicized"]] = None
    repository: Optional[Repository9] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class RepositoryRenamed(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["renamed"]] = None
    changes: Optional[Changes28] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class RepositoryTransferred(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["transferred"]] = None
    changes: Optional[Changes29] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Repository11(Repository):
    archived: Optional[Literal[False]] = Field(
        False, description="Whether the repository is archived."
    )


class RepositoryUnarchived(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unarchived"]] = None
    repository: Optional[Repository11] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class RepositoryEvent(BaseModel):
    __root__: Optional[
        Union[
            RepositoryArchived,
            RepositoryCreated,
            RepositoryDeleted,
            RepositoryEdited,
            RepositoryPrivatized,
            RepositoryPublicized,
            RepositoryRenamed,
            RepositoryTransferred,
            RepositoryUnarchived,
        ]
    ] = None


class RepositoryDispatchEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[str] = None
    branch: Optional[str] = None
    client_payload: Optional[Dict[str, Any]] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class RepositoryImportEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    status: Optional[Status9] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Alert6(RepositoryVulnerabilityAlertAlert):
    state: Optional[Literal["open"]] = None


class RepositoryVulnerabilityAlertCreate(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["create"]] = None
    alert: Optional[Alert6] = None
    repository: Optional[Repository] = None
    sender: Optional[GithubOrg] = None
    organization: Optional[Organization] = None


class Alert7(RepositoryVulnerabilityAlertAlert):
    dismisser: Optional[User] = None
    dismiss_reason: Optional[str] = None
    dismissed_at: Optional[str] = None
    state: Optional[Literal["dismissed"]] = None


class RepositoryVulnerabilityAlertDismiss(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["dismiss"]] = None
    alert: Optional[Alert7] = None
    repository: Optional[Repository] = None
    sender: Optional[GithubOrg] = None
    organization: Optional[Organization] = None


class Alert8(Alert6):
    pass


class RepositoryVulnerabilityAlertReopen(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["reopen"]] = None
    alert: Optional[Alert8] = None
    repository: Optional[Repository] = None
    sender: Optional[GithubOrg] = None
    organization: Optional[Organization] = None


class Alert9(RepositoryVulnerabilityAlertAlert):
    state: Optional[Literal["fixed"]] = None
    fixed_at: Optional[datetime] = None
    fix_reason: Optional[str] = None


class RepositoryVulnerabilityAlertResolve(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["resolve"]] = None
    alert: Optional[Alert9] = None
    repository: Optional[Repository] = None
    sender: Optional[GithubOrg] = None
    organization: Optional[Organization] = None


class RepositoryVulnerabilityAlertEvent(BaseModel):
    __root__: Optional[
        Union[
            RepositoryVulnerabilityAlertCreate,
            RepositoryVulnerabilityAlertDismiss,
            RepositoryVulnerabilityAlertReopen,
            RepositoryVulnerabilityAlertResolve,
        ]
    ] = None


class SecretScanningAlertCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    alert: Optional[Alert10] = Field(
        None, description="The secret scanning alert involved in the event."
    )
    repository: Optional[Repository] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class SecretScanningAlertReopened(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["reopened"]] = None
    alert: Optional[Alert11] = Field(
        None, description="The secret scanning alert involved in the event."
    )
    repository: Optional[Repository] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None
    sender: Optional[User] = None


class SecretScanningAlertResolved(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["resolved"]] = None
    alert: Optional[Alert12] = Field(
        None, description="The secret scanning alert involved in the event."
    )
    repository: Optional[Repository] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None
    sender: Optional[User] = None


class SecretScanningAlertEvent(BaseModel):
    __root__: Optional[
        Union[
            SecretScanningAlertCreated,
            SecretScanningAlertReopened,
            SecretScanningAlertResolved,
        ]
    ] = None


class StarCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    starred_at: Optional[str] = Field(
        None,
        description="The time the star was created. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Will be `null` for the `deleted` action.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class StarDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    starred_at: Optional[Any] = Field(
        None,
        description="The time the star was created. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Will be `null` for the `deleted` action.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class StarEvent(BaseModel):
    __root__: Optional[Union[StarCreated, StarDeleted]] = None


class StatusEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[int] = Field(None, description="The unique identifier of the status.")
    sha: Optional[str] = Field(None, description="The Commit SHA.")
    name: Optional[str] = None
    avatar_url: Optional[Optional[str]] = None
    target_url: Optional[Optional[str]] = Field(
        None, description="The optional link added to the status."
    )
    context: Optional[str] = None
    description: Optional[Optional[str]] = Field(
        None, description="The optional human-readable description added to the status."
    )
    state: Optional[State11] = Field(
        None,
        description="The new state. Can be `pending`, `success`, `failure`, or `error`.",
    )
    commit: Optional[Commit1] = None
    branches: Optional[List[Branch]] = Field(
        None,
        description="An array of branch objects containing the status' SHA. Each branch contains the given SHA, but the SHA may or may not be the head of the branch. The array includes a maximum of 10 branches.",
    )
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class TeamAddedToRepository(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["added_to_repository"]] = None
    team: Optional[Team] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class TeamCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    team: Optional[Team] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class TeamDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    team: Optional[Team] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class TeamEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes33] = Field(
        None, description="The changes to the team if the action was `edited`."
    )
    team: Optional[Team] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class TeamRemovedFromRepository(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["removed_from_repository"]] = None
    team: Optional[Team] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None


class TeamEvent(BaseModel):
    __root__: Optional[
        Union[
            TeamAddedToRepository,
            TeamCreated,
            TeamDeleted,
            TeamEdited,
            TeamRemovedFromRepository,
        ]
    ] = None


class TeamAddEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    team: Optional[Team] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class WatchStarted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["started"]] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class WatchEvent(BaseModel):
    __root__: Optional[WatchStarted] = None


class WorkflowDispatchEvent(BaseModel):
    class Config:
        extra = Extra.forbid

    inputs: Optional[Union[Dict[str, Any], Any]] = Field(
        None,
        description="Inputs to the workflow. Each key represents the name of the input while it's value represents the value of that input.",
    )
    ref: Optional[str] = Field(
        None, description="The branch ref from which the workflow was run."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    workflow: Optional[str] = Field(
        None,
        description="Relative path to the workflow file which contains the workflow.",
    )


class WorkflowJobModel(WorkflowJob):
    class Config:
        extra = Extra.forbid

    conclusion: Optional[Conclusion12] = None


class WorkflowJobCompleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["completed"]] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    workflow_job: Optional[WorkflowJobModel] = None


class WorkflowJob1(WorkflowJob):
    status: Optional[Literal["in_progress"]] = None
    steps: Optional[List[WorkflowStepInProgress]] = Field(None, min_items=1)


class WorkflowJobInProgress(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["in_progress"]] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    workflow_job: Optional[WorkflowJob1] = None


class WorkflowJobQueued(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["queued"]] = None
    organization: Optional[Organization] = None
    installation: Optional[InstallationLite] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    workflow_job: Optional[WorkflowJob2] = None


class WorkflowJobEvent(BaseModel):
    __root__: Optional[
        Union[WorkflowJobCompleted, WorkflowJobInProgress, WorkflowJobQueued]
    ] = None


class WorkflowRunModel(WorkflowRun):
    class Config:
        extra = Extra.forbid

    conclusion: Optional[Conclusion13] = None


class WorkflowRunCompleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["completed"]] = None
    organization: Optional[Organization] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    workflow: Optional[Workflow] = None
    workflow_run: Optional[WorkflowRunModel] = None
    installation: Optional[InstallationLite] = None


class WorkflowRunRequested(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["requested"]] = None
    organization: Optional[Organization] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    workflow: Optional[Workflow] = None
    workflow_run: Optional[WorkflowRun] = None
    installation: Optional[InstallationLite] = None


class WorkflowRunEvent(BaseModel):
    __root__: Optional[Union[WorkflowRunCompleted, WorkflowRunRequested]] = None


class Issue(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = Field(None, description="URL for the issue")
    repository_url: Optional[AnyUrl] = None
    labels_url: Optional[str] = None
    comments_url: Optional[AnyUrl] = None
    events_url: Optional[AnyUrl] = None
    html_url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    number: Optional[int] = None
    title: Optional[str] = Field(None, description="Title of the issue")
    user: Optional[User] = None
    labels: Optional[List[Label]] = None
    state: Optional[State5] = Field(
        None, description="State of the issue; either 'open' or 'closed'"
    )
    locked: Optional[bool] = None
    assignee: Optional[Optional[User]] = None
    assignees: Optional[List[User]] = None
    milestone: Optional[Optional[Milestone]] = None
    comments: Optional[int] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    closed_at: Optional[Optional[str]] = None
    author_association: Optional[AuthorAssociation] = None
    active_lock_reason: Optional[ActiveLockReason] = None
    draft: Optional[bool] = None
    performed_via_github_app: Optional[Optional[App]] = None
    pull_request: Optional[PullRequest9] = None
    body: Optional[Optional[str]] = Field(None, description="Contents of the issue")
    reactions: Optional[Reactions] = None
    timeline_url: Optional[AnyUrl] = None


class Head4(Head5):
    pass


class Base5(Head5):
    pass


class PullRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    url: Optional[AnyUrl] = None
    id: Optional[int] = None
    node_id: Optional[str] = None
    html_url: Optional[AnyUrl] = None
    diff_url: Optional[AnyUrl] = None
    patch_url: Optional[AnyUrl] = None
    issue_url: Optional[AnyUrl] = None
    number: Optional[int] = Field(
        None,
        description="Number uniquely identifying the pull request within its repository.",
    )
    state: Optional[State5] = Field(
        None, description="State of this Pull Request. Either `open` or `closed`."
    )
    locked: Optional[bool] = None
    title: Optional[str] = Field(None, description="The title of the pull request.")
    user: Optional[User] = None
    body: Optional[Optional[str]] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    closed_at: Optional[Optional[str]] = None
    merged_at: Optional[Optional[str]] = None
    merge_commit_sha: Optional[Optional[str]] = None
    assignee: Optional[Optional[User]] = None
    assignees: Optional[List[User]] = None
    requested_reviewers: Optional[List[Union[User, Team]]] = None
    requested_teams: Optional[List[Team]] = None
    labels: Optional[List[Label]] = None
    milestone: Optional[Optional[Milestone]] = None
    commits_url: Optional[AnyUrl] = None
    review_comments_url: Optional[AnyUrl] = None
    review_comment_url: Optional[str] = None
    comments_url: Optional[AnyUrl] = None
    statuses_url: Optional[AnyUrl] = None
    head: Optional[Head4] = None
    base: Optional[Base5] = None
    links: Optional[Links7] = Field(None, alias="_links")
    author_association: Optional[AuthorAssociation] = None
    auto_merge: Optional[Optional[AutoMerge]] = None
    active_lock_reason: Optional[ActiveLockReason] = None
    draft: Optional[bool] = Field(
        None, description="Indicates whether or not the pull request is a draft."
    )
    merged: Optional[Optional[bool]] = None
    mergeable: Optional[Optional[bool]] = None
    rebaseable: Optional[Optional[bool]] = None
    mergeable_state: Optional[str] = None
    merged_by: Optional[Optional[User]] = None
    comments: Optional[int] = None
    review_comments: Optional[int] = None
    maintainer_can_modify: Optional[bool] = Field(
        None, description="Indicates whether maintainers can modify the pull request."
    )
    commits: Optional[int] = None
    additions: Optional[int] = None
    deletions: Optional[int] = None
    changed_files: Optional[int] = None


class IssueModel(Issue):
    class Config:
        extra = Extra.forbid

    assignee: Optional[Optional[User]] = None
    state: Optional[State5] = Field(
        None, description="State of the issue; either 'open' or 'closed'"
    )
    locked: Optional[bool] = None
    labels: Optional[List[Label]] = None


class IssueCommentCreated(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["created"]] = None
    issue: Optional[IssueModel] = Field(
        None,
        description="The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.",
    )
    comment: Optional[IssueComment] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Issue1(Issue):
    assignee: Optional[Optional[User]] = None
    state: Optional[State5] = Field(
        None, description="State of the issue; either 'open' or 'closed'"
    )
    locked: Optional[bool] = None
    labels: Optional[List[Label]] = None


class IssueCommentDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    issue: Optional[Issue1] = Field(
        None,
        description="The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.",
    )
    comment: Optional[IssueComment] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Issue2(Issue1):
    pass


class IssueCommentEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    changes: Optional[Changes5] = Field(None, description="The changes to the comment.")
    issue: Optional[Issue2] = Field(
        None,
        description="The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.",
    )
    comment: Optional[IssueComment] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class IssueCommentEvent(BaseModel):
    __root__: Optional[
        Union[IssueCommentCreated, IssueCommentDeleted, IssueCommentEdited]
    ] = None


class IssuesAssigned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["assigned"]] = Field(
        None, description="The action that was performed."
    )
    issue: Optional[Issue] = None
    assignee: Optional[Optional[User]] = Field(
        None,
        description="The optional user who was assigned or unassigned from the issue.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Issue3(Issue):
    state: Optional[Literal["closed"]] = None
    closed_at: Optional[str] = None


class IssuesClosed(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["closed"]] = Field(
        None, description="The action that was performed."
    )
    issue: Optional[Issue3] = Field(
        None,
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class IssuesDeleted(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["deleted"]] = None
    issue: Optional[Issue] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Issue4(Issue):
    milestone: Optional[Any] = None


class IssuesDemilestoned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["demilestoned"]] = None
    issue: Optional[Issue4] = None
    milestone: Optional[Milestone] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class IssuesEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    issue: Optional[Issue] = None
    label: Optional[Label] = None
    changes: Optional[Changes6] = Field(None, description="The changes to the issue.")
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class IssuesLabeled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["labeled"]] = None
    issue: Optional[Issue] = None
    label: Optional[Label] = Field(
        None, description="The label that was added to the issue."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Issue5(Issue):
    locked: Optional[Literal[True]] = None
    active_lock_reason: Optional[ActiveLockReason] = None


class IssuesLocked(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["locked"]] = None
    issue: Optional[Issue5] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Issue6(Issue):
    milestone: Optional[Milestone] = None


class IssuesMilestoned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["milestoned"]] = None
    issue: Optional[Issue6] = None
    milestone: Optional[Milestone] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Changes7(BaseModel):
    class Config:
        extra = Extra.forbid

    old_issue: Optional[Issue] = None
    old_repository: Optional[Repository] = None


class Issue7(Issue):
    state: Optional[Literal["open"]] = None
    closed_at: Optional[Any] = None


class IssuesOpened(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["opened"]] = None
    changes: Optional[Changes7] = None
    issue: Optional[Issue7] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class IssuesPinned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["pinned"]] = None
    issue: Optional[Issue] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Issue8(Issue):
    state: Optional[Literal["open"]] = None


class IssuesReopened(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["reopened"]] = None
    issue: Optional[Issue8] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Changes8(BaseModel):
    class Config:
        extra = Extra.forbid

    new_issue: Optional[Issue] = None
    new_repository: Optional[Repository] = None


class IssuesTransferred(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["transferred"]] = None
    changes: Optional[Changes8] = None
    issue: Optional[Issue] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class IssuesUnassigned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unassigned"]] = Field(
        None, description="The action that was performed."
    )
    issue: Optional[Issue] = None
    assignee: Optional[Optional[User]] = Field(
        None,
        description="The optional user who was assigned or unassigned from the issue.",
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class IssuesUnlabeled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unlabeled"]] = None
    issue: Optional[Issue] = None
    label: Optional[Label] = Field(
        None, description="The label that was removed from the issue."
    )
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class Issue9(Issue):
    locked: Optional[Literal[False]] = None
    active_lock_reason: Optional[Any] = None


class IssuesUnlocked(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unlocked"]] = None
    issue: Optional[Issue9] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class IssuesUnpinned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unpinned"]] = None
    issue: Optional[Issue] = None
    repository: Optional[Repository] = None
    sender: Optional[User] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None


class IssuesEvent(BaseModel):
    __root__: Optional[
        Union[
            IssuesAssigned,
            IssuesClosed,
            IssuesDeleted,
            IssuesDemilestoned,
            IssuesEdited,
            IssuesLabeled,
            IssuesLocked,
            IssuesMilestoned,
            IssuesOpened,
            IssuesPinned,
            IssuesReopened,
            IssuesTransferred,
            IssuesUnassigned,
            IssuesUnlabeled,
            IssuesUnlocked,
            IssuesUnpinned,
        ]
    ] = None


class PullRequestAssigned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["assigned"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    assignee: Optional[User] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestAutoMergeDisabled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["auto_merge_disabled"]] = None
    number: Optional[int] = None
    pull_request: Optional[PullRequest] = None
    reason: Optional[str] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestAutoMergeEnabled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["auto_merge_enabled"]] = None
    number: Optional[int] = None
    pull_request: Optional[PullRequest] = None
    reason: Optional[str] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequest1(PullRequest):
    state: Optional[Literal["closed"]] = Field(
        None, description="State of this Pull Request. Either `open` or `closed`."
    )
    closed_at: Optional[datetime] = None
    merged: Optional[bool] = None


class PullRequestClosed(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["closed"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest1] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequest2(PullRequest):
    closed_at: Optional[Any] = None
    merged_at: Optional[Any] = None
    draft: Optional[Literal[True]] = Field(
        None, description="Indicates whether or not the pull request is a draft."
    )
    merged: Optional[Literal[False]] = None
    merged_by: Optional[Any] = None


class PullRequestConvertedToDraft(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["converted_to_draft"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest2] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestEdited(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["edited"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    changes: Optional[Changes23] = Field(
        None, description="The changes to the comment if the action was `edited`."
    )
    pull_request: Optional[PullRequest] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestLabeled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["labeled"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    label: Optional[Label] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestLocked(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["locked"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequest3(PullRequest):
    state: Optional[Literal["open"]] = None
    closed_at: Optional[Any] = None
    merged_at: Optional[Any] = None
    merge_commit_sha: Optional[Any] = None
    active_lock_reason: Optional[Any] = None
    merged_by: Optional[Any] = None


class PullRequestOpened(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["opened"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest3] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequest4(PullRequest):
    state: Optional[Literal["open"]] = None
    closed_at: Optional[Any] = None
    merged_at: Optional[Any] = None
    draft: Optional[Literal[False]] = Field(
        None, description="Indicates whether or not the pull request is a draft."
    )
    merged: Optional[bool] = None
    merged_by: Optional[Any] = None


class PullRequestReadyForReview(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["ready_for_review"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest4] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequest5(PullRequest):
    state: Optional[Literal["open"]] = None
    closed_at: Optional[Any] = None
    merged_at: Optional[Any] = None
    merged: Optional[bool] = None
    merged_by: Optional[Any] = None


class PullRequestReopened(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["reopened"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest5] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewRequestRemovedItem(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["review_request_removed"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    requested_reviewer: Optional[User] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewRequestRemovedItem1(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["review_request_removed"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    requested_team: Optional[Team] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewRequestRemoved(BaseModel):
    __root__: Optional[
        Union[PullRequestReviewRequestRemovedItem, PullRequestReviewRequestRemovedItem1]
    ] = Field(None, title="pull_request review_request_removed event")


class PullRequestReviewRequestedItem(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["review_requested"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    requested_reviewer: Optional[User] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewRequestedItem1(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["review_requested"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    requested_team: Optional[Team] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestReviewRequested(BaseModel):
    __root__: Optional[
        Union[PullRequestReviewRequestedItem, PullRequestReviewRequestedItem1]
    ] = Field(None, title="pull_request review_requested event")


class PullRequestSynchronize(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["synchronize"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    before: Optional[str] = None
    after: Optional[str] = None
    pull_request: Optional[PullRequest] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestUnassigned(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unassigned"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    assignee: Optional[User] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestUnlabeled(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unlabeled"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    label: Optional[Label] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestUnlocked(BaseModel):
    class Config:
        extra = Extra.forbid

    action: Optional[Literal["unlocked"]] = None
    number: Optional[int] = Field(None, description="The pull request number.")
    pull_request: Optional[PullRequest] = None
    repository: Optional[Repository] = None
    installation: Optional[InstallationLite] = None
    organization: Optional[Organization] = None
    sender: Optional[User] = None


class PullRequestEvent(BaseModel):
    __root__: Optional[
        Union[
            PullRequestAssigned,
            PullRequestAutoMergeDisabled,
            PullRequestAutoMergeEnabled,
            PullRequestClosed,
            PullRequestConvertedToDraft,
            PullRequestEdited,
            PullRequestLabeled,
            PullRequestLocked,
            PullRequestOpened,
            PullRequestReadyForReview,
            PullRequestReopened,
            PullRequestReviewRequestRemoved,
            PullRequestReviewRequested,
            PullRequestSynchronize,
            PullRequestUnassigned,
            PullRequestUnlabeled,
            PullRequestUnlocked,
        ]
    ] = None


class Model(BaseModel):
    __root__: Optional[
        Union[
            BranchProtectionRuleEvent,
            CheckRunEvent,
            CheckSuiteEvent,
            CodeScanningAlertEvent,
            CommitCommentEvent,
            CreateEvent,
            DeleteEvent,
            DeployKeyEvent,
            DeploymentEvent,
            DeploymentStatusEvent,
            DiscussionEvent,
            DiscussionCommentEvent,
            ForkEvent,
            GithubAppAuthorizationEvent,
            GollumEvent,
            InstallationEvent,
            InstallationRepositoriesEvent,
            IssueCommentEvent,
            IssuesEvent,
            LabelEvent,
            MarketplacePurchaseEvent,
            MemberEvent,
            MembershipEvent,
            MetaEvent,
            MilestoneEvent,
            OrgBlockEvent,
            OrganizationEvent,
            PackageEvent,
            PageBuildEvent,
            PingEvent,
            ProjectEvent,
            ProjectCardEvent,
            ProjectColumnEvent,
            ProjectsV2ItemEvent,
            PublicEvent,
            PullRequestEvent,
            PullRequestReviewEvent,
            PullRequestReviewCommentEvent,
            PullRequestReviewThreadEvent,
            PushEvent,
            ReleaseEvent,
            RepositoryEvent,
            RepositoryDispatchEvent,
            RepositoryImportEvent,
            RepositoryVulnerabilityAlertEvent,
            SecretScanningAlertEvent,
            SecurityAdvisoryEvent,
            SponsorshipEvent,
            StarEvent,
            StatusEvent,
            TeamEvent,
            TeamAddEvent,
            WatchEvent,
            WorkflowDispatchEvent,
            WorkflowJobEvent,
            WorkflowRunEvent,
        ]
    ] = None
