""" GlobalAvgPooling Module"""
from mindspore import nn
from mindspore import ops


class GlobalAvgPooling(nn.Cell):
    """
    GlobalAvgPooling, same as torch.nn.AdaptiveAvgPool2d when output shape is 1
    """
    def __init__(self,
                 keep_dims: bool = False
                 ) -> None:
        super().__init__()
        self.keep_dims = keep_dims

    def construct(self, x):
        x = ops.mean(x, axis=(2, 3), keep_dims=self.keep_dims)
        return x
