# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['powernap']

package_data = \
{'': ['*']}

install_requires = \
['httpx', 'typing-extensions>=4.4.0,<5.0.0']

setup_kwargs = {
    'name': 'powernap',
    'version': '1.0.0',
    'description': 'A small REST client that refills your batteries',
    'long_description': '# PowerNap\n\n[![Deployed to PyPI](https://img.shields.io/pypi/pyversions/powernap?logo=pypi&logoColor=white)](https://pypi.org/pypi/powernap)\n[![GitHub Repository](https://img.shields.io/github/stars/ewjoachim/powernap?logo=github)](https://github.com/ewjoachim/powernap/)\n[![Continuous Integration](https://img.shields.io/github/workflow/status/ewjoachim/powernap/CI?logo=github)](https://github.com/ewjoachim/powernap/actions?workflow=CI)\n[![Coverage](https://raw.githubusercontent.com/ewjoachim/powernap/python-coverage-comment-action-data/badge.svg)](https://github.com/ewjoachim/powernap/tree/python-coverage-comment-action-data)\n[![MIT License](https://img.shields.io/github/license/ewjoachim/powernap?logo=open-source-initiative&logoColor=white)](https://github.com/ewjoachim/powernap/blob/main/LICENSE.md)\n[![Contributor Covenant](https://img.shields.io/badge/Contributor%20Covenant-v1.4%20adopted-ff69b4.svg)](https://github.com/ewjoachim/powernap/blob/main/LICENSE/CODE_OF_CONDUCT.md)\n\nPowerNap is a simplistic API client, a small wrapper around httpx that makes your code\na bit more fluidly\n\n## Installation\n\n```console\n$ pip install powernap\n```\n\n## Usage\n\n```python\n# You will need an httpx Client. Let\'s do a GitHub client!\nhttpx_client = httpx.Client(\n    base_url="https://api.github.com/v3",\n    headers={"Authorization": f"token {token}"}\n)\n\n# Instantiate the PowerNap client\ngithub_client = powernap.PowerNap(httpx_client=httpx_client)\n\n# PowerNap will help you build complex URLs in a pythonic-looking way:\nrepo = github_client.repos("ewjoachim/powernap").get()\n\n# And access the json responses like objects\ncount_stars = repo.stargazers_count\n\n# You can also easily send POST requests.\ngithub_client.repos("ewjoachim/powernap").issues(42).comments.post(\n    body=f"Wow look! This repo has {count_stars} stars!"\n)\n```\n\n### Build complex URLs\n\nYou can use `client(something)` or `client.something`, and chain calls.\nWith the form `client(something)`, you can pass multiple parameters, and they\nwill be joined together\n\n```python\n\n# The next calls are all identical and target:\n#    {base_url}/repos/ewjoachim/powernap/stargazers\ngithub_client.repos("ewjoachim/powernap").stargazers.get()\ngithub_client.repos("ewjoachim").powernap("stargazers").get()\ngithub_client.repos("ewjoachim", "powernap", "stargazers").get()\ngithub_client.repos("ewjoachim", "powernap")("stargazers").get()\ngithub_client("repos/ewjoachim/powernap/stargazers").get()\n\n# The recommended way is to use client.something for static parts of the url and\n# client(something) with a variable for dynamic parts.\n\n# You can also target the base url directly\n# {base_url}\ngithub_client().get()\n```\n\n### Access the json responses like objects\n\nOn the json responses, all objects (even nested) are configured so that you can\nget keys with the `object.key` syntax in addition to the classic\n`object["key"]`.\n\n```python\n# GET /nested_json -> {"a": {"b":{"c": "d"}}}\nresponse = some_api_client.nested_json.get()\n\nassert response == {"a": {"b":{"c": "d"}}}\nassert response["a"]["b"]["c"] == "d"\n# But also the magic form:\nassert response.a.b.c == "d"\n```\n\n### Arguments\n\nThe arguments in the `.get/delete()` calls are used as query parameters on\nthe call.\n\nThe arguments in the `.post/put/patch()` calls are put together, and passed\nas the json payload for the call.\n\n\n### Response types\n\nIf the response comes with `Content-Type: application/json`, then you\'ll get\nthe "magic" json response as described above. Otherwise, if the content type\nis `text/*`, you\'ll get a `string`, and otherwise, you\'ll get `bytes`.\n\n### More control over input and output\n\nThis magic is nice and all, but sometimes, you may want more control.\nIf you want to send additional headers or a non-JSON-dict payload, or\nif you want to read the headers on the response, it possible too.\n\nInstead of calling `.get()`, use either `.get.i()`, `.get.o()` or `.get.io()`\n(it works with any method: `get/post/put/patch/delete`):\n\n- If you call with `.get.i(...)` (or `.get.io(...)`), you control the input.\n  The method keyword arguments will be passed to the underlying\n  `httpx.Client().get(...)` as-is.\n- If you call with `.get.o(...)` (or `.get.io(...)`), you get the original\n  output. The function will return a `httpx.Response` object. (Note that in\n  this case, we will still have called `.raise_for_status()`)\n\nIf you regularly use `get.io()`, it\'s probably that PowerNap is probably not\nthe project you need. Use `httpx.Client` directly, build something to help you\ncraft URLs (you can ~~steal~~ copy the relevant code, don\'t forget to copy the\nlicense too)\n\n## Name\n\nWhile looking for a name for this lib, I looked at all the synonyms for "small\nrest". It\'s amazing how many other projects have gone the same route. To name a\nfew:\n- [`nap`](https://pypi.org/project/nap/) looks awesome! Unrelated lib but same\n  goals as this one. Seems unmaintained but I\'m not sure a lib like this needs\n  a lot of maintenance.\n- [`catnap`](https://pypi.org/project/Catnap/)\n- [`respite`](https://pypi.org/project/respite/)\n- `snooze` is not taken but\n  [`snooze-server`](https://pypi.org/project/snooze-server/) is and I didn\'t\n  want to create confusion.\n\nFunnily enough, a consequent number of those projects have the same goals as\nthis one, yet don\'t have the exact look and feel I\'m trying to achieve.\n\n## Credits where due\n\nThis lib is heavily inspired from githubpy, which is under Apache license.\n\n- [The version that was used for inspiration](https://github.com/michaelliao/githubpy/blob/96d0c3e729c0b3e3c043a604547ccff17782ac2b/github.py)\n- Author: Michael Liao (askxuefeng@gmail.com)\n- [Original license](https://github.com/michaelliao/githubpy/blob/96d0c3e729c0b3e3c043a604547ccff17782ac2b/LICENSE.txt)\n',
    'author': 'Joachim Jablon',
    'author_email': 'ewjoachim@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ewjoachim/powernap',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
