/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.bucketing;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.physical.AllTuples$;
import org.apache.spark.sql.catalyst.plans.physical.ClusteredDistribution;
import org.apache.spark.sql.catalyst.plans.physical.Distribution;
import org.apache.spark.sql.catalyst.plans.physical.HashClusteredDistribution;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.aggregate.BaseAggregateExec;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.BitSet;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;

public final class DisableUnnecessaryBucketedScan$
extends Rule<SparkPlan> {
    public static DisableUnnecessaryBucketedScan$ MODULE$;

    static {
        new DisableUnnecessaryBucketedScan$();
    }

    private SparkPlan disableBucketWithInterestingPartition(SparkPlan plan, boolean withInterestingPartition, boolean withExchange, boolean withAllowedNode) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2 = plan;
        if (this.hasInterestingPartition(sparkPlan2)) {
            sparkPlan = (SparkPlan)sparkPlan2.mapChildren((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.disableBucketWithInterestingPartition((SparkPlan)((Object)x$1), true, false, true));
        } else if (sparkPlan2 instanceof Exchange) {
            Exchange exchange = (Exchange)sparkPlan2;
            sparkPlan = (SparkPlan)exchange.mapChildren((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.disableBucketWithInterestingPartition((SparkPlan)((Object)x$2), withInterestingPartition, true, withAllowedNode));
        } else if (sparkPlan2 instanceof FileSourceScanExec) {
            FileSourceScanExec fileSourceScanExec;
            FileSourceScanExec fileSourceScanExec2 = (FileSourceScanExec)sparkPlan2;
            if (this.isBucketedScanWithoutFilter(fileSourceScanExec2)) {
                if (!withInterestingPartition || withExchange && withAllowedNode) {
                    boolean x$12 = true;
                    HadoopFsRelation x$22 = fileSourceScanExec2.copy$default$1();
                    Seq<Attribute> x$32 = fileSourceScanExec2.copy$default$2();
                    StructType x$4 = fileSourceScanExec2.copy$default$3();
                    Seq<Expression> x$5 = fileSourceScanExec2.copy$default$4();
                    Option<BitSet> x$6 = fileSourceScanExec2.copy$default$5();
                    Option<Object> x$7 = fileSourceScanExec2.copy$default$6();
                    Seq<Expression> x$8 = fileSourceScanExec2.copy$default$7();
                    Option<TableIdentifier> x$9 = fileSourceScanExec2.copy$default$8();
                    FileSourceScanExec nonBucketedScan = fileSourceScanExec2.copy(x$22, x$32, x$4, x$5, x$6, x$7, x$8, x$9, x$12);
                    fileSourceScanExec2.logicalLink().foreach((Function1 & Serializable & scala.Serializable)logicalPlan2 -> {
                        nonBucketedScan.setLogicalLink(logicalPlan2);
                        return BoxedUnit.UNIT;
                    });
                    fileSourceScanExec = nonBucketedScan;
                } else {
                    fileSourceScanExec = fileSourceScanExec2;
                }
            } else {
                fileSourceScanExec = fileSourceScanExec2;
            }
            sparkPlan = fileSourceScanExec;
        } else {
            sparkPlan = (SparkPlan)sparkPlan2.mapChildren((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.disableBucketWithInterestingPartition((SparkPlan)((Object)x$3), withInterestingPartition, withExchange, withAllowedNode && MODULE$.isAllowedUnaryExecNode(sparkPlan2)));
        }
        return sparkPlan;
    }

    private boolean hasInterestingPartition(SparkPlan plan) {
        return plan.requiredChildDistribution().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DisableUnnecessaryBucketedScan$.$anonfun$hasInterestingPartition$1(x0$1)));
    }

    private boolean isAllowedUnaryExecNode(SparkPlan plan) {
        boolean bl;
        SparkPlan sparkPlan = plan;
        boolean bl2 = sparkPlan instanceof SortExec ? true : (sparkPlan instanceof ProjectExec ? true : sparkPlan instanceof FilterExec);
        if (bl2) {
            bl = true;
        } else if (sparkPlan instanceof BaseAggregateExec) {
            BaseAggregateExec baseAggregateExec = (BaseAggregateExec)((Object)sparkPlan);
            bl = baseAggregateExec.requiredChildDistributionExpressions().isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isBucketedScanWithoutFilter(FileSourceScanExec scan) {
        return scan.bucketedScan() && scan.optionalBucketSet().isEmpty();
    }

    public SparkPlan apply(SparkPlan plan) {
        LazyBoolean hasBucketedScanWithoutFilter$lzy = new LazyBoolean();
        return !this.conf().bucketingEnabled() || !this.conf().autoBucketedScanEnabled() || !DisableUnnecessaryBucketedScan$.hasBucketedScanWithoutFilter$1(hasBucketedScanWithoutFilter$lzy, plan) ? plan : this.disableBucketWithInterestingPartition(plan, false, false, true);
    }

    public static final /* synthetic */ boolean $anonfun$hasInterestingPartition$1(Distribution x0$1) {
        Distribution distribution = x0$1;
        boolean bl = distribution instanceof ClusteredDistribution ? true : (distribution instanceof HashClusteredDistribution ? true : AllTuples$.MODULE$.equals(distribution));
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(SparkPlan x0$1) {
        boolean bl;
        SparkPlan sparkPlan = x0$1;
        if (sparkPlan instanceof FileSourceScanExec) {
            FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
            bl = MODULE$.isBucketedScanWithoutFilter(fileSourceScanExec);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final /* synthetic */ boolean hasBucketedScanWithoutFilter$lzycompute$1(LazyBoolean hasBucketedScanWithoutFilter$lzy$1, SparkPlan plan$1) {
        boolean bl;
        LazyBoolean lazyBoolean = hasBucketedScanWithoutFilter$lzy$1;
        synchronized (lazyBoolean) {
            bl = hasBucketedScanWithoutFilter$lzy$1.initialized() ? hasBucketedScanWithoutFilter$lzy$1.value() : hasBucketedScanWithoutFilter$lzy$1.initialize(plan$1.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DisableUnnecessaryBucketedScan$.$anonfun$apply$1(x0$1))).isDefined());
        }
        return bl;
    }

    private static final boolean hasBucketedScanWithoutFilter$1(LazyBoolean hasBucketedScanWithoutFilter$lzy$1, SparkPlan plan$1) {
        return hasBucketedScanWithoutFilter$lzy$1.initialized() ? hasBucketedScanWithoutFilter$lzy$1.value() : DisableUnnecessaryBucketedScan$.hasBucketedScanWithoutFilter$lzycompute$1(hasBucketedScanWithoutFilter$lzy$1, plan$1);
    }

    private DisableUnnecessaryBucketedScan$() {
        MODULE$ = this;
    }
}

