/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyEgressRule;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyEgressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyEgressRuleFluentImpl;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRule;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyIngressRuleFluentImpl;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicySpec;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class NetworkPolicySpecFluentImpl<A extends NetworkPolicySpecFluent<A>>
extends BaseFluent<A>
implements NetworkPolicySpecFluent<A> {
    private List<NetworkPolicyEgressRuleBuilder> egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
    private List<NetworkPolicyIngressRuleBuilder> ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
    private LabelSelectorBuilder podSelector;
    private List<String> policyTypes = new ArrayList<String>();

    public NetworkPolicySpecFluentImpl() {
    }

    public NetworkPolicySpecFluentImpl(NetworkPolicySpec instance) {
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.withPolicyTypes(instance.getPolicyTypes());
    }

    @Override
    public A addToEgress(int index, NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
        }
        NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
        this._visitables.get((Object)"egress").add(index >= 0 ? index : this._visitables.get((Object)"egress").size(), builder);
        this.egress.add(index >= 0 ? index : this.egress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEgress(int index, NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
        }
        NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"egress").size()) {
            this._visitables.get((Object)"egress").add(builder);
        } else {
            this._visitables.get((Object)"egress").set(index, builder);
        }
        if (index < 0 || index >= this.egress.size()) {
            this.egress.add(builder);
        } else {
            this.egress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEgress(NetworkPolicyEgressRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
        }
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgress(Collection<NetworkPolicyEgressRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
        }
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgress(NetworkPolicyEgressRule ... items) {
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get((Object)"egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgress(Collection<NetworkPolicyEgressRule> items) {
        for (NetworkPolicyEgressRule item : items) {
            NetworkPolicyEgressRuleBuilder builder = new NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get((Object)"egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyEgressRuleBuilder> each = this.egress.iterator();
        List visitables = this._visitables.get((Object)"egress");
        while (each.hasNext()) {
            NetworkPolicyEgressRuleBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicyEgressRule> getEgress() {
        return NetworkPolicySpecFluentImpl.build(this.egress);
    }

    @Override
    public List<NetworkPolicyEgressRule> buildEgress() {
        return NetworkPolicySpecFluentImpl.build(this.egress);
    }

    @Override
    public NetworkPolicyEgressRule buildEgress(int index) {
        return this.egress.get(index).build();
    }

    @Override
    public NetworkPolicyEgressRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    @Override
    public NetworkPolicyEgressRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    @Override
    public NetworkPolicyEgressRule buildMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        for (NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        for (NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgress(List<NetworkPolicyEgressRule> egress) {
        if (this.egress != null) {
            this._visitables.get((Object)"egress").removeAll(this.egress);
        }
        if (egress != null) {
            this.egress = new ArrayList<NetworkPolicyEgressRuleBuilder>();
            for (NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)this;
    }

    @Override
    public A withEgress(NetworkPolicyEgressRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
        }
        if (egress != null) {
            for (NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> addNewEgress() {
        return new EgressNestedImpl();
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(NetworkPolicyEgressRule item) {
        return new EgressNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(int index, NetworkPolicyEgressRule item) {
        return new EgressNestedImpl(index, item);
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public NetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.apply((Object)this.egress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public A addToIngress(int index, NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
        }
        NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
        this._visitables.get((Object)"ingress").add(index >= 0 ? index : this._visitables.get((Object)"ingress").size(), builder);
        this.ingress.add(index >= 0 ? index : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(int index, NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
        }
        NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"ingress").size()) {
            this._visitables.get((Object)"ingress").add(builder);
        } else {
            this._visitables.get((Object)"ingress").set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(NetworkPolicyIngressRule ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
        }
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<NetworkPolicyIngressRule> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
        }
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(NetworkPolicyIngressRule ... items) {
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get((Object)"ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<NetworkPolicyIngressRule> items) {
        for (NetworkPolicyIngressRule item : items) {
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get((Object)"ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyIngressRuleBuilder> each = this.ingress.iterator();
        List visitables = this._visitables.get((Object)"ingress");
        while (each.hasNext()) {
            NetworkPolicyIngressRuleBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicyIngressRule> getIngress() {
        return NetworkPolicySpecFluentImpl.build(this.ingress);
    }

    @Override
    public List<NetworkPolicyIngressRule> buildIngress() {
        return NetworkPolicySpecFluentImpl.build(this.ingress);
    }

    @Override
    public NetworkPolicyIngressRule buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public NetworkPolicyIngressRule buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public NetworkPolicyIngressRule buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public NetworkPolicyIngressRule buildMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        for (NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        for (NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<NetworkPolicyIngressRule> ingress) {
        if (this.ingress != null) {
            this._visitables.get((Object)"ingress").removeAll(this.ingress);
        }
        if (ingress != null) {
            this.ingress = new ArrayList<NetworkPolicyIngressRuleBuilder>();
            for (NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(NetworkPolicyIngressRule ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
        }
        if (ingress != null) {
            for (NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(int index, NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.apply((Object)this.ingress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    @Deprecated
    public LabelSelector getPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.get((Object)"podSelector").remove(this.podSelector);
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.get((Object)"podSelector").add(this.podSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodSelector() {
        return this.podSelector != null;
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNestedImpl();
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNestedImpl(item);
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector());
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : item);
    }

    @Override
    public A addToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPolicyTypes(String ... items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPolicyTypes(Collection<String> items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPolicyTypes(String ... items) {
        for (String item : items) {
            if (this.policyTypes == null) continue;
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPolicyTypes(Collection<String> items) {
        for (String item : items) {
            if (this.policyTypes == null) continue;
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    @Override
    public String getPolicyType(int index) {
        return this.policyTypes.get(index);
    }

    @Override
    public String getFirstPolicyType() {
        return this.policyTypes.get(0);
    }

    @Override
    public String getLastPolicyType() {
        return this.policyTypes.get(this.policyTypes.size() - 1);
    }

    @Override
    public String getMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPolicyTypes(List<String> policyTypes) {
        if (this.policyTypes != null) {
            this._visitables.get((Object)"policyTypes").removeAll(this.policyTypes);
        }
        if (policyTypes != null) {
            this.policyTypes = new ArrayList<String>();
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        } else {
            this.policyTypes = null;
        }
        return (A)this;
    }

    @Override
    public A withPolicyTypes(String ... policyTypes) {
        if (this.policyTypes != null) {
            this.policyTypes.clear();
        }
        if (policyTypes != null) {
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicyTypes() {
        return this.policyTypes != null && !this.policyTypes.isEmpty();
    }

    @Override
    public A addNewPolicyType(String arg1) {
        return this.addToPolicyTypes(new String(arg1));
    }

    @Override
    public A addNewPolicyType(StringBuilder arg1) {
        return this.addToPolicyTypes(new String(arg1));
    }

    @Override
    public A addNewPolicyType(StringBuffer arg1) {
        return this.addToPolicyTypes(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkPolicySpecFluentImpl that = (NetworkPolicySpecFluentImpl)o;
        if (this.egress != null ? !this.egress.equals(that.egress) : that.egress != null) {
            return false;
        }
        if (this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null) {
            return false;
        }
        if (this.podSelector != null ? !this.podSelector.equals((Object)that.podSelector) : that.podSelector != null) {
            return false;
        }
        return !(this.policyTypes != null ? !this.policyTypes.equals(that.policyTypes) : that.policyTypes != null);
    }

    public int hashCode() {
        return Objects.hash(this.egress, this.ingress, this.podSelector, this.policyTypes, super.hashCode());
    }

    public class PodSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<NetworkPolicySpecFluent.PodSelectorNested<N>>
    implements NetworkPolicySpecFluent.PodSelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        PodSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        PodSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicySpecFluentImpl.this.withPodSelector(this.builder.build());
        }

        @Override
        public N endPodSelector() {
            return this.and();
        }
    }

    public class IngressNestedImpl<N>
    extends NetworkPolicyIngressRuleFluentImpl<NetworkPolicySpecFluent.IngressNested<N>>
    implements NetworkPolicySpecFluent.IngressNested<N>,
    Nested<N> {
        private final NetworkPolicyIngressRuleBuilder builder;
        private final int index;

        IngressNestedImpl(int index, NetworkPolicyIngressRule item) {
            this.index = index;
            this.builder = new NetworkPolicyIngressRuleBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyIngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicySpecFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }

    public class EgressNestedImpl<N>
    extends NetworkPolicyEgressRuleFluentImpl<NetworkPolicySpecFluent.EgressNested<N>>
    implements NetworkPolicySpecFluent.EgressNested<N>,
    Nested<N> {
        private final NetworkPolicyEgressRuleBuilder builder;
        private final int index;

        EgressNestedImpl(int index, NetworkPolicyEgressRule item) {
            this.index = index;
            this.builder = new NetworkPolicyEgressRuleBuilder(this, item);
        }

        EgressNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyEgressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicySpecFluentImpl.this.setToEgress(this.index, this.builder.build());
        }

        @Override
        public N endEgress() {
            return this.and();
        }
    }
}

