/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractAll$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp[, idx]) - Extract all strings in the `str` that match the `regexp`\n    expression and corresponding to the regex group index.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.\n\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".\n\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * idx - an integer expression that representing the group index. The regex may contains\n          multiple groups. `idx` indicates which regex group to extract. The group index should\n          be non-negative. The minimum value of `idx` is 0, which means matching the entire\n          regular expression. If `idx` is not specified, the default group index value is 1. The\n          `idx` parameter is the Java regex Matcher group() method index.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200, 300-400', '(\\\\d+)-(\\\\d+)', 1);\n       [\"100\",\"300\"]\n  ", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\u0010 \u00012B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011!\u0011\u0005A!f\u0001\n\u0003Y\u0004\u0002C\"\u0001\u0005#\u0005\u000b\u0011\u0002\u001f\t\u000b\u0011\u0003A\u0011A#\t\u000b\u0011\u0003A\u0011\u0001&\t\u000b=\u0003A\u0011\t)\t\u000ba\u0003A\u0011I-\t\u000b\u0001\u0004A\u0011I1\t\u000b5\u0004A\u0011\u000b8\t\u000fq\u0004\u0011\u0011!C\u0001{\"I\u00111\u0001\u0001\u0012\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u00037\u0001\u0011\u0013!C\u0001\u0003\u000bA\u0011\"!\b\u0001#\u0003%\t!!\u0002\t\u0013\u0005}\u0001!!A\u0005B\u0005\u0005\u0002\"CA\u0019\u0001\u0005\u0005I\u0011AA\u001a\u0011%\tY\u0004AA\u0001\n\u0003\ti\u0004C\u0005\u0002D\u0001\t\t\u0011\"\u0011\u0002F!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003?\u0002\u0011\u0011!C!\u0003C:\u0011\"!\" \u0003\u0003E\t!a\"\u0007\u0011yy\u0012\u0011!E\u0001\u0003\u0013Ca\u0001\u0012\r\u0005\u0002\u0005]\u0005\"CAM1\u0005\u0005IQIAN\u0011%\ti\nGA\u0001\n\u0003\u000by\nC\u0005\u0002(b\t\t\u0011\"!\u0002*\"I\u00111\u0018\r\u0002\u0002\u0013%\u0011Q\u0018\u0002\u0011%\u0016<W\t\u001f9FqR\u0014\u0018m\u0019;BY2T!\u0001I\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003E\r\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003I\u0015\n1a]9m\u0015\t1s%A\u0003ta\u0006\u00148N\u0003\u0002)S\u00051\u0011\r]1dQ\u0016T\u0011AK\u0001\u0004_J<7\u0001A\n\u0005\u00015\nt\u0007\u0005\u0002/_5\tq$\u0003\u00021?\t\t\"+Z4FqB,\u0005\u0010\u001e:bGR\u0014\u0015m]3\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u000fA\u0013x\u000eZ;diB\u0011!\u0007O\u0005\u0003sM\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fqa];cU\u0016\u001cG/F\u0001=!\tqS(\u0003\u0002??\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0011M,(M[3di\u0002\naA]3hKb\u0004\u0018a\u0002:fO\u0016D\b\u000fI\u0001\u0004S\u0012D\u0018\u0001B5eq\u0002\na\u0001P5oSRtD\u0003\u0002$H\u0011&\u0003\"A\f\u0001\t\u000bi:\u0001\u0019\u0001\u001f\t\u000b\u0001;\u0001\u0019\u0001\u001f\t\u000b\t;\u0001\u0019\u0001\u001f\u0015\u0007\u0019[U\nC\u0003M\u0011\u0001\u0007A(A\u0001t\u0011\u0015q\u0005\u00021\u0001=\u0003\u0005\u0011\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003B)U+^\u0003\"A\r*\n\u0005M\u001b$aA!os\")A*\u0003a\u0001#\")a+\u0003a\u0001#\u0006\t\u0001\u000fC\u0003O\u0013\u0001\u0007\u0011+\u0001\u0005eCR\fG+\u001f9f+\u0005Q\u0006CA._\u001b\u0005a&BA/$\u0003\u0015!\u0018\u0010]3t\u0013\tyFL\u0001\u0005ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002EB\u00111M\u001b\b\u0003I\"\u0004\"!Z\u001a\u000e\u0003\u0019T!aZ\u0016\u0002\rq\u0012xn\u001c;?\u0013\tI7'\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA54\u0003%!wnR3o\u0007>$W\rF\u0002pkj\u0004\"\u0001]:\u000e\u0003ET!A]\u0010\u0002\u000f\r|G-Z4f]&\u0011A/\u001d\u0002\t\u000bb\u0004(oQ8eK\")a\u000f\u0004a\u0001o\u0006\u00191\r\u001e=\u0011\u0005AD\u0018BA=r\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQa\u001f\u0007A\u0002=\f!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u0006\rz|\u0018\u0011\u0001\u0005\bu5\u0001\n\u00111\u0001=\u0011\u001d\u0001U\u0002%AA\u0002qBqAQ\u0007\u0011\u0002\u0003\u0007A(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d!f\u0001\u001f\u0002\n-\u0012\u00111\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016M\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI\"a\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\t\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005!A.\u00198h\u0015\t\ti#\u0001\u0003kCZ\f\u0017bA6\u0002(\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0007\t\u0004e\u0005]\u0012bAA\u001dg\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0011+a\u0010\t\u0013\u0005\u00053#!AA\u0002\u0005U\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002HA)\u0011\u0011JA(#6\u0011\u00111\n\u0006\u0004\u0003\u001b\u001a\u0014AC2pY2,7\r^5p]&!\u0011\u0011KA&\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0013Q\f\t\u0004e\u0005e\u0013bAA.g\t9!i\\8mK\u0006t\u0007\u0002CA!+\u0005\u0005\t\u0019A)\u0002\r\u0015\fX/\u00197t)\u0011\t9&a\u0019\t\u0011\u0005\u0005c#!AA\u0002EC3\u0003AA4\u0003[\ny'a\u001d\u0002v\u0005e\u00141PA@\u0003\u0003\u00032ALA5\u0013\r\tYg\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t(AA\u0019\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue2\u0002#/Z4fqB\\F\u0006I5eqvK\u0003%\f\u0011FqR\u0014\u0018m\u0019;!C2d\u0007e\u001d;sS:<7\u000fI5oAQDW\r\t1tiJ\u0004\u0007\u0005\u001e5bi\u0002j\u0017\r^2iAQDW\r\t1sK\u001e,\u0007\u0010\u001d1\u000bA\u0001\u0002\u0003%\u001a=qe\u0016\u001c8/[8oA\u0005tG\rI2peJ,7\u000f]8oI&tw\r\t;pAQDW\r\t:fO\u0016D\be\u001a:pkB\u0004\u0013N\u001c3fq:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a\u001e\u0002\u0011OS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:t#\u0002\t\u0011!A\u0001\u0002#\u0006\t:fO\u0016D\b\u000fI\u0017!C\u0002\u001aHO]5oO\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hA\u0005\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o]\u0001\"\u0006.\u001a\u0011sK\u001e,\u0007\u0010I:ue&tw\rI:i_VdG\r\t2fA\u0005T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011KCZ\f\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:R!\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'&t7-\u001a\u0011Ta\u0006\u00148\u000e\t\u001a/a1\u00023\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d7\u000f\t\u0015j]\u000edW\u000fZ5oO\u0002\u0012XmZ3yAA\fG\u000f^3s]NL\u0003%\u0019:fAUtWm]2ba\u0016$\u0007%\u001b8!_V\u0014\beU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005]1sg\u0016\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003\u0005^8![\u0006$8\r\u001b\u0011#9\u0006\u00147M\t\u0017!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!M>\u0014\b\u0005\u0019:fO\u0016D\b\u000f\u0019\u0011dC:\u0004#-\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012c\f\u0018/bE\u000e$#E\f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000b[3sK\u0002J7\u000fI1!'Fc\u0005eY8oM&<\u0007eJ:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mg\u001e\u0002C\u000f[1uA\r\fg\u000e\t2fAU\u001cX\r\u001a\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t4bY2\u0014\u0017mY6!i>\u0004C\u000f[3!'B\f'o\u001b\u00112]Y\u0002#-\u001a5bm&|'\u000f\t:fO\u0006\u0014H-\u001b8hAM$(/\u001b8hA1LG/\u001a:bY\u0002\u0002\u0018M]:j]\u001et\u0003ER8sA\u0015D\u0018-\u001c9mK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011jM\u0002\"\b.\u001a\u0011d_:4\u0017n\u001a\u0011jg\u0002*g.\u00192mK\u0012d\u0003\u0005\u001e5fA\u0001\u0014XmZ3ya\u0002\u0004C\u000f[1uA\r\fg\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014\u0003%[:!Eyc\u0016MY2%E9R\u0001\u0005\t\u0011!A\u0001R\u0003%\u001b3yA5\u0002\u0013M\u001c\u0011j]R,w-\u001a:!Kb\u0004(/Z:tS>t\u0007\u0005\u001e5bi\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hAQDW\rI4s_V\u0004\b%\u001b8eKbt\u0003\u0005\u00165fAI,w-\u001a=![\u0006L\beY8oi\u0006Lgn\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001jW\u000f\u001c;ja2,\u0007e\u001a:pkB\u001ch\u0006\t1jIb\u0004\u0007%\u001b8eS\u000e\fG/Z:!o\"L7\r\u001b\u0011sK\u001e,\u0007\u0010I4s_V\u0004\b\u0005^8!Kb$(/Y2u]\u0001\"\u0006.\u001a\u0011he>,\b\u000fI5oI\u0016D\be\u001d5pk2$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E\u0016\u0004cn\u001c8.]\u0016<\u0017\r^5wK:\u0002C\u000b[3![&t\u0017.\\;nAY\fG.^3!_\u001a\u0004\u0003-\u001b3yA\u0002J7\u000f\t\u0019-A]D\u0017n\u00195![\u0016\fgn\u001d\u0011nCR\u001c\u0007.\u001b8hAQDW\rI3oi&\u0014XM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!\u0013\u001a\u0004\u0003-\u001b3yA\u0002J7\u000f\t8pi\u0002\u001a\b/Z2jM&,G\r\f\u0011uQ\u0016\u0004C-\u001a4bk2$\be\u001a:pkB\u0004\u0013N\u001c3fq\u00022\u0018\r\\;fA%\u001c\b%\r\u0018!)\",'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A&$\u0007\u0010\u0019\u0011qCJ\fW.\u001a;fe\u0002J7\u000f\t;iK\u0002R\u0015M^1!e\u0016<W\r\u001f\u0011NCR\u001c\u0007.\u001a:!OJ|W\u000f\u001d\u0015*A5,G\u000f[8eA%tG-\u001a=/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0014!\u001a\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OE\u0002\u0004'\f\u001a1a1\u00023\u0007\r\u0019.iA\u0002t\u0005\f\u0011(QqcFmK\u0015.QqcFmK\u0015(Y\u0001\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\EE\u0002\u0004G\t\u0017#gA\u0002$%\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111Q\u0001\u0006g9\nd\u0006M\u0001\u0011%\u0016<W\t\u001f9FqR\u0014\u0018m\u0019;BY2\u0004\"A\f\r\u0014\ta\tYi\u000e\t\t\u0003\u001b\u000b\u0019\n\u0010\u001f=\r6\u0011\u0011q\u0012\u0006\u0004\u0003#\u001b\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003+\u000byIA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\t\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\u0019\u000b\t+a)\u0002&\")!h\u0007a\u0001y!)\u0001i\u0007a\u0001y!)!i\u0007a\u0001y\u00059QO\\1qa2LH\u0003BAV\u0003o\u0003RAMAW\u0003cK1!a,4\u0005\u0019y\u0005\u000f^5p]B1!'a-=yqJ1!!.4\u0005\u0019!V\u000f\u001d7fg!A\u0011\u0011\u0018\u000f\u0002\u0002\u0003\u0007a)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0018\t\u0005\u0003K\t\t-\u0003\u0003\u0002D\u0006\u001d\"AB(cU\u0016\u001cG\u000f")
public class RegExpExtractAll
extends RegExpExtractBase
implements scala.Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtractAll regExpExtractAll) {
        return RegExpExtractAll$.MODULE$.unapply(regExpExtractAll);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtractAll> tupled() {
        return RegExpExtractAll$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtractAll>>> curried() {
        return RegExpExtractAll$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        Matcher m = this.getLastMatcher(s, p);
        ArrayBuffer matchResults = new ArrayBuffer();
        while (m.find()) {
            MatchResult mr = m.toMatchResult();
            int index = BoxesRunTime.unboxToInt((Object)r);
            RegExpExtractBase$.MODULE$.checkGroupIndex(mr.groupCount(), index);
            String group = mr.group(index);
            ArrayBuffer arrayBuffer = group == null ? matchResults.$plus$eq((Object)UTF8String.EMPTY_UTF8) : matchResults.$plus$eq((Object)UTF8String.fromString((String)group));
        }
        return new GenericArrayData((Object[])matchResults.toArray(ClassTag$.MODULE$.apply(UTF8String.class)));
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    @Override
    public String prettyName() {
        return "regexp_extract_all";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameRegExpExtractBase = RegExpExtractBase.class.getCanonicalName();
        String arrayClass = GenericArrayData.class.getName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String matchResults = ctx.freshName("matchResults");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(subject, regexp, idx) -> new StringBuilder(691).append("\n         | if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n         |   // regex value changed\n         |   ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n         |   ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n         | }\n         | java.util.regex.Matcher ").append(matcher).append(" = ").append(termPattern).append(".matcher(").append((String)subject).append(".toString());\n         | java.util.ArrayList ").append(matchResults).append(" = new java.util.ArrayList<UTF8String>();\n         | while (").append(matcher).append(".find()) {\n         |   java.util.regex.MatchResult ").append(matchResult).append(" = ").append(matcher).append(".toMatchResult();\n         |   ").append(classNameRegExpExtractBase).append(".checkGroupIndex(").append(matchResult).append(".groupCount(), ").append((String)idx).append(");\n         |   if (").append(matchResult).append(".group(").append((String)idx).append(") == null) {\n         |     ").append(matchResults).append(".add(UTF8String.EMPTY_UTF8);\n         |   } else {\n         |     ").append(matchResults).append(".add(UTF8String.fromString(").append(matchResult).append(".group(").append((String)idx).append(")));\n         |   }\n         | }\n         | ").append(ev.value()).append(" =\n         |   new ").append(arrayClass).append("(").append(matchResults).append(".toArray(new UTF8String[").append(matchResults).append(".size()]));\n         | ").append(setEvNotNull).append("\n         ").toString());
    }

    public RegExpExtractAll copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtractAll(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtractAll";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.idx();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtractAll;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtractAll)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtractAll regExpExtractAll = (RegExpExtractAll)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtractAll.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtractAll.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtractAll.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtractAll.canEqual(this)) return false;
        return true;
    }

    public RegExpExtractAll(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpExtractAll(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

